import numpy as np

COCO_PERSON_SKELETON = [(16, 14), (14, 12), (17, 15), (15, 13), (12, 13), (6, 12),
                        (7, 13), (6, 7), (6, 8), (7, 9), (8, 10), (9, 11), (2, 3),
                        (1, 2), (1, 3), (2, 4), (3, 5), (4, 6), (5, 7)]

H36_PERSON_SKELETON = [[1, 2], [2, 3], [3, 4], [1, 5], [5, 6], [6, 7],
                       [1, 8], [8, 9], [9, 10], [10, 11], [9, 12],
                       [12, 13], [13, 14], [9, 15], [15, 16], [16, 17]]

WEIGHTS_COCO = np.array([0.01, 0.01, 0.01, 0.015, 0.015, 0.1, 0.1, 0.05, 0.05,
                         0.03, 0.03, 0.16, 0.16, 0.09, 0.09, 0.04, 0.04])

WEIGHTS_H36 = np.array([0.15, 0.075, 0.04, 0.025, 0.075, 0.04, 0.025, 0.125, 0.105,
                        0.075, 0.075, 0.05, 0.03, 0.015, 0.05, 0.03, 0.015])

PERSON_SKELETONS = {'COCO': COCO_PERSON_SKELETON,
                    'H36': H36_PERSON_SKELETON}

COLORS = [[14, 127, 255], [232, 199, 174], [180, 119, 31], [120, 187, 255], [44, 160, 44],
          [138, 223, 152], [40, 39, 214], [150, 152, 255], [189, 103, 148], [213, 176, 197],
          [75, 86, 140], [148, 156, 196], [194, 119, 227], [210, 182, 247], [127, 127, 127],
          [199, 199, 199], [34, 189, 188], [141, 219, 219], [207, 190, 23], [229, 218, 158]]
