--  Additives and AdditiveRisk
CREATE TABLE public.additiverisks (
    id integer NOT NULL,
    name text NOT NULL
);

ALTER TABLE ONLY public.additiverisks
    ADD CONSTRAINT additiverisks_pk PRIMARY KEY (id);
    
INSERT INTO public.additiverisks (id, name) VALUES (1, 'Low'); -- 
INSERT INTO public.additiverisks (id, name) VALUES (2, 'Medium');
INSERT INTO public.additiverisks (id, name) VALUES (3, 'High');

CREATE TABLE public.additives (
    id integer NOT NULL,
    name text NOT NULL, 
    description text NOT NULL, 
    risk integer NULL
);

ALTER TABLE ONLY public.additives
    ADD CONSTRAINT additives_pk PRIMARY KEY (id);

INSERT INTO public.additives (id, name, description, risk) VALUES (1,'E100','Curcuminas',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (2,'E100i','Curcumina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (3,'E100ii','Cúrcuma',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (4,'E101','Riboflavinas',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (5,'E101i','Riboflavina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (6,'E101ii','Fosfato de Riboflavina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (7,'E101iii','Riboflavina de Bacillus Subtilis',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (8,'E102','Tartrazina',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (9,'E103','Crisoína',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (10,'E104','Amarillo de Quinoleína',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (11,'E105','Amarillo Sólido',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (12,'E107','Amarillo 2G',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (13,'E110','Amarillo Ocaso FCF',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (14,'E111','Naranja GGN',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (15,'E120','Ácido Carmínico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (16,'E120i','Rojo Carmín',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (17,'E120ii','Extracto de Cochinilla',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (18,'E121','Rojo Cítrico 2',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (19,'E122','Azorrubina',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (20,'E123','Amaranto',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (21,'E124','Ponceau 4R',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (22,'E125','Ponceau SX',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (23,'E126','Ponceau 6R',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (24,'E127','Eritrosina',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (25,'E128','Rojo 2G',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (26,'E129','Rojo Allura AC',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (27,'E130','Azul de Antraquinona',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (28,'E131','Azul Patente V',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (29,'E132','Indigotina',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (30,'E133','Azul Brillante FCF',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (31,'E140','Clorofilas y Clorofilinas',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (32,'E140i','Clorofila',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (33,'E140ii','Clorofilina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (34,'E141','Complejos Cúpricos de Clorofilas y Clorofilinas',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (35,'E141i','Complejo Cúprico de Clorofila',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (36,'E141ii','Complejo Cúprico de Clorofilina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (37,'E142','Verde S',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (38,'E143','Verde Sólido FCF',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (39,'E150','Caramelos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (40,'E150a','Caramelo Cáustico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (41,'E150b','Caramelo Caústico de Sulfito',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (42,'E150c','Caramelo Amónico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (43,'E150d','Caramelo Amónico de Sulfito',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (44,'E151','Negro Brillante BN',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (45,'E152','Negro 7984',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (46,'E153','Carbón Vegetal',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (47,'E154','Marrón FK',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (48,'E155','Marrón HT',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (49,'E160','Carotenos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (50,'E160a','Beta Caroteno',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (51,'E160b','Annatto, Bija, Bixina, Norbixina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (52,'E160c','Extracto de Pimentón, Capsantina, Capsorrubina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (53,'E160d','Licopeno',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (54,'E160e','Beta Apocarotenal',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (55,'E160f','Éster Etílico del Ácido Beta Apocarotenoico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (56,'E161','Xantófilas',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (57,'E161a','Flavoxantina',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (58,'E161b','Luteína',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (59,'E161c','Criptoxantina',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (60,'E161d','Rubixantina',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (61,'E161e','Violaxantina',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (62,'E161f','Rodoxantina',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (63,'E161g','Cantaxantina',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (64,'E161h','Zeaxantina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (65,'E161i','Citranaxantina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (66,'E161j','Astaxantina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (67,'E162','Betanina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (68,'E163','Antocianinas',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (69,'E163a','Cianidina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (70,'E163b','Delfinidina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (71,'E163c','Malvidina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (72,'E163d','Pelargonidina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (73,'E163e','Peonidina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (74,'E163f','Petunidina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (75,'E164','Amarillo de Gardenia',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (76,'E165','Azul de Gardenia',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (77,'E166','Madera de Sándalo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (78,'E170','Carbonatos Cálcicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (79,'E170i','Carbonato de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (80,'E170ii','Bicarbonato de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (81,'E171','Dióxido de Titanio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (82,'E172','Óxidos e Hidróxidos Férricos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (83,'E172i','Óxido de Hierro Negro',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (84,'E172ii','Óxido de Hierro Rojo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (85,'E172iii','Óxido de Hierro Amarillo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (86,'E173','Aluminio Comestible',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (87,'E174','Plata Comestible',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (88,'E175','Oro Comestible',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (89,'E180','Litolrrubina BK',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (90,'E181','Ácido Tánico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (91,'E182','Orceína',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (92,'E200','Ácido Sórbico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (93,'E201','Sorbato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (94,'E202','Sorbato de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (95,'E203','Sorbato de Calcio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (96,'E210','Ácido Benzoico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (97,'E211','Benzoato de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (98,'E212','Benzoato de Potasio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (99,'E213','Benzoato de Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (100,'E214','Etil P-Hidroxibenzoato',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (101,'E215','Etil P-Hidroxibenzoato de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (102,'E216','Propil P-Hidroxibenzoato',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (103,'E217','Propil P-Hidroxibenzoato de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (104,'E218','Metil P-Hidroxibenzoato',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (105,'E219','Metil P-Hidroxibenzoato de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (106,'E220','Dióxido de Azufre',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (107,'E221','Sulfito de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (108,'E222','Bisulfito de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (109,'E223','Metabisulfito de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (110,'E224','Metabisulfito de Potasio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (111,'E225','Sulfito de Potasio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (112,'E226','Sulfito de Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (113,'E227','Bisulfito de Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (114,'E228','Bisulfito de Potasio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (115,'E230','Bifenilo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (116,'E231','Ortofenilfenol',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (117,'E232','Ortofenilfenol de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (118,'E233','Tiabendazol',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (119,'E234','Nisina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (120,'E235','Natamicina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (121,'E236','Ácido Fórmico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (122,'E237','Formiato de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (123,'E238','Formiato de Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (124,'E239','Hexametilentetramina, HMTA',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (125,'E240','Formaldehído',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (126,'E241','Goma de Guayaco',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (127,'E242','Dimetil Dicarbonato',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (128,'E243','Etil Lauroil Arginato',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (129,'E249','Nitrito de Potasio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (130,'E250','Nitrito de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (131,'E251','Nitrato de Sodio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (132,'E252','Nitrato de Potasio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (133,'E260','Ácido Acético',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (134,'E261','Acetatos Potásicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (135,'E261i','Acetato de Potasio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (136,'E261ii','Diacetato de Potasio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (137,'E262','Acetatos Sódicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (138,'E262i','Acetato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (139,'E262ii','Diacetato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (140,'E263','Acetato de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (141,'E264','Acetato de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (142,'E265','Ácido Dehidroacético',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (143,'E266','Dehidroacetato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (144,'E270','Ácido Láctico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (145,'E280','Ácido Propiónico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (146,'E281','Propionato de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (147,'E282','Propionato de Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (148,'E283','Propionato de Potasio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (149,'E284','Ácido Bórico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (150,'E285','Tetraborato de Sodio, Bórax',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (151,'E290','Dióxido de Carbono, CO2',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (152,'E296','Ácido Málico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (153,'E297','Ácido Fumárico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (154,'E300','Ácido Ascórbico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (155,'E301','Ascorbato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (156,'E302','Ascorbato de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (157,'E303','Ascorbato de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (158,'E304','Ésteres de Ácidos Grasos del Ácido Ascórbico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (159,'E304i','Palmitato Ascorbilo',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (160,'E304ii','Estearato Ascorbilo',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (161,'E306','Extractos Naturales Ricos en Tocoferoles',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (162,'E307','Alfa Tocoferol',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (163,'E308','Gamma Tocoferol',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (164,'E309','Delta Tocoferol',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (165,'E310','Galato de Propilo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (166,'E311','Galato de Octilo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (167,'E312','Galato de Dodecilo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (168,'E313','Galato de Etilo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (169,'E314','Resina de Guayaco',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (170,'E315','Ácido Eritórbico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (171,'E316','Eritorbato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (172,'E317','Eritorbato de Potasio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (173,'E318','Eritorbato de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (174,'E319','Terbutilhidroquinona, TBHQ',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (175,'E320','Butilhidroxianisol, BHA',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (176,'E321','Butilhidroxitoluol, BHT',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (177,'E322','Lecitinas',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (178,'E323','Anoxómero',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (179,'E324','Etoxiquina',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (180,'E325','Lactato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (181,'E326','Lactato de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (182,'E327','Lactato de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (183,'E328','Lactato de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (184,'E329','Lactato de Magnesio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (185,'E330','Ácido Cítrico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (186,'E331','Citratos Sódicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (187,'E331i','Citrato Monosódico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (188,'E331ii','Citrato Disódico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (189,'E331iii','Citrato Trisódico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (190,'E332','Citratos Potásicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (191,'E332i','Citrato Monopotásico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (192,'E332ii','Citrato Dipotásico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (193,'E332iii','Citrato Tripotásico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (194,'E333','Citratos Cálcicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (195,'E333i','Citrato Monocálcico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (196,'E333ii','Citrato Dicálcico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (197,'E333iii','Citrato Tricálcico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (198,'E334','Ácido Tartárico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (199,'E335','Tartratos Sódicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (200,'E335i','Tartrato Monosódico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (201,'E335ii','Tartrato Disódico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (202,'E336','Tartratos Potásicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (203,'E336i','Tartrato Monopotásico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (204,'E336ii','Tartrato Dipotásico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (205,'E337','Tartrato Sódico-Potásico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (206,'E338','Ácido Fosfórico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (207,'E339','Fosfatos Sódicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (208,'E339i','Fosfato Monosódico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (209,'E339ii','Fosfato Disódico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (210,'E339iii','Fosfato Trisódico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (211,'E340','Fosfatos Potásicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (212,'E340i','Fosfato Monopotásico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (213,'E340ii','Fosfato Dipotásico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (214,'E340iii','Fosfato Tripotásico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (215,'E341','Fosfatos Cálcicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (216,'E341i','Fosfato Monocálcico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (217,'E341ii','Fosfato Dicálcico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (218,'E341iii','Fosfato Tricálcico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (219,'E342','Fosfatos Amónicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (220,'E342i','Fosfato Monoamónico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (221,'E342ii','Fosfato Diamónico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (222,'E342iii','Fosfato Triamónico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (223,'E343','Fosfatos Magnésicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (224,'E343i','Fosfato Monomagnésico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (225,'E343ii','Fosfato Dimagnésico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (226,'E343iii','Fosfato Trimagnésico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (227,'E344','Citrato de Lecitina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (228,'E345','Citrato de Magnesio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (229,'E349','Malatos Amónicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (230,'E349i','Malato de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (231,'E349ii','Malato Ácido de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (232,'E350','Malatos Sódicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (233,'E350i','Malato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (234,'E350ii','Malato Ácido de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (235,'E351','Malatos Potásicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (236,'E351i','Malato de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (237,'E351ii','Malato Ácido de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (238,'E352','Malatos Cálcicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (239,'E352i','Malato de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (240,'E352ii','Malato Ácido de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (241,'E353','Ácido Metatartárico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (242,'E354','Tartratos Cálcicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (243,'E354i','Tartrato Monocálcico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (244,'E354ii','Tartrato Dicálcico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (245,'E355','Ácido Adípico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (246,'E356','Adipato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (247,'E357','Adipato de Potasio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (248,'E358','Adipato de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (249,'E359','Adipato de Amonio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (250,'E360','Adipato de Magnesio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (251,'E363','Ácido Succínico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (252,'E364','Succinato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (253,'E365','Fumarato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (254,'E366','Fumarato de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (255,'E367','Fumarato de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (256,'E368','Fumarato de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (257,'E369','Fumarato de Magnesio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (258,'E370','Heptonolactona',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (259,'E375','Ácido Nicotínico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (260,'E380','Citrato de Triamonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (261,'E381','Citrato Férrico de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (262,'E383','Glicerofosfato de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (263,'E384','Citrato de Isopropilo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (264,'E385','Etileno Diamina Tetra Acetato, EDTA',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (265,'E386','Ácido Etileno Diamino Tetraacético, AEDT',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (266,'E387','Oxiestearina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (267,'E388','Ácido Tiodipropiónico, TDPA',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (268,'E389','Tiodipropionato de Dilaurilo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (269,'E390','Tiodipropionato de Distearilo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (270,'E391','Ácido Fítico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (271,'E392','Extracto de Romero',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (272,'E399','Lactobionato de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (273,'E400','Ácido Algínico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (274,'E401','Alginato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (275,'E402','Alginato de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (276,'E403','Alginato de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (277,'E404','Alginato de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (278,'E405','Alginato de Propilenglicol',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (279,'E406','Agar-Agar',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (280,'E407','Carragenanos',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (281,'E407a','Algas Euchema',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (282,'E408','Glicano de Levadura Panaria',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (283,'E409','Arabinogalactano',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (284,'E410','Goma Garrofín',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (285,'E411','Goma de Avena',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (286,'E412','Goma Guar',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (287,'E413','Goma Tragacanto',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (288,'E414','Goma Arábiga',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (289,'E415','Goma Xantana',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (290,'E416','Goma Karaya',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (291,'E417','Goma Tara',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (292,'E418','Goma Gellan',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (293,'E419','Goma Ghatti',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (294,'E420','Sorbitoles y Jarabes de Sorbitol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (295,'E420i','Sorbitol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (296,'E420ii','Jarabe de Sorbitol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (297,'E421','Manitol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (298,'E422','Glicerol',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (299,'E424','Curdlan',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (300,'E425','Harina de Konjac',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (301,'E425i','Goma de Konjac',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (302,'E425ii','Glucomanano de Konjac',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (303,'E426','Hemicelulosa de Soja',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (304,'E427','Goma Cassia',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (305,'E428','Gelatina',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (306,'E429','Peptonas',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (307,'E429i','Peptona Pépsica',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (308,'E429ii','Peptona Pancreática',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (309,'E430','Estearato de Polioxietileno 8',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (310,'E431','Estearato de Polioxietileno 40',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (311,'E432','Monolaurato de Sorbitano Polioxietinelado, Polisorbato 20',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (312,'E433','Monooleato de Sorbitano Polioxietinelado, Polisorbato 80',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (313,'E434','Monopalmitato de Sorbitano Polioxietinelado, Polisorbato 40',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (314,'E435','Monoestearato de Sorbitano Polioxietinelado, Polisorbato 60',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (315,'E436','Triestearato de Sorbitano Polioxietinelado, Polisorbato 65',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (316,'E440','Pectinas',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (317,'E440i','Pectina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (318,'E440ii','Pectina Amidada',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (319,'E441','Aceite de Semilla de Colza Superglicerinado Hidrogenado',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (320,'E442','Fosfátidos de Amonio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (321,'E443','Aceite Vegetal Bromado',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (322,'E444','Acetato Isobutirato de Sacarosa',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (323,'E445','Ésteres Glicéridos de Resina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (324,'E445i','Ésteres Glicéridos de Goma de Resina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (325,'E445ii','Ésteres Glicéridos de Colofonia de Aceite de Pino',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (326,'E445iii','Ésteres Glicéridos de Colofonia de Madera',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (327,'E446','Succistearina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (328,'E450','Difosfatos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (329,'E450i','Difosfato Disódico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (330,'E450ii','Difosfato Trisódico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (331,'E450iii','Difosfato Tetrasódico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (332,'E450iv','Difosfato Dipotásico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (333,'E450v','Difosfato Tetrapotásico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (334,'E450vi','Difosfato Dicálcico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (335,'E450vii','Difosfato Ácido Cálcico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (336,'E450viii','Difosfato Dimagnésico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (337,'E450ix','Difosfato Magnésico de Dihidrógeno',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (338,'E451','Trifosfatos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (339,'E451i','Trifosfato Pentasódico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (340,'E451ii','Trifosfato Pentapotásico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (341,'E451iii','Trifosfato Sódico-Potásico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (342,'E452','Polifosfatos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (343,'E452i','Polifosfato Sódico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (344,'E452ii','Polifosfato Potásico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (345,'E452iii','Polifosfato Sódico-Cálcico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (346,'E452iv','Polifosfato Cálcico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (347,'E452v','Polifosfato Amónico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (348,'E456','Poliaspartato Potásico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (349,'E457','Alfa-Ciclodextrina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (350,'E458','Gamma-Ciclodextrina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (351,'E459','Beta-Ciclodextrina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (352,'E460','Celulosas',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (353,'E460i','Celulosa Microcristalina',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (354,'E460ii','Celulosa en Polvo',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (355,'E461','Metil Celulosa',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (356,'E462','Etil Celulosa',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (357,'E463','Hidroxipropil Celulosa',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (358,'E464','Hidroxipropilmetil Celulosa',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (359,'E465','Metil Etil Celulosa',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (360,'E466','Carboximetil Celulosa de Sodio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (361,'E467','Etil Hidroxietil Celulosa',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (362,'E468','Carboximetil Celulosa de Sodio Reticulada',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (363,'E469','Carboximetil Celulosa de Sodio Hidrolizada',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (364,'E470','Sales de los Ácidos Grasos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (365,'E470a','Sales de Sodio, Potasio y Calcio de los Ácidos Grasos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (366,'E470b','Sales de Magnesio de Ácidos Grasos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (367,'E471','Mono y Diglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (368,'E472','Ésteres de los Mono y Diglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (369,'E472a','Ésteres Acéticos de los Mono y Diglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (370,'E472b','Ésteres Lácticos de los Mono y Diglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (371,'E472c','Ésteres Cítricos de los Mono y Diglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (372,'E472d','Ésteres Tartáricos de los Mono y Diglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (373,'E472e','Ésteres Mono y Diacetiltartárico de los Mono y Diglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (374,'E472f','Ésteres Mixtos Acéticos y Tartáricos de los Mono y Diglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (375,'E473','Sucroésteres de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (376,'E473a','Oligoésteres de Sacarosa',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (377,'E474','Sucroglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (378,'E475','Ésteres Poliglicéridos de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (379,'E476','Polirricinoleato de Poliglicerol',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (380,'E477','Ésteres de Propilenglicol de Ácidos Grasos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (381,'E478','Ésteres de Glicerol y Propilenglicol de Ácidos Grasos Lactilados',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (382,'E479','Aceite de Soja Oxidado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (383,'E480','Dioctil Sulfosuccinato de Sodio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (384,'E481','Lactilatos Sódicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (385,'E481i','Estearoil Lactilato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (386,'E481ii','Lactilato Oleico de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (387,'E482','Lactilatos Cálcicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (388,'E482i','Estearoil Lactilato de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (389,'E482ii','Lactilato Oleico de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (390,'E483','Tartrato de Estearilo',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (391,'E484','Citrato de Estearilo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (392,'E485','Estearoil Fumarato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (393,'E486','Estearoil Fumarato de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (394,'E487','Lauril Sulfato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (395,'E488','Mono y Diglicéridos Etoxilados',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (396,'E489','Éster de Metilglucósido de Aceite de Coco',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (397,'E491','Monoestearato de Sorbitano',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (398,'E492','Triestearato de Sorbitano',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (399,'E493','Monolaurato de Sorbitano',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (400,'E494','Monooleato de Sorbitano',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (401,'E495','Monopalmitato de Sorbitano',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (402,'E496','Trioleato de Sorbitano',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (403,'E499','Fitoesteroles Ricos en Estigmasterol',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (404,'E500','Carbonatos Sódicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (405,'E500i','Carbonato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (406,'E500ii','Bicarbonato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (407,'E500iii','Sesquicarbonato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (408,'E501','Carbonatos Potásicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (409,'E501i','Carbonato de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (410,'E501ii','Bicarbonato de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (411,'E503','Carbonatos Amónicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (412,'E503i','Carbonato de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (413,'E503ii','Bicarbonato de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (414,'E504','Carbonatos Magnésicos',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (415,'E504i','Carbonato de Magnesio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (416,'E504ii','Bicarbonato de Magnesio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (417,'E505','Carbonato de Hierro',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (418,'E507','Ácido Clorhídrico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (419,'E508','Cloruro de Potasio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (420,'E509','Cloruro de Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (421,'E510','Cloruro de Amonio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (422,'E511','Cloruro de Magnesio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (423,'E512','Cloruro de Estaño',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (424,'E513','Ácido Sulfúrico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (425,'E514','Sulfatos Sódicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (426,'E514i','Sulfato de Sodio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (427,'E514ii','Sulfato Ácido de Sodio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (428,'E515','Sulfatos Potásicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (429,'E515i','Sulfato de Potasio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (430,'E515ii','Sulfato Ácido de Potasio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (431,'E516','Sulfatos Cálcicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (432,'E516i','Sulfato de Calcio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (433,'E516ii','Sulfato Ácido de Calcio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (434,'E517','Sulfatos Amónicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (435,'E517i','Sulfato de Amonio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (436,'E517ii','Sulfato Ácido de Amonio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (437,'E518','Sulfatos Magnésicos',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (438,'E518i','Sulfato de Magnesio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (439,'E518ii','Sulfato Ácido de Magnesio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (440,'E519','Sulfatos Cúpricos',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (441,'E519i','Sulfato de Cobre',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (442,'E519ii','Sulfato Ácido de Cobre',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (443,'E520','Sulfato de Aluminio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (444,'E521','Sulfato de Aluminio Sódico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (445,'E522','Sulfato de Aluminio Potásico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (446,'E523','Sulfato de Aluminio Amónico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (447,'E524','Hidróxido de Sodio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (448,'E525','Hidróxido de Potasio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (449,'E526','Hidróxido de Calcio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (450,'E527','Hidróxido de Amonio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (451,'E528','Hidróxido de Magnesio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (452,'E529','Óxido de Calcio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (453,'E530','Óxido de Magnesio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (454,'E535','Ferrocianuro de Sodio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (455,'E536','Ferrocianuro de Potasio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (456,'E537','Hexacianomanganato de Hierro',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (457,'E538','Ferrocianuro de Calcio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (458,'E539','Tiosulfato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (459,'E540','Fosfato Ácido de Calcio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (460,'E541','Fosfato de Sodio y Aluminio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (461,'E541i','Fosfato Ácido de Sodio y Aluminio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (462,'E541ii','Fosfato Básico de Sodio y Aluminio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (463,'E542','Fosfato Tribásico de Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (464,'E543','Polifosfatos de Sodio y Calcio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (465,'E544','Polifosfatos de Calcio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (466,'E545','Polifosfatos de Amonio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (467,'E546','Polifosfatos de Magnesio',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (468,'E550','Silicatos Sódicos',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (469,'E550i','Silicato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (470,'E550ii','Metasilicato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (471,'E551','Dióxido de Silicio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (472,'E552','Silicato de Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (473,'E553','Silicatos Magnésicos',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (474,'E553a','Silicato de Magnesio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (475,'E553b','Talco de Magnesio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (476,'E554','Silicato de Sodio y Aluminio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (477,'E555','Silicato de Potasio y Aluminio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (478,'E556','Silicato de Calcio y Aluminio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (479,'E557','Silicato de Zinc',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (480,'E558','Bentonita',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (481,'E559','Silicato de Aluminio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (482,'E560','Silicato de Potasio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (483,'E570','Ácido Esteárico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (484,'E571','Estearato de Amonio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (485,'E572','Estearato de Magnesio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (486,'E573','Estearato de Aluminio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (487,'E574','Ácido Glucónico',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (488,'E575','Glucono-Delta-Lactona ',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (489,'E576','Gluconato de Sodio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (490,'E577','Gluconato de Potasio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (491,'E578','Gluconato de Calcio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (492,'E579','Gluconato de Hierro',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (493,'E585','Lactato de Hierro',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (494,'E586','Hexilresorcinol',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (495,'E620','Ácido Glutámico ',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (496,'E621','Glutamato Monosódico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (497,'E622','Glutamato Monopotásico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (498,'E623','Glutamato Cálcico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (499,'E624','Glutamato Amónico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (500,'E625','Glutamato Magnésico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (501,'E626','Ácido Guanílico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (502,'E627','Guanilato Sódico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (503,'E628','Guanilato Potásico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (504,'E629','Guanilato Cálcico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (505,'E630','Ácido Inosínico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (506,'E631','Inosinato Sódico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (507,'E632','Inosinato Potásico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (508,'E633','Inosinato Cálcico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (509,'E634','Ribonucleótidos de Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (510,'E635','Ribonucleótidos de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (511,'E636','Maltol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (512,'E637','Etil Maltol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (513,'E638','Aspartato de Sodio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (514,'E639','Alanina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (515,'E640','Glicina y Glicinato de Sodio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (516,'E641','Leucina',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (517,'E642','Hidrocloruro de Lisina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (518,'E650','Acetato de Zinc',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (519,'E900','Dimetilsiloxano, DMS',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (520,'E900a','Polidimetilsiloxano, PDMS',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (521,'E900b','Polimetilfenilsiloxano, PMFS',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (522,'E901','Cera de Abejas',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (523,'E901i','Cera de Abejas Blanca',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (524,'E901ii','Cera de Abejas Amarilla',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (525,'E902','Cera de Candelilla',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (526,'E903','Cera de Carnaúba',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (527,'E904','Goma Laca',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (528,'E905','Cera Microcristalina',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (529,'E905a','Aceite Mineral de Calidad Alimentaria',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (530,'E905b','Vaselina de Calidad Alimentaria',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (531,'E905c','Cera de Parafina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (532,'E905d','Parafina Líquida de Viscosidad Alta',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (533,'E905e','Parafina Líquida de Viscosidad Media y Baja, Categoría 1',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (534,'E905f','Parafina Líquida de Viscosidad Media y Baja, Categoría 2',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (535,'E905g','Parafina Líquida de Viscosidad Media y Baja, Categoría 3',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (536,'E906','Goma de Benzoína',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (537,'E907','Poli Deceno Hidrogenado',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (538,'E908','Cera de Salvado de Arroz',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (539,'E909','Cera de Esperma de Ballena',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (540,'E910','Ésteres de Cera',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (541,'E911','Ésteres Metílicos de Ácidos Grasos',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (542,'E912','Ésteres de Ácido Montánico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (543,'E913','Cera de Lana, Lanolina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (544,'E914','Cera de Polietileno Oxidada',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (545,'E915','Ésteres de Glicerina, Metílico o Pentaeritrítico de Colofonia Parcialmente Hidrogenada o Polimerizada',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (546,'E916','Yodato de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (547,'E917','Yodato de Potasio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (548,'E918','Óxidos de Nitrógeno',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (549,'E919','Cloruro de Nitrosilo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (550,'E920','L-Cisteína y Clorhidratos de Cisteína',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (551,'E921','L-Cistina y Clorhidratos de Cistina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (552,'E922','Persulfato de Potasio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (553,'E923','Persulfato de Amonio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (554,'E924a','Bromato de Potasio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (555,'E924b','Bromato de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (556,'E925','Cloro',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (557,'E926','Dióxido de Cloro',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (558,'E927a','Azodicarbonamida',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (559,'E927b','Carbamida',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (560,'E928','Peróxido de Benzoilo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (561,'E929','Peróxido de Acetona',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (562,'E930','Peróxido de Calcio',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (563,'E938','Argón',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (564,'E939','Helio',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (565,'E940','Diclorodifluorometano',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (566,'E941','Nitrógeno',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (567,'E942','Óxido Nitroso',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (568,'E943a','Butano',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (569,'E943b','Isobutano',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (570,'E944','Propano',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (571,'E945','Cloropentafluoroetano',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (572,'E946','Octafluorociclobutano',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (573,'E948','Oxígeno',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (574,'E949','Hidrógeno',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (575,'E950','Acesulfamo K',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (576,'E951','Aspartamo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (577,'E952','Ácido Ciclámico, Sales de Sodio y Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (578,'E952i','Ácido Ciclámico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (579,'E952ii','Ciclamato Sódico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (580,'E952iii','Ciclamato Cálcico',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (581,'E953','Isomaltosa',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (582,'E954','Sacarina, Sales de Sodio, Potasio y Calcio',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (583,'E954i','Sacarina',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (584,'E954ii','Sacarina Sódica',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (585,'E954iii','Sacarina Potásica',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (586,'E954iv','Sacarina Cálcica',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (587,'E955','Sucralosa',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (588,'E956','Alitamo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (589,'E957','Taumatina',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (590,'E958','Glicirricina',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (591,'E959','Neohesperidina Dihidrocalcona',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (592,'E960','Glucósidos de Esteviol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (593,'E961','Neotamo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (594,'E962','Sal de Aspartamo y Acesulfamo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (595,'E963','Tagatosa',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (596,'E964','Jarabe de Poliglicitol',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (597,'E965','Maltitol y Jarabe de Maltitol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (598,'E965i','Maltitol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (599,'E965ii','Jarabe de Maltitol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (600,'E966','Lactitol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (601,'E967','Xilitol',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (602,'E968','Eritritol',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (603,'E969','Advantamo',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (604,'E999','Extracto de Quillay',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (605,'E1000','Ácido Cólico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (606,'E1001','Sales y Ésteres de Colina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (607,'E1001i','Acetato de Colina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (608,'E1001ii','Carbonato de Colina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (609,'E1001iii','Cloruro de Colina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (610,'E1001iv','Citrato de Colina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (611,'E1001v','Tartrato de Colina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (612,'E1001vi','Lactato de Colina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (613,'E1100','Amilasas',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (614,'E1101','Peptidasas',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (615,'E1101i','Peptidasa',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (616,'E1101ii','Papaína',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (617,'E1101iii','Bromelina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (618,'E1101iv','Ficina',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (619,'E1102','Glucosa Oxidasa',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (620,'E1103','Invertasas',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (621,'E1104','Lipasas',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (622,'E1105','Lisozima',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (623,'E1200','Polidextrosas A y N',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (624,'E1201','Polivinilpirrolidona, PVP',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (625,'E1202','Polivinilpolipirrolidona, PVPP',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (626,'E1203','Alcohol Polivinílico, PVA',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (627,'E1204','Pululano',1);
INSERT INTO public.additives (id, name, description, risk) VALUES (628,'E1205','Copolímero de Metacrilato Básico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (629,'E1208','Copolímero de Acetato de Vinilo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (630,'E1209','Copolímero de Injerto, PVA-PEG',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (631,'E1400','Dextrinas',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (632,'E1401','Almidón Ácido',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (633,'E1402','Almidón Alcalino',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (634,'E1403','Almidón Blanqueado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (635,'E1404','Almidón Oxidado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (636,'E1405','Almidón Enzimático',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (637,'E1410','Fosfato de Monoalmidón',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (638,'E1412','Fosfato de Dialmidón',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (639,'E1413','Fosfato de Dialmidón Fosfatado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (640,'E1414','Fosfato de Dialmidón Acetilado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (641,'E1420','Almidón Acetilado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (642,'E1422','Adipato de Dialmidón Acetilado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (643,'E1440','Hidroxipropil de Almidón',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (644,'E1441','Glicerona de Dialmidón Hidroxipropilado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (645,'E1442','Fosfato de Dialmidón Hidroxipropilado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (646,'E1450','Octenil Succinato Sódico de Almidón',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (647,'E1451','Almidón Oxidado Acetilado',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (648,'E1452','Octenil Succinato Alumínico de Almidón',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (649,'E1501','Hidrocarbonos Bencilados',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (650,'E1502','Butanodiol',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (651,'E1503','Aceite de Ricino',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (652,'E1504','Acetato de Etilo',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (653,'E1505','Citrato de Trietilo',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (654,'E1510','Alcohol Etílico',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (655,'E1516','Monoacetato de Glicerol',NULL);
INSERT INTO public.additives (id, name, description, risk) VALUES (656,'E1517','Diacetato de Glicerilo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (657,'E1518','Triacetato de Glicerilo',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (658,'E1519','Alcohol Bencílico',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (659,'E1520','Propilenglicol',2);
INSERT INTO public.additives (id, name, description, risk) VALUES (660,'E1521','Polietilenglicol',3);
INSERT INTO public.additives (id, name, description, risk) VALUES (661,'E1522','Lignosulfonato de Calcio',NULL);

ALTER TABLE public.products ADD COLUMN additives INTEGER[];
ALTER TABLE public.personalproducts ADD COLUMN additives INTEGER[];
ALTER TABLE public.products ADD CONSTRAINT products_foodtypes_fk FOREIGN KEY (foodtypes_id) REFERENCES foodtypes(id) ON DELETE NO ACTION ON UPDATE NO ACTION;

