"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BastionAccessPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const security_tag_1 = require("./security-tag");
class BastionAccessPolicy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = props?.securityTag
            ? props.securityTag
            : security_tag_1.DefaultSecurityTag;
        this.policy = new aws_cdk_lib_1.aws_iam.PolicyDocument({
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'cloudwatch:DescribeAlarms',
                        'ec2:DescribeInstances',
                        'ec2:DescribeInstanceStatus',
                        'ec2:DescribeSecurityGroup*',
                        'identitystore:DescribeUser',
                        'ssm-guiconnect:CancelConnection',
                        'ssm-guiconnect:GetConnection',
                        'ssm-guiconnect:StartConnection',
                        'ssm:DescribeInstance*',
                        'ssm:GetCommandInvocation',
                        'ssm:GetInventorySchema',
                        'sso:ListDirectoryAssociations*',
                        'rds:Describe*',
                        'secretsmanager:ListSecrets',
                        'kms:ListAliases',
                    ],
                    resources: ['*'],
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'ec2:GetPasswordData',
                        'ec2:StartInstances',
                        'ssm:GetConnectionStatus',
                        'ssm:SendCommand',
                        'ssm:StartSession',
                    ],
                    resources: ['arn:aws:ec2:*:*:instance/*'],
                    conditions: {
                        StringEquals: JSON.parse(`{"aws:ResourceTag/${securityTag.key}": "${securityTag.value}"}`),
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: [
                        'secretsmanager:DescribeSecret',
                        'secretsmanager:GetSecretValue',
                    ],
                    resources: ['*'],
                    conditions: {
                        StringEquals: JSON.parse(`{"aws:ResourceTag/${securityTag.key}": "${securityTag.value}"}`),
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: ['ssm:TerminateSession'],
                    resources: ['*'],
                    conditions: {
                        StringLike: {
                            'ssm:resourceTag/aws:ssmmessages:session-id': '${aws:userName}',
                        },
                    },
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: ['ssm:GetDocument'],
                    resources: [
                        'arn:aws:ssm:*:*:document/AWS-StartPortForwardingSession',
                        'arn:aws:ssm:*:*:document/SSM-SessionManagerRunShell',
                    ],
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    actions: ['ssm:SendCommand', 'ssm:StartSession'],
                    resources: [
                        'arn:aws:ssm:*:*:document/AWS-StartPortForwardingSession',
                        'arn:aws:ssm:*:*:document/AWSSSO-CreateSSOUser',
                        'arn:aws:ssm:*:*:managed-instance/*',
                    ],
                    conditions: {
                        BoolIfExists: {
                            'ssm:SessionDocumentAccessCheck': 'true',
                        },
                    },
                }),
            ],
        });
    }
}
exports.BastionAccessPolicy = BastionAccessPolicy;
_a = JSII_RTTI_SYMBOL_1;
BastionAccessPolicy[_a] = { fqn: "pwed-cdk.bastion.BastionAccessPolicy", version: "0.0.59" };
//# sourceMappingURL=data:application/json;base64,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