"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process = require("child_process");
const crypto = require("crypto");
const fs = require("fs");
const path_1 = require("path");
const process = require("process");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const glob_1 = require("glob");
class StaticSite extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'Bucket', {
            encryption: aws_cdk_lib_1.aws_s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                {
                    transitions: [
                        {
                            storageClass: aws_cdk_lib_1.aws_s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: aws_cdk_lib_1.Duration.days(7),
                        },
                    ],
                },
            ],
        });
        const hostedZone = props.hostedZone
            ? props.hostedZone
            : aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, `HostedZone${props.domain}`, {
                domainName: props.domain,
            });
        const alternativeHostedZones = props.alternativeHostedZones
            ? props.alternativeHostedZones
            : props.alternativeDomains
                ? props.alternativeDomains.map((domain) => {
                    return aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, `HostedZone${domain}`, {
                        domainName: domain,
                    });
                })
                : undefined;
        let domainValidation = {
            [props.domain]: hostedZone,
        };
        props.alternativeDomains?.map((domain, index) => {
            domainValidation[domain] = alternativeHostedZones[index];
        });
        const certificate = new aws_cdk_lib_1.aws_certificatemanager.Certificate(this, 'Certificate', {
            domainName: props.domain,
            subjectAlternativeNames: props.alternativeDomains,
            validation: aws_cdk_lib_1.aws_certificatemanager.CertificateValidation.fromDnsMultiZone(domainValidation),
        });
        const originAccessIdentity = new aws_cdk_lib_1.aws_cloudfront.OriginAccessIdentity(this, 'OriginAccessIdentity');
        bucket.grantRead(originAccessIdentity);
        let prettyPathHandler;
        if (props.enablePrettyPaths)
            prettyPathHandler = new aws_cdk_lib_1.aws_cloudfront.Function(this, 'PrettyPathHandler', {
                code: aws_cdk_lib_1.aws_cloudfront.FunctionCode.fromFile({
                    filePath: path_1.join(__dirname, 'prettyPathHandler.js'),
                }),
            });
        this.distribution = new aws_cdk_lib_1.aws_cloudfront.Distribution(this, 'Distribution', {
            defaultBehavior: {
                origin: new aws_cdk_lib_1.aws_cloudfront_origins.S3Origin(bucket, {
                    originAccessIdentity,
                }),
                allowedMethods: aws_cdk_lib_1.aws_cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                functionAssociations: props.enablePrettyPaths
                    ? [
                        {
                            function: prettyPathHandler,
                            eventType: aws_cdk_lib_1.aws_cloudfront.FunctionEventType.VIEWER_REQUEST,
                        },
                    ]
                    : undefined,
            },
            domainNames: props.alternativeDomains
                ? [props.domain, ...props.alternativeDomains]
                : [props.domain],
            certificate,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 404,
                    responsePagePath: '/404.html',
                },
            ],
            defaultRootObject: 'index.html',
            httpVersion: aws_cdk_lib_1.aws_cloudfront.HttpVersion.HTTP2_AND_3,
        });
        new aws_cdk_lib_1.aws_route53.ARecord(this, 'AAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
        });
        new aws_cdk_lib_1.aws_route53.AaaaRecord(this, 'AaaaAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
        });
        props.alternativeDomains?.map((domain, index) => {
            new aws_cdk_lib_1.aws_route53.ARecord(this, `AAliasRecord${domain}`, {
                recordName: domain,
                zone: alternativeHostedZones[index],
                target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
            });
            new aws_cdk_lib_1.aws_route53.AaaaRecord(this, `AaaaAliasRecord${domain}`, {
                recordName: domain,
                zone: alternativeHostedZones[index],
                target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
            });
        });
        const hashFile = '/.hashfile';
        let invalidations = [hashFile];
        invalidations.push(...compareRemoteToLocal(props.domain, hashFile, props.path));
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'StaticDeployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(props.path)],
            destinationBucket: bucket,
            distribution: this.distribution,
            distributionPaths: invalidations,
        });
    }
}
exports.StaticSite = StaticSite;
_a = JSII_RTTI_SYMBOL_1;
StaticSite[_a] = { fqn: "pwed-cdk.static_site.StaticSite", version: "0.0.59" };
function getHashes(globPattern, dir) {
    let fh = new Map();
    const gs = glob_1.sync(globPattern, { cwd: dir, nodir: true });
    const pwd = process.cwd();
    process.chdir(dir);
    gs.forEach(function (file) {
        const fileBuffer = fs.readFileSync(file, {});
        const hashSum = crypto.createHash('sha256');
        hashSum.update(fileBuffer);
        const hex = hashSum.digest('hex');
        fh.set(file, hex);
    });
    process.chdir(pwd);
    return fh;
}
function getInvalidations(oldHashes, newHashes) {
    let invalidations = [];
    oldHashes.forEach(function (v, k) {
        if (newHashes.get(k) !== v) {
            invalidations.push(`/${k}`);
        }
    });
    return invalidations;
}
function compareRemoteToLocal(domain, hashFile, localFolder) {
    let oldHashesJSON;
    const newHashes = getHashes('**', localFolder);
    fs.writeFileSync(path_1.join(localFolder, hashFile), JSON.stringify(Object.fromEntries(newHashes)));
    try {
        oldHashesJSON = child_process
            .execSync(`curl -s https://${domain}/${hashFile}`)
            .toString();
    }
    catch {
        return ['/*'];
    }
    let oldHashes;
    try {
        oldHashes = new Map(Object.entries(JSON.parse(oldHashesJSON)));
    }
    catch (e) {
        return ['/*'];
    }
    return getInvalidations(oldHashes, newHashes);
}
//# sourceMappingURL=data:application/json;base64,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