import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [aws-cloud-control-api](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudcontrolapi.html).
 *
 * @experimental
 */
export declare class AwsCloudControlApi extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to cancel resource requests in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_CancelResourceRequest.html
     *
     * @experimental
     */
    toCancelResourceRequest(): this;
    /**
     * (experimental) Grants permission to create resources in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_CreateResource.html
     *
     * @experimental
     */
    toCreateResource(): this;
    /**
     * (experimental) Grants permission to delete resources in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_DeleteResource.html
     *
     * @experimental
     */
    toDeleteResource(): this;
    /**
     * (experimental) Grants permission to get resources in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResource.html
     *
     * @experimental
     */
    toGetResource(): this;
    /**
     * (experimental) Grants permission to get resource requests in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html
     *
     * @experimental
     */
    toGetResourceRequestStatus(): this;
    /**
     * (experimental) Grants permission to list resource requests in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ListResourceRequests.html
     *
     * @experimental
     */
    toListResourceRequests(): this;
    /**
     * (experimental) Grants permission to list resources in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_ListResources.html
     *
     * @experimental
     */
    toListResources(): this;
    /**
     * (experimental) Grants permission to update resources in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_UpdateResource.html
     *
     * @experimental
     */
    toUpdateResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [aws-cloud-control-api](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudcontrolapi.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
