"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeOptimizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscomputeoptimizer.html).
 *
 * @experimental
 */
class ComputeOptimizer extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscomputeoptimizer.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'compute-optimizer';
        /**
         * @experimental
         */
        this.accessLevelList = {
            List: [
                'DescribeRecommendationExportJobs',
                'GetAutoScalingGroupRecommendations',
                'GetEBSVolumeRecommendations',
                'GetEC2InstanceRecommendations',
                'GetEC2RecommendationProjectedMetrics',
                'GetEnrollmentStatus',
                'GetEnrollmentStatusesForOrganization',
                'GetLambdaFunctionRecommendations',
                'GetRecommendationSummaries'
            ],
            Write: [
                'ExportAutoScalingGroupRecommendations',
                'ExportEBSVolumeRecommendations',
                'ExportEC2InstanceRecommendations',
                'ExportLambdaFunctionRecommendations',
                'UpdateEnrollmentStatus'
            ]
        };
    }
    /**
     * (experimental) Grants permission to view the status of recommendation export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DescribeRecommendationExportJobs.html
     *
     * @experimental
     */
    toDescribeRecommendationExportJobs() {
        return this.to('DescribeRecommendationExportJobs');
    }
    /**
     * (experimental) Grants permission to export autoscaling group recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - compute-optimizer:GetAutoScalingGroupRecommendations
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportAutoScalingGroupRecommendations.html
     *
     * @experimental
     */
    toExportAutoScalingGroupRecommendations() {
        return this.to('ExportAutoScalingGroupRecommendations');
    }
    /**
     * (experimental) Grants permission to export EBS volume recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetEBSVolumeRecommendations
     * - ec2:DescribeVolumes
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEBSVolumeRecommendations.html
     *
     * @experimental
     */
    toExportEBSVolumeRecommendations() {
        return this.to('ExportEBSVolumeRecommendations');
    }
    /**
     * (experimental) Grants permission to export EC2 instance recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetEC2InstanceRecommendations
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEC2InstanceRecommendations.html
     *
     * @experimental
     */
    toExportEC2InstanceRecommendations() {
        return this.to('ExportEC2InstanceRecommendations');
    }
    /**
     * (experimental) Grants permission to export Lambda function recommendations to S3 for the provided accounts.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetLambdaFunctionRecommendations
     * - lambda:ListFunctions
     * - lambda:ListProvisionedConcurrencyConfigs
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportLambdaFunctionRecommendations.html
     *
     * @experimental
     */
    toExportLambdaFunctionRecommendations() {
        return this.to('ExportLambdaFunctionRecommendations');
    }
    /**
     * (experimental) Grants permission to get recommendations for the provided autoscaling groups.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetAutoScalingGroupRecommendations.html
     *
     * @experimental
     */
    toGetAutoScalingGroupRecommendations() {
        return this.to('GetAutoScalingGroupRecommendations');
    }
    /**
     * (experimental) Grants permission to get recommendations for the provided ebs volumes.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeVolumes
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEBSVolumeRecommendations.html
     *
     * @experimental
     */
    toGetEBSVolumeRecommendations() {
        return this.to('GetEBSVolumeRecommendations');
    }
    /**
     * (experimental) Grants permission to get recommendations for the provided EC2 instances.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2InstanceRecommendations.html
     *
     * @experimental
     */
    toGetEC2InstanceRecommendations() {
        return this.to('GetEC2InstanceRecommendations');
    }
    /**
     * (experimental) Grants permission to get the recommendation projected metrics of the specified instance.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2RecommendationProjectedMetrics.html
     *
     * @experimental
     */
    toGetEC2RecommendationProjectedMetrics() {
        return this.to('GetEC2RecommendationProjectedMetrics');
    }
    /**
     * (experimental) Grants permission to get the enrollment status for the specified account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatus.html
     *
     * @experimental
     */
    toGetEnrollmentStatus() {
        return this.to('GetEnrollmentStatus');
    }
    /**
     * (experimental) Grants permission to get the enrollment statuses for member accounts of the organization.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatusesForOrganization.html
     *
     * @experimental
     */
    toGetEnrollmentStatusesForOrganization() {
        return this.to('GetEnrollmentStatusesForOrganization');
    }
    /**
     * (experimental) Grants permission to get recommendations for the provided lambda functions.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - lambda:ListFunctions
     * - lambda:ListProvisionedConcurrencyConfigs
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetLambdaFunctionRecommendations.html
     *
     * @experimental
     */
    toGetLambdaFunctionRecommendations() {
        return this.to('GetLambdaFunctionRecommendations');
    }
    /**
     * (experimental) Grants permission to get the recommendation summaries for the specified account(s).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationSummaries.html
     *
     * @experimental
     */
    toGetRecommendationSummaries() {
        return this.to('GetRecommendationSummaries');
    }
    /**
     * (experimental) Grants permission to update the enrollment status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_UpdateEnrollmentStatus.html
     *
     * @experimental
     */
    toUpdateEnrollmentStatus() {
        return this.to('UpdateEnrollmentStatus');
    }
}
exports.ComputeOptimizer = ComputeOptimizer;
_a = JSII_RTTI_SYMBOL_1;
ComputeOptimizer[_a] = { fqn: "cdk-iam-floyd.ComputeOptimizer", version: "0.300.0" };
//# sourceMappingURL=data:application/json;base64,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