import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [macie](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmacieclassic.html).
 *
 * @experimental
 */
export declare class Macie extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Enables the user to associate a specified AWS account with Amazon Macie as a member account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_AssociateMemberAccount.html
     *
     * @experimental
     */
    toAssociateMemberAccount(): this;
    /**
     * (experimental) Enables the user to associate specified S3 resources with Amazon Macie for monitoring and data classification.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsSourceArn()
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_AssociateS3Resources.html
     *
     * @experimental
     */
    toAssociateS3Resources(): this;
    /**
     * (experimental) Enables the user to remove the specified member account from Amazon Macie.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_DisassociateMemberAccount.html
     *
     * @experimental
     */
    toDisassociateMemberAccount(): this;
    /**
     * (experimental) Enables the user to remove specified S3 resources from being monitored by Amazon Macie.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsSourceArn()
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_DisassociateS3Resources.html
     *
     * @experimental
     */
    toDisassociateS3Resources(): this;
    /**
     * (experimental) Enables the user to list all Amazon Macie member accounts for the current Macie master account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_ListMemberAccounts.html
     *
     * @experimental
     */
    toListMemberAccounts(): this;
    /**
     * (experimental) Enables the user to list all the S3 resources associated with Amazon Macie.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_ListS3Resources.html
     *
     * @experimental
     */
    toListS3Resources(): this;
    /**
     * (experimental) Enables the user to update the classification types for the specified S3 resources.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsSourceArn()
     *
     * https://docs.aws.amazon.com/macie/1.0/APIReference/API_UpdateS3Resources.html
     *
     * @experimental
     */
    toUpdateS3Resources(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [macie](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmacieclassic.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
