import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations..html).
 *
 * @experimental
 */
export declare class MigrationhubStrategy extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to get details of each anti pattern that collector should look at in a customer's environment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAntiPattern.html
     *
     * @experimental
     */
    toGetAntiPattern(): this;
    /**
     * (experimental) Grants permission to get details of an application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentDetails.html
     *
     * @experimental
     */
    toGetApplicationComponentDetails(): this;
    /**
     * (experimental) Grants permission to get a list of all recommended strategies and tools for an application running in a server.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentStrategies.html
     *
     * @experimental
     */
    toGetApplicationComponentStrategies(): this;
    /**
     * (experimental) Grants permission to retrieve status of an on-going assessment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAssessment.html
     *
     * @experimental
     */
    toGetAssessment(): this;
    /**
     * (experimental) Grants permission to get details of a specific import task.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetImportFileTask.html
     *
     * @experimental
     */
    toGetImportFileTask(): this;
    /**
     * (experimental) Grants permission to the collector to receive information from the service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetMessage.html
     *
     * @experimental
     */
    toGetMessage(): this;
    /**
     * (experimental) Grants permission to retrieve customer migration/Modernization preferences.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioPreferences.html
     *
     * @experimental
     */
    toGetPortfolioPreferences(): this;
    /**
     * (experimental) Grants permission to retrieve overall summary (number-of servers to rehost etc as well as overall number of anti patterns).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioSummary.html
     *
     * @experimental
     */
    toGetPortfolioSummary(): this;
    /**
     * (experimental) Grants permission to retrieve detailed information about a recommendation report.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetRecommendationReportDetails.html
     *
     * @experimental
     */
    toGetRecommendationReportDetails(): this;
    /**
     * (experimental) Grants permission to get info about a specific server.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerDetails.html
     *
     * @experimental
     */
    toGetServerDetails(): this;
    /**
     * (experimental) Grants permission to get recommended strategies and tools for a specific server.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerStrategies.html
     *
     * @experimental
     */
    toGetServerStrategies(): this;
    /**
     * (experimental) Grants permission to get a list of all anti patterns that collector should look for in a customer's environment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListAntiPatterns.html
     *
     * @experimental
     */
    toListAntiPatterns(): this;
    /**
     * (experimental) Grants permission to get a list of all applications running on servers on customer's servers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListApplicationComponents.html
     *
     * @experimental
     */
    toListApplicationComponents(): this;
    /**
     * (experimental) Grants permission to get a list of all collectors installed by the customer.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListCollectors.html
     *
     * @experimental
     */
    toListCollectors(): this;
    /**
     * (experimental) Grants permission to get list of all imports performed by the customer.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListImportFileTask.html
     *
     * @experimental
     */
    toListImportFileTask(): this;
    /**
     * (experimental) Grants permission to get a list of binaries that collector should assess.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListJarArtifacts.html
     *
     * @experimental
     */
    toListJarArtifacts(): this;
    /**
     * (experimental) Grants permission to get a list of all servers in a customer's environment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListServers.html
     *
     * @experimental
     */
    toListServers(): this;
    /**
     * (experimental) Grants permission to save customer's Migration/Modernization preferences.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_PutPortfolioPreferences.html
     *
     * @experimental
     */
    toPutPortfolioPreferences(): this;
    /**
     * (experimental) Grants permission to register the collector to receive an ID and to start receiving messages from the service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_RegisterCollector.html
     *
     * @experimental
     */
    toRegisterCollector(): this;
    /**
     * (experimental) Grants permission to the collector to send information to the service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_SendMessage.html
     *
     * @experimental
     */
    toSendMessage(): this;
    /**
     * (experimental) Grants permission to start assessment in a customer's environment (collect data from all servers and provide recommendations).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartAssessment.html
     *
     * @experimental
     */
    toStartAssessment(): this;
    /**
     * (experimental) Grants permission to start importing data from a file provided by customer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartImportFileTask.html
     *
     * @experimental
     */
    toStartImportFileTask(): this;
    /**
     * (experimental) Grants permission to start generating a recommendation report.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartRecommendationReportGeneration.html
     *
     * @experimental
     */
    toStartRecommendationReportGeneration(): this;
    /**
     * (experimental) Grants permission to stop an on-going assessment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StopAssessment.html
     *
     * @experimental
     */
    toStopAssessment(): this;
    /**
     * (experimental) Grants permission to update details for an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateApplicationComponentConfig.html
     *
     * @experimental
     */
    toUpdateApplicationComponentConfig(): this;
    /**
     * (experimental) Grants permission to update info on a server along with the recommended strategy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateServerConfig.html
     *
     * @experimental
     */
    toUpdateServerConfig(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations..html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
