import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [resiliencehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html).
 *
 * @experimental
 */
export declare class Resiliencehub extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to add draft application version resource mappings.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AddDraftAppVersionResourceMappings.html
     *
     * @experimental
     */
    toAddDraftAppVersionResourceMappings(): this;
    /**
     * (experimental) Grants permission to create application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateApp.html
     *
     * @experimental
     */
    toCreateApp(): this;
    /**
     * (experimental) Grants permission to create recommendation template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateRecommendationTemplate.html
     *
     * @experimental
     */
    toCreateRecommendationTemplate(): this;
    /**
     * (experimental) Grants permission to create resiliency policy.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateResiliencyPolicy.html
     *
     * @experimental
     */
    toCreateResiliencyPolicy(): this;
    /**
     * (experimental) Grants permission to batch delete application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteApp.html
     *
     * @experimental
     */
    toDeleteApp(): this;
    /**
     * (experimental) Grants permission to batch delete application assessment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteAppAssessment.html
     *
     * @experimental
     */
    toDeleteAppAssessment(): this;
    /**
     * (experimental) Grants permission to batch delete recommendation template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteRecommendationTemplate.html
     *
     * @experimental
     */
    toDeleteRecommendationTemplate(): this;
    /**
     * (experimental) Grants permission to batch delete resiliency policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteResiliencyPolicy.html
     *
     * @experimental
     */
    toDeleteResiliencyPolicy(): this;
    /**
     * (experimental) Grants permission to describe application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeApp.html
     *
     * @experimental
     */
    toDescribeApp(): this;
    /**
     * (experimental) Grants permission to describe application assessment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppAssessment.html
     *
     * @experimental
     */
    toDescribeAppAssessment(): this;
    /**
     * (experimental) Grants permission to describe application resolution.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionResourcesResolutionStatus.html
     *
     * @experimental
     */
    toDescribeAppVersionResourcesResolutionStatus(): this;
    /**
     * (experimental) Grants permission to describe application version template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionTemplate.html
     *
     * @experimental
     */
    toDescribeAppVersionTemplate(): this;
    /**
     * (experimental) Grants permission to describe draft application version resources import status.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeDraftAppVersionResourcesImportStatus.html
     *
     * @experimental
     */
    toDescribeDraftAppVersionResourcesImportStatus(): this;
    /**
     * (experimental) Grants permission to describe resiliency policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeResiliencyPolicy.html
     *
     * @experimental
     */
    toDescribeResiliencyPolicy(): this;
    /**
     * (experimental) Grants permission to import resources to draft application version.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ImportResourcesToDraftAppVersion.html
     *
     * @experimental
     */
    toImportResourcesToDraftAppVersion(): this;
    /**
     * (experimental) Grants permission to list alarm recommendation.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAlarmRecommendations.html
     *
     * @experimental
     */
    toListAlarmRecommendations(): this;
    /**
     * (experimental) Grants permission to list application assessment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppAssessments.html
     *
     * @experimental
     */
    toListAppAssessments(): this;
    /**
     * (experimental) Grants permission to list app component compliances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentCompliances.html
     *
     * @experimental
     */
    toListAppComponentCompliances(): this;
    /**
     * (experimental) Grants permission to list app component recommendations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentRecommendations.html
     *
     * @experimental
     */
    toListAppComponentRecommendations(): this;
    /**
     * (experimental) Grants permission to application version resource mappings.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResourceMappings.html
     *
     * @experimental
     */
    toListAppVersionResourceMappings(): this;
    /**
     * (experimental) Grants permission to list application resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResources.html
     *
     * @experimental
     */
    toListAppVersionResources(): this;
    /**
     * (experimental) Grants permission to list application version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersions.html
     *
     * @experimental
     */
    toListAppVersions(): this;
    /**
     * (experimental) Grants permission to list applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListApps.html
     *
     * @experimental
     */
    toListApps(): this;
    /**
     * (experimental) Grants permission to list recommendation templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListRecommendationTemplates.html
     *
     * @experimental
     */
    toListRecommendationTemplates(): this;
    /**
     * (experimental) Grants permission to list resiliency policies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListResiliencyPolicies.html
     *
     * @experimental
     */
    toListResiliencyPolicies(): this;
    /**
     * (experimental) Grants permission to list SOP recommendations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSopRecommendations.html
     *
     * @experimental
     */
    toListSopRecommendations(): this;
    /**
     * (experimental) Grants permission to list suggested resiliency policies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSuggestedResiliencyPolicies.html
     *
     * @experimental
     */
    toListSuggestedResiliencyPolicies(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list test recommendations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTestRecommendations.html
     *
     * @experimental
     */
    toListTestRecommendations(): this;
    /**
     * (experimental) Grants permission to list unsupported application version resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListUnsupportedAppVersionResources.html
     *
     * @experimental
     */
    toListUnsupportedAppVersionResources(): this;
    /**
     * (experimental) Grants permission to publish application version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PublishAppVersion.html
     *
     * @experimental
     */
    toPublishAppVersion(): this;
    /**
     * (experimental) Grants permission to put draft application version template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PutDraftAppVersionTemplate.html
     *
     * @experimental
     */
    toPutDraftAppVersionTemplate(): this;
    /**
     * (experimental) Grants permission to remove draft application version mappings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RemoveDraftAppVersionResourceMappings.html
     *
     * @experimental
     */
    toRemoveDraftAppVersionResourceMappings(): this;
    /**
     * (experimental) Grants permission to resolve application version resources.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResolveAppVersionResources.html
     *
     * @experimental
     */
    toResolveAppVersionResources(): this;
    /**
     * (experimental) Grants permission to create application assessment.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - cloudwatch:DescribeAlarms
     * - cloudwatch:GetMetricData
     * - cloudwatch:GetMetricStatistics
     * - cloudwatch:PutMetricData
     * - fis:GetExperimentTemplate
     * - fis:ListExperimentTemplates
     * - fis:ListExperiments
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     * - ssm:GetParametersByPath
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_StartAppAssessment.html
     *
     * @experimental
     */
    toStartAppAssessment(): this;
    /**
     * (experimental) Grants permission to assign a resource tag.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateApp.html
     *
     * @experimental
     */
    toUpdateApp(): this;
    /**
     * (experimental) Grants permission to update resiliency policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateResiliencyPolicy.html
     *
     * @experimental
     */
    toUpdateResiliencyPolicy(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type resiliency-policy to the statement.
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResiliencyPolicy.html
     *
     * @param resiliencyPolicyID - Identifier for the resiliencyPolicyID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onResiliencyPolicy(resiliencyPolicyID: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type application to the statement.
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_App.html
     *
     * @param appID - Identifier for the appID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onApplication(appID: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type app-assessment to the statement.
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AppAssessment.html
     *
     * @param appAssessmentID - Identifier for the appAssessmentID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAppAssessment(appAssessmentID: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type recommendation-template to the statement.
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RecommendationTemplate.html
     *
     * @param recommendationTemplateID - Identifier for the recommendationTemplateID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRecommendationTemplate(recommendationTemplateID: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [resiliencehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
