import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [robomaker](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrobomaker.html).
 *
 * @experimental
 */
export declare class Robomaker extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Delete one or more worlds in a batch operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_BatchDeleteWorlds.html
     *
     * @experimental
     */
    toBatchDeleteWorlds(): this;
    /**
     * (experimental) Describe multiple simulation jobs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_BatchDescribeSimulationJob.html
     *
     * @experimental
     */
    toBatchDescribeSimulationJob(): this;
    /**
     * (experimental) Cancel a deployment job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelDeploymentJob.html
     *
     * @experimental
     */
    toCancelDeploymentJob(): this;
    /**
     * (experimental) Cancel a simulation job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelSimulationJob.html
     *
     * @experimental
     */
    toCancelSimulationJob(): this;
    /**
     * (experimental) Cancel a simulation job batch.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelSimulationJobBatch.html
     *
     * @experimental
     */
    toCancelSimulationJobBatch(): this;
    /**
     * (experimental) Cancel a world export job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelWorldExportJob.html
     *
     * @experimental
     */
    toCancelWorldExportJob(): this;
    /**
     * (experimental) Cancel a world generation job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CancelWorldGenerationJob.html
     *
     * @experimental
     */
    toCancelWorldGenerationJob(): this;
    /**
     * (experimental) Create a deployment job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateDeploymentJob.html
     *
     * @experimental
     */
    toCreateDeploymentJob(): this;
    /**
     * (experimental) Create a deployment fleet that represents a logical group of robots running the same robot application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateFleet.html
     *
     * @experimental
     */
    toCreateFleet(): this;
    /**
     * (experimental) Create a robot that can be registered to a fleet.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateRobot.html
     *
     * @experimental
     */
    toCreateRobot(): this;
    /**
     * (experimental) Create a robot application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateRobotApplication.html
     *
     * @experimental
     */
    toCreateRobotApplication(): this;
    /**
     * (experimental) Create a snapshot of a robot application.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateRobotApplicationVersion.html
     *
     * @experimental
     */
    toCreateRobotApplicationVersion(): this;
    /**
     * (experimental) Create a simulation application.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateSimulationApplication.html
     *
     * @experimental
     */
    toCreateSimulationApplication(): this;
    /**
     * (experimental) Create a snapshot of a simulation application.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateSimulationApplicationVersion.html
     *
     * @experimental
     */
    toCreateSimulationApplicationVersion(): this;
    /**
     * (experimental) Create a simulation job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateSimulationJob.html
     *
     * @experimental
     */
    toCreateSimulationJob(): this;
    /**
     * (experimental) Create a world export job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateWorldExportJob.html
     *
     * @experimental
     */
    toCreateWorldExportJob(): this;
    /**
     * (experimental) Create a world generation job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateWorldGenerationJob.html
     *
     * @experimental
     */
    toCreateWorldGenerationJob(): this;
    /**
     * (experimental) Create a world template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_CreateWorldTemplate.html
     *
     * @experimental
     */
    toCreateWorldTemplate(): this;
    /**
     * (experimental) Delete a deployment fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteFleet.html
     *
     * @experimental
     */
    toDeleteFleet(): this;
    /**
     * (experimental) Delete a robot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteRobot.html
     *
     * @experimental
     */
    toDeleteRobot(): this;
    /**
     * (experimental) Delete a robot application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteRobotApplication.html
     *
     * @experimental
     */
    toDeleteRobotApplication(): this;
    /**
     * (experimental) Delete a simulation application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteSimulationApplication.html
     *
     * @experimental
     */
    toDeleteSimulationApplication(): this;
    /**
     * (experimental) Delete a world template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DeleteWorldTemplate.html
     *
     * @experimental
     */
    toDeleteWorldTemplate(): this;
    /**
     * (experimental) Deregister a robot from a fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DeregisterRobot.html
     *
     * @experimental
     */
    toDeregisterRobot(): this;
    /**
     * (experimental) Describe a deployment job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeDeploymentJob.html
     *
     * @experimental
     */
    toDescribeDeploymentJob(): this;
    /**
     * (experimental) Describe a deployment fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeFleet.html
     *
     * @experimental
     */
    toDescribeFleet(): this;
    /**
     * (experimental) Describe a robot.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeRobot.html
     *
     * @experimental
     */
    toDescribeRobot(): this;
    /**
     * (experimental) Describe a robot application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeRobotApplication.html
     *
     * @experimental
     */
    toDescribeRobotApplication(): this;
    /**
     * (experimental) Describe a simulation application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeSimulationApplication.html
     *
     * @experimental
     */
    toDescribeSimulationApplication(): this;
    /**
     * (experimental) Describe a simulation job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeSimulationJob.html
     *
     * @experimental
     */
    toDescribeSimulationJob(): this;
    /**
     * (experimental) Describe a simulation job batch.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeSimulationJobBatch.html
     *
     * @experimental
     */
    toDescribeSimulationJobBatch(): this;
    /**
     * (experimental) Describe a world.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorld.html
     *
     * @experimental
     */
    toDescribeWorld(): this;
    /**
     * (experimental) Describe a world export job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorldExportJob.html
     *
     * @experimental
     */
    toDescribeWorldExportJob(): this;
    /**
     * (experimental) Describe a world generation job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorldGenerationJob.html
     *
     * @experimental
     */
    toDescribeWorldGenerationJob(): this;
    /**
     * (experimental) Describe a world template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_DescribeWorldTemplate.html
     *
     * @experimental
     */
    toDescribeWorldTemplate(): this;
    /**
     * (experimental) Get the body of a world template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_GetWorldTemplateBody.html
     *
     * @experimental
     */
    toGetWorldTemplateBody(): this;
    /**
     * (experimental) List deployment jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListDeploymentJobs.html
     *
     * @experimental
     */
    toListDeploymentJobs(): this;
    /**
     * (experimental) List fleets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListFleets.html
     *
     * @experimental
     */
    toListFleets(): this;
    /**
     * (experimental) List robot applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListRobotApplications.html
     *
     * @experimental
     */
    toListRobotApplications(): this;
    /**
     * (experimental) List robots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListRobots.html
     *
     * @experimental
     */
    toListRobots(): this;
    /**
     * (experimental) List simulation applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListSimulationApplications.html
     *
     * @experimental
     */
    toListSimulationApplications(): this;
    /**
     * (experimental) List simulation job batches.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListSimulationJobBatches.html
     *
     * @experimental
     */
    toListSimulationJobBatches(): this;
    /**
     * (experimental) List simulation jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListSimulationJobs.html
     *
     * @experimental
     */
    toListSimulationJobs(): this;
    /**
     * (experimental) Lists supported availability zones.
     *
     * Access Level: List
     *
     * @experimental
     */
    toListSupportedAvailabilityZones(): this;
    /**
     * (experimental) List tags for a RoboMaker resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) List world export jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorldExportJobs.html
     *
     * @experimental
     */
    toListWorldExportJobs(): this;
    /**
     * (experimental) List world generation jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorldGenerationJobs.html
     *
     * @experimental
     */
    toListWorldGenerationJobs(): this;
    /**
     * (experimental) List world templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorldTemplates.html
     *
     * @experimental
     */
    toListWorldTemplates(): this;
    /**
     * (experimental) List worlds.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_ListWorlds.html
     *
     * @experimental
     */
    toListWorlds(): this;
    /**
     * (experimental) Register a robot to a fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_RegisterRobot.html
     *
     * @experimental
     */
    toRegisterRobot(): this;
    /**
     * (experimental) Restart a running simulation job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_RestartSimulationJob.html
     *
     * @experimental
     */
    toRestartSimulationJob(): this;
    /**
     * (experimental) Create a simulation job batch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_StartSimulationJobBatch.html
     *
     * @experimental
     */
    toStartSimulationJobBatch(): this;
    /**
     * (experimental) Ensures the most recently deployed robot application is deployed to all robots in the fleet.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_SyncDeploymentJob.html
     *
     * @experimental
     */
    toSyncDeploymentJob(): this;
    /**
     * (experimental) Add tags to a RoboMaker resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Remove tags from a RoboMaker resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Update a robot application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_UpdateRobotApplication.html
     *
     * @experimental
     */
    toUpdateRobotApplication(): this;
    /**
     * (experimental) Report the deployment status for an individual robot.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toUpdateRobotDeployment(): this;
    /**
     * (experimental) Update a simulation application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_UpdateSimulationApplication.html
     *
     * @experimental
     */
    toUpdateSimulationApplication(): this;
    /**
     * (experimental) Update a world template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/API_UpdateWorldTemplate.html
     *
     * @experimental
     */
    toUpdateWorldTemplate(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type robotApplication to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/managing-robot-applications.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param createdOnEpoch - Identifier for the createdOnEpoch.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRobotApplication(applicationName: string, createdOnEpoch: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type simulationApplication to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/managing-simulation-applications.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param createdOnEpoch - Identifier for the createdOnEpoch.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSimulationApplication(applicationName: string, createdOnEpoch: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type simulationJob to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/simulation.html
     *
     * @param simulationJobId - Identifier for the simulationJobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSimulationJob(simulationJobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type simulationJobBatch to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/simulation-job-batch.html
     *
     * @param simulationJobBatchId - Identifier for the simulationJobBatchId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSimulationJobBatch(simulationJobBatchId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type deploymentJob to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/deployment.html
     *
     * @param deploymentJobId - Identifier for the deploymentJobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDeploymentJob(deploymentJobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type robot to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/fleets.html
     *
     * @param robotName - Identifier for the robotName.
     * @param createdOnEpoch - Identifier for the createdOnEpoch.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRobot(robotName: string, createdOnEpoch: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type deploymentFleet to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/managing-simulation-applications.html
     *
     * @param fleetName - Identifier for the fleetName.
     * @param createdOnEpoch - Identifier for the createdOnEpoch.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDeploymentFleet(fleetName: string, createdOnEpoch: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type worldGenerationJob to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-generation-jobs.html
     *
     * @param worldGenerationJobId - Identifier for the worldGenerationJobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorldGenerationJob(worldGenerationJobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type worldExportJob to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-export-jobs.html
     *
     * @param worldExportJobId - Identifier for the worldExportJobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorldExportJob(worldExportJobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type worldTemplate to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-simworld-templates.html
     *
     * @param worldTemplateJobId - Identifier for the worldTemplateJobId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorldTemplate(worldTemplateJobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type world to the statement.
     *
     * https://docs.aws.amazon.com/robomaker/latest/dg/worlds-managing-generated-worlds.html
     *
     * @param worldId - Identifier for the worldId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorld(worldId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [robomaker](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsrobomaker.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
