import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [snow-device-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowdevicemanagement.html).
 *
 * @experimental
 */
export declare class SnowDeviceManagement extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to cancel tasks on remote devices.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-cancel-task.html
     *
     * @experimental
     */
    toCancelTask(): this;
    /**
     * (experimental) Grants permission to create tasks on remote devices.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-create-task.html
     *
     * @experimental
     */
    toCreateTask(): this;
    /**
     * (experimental) Grants permission to describe a remotely-managed device.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-describe-device.html
     *
     * @experimental
     */
    toDescribeDevice(): this;
    /**
     * (experimental) Grants permission to describe a remotely-managed device's EC2 instances.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-describe-ec2-instances.html
     *
     * @experimental
     */
    toDescribeDeviceEc2Instances(): this;
    /**
     * (experimental) Grants permission to describe task executions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-describe-execution.html
     *
     * @experimental
     */
    toDescribeExecution(): this;
    /**
     * (experimental) Grants permission to describe a task.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-describe-task.html
     *
     * @experimental
     */
    toDescribeTask(): this;
    /**
     * (experimental) Grants permission to list a remotely-managed device's resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-device-resources.html
     *
     * @experimental
     */
    toListDeviceResources(): this;
    /**
     * (experimental) Grants permission to list remotely-managed devices.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-devices.html
     *
     * @experimental
     */
    toListDevices(): this;
    /**
     * (experimental) Grants permission to list task executions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-executions.html
     *
     * @experimental
     */
    toListExecutions(): this;
    /**
     * (experimental) Grants permission to list the tags for a resource (device or task).
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-tags-for-resource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-tasks.html
     *
     * @experimental
     */
    toListTasks(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-tag-resource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-untag-resources.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type managed-device to the statement.
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/aws-sdms.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onManagedDevice(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type task to the statement.
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/aws-sdms.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTask(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [snow-device-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowdevicemanagement.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
