import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [workdocs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkdocs.html).
 *
 * @experimental
 */
export declare class Workdocs extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to abort the upload of the specified document version that was previously initiated by InitiateDocumentVersionUpload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AbortDocumentVersionUpload.html
     *
     * @experimental
     */
    toAbortDocumentVersionUpload(): this;
    /**
     * (experimental) Grants permission to activate the specified user. Only active users can access Amazon WorkDocs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_ActivateUser.html
     *
     * @experimental
     */
    toActivateUser(): this;
    /**
     * (experimental) Grants permission to create a set of permissions for the specified folder or document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_AddResourcePermissions.html
     *
     * @experimental
     */
    toAddResourcePermissions(): this;
    /**
     * (experimental) Grants permission to add a user to a group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage_set_admin.html
     *
     * @experimental
     */
    toAddUserToGroup(): this;
    /**
     * (experimental) Grants permission to check an alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/cloud_quick_start.html
     *
     * @experimental
     */
    toCheckAlias(): this;
    /**
     * (experimental) Grants permission to add a new comment to the specified document version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateComment.html
     *
     * @experimental
     */
    toCreateComment(): this;
    /**
     * (experimental) Grants permission to add one or more custom properties to the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateCustomMetadata.html
     *
     * @experimental
     */
    toCreateCustomMetadata(): this;
    /**
     * (experimental) Grants permission to create a folder with the specified name and parent folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateFolder.html
     *
     * @experimental
     */
    toCreateFolder(): this;
    /**
     * (experimental) Grants permission to create an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     *
     * @experimental
     */
    toCreateInstance(): this;
    /**
     * (experimental) Grants permission to add labels to the given resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateLabels.html
     *
     * @experimental
     */
    toCreateLabels(): this;
    /**
     * (experimental) Grants permission to configure WorkDocs to use Amazon SNS notifications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateNotificationSubscription.html
     *
     * @experimental
     */
    toCreateNotificationSubscription(): this;
    /**
     * (experimental) Grants permission to create a user in a Simple AD or Microsoft AD directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_CreateUser.html
     *
     * @experimental
     */
    toCreateUser(): this;
    /**
     * (experimental) Grants permission to deactivate the specified user, which revokes the user's access to Amazon WorkDocs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeactivateUser.html
     *
     * @experimental
     */
    toDeactivateUser(): this;
    /**
     * (experimental) Grants permission to delete the specified comment from the document version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteComment.html
     *
     * @experimental
     */
    toDeleteComment(): this;
    /**
     * (experimental) Grants permission to delete custom metadata from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteCustomMetadata.html
     *
     * @experimental
     */
    toDeleteCustomMetadata(): this;
    /**
     * (experimental) Grants permission to permanently delete the specified document and its associated metadata.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteDocument.html
     *
     * @experimental
     */
    toDeleteDocument(): this;
    /**
     * (experimental) Grants permission to permanently delete the specified folder and its contents.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolder.html
     *
     * @experimental
     */
    toDeleteFolder(): this;
    /**
     * (experimental) Grants permission to delete the contents of the specified folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteFolderContents.html
     *
     * @experimental
     */
    toDeleteFolderContents(): this;
    /**
     * (experimental) Grants permission to delete an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     *
     * @experimental
     */
    toDeleteInstance(): this;
    /**
     * (experimental) Grants permission to delete one or more labels from a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteLabels.html
     *
     * @experimental
     */
    toDeleteLabels(): this;
    /**
     * (experimental) Grants permission to delete the specified subscription from the specified organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteNotificationSubscription.html
     *
     * @experimental
     */
    toDeleteNotificationSubscription(): this;
    /**
     * (experimental) Grants permission to delete the specified user from a Simple AD or Microsoft AD directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DeleteUser.html
     *
     * @experimental
     */
    toDeleteUser(): this;
    /**
     * (experimental) Grants permission to deregister a directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html#delete_site
     *
     * @experimental
     */
    toDeregisterDirectory(): this;
    /**
     * (experimental) Grants permission to fetch user activities in a specified time period.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeActivities.html
     *
     * @experimental
     */
    toDescribeActivities(): this;
    /**
     * (experimental) Grants permission to describe available directories.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     *
     * @experimental
     */
    toDescribeAvailableDirectories(): this;
    /**
     * (experimental) Grants permission to list all the comments for the specified document version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeComments.html
     *
     * @experimental
     */
    toDescribeComments(): this;
    /**
     * (experimental) Grants permission to retrieve the document versions for the specified document.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeDocumentVersions.html
     *
     * @experimental
     */
    toDescribeDocumentVersions(): this;
    /**
     * (experimental) Grants permission to describe the contents of the specified folder, including its documents and sub-folders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeFolderContents.html
     *
     * @experimental
     */
    toDescribeFolderContents(): this;
    /**
     * (experimental) Grants permission to describe the user groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeGroups.html
     *
     * @experimental
     */
    toDescribeGroups(): this;
    /**
     * (experimental) Grants permission to describe instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     *
     * @experimental
     */
    toDescribeInstances(): this;
    /**
     * (experimental) Grants permission to list the specified notification subscriptions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeNotificationSubscriptions.html
     *
     * @experimental
     */
    toDescribeNotificationSubscriptions(): this;
    /**
     * (experimental) Grants permission to view a description of a specified resource's permissions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeResourcePermissions.html
     *
     * @experimental
     */
    toDescribeResourcePermissions(): this;
    /**
     * (experimental) Grants permission to describe the root folders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeRootFolders.html
     *
     * @experimental
     */
    toDescribeRootFolders(): this;
    /**
     * (experimental) Grants permission to view a description of the specified users.
     *
     * You can describe all users or filter the results (for example, by status or organization).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_DescribeUsers.html
     *
     * @experimental
     */
    toDescribeUsers(): this;
    /**
     * (experimental) Grants permission to download a specified document version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     *
     * @experimental
     */
    toDownloadDocumentVersion(): this;
    /**
     * (experimental) Grants permission to retrieve the details of the current user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetCurrentUser.html
     *
     * @experimental
     */
    toGetCurrentUser(): this;
    /**
     * (experimental) Grants permission to retrieve the specified document object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocument.html
     *
     * @experimental
     */
    toGetDocument(): this;
    /**
     * (experimental) Grants permission to retrieve the path information (the hierarchy from the root folder) for the requested document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentPath.html
     *
     * @experimental
     */
    toGetDocumentPath(): this;
    /**
     * (experimental) Grants permission to retrieve version metadata for the specified document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetDocumentVersion.html
     *
     * @experimental
     */
    toGetDocumentVersion(): this;
    /**
     * (experimental) Grants permission to retrieve the metadata of the specified folder.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolder.html
     *
     * @experimental
     */
    toGetFolder(): this;
    /**
     * (experimental) Grants permission to retrieve the path information (the hierarchy from the root folder) for the specified folder.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetFolderPath.html
     *
     * @experimental
     */
    toGetFolderPath(): this;
    /**
     * (experimental) Grants permission to retrieve details for the specified group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_Operations.html
     *
     * @experimental
     */
    toGetGroup(): this;
    /**
     * (experimental) Grants permission to get a collection of resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_GetResources.html
     *
     * @experimental
     */
    toGetResources(): this;
    /**
     * (experimental) Grants permission to create a new document object and version object.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_InitiateDocumentVersionUpload.html
     *
     * @experimental
     */
    toInitiateDocumentVersionUpload(): this;
    /**
     * (experimental) Grants permission to register a directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/existing-dir-setup.html
     *
     * @experimental
     */
    toRegisterDirectory(): this;
    /**
     * (experimental) Grants permission to remove all the permissions from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveAllResourcePermissions.html
     *
     * @experimental
     */
    toRemoveAllResourcePermissions(): this;
    /**
     * (experimental) Grants permission to remove the permission for the specified principal from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_RemoveResourcePermission.html
     *
     * @experimental
     */
    toRemoveResourcePermission(): this;
    /**
     * (experimental) Grants permission to update the specified attributes of the specified document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocument.html
     *
     * @experimental
     */
    toUpdateDocument(): this;
    /**
     * (experimental) Grants permission to change the status of the document version to ACTIVE.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateDocumentVersion.html
     *
     * @experimental
     */
    toUpdateDocumentVersion(): this;
    /**
     * (experimental) Grants permission to update the specified attributes of the specified folder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateFolder.html
     *
     * @experimental
     */
    toUpdateFolder(): this;
    /**
     * (experimental) Grants permission to update an instance alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/adminguide/getting_started.html
     *
     * @experimental
     */
    toUpdateInstanceAlias(): this;
    /**
     * (experimental) Grants permission to update the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workdocs/latest/APIReference/API_UpdateUser.html
     *
     * @experimental
     */
    toUpdateUser(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [workdocs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkdocs.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
