"""
# Terraform CDK google Provider ~> 3.0

This repo builds and publishes the Terraform google Provider bindings for [cdktf](https://cdk.tf).

Current build targets are:

* npm
* Pypi

## Versioning

This project is explicitly not tracking the Terraform google Provider version 1:1. In fact, it always tracks `latest` of `~> 3.0` with every release. If there scenarios where you explicitly have to pin your provider version, you can do so by generating the [provider constructs manually](https://cdk.tf/imports).

These are the upstream dependencies:

* [Terraform CDK](https://cdk.tf)
* [Terraform google Provider](https://github.com/terraform-providers/terraform-provider-google)
* [Terraform Engine](https://terraform.io)

If there are breaking changes (backward incompatible) in any of the above, the major version of this project will be bumped. While the Terraform Engine and the Terraform google Provider are relatively stable, the Terraform CDK is in an early stage. Therefore, it's likely that there will be breaking changes.

## Features / Issues / Bugs

Please report bugs and issues to the [terraform cdk](https://cdk.tf) project:

* [Create bug report](https://cdk.tf/bug)
* [Create feature request](https://cdk.tf/feature)

## Contributing

## projen

This is mostly based on [projen](https://github.com/eladb/projen), which takes care of generating the entire repository.

## cdktf-provider-project based on projen

There's a custom [project builder](https://github.com/skorfmann/cdktf-provider-project) which encapsulate the common settings for all `cdktf` providers.

## provider version

The provider version can be adjusted in [./.projenrc.js](./.projenrc.js).
"""
import abc
import builtins
import datetime
import enum
import typing

import jsii
import jsii.compat
import publication

from ._jsii import *

import cdktf
import constructs


class AccessContextManagerAccessLevel(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AccessContextManagerAccessLevel"):
    def __init__(self, scope: constructs.Construct, id: str, *, name: str, parent: str, title: str, basic: typing.Optional[typing.List["AccessContextManagerAccessLevelBasic"]]=None, custom: typing.Optional[typing.List["AccessContextManagerAccessLevelCustom"]]=None, description: typing.Optional[str]=None, timeouts: typing.Optional["AccessContextManagerAccessLevelTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param name: Resource name for the Access Level. The short_name component must begin with a letter and only include alphanumeric and '_'. Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        :param parent: The AccessPolicy this AccessLevel lives in. Format: accessPolicies/{policy_id}
        :param title: Human readable title. Must be unique within the Policy.
        :param basic: basic block.
        :param custom: custom block.
        :param description: Description of the AccessLevel and its use. Does not affect behavior.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AccessContextManagerAccessLevelConfig(name=name, parent=parent, title=title, basic=basic, custom=custom, description=description, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AccessContextManagerAccessLevel, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="parent")
    def parent(self) -> str:
        return jsii.get(self, "parent")

    @parent.setter
    def parent(self, value: str) -> None:
        jsii.set(self, "parent", value)

    @builtins.property
    @jsii.member(jsii_name="title")
    def title(self) -> str:
        return jsii.get(self, "title")

    @title.setter
    def title(self, value: str) -> None:
        jsii.set(self, "title", value)

    @builtins.property
    @jsii.member(jsii_name="basic")
    def basic(self) -> typing.Optional[typing.List["AccessContextManagerAccessLevelBasic"]]:
        return jsii.get(self, "basic")

    @basic.setter
    def basic(self, value: typing.Optional[typing.List["AccessContextManagerAccessLevelBasic"]]) -> None:
        jsii.set(self, "basic", value)

    @builtins.property
    @jsii.member(jsii_name="custom")
    def custom(self) -> typing.Optional[typing.List["AccessContextManagerAccessLevelCustom"]]:
        return jsii.get(self, "custom")

    @custom.setter
    def custom(self, value: typing.Optional[typing.List["AccessContextManagerAccessLevelCustom"]]) -> None:
        jsii.set(self, "custom", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AccessContextManagerAccessLevelTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AccessContextManagerAccessLevelTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessLevelBasic", jsii_struct_bases=[], name_mapping={'conditions': 'conditions', 'combining_function': 'combiningFunction'})
class AccessContextManagerAccessLevelBasic():
    def __init__(self, *, conditions: typing.List["AccessContextManagerAccessLevelBasicConditions"], combining_function: typing.Optional[str]=None) -> None:
        """
        :param conditions: conditions block.
        :param combining_function: How the conditions list should be combined to determine if a request is granted this AccessLevel. If AND is used, each Condition in conditions must be satisfied for the AccessLevel to be applied. If OR is used, at least one Condition in conditions must be satisfied for the AccessLevel to be applied. Default value: "AND" Possible values: ["AND", "OR"]
        """
        self._values = {
            'conditions': conditions,
        }
        if combining_function is not None: self._values["combining_function"] = combining_function

    @builtins.property
    def conditions(self) -> typing.List["AccessContextManagerAccessLevelBasicConditions"]:
        """conditions block."""
        return self._values.get('conditions')

    @builtins.property
    def combining_function(self) -> typing.Optional[str]:
        """How the conditions list should be combined to determine if a request is granted this AccessLevel.

        If AND is used, each Condition in
        conditions must be satisfied for the AccessLevel to be applied. If
        OR is used, at least one Condition in conditions must be satisfied
        for the AccessLevel to be applied. Default value: "AND" Possible values: ["AND", "OR"]
        """
        return self._values.get('combining_function')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessLevelBasic(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessLevelBasicConditions", jsii_struct_bases=[], name_mapping={'device_policy': 'devicePolicy', 'ip_subnetworks': 'ipSubnetworks', 'members': 'members', 'negate': 'negate', 'regions': 'regions', 'required_access_levels': 'requiredAccessLevels'})
class AccessContextManagerAccessLevelBasicConditions():
    def __init__(self, *, device_policy: typing.Optional[typing.List["AccessContextManagerAccessLevelBasicConditionsDevicePolicy"]]=None, ip_subnetworks: typing.Optional[typing.List[str]]=None, members: typing.Optional[typing.List[str]]=None, negate: typing.Optional[bool]=None, regions: typing.Optional[typing.List[str]]=None, required_access_levels: typing.Optional[typing.List[str]]=None) -> None:
        """
        :param device_policy: device_policy block.
        :param ip_subnetworks: A list of CIDR block IP subnetwork specification. May be IPv4 or IPv6. Note that for a CIDR IP address block, the specified IP address portion must be properly truncated (i.e. all the host bits must be zero) or the input is considered malformed. For example, "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32" is not. The originating IP of a request must be in one of the listed subnets in order for this Condition to be true. If empty, all IP addresses are allowed.
        :param members: An allowed list of members (users, service accounts). Using groups is not supported yet. The signed-in user originating the request must be a part of one of the provided members. If not specified, a request may come from any user (logged in/not logged in, not present in any groups, etc.). Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
        :param negate: Whether to negate the Condition. If true, the Condition becomes a NAND over its non-empty fields, each field must be false for the Condition overall to be satisfied. Defaults to false.
        :param regions: The request must originate from one of the provided countries/regions. Format: A valid ISO 3166-1 alpha-2 code.
        :param required_access_levels: A list of other access levels defined in the same Policy, referenced by resource name. Referencing an AccessLevel which does not exist is an error. All access levels listed must be granted for the Condition to be true. Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        self._values = {
        }
        if device_policy is not None: self._values["device_policy"] = device_policy
        if ip_subnetworks is not None: self._values["ip_subnetworks"] = ip_subnetworks
        if members is not None: self._values["members"] = members
        if negate is not None: self._values["negate"] = negate
        if regions is not None: self._values["regions"] = regions
        if required_access_levels is not None: self._values["required_access_levels"] = required_access_levels

    @builtins.property
    def device_policy(self) -> typing.Optional[typing.List["AccessContextManagerAccessLevelBasicConditionsDevicePolicy"]]:
        """device_policy block."""
        return self._values.get('device_policy')

    @builtins.property
    def ip_subnetworks(self) -> typing.Optional[typing.List[str]]:
        """A list of CIDR block IP subnetwork specification.

        May be IPv4
        or IPv6.
        Note that for a CIDR IP address block, the specified IP address
        portion must be properly truncated (i.e. all the host bits must
        be zero) or the input is considered malformed. For example,
        "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
        for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
        is not. The originating IP of a request must be in one of the
        listed subnets in order for this Condition to be true.
        If empty, all IP addresses are allowed.
        """
        return self._values.get('ip_subnetworks')

    @builtins.property
    def members(self) -> typing.Optional[typing.List[str]]:
        """An allowed list of members (users, service accounts). Using groups is not supported yet.

        The signed-in user originating the request must be a part of one
        of the provided members. If not specified, a request may come
        from any user (logged in/not logged in, not present in any
        groups, etc.).
        Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
        """
        return self._values.get('members')

    @builtins.property
    def negate(self) -> typing.Optional[bool]:
        """Whether to negate the Condition.

        If true, the Condition becomes
        a NAND over its non-empty fields, each field must be false for
        the Condition overall to be satisfied. Defaults to false.
        """
        return self._values.get('negate')

    @builtins.property
    def regions(self) -> typing.Optional[typing.List[str]]:
        """The request must originate from one of the provided countries/regions.

        Format: A valid ISO 3166-1 alpha-2 code.
        """
        return self._values.get('regions')

    @builtins.property
    def required_access_levels(self) -> typing.Optional[typing.List[str]]:
        """A list of other access levels defined in the same Policy, referenced by resource name.

        Referencing an AccessLevel which
        does not exist is an error. All access levels listed must be
        granted for the Condition to be true.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return self._values.get('required_access_levels')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessLevelBasicConditions(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessLevelBasicConditionsDevicePolicy", jsii_struct_bases=[], name_mapping={'allowed_device_management_levels': 'allowedDeviceManagementLevels', 'allowed_encryption_statuses': 'allowedEncryptionStatuses', 'os_constraints': 'osConstraints', 'require_admin_approval': 'requireAdminApproval', 'require_corp_owned': 'requireCorpOwned', 'require_screen_lock': 'requireScreenLock'})
class AccessContextManagerAccessLevelBasicConditionsDevicePolicy():
    def __init__(self, *, allowed_device_management_levels: typing.Optional[typing.List[str]]=None, allowed_encryption_statuses: typing.Optional[typing.List[str]]=None, os_constraints: typing.Optional[typing.List["AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints"]]=None, require_admin_approval: typing.Optional[bool]=None, require_corp_owned: typing.Optional[bool]=None, require_screen_lock: typing.Optional[bool]=None) -> None:
        """
        :param allowed_device_management_levels: A list of allowed device management levels. An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"]
        :param allowed_encryption_statuses: A list of allowed encryptions statuses. An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"]
        :param os_constraints: os_constraints block.
        :param require_admin_approval: Whether the device needs to be approved by the customer admin.
        :param require_corp_owned: Whether the device needs to be corp owned.
        :param require_screen_lock: Whether or not screenlock is required for the DevicePolicy to be true. Defaults to false.
        """
        self._values = {
        }
        if allowed_device_management_levels is not None: self._values["allowed_device_management_levels"] = allowed_device_management_levels
        if allowed_encryption_statuses is not None: self._values["allowed_encryption_statuses"] = allowed_encryption_statuses
        if os_constraints is not None: self._values["os_constraints"] = os_constraints
        if require_admin_approval is not None: self._values["require_admin_approval"] = require_admin_approval
        if require_corp_owned is not None: self._values["require_corp_owned"] = require_corp_owned
        if require_screen_lock is not None: self._values["require_screen_lock"] = require_screen_lock

    @builtins.property
    def allowed_device_management_levels(self) -> typing.Optional[typing.List[str]]:
        """A list of allowed device management levels.

        An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"]
        """
        return self._values.get('allowed_device_management_levels')

    @builtins.property
    def allowed_encryption_statuses(self) -> typing.Optional[typing.List[str]]:
        """A list of allowed encryptions statuses.

        An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"]
        """
        return self._values.get('allowed_encryption_statuses')

    @builtins.property
    def os_constraints(self) -> typing.Optional[typing.List["AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints"]]:
        """os_constraints block."""
        return self._values.get('os_constraints')

    @builtins.property
    def require_admin_approval(self) -> typing.Optional[bool]:
        """Whether the device needs to be approved by the customer admin."""
        return self._values.get('require_admin_approval')

    @builtins.property
    def require_corp_owned(self) -> typing.Optional[bool]:
        """Whether the device needs to be corp owned."""
        return self._values.get('require_corp_owned')

    @builtins.property
    def require_screen_lock(self) -> typing.Optional[bool]:
        """Whether or not screenlock is required for the DevicePolicy to be true.

        Defaults to false.
        """
        return self._values.get('require_screen_lock')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessLevelBasicConditionsDevicePolicy(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints", jsii_struct_bases=[], name_mapping={'os_type': 'osType', 'minimum_version': 'minimumVersion'})
class AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints():
    def __init__(self, *, os_type: str, minimum_version: typing.Optional[str]=None) -> None:
        """
        :param os_type: The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS"]
        :param minimum_version: The minimum allowed OS version. If not set, any version of this OS satisfies the constraint. Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        self._values = {
            'os_type': os_type,
        }
        if minimum_version is not None: self._values["minimum_version"] = minimum_version

    @builtins.property
    def os_type(self) -> str:
        """The operating system type of the device.

        Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS"]
        """
        return self._values.get('os_type')

    @builtins.property
    def minimum_version(self) -> typing.Optional[str]:
        """The minimum allowed OS version.

        If not set, any version
        of this OS satisfies the constraint.
        Format: "major.minor.patch" such as "10.5.301", "9.2.1".
        """
        return self._values.get('minimum_version')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessLevelConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'name': 'name', 'parent': 'parent', 'title': 'title', 'basic': 'basic', 'custom': 'custom', 'description': 'description', 'timeouts': 'timeouts'})
class AccessContextManagerAccessLevelConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, name: str, parent: str, title: str, basic: typing.Optional[typing.List["AccessContextManagerAccessLevelBasic"]]=None, custom: typing.Optional[typing.List["AccessContextManagerAccessLevelCustom"]]=None, description: typing.Optional[str]=None, timeouts: typing.Optional["AccessContextManagerAccessLevelTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: Resource name for the Access Level. The short_name component must begin with a letter and only include alphanumeric and '_'. Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        :param parent: The AccessPolicy this AccessLevel lives in. Format: accessPolicies/{policy_id}
        :param title: Human readable title. Must be unique within the Policy.
        :param basic: basic block.
        :param custom: custom block.
        :param description: Description of the AccessLevel and its use. Does not affect behavior.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AccessContextManagerAccessLevelTimeouts(**timeouts)
        self._values = {
            'name': name,
            'parent': parent,
            'title': title,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if basic is not None: self._values["basic"] = basic
        if custom is not None: self._values["custom"] = custom
        if description is not None: self._values["description"] = description
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def name(self) -> str:
        """Resource name for the Access Level.

        The short_name component must begin
        with a letter and only include alphanumeric and '_'.
        Format: accessPolicies/{policy_id}/accessLevels/{short_name}
        """
        return self._values.get('name')

    @builtins.property
    def parent(self) -> str:
        """The AccessPolicy this AccessLevel lives in.

        Format: accessPolicies/{policy_id}
        """
        return self._values.get('parent')

    @builtins.property
    def title(self) -> str:
        """Human readable title.

        Must be unique within the Policy.
        """
        return self._values.get('title')

    @builtins.property
    def basic(self) -> typing.Optional[typing.List["AccessContextManagerAccessLevelBasic"]]:
        """basic block."""
        return self._values.get('basic')

    @builtins.property
    def custom(self) -> typing.Optional[typing.List["AccessContextManagerAccessLevelCustom"]]:
        """custom block."""
        return self._values.get('custom')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """Description of the AccessLevel and its use.

        Does not affect behavior.
        """
        return self._values.get('description')

    @builtins.property
    def timeouts(self) -> typing.Optional["AccessContextManagerAccessLevelTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessLevelConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessLevelCustom", jsii_struct_bases=[], name_mapping={'expr': 'expr'})
class AccessContextManagerAccessLevelCustom():
    def __init__(self, *, expr: typing.List["AccessContextManagerAccessLevelCustomExpr"]) -> None:
        """
        :param expr: expr block.
        """
        self._values = {
            'expr': expr,
        }

    @builtins.property
    def expr(self) -> typing.List["AccessContextManagerAccessLevelCustomExpr"]:
        """expr block."""
        return self._values.get('expr')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessLevelCustom(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessLevelCustomExpr", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'description': 'description', 'location': 'location', 'title': 'title'})
class AccessContextManagerAccessLevelCustomExpr():
    def __init__(self, *, expression: str, description: typing.Optional[str]=None, location: typing.Optional[str]=None, title: typing.Optional[str]=None) -> None:
        """
        :param expression: Textual representation of an expression in Common Expression Language syntax.
        :param description: Description of the expression.
        :param location: String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param title: Title for the expression, i.e. a short string describing its purpose.
        """
        self._values = {
            'expression': expression,
        }
        if description is not None: self._values["description"] = description
        if location is not None: self._values["location"] = location
        if title is not None: self._values["title"] = title

    @builtins.property
    def expression(self) -> str:
        """Textual representation of an expression in Common Expression Language syntax."""
        return self._values.get('expression')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """Description of the expression."""
        return self._values.get('description')

    @builtins.property
    def location(self) -> typing.Optional[str]:
        """String indicating the location of the expression for error reporting, e.g. a file name and a position in the file."""
        return self._values.get('location')

    @builtins.property
    def title(self) -> typing.Optional[str]:
        """Title for the expression, i.e. a short string describing its purpose."""
        return self._values.get('title')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessLevelCustomExpr(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessLevelTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class AccessContextManagerAccessLevelTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessLevelTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AccessContextManagerAccessPolicy(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AccessContextManagerAccessPolicy"):
    def __init__(self, scope: constructs.Construct, id: str, *, parent: str, title: str, timeouts: typing.Optional["AccessContextManagerAccessPolicyTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param parent: The parent of this AccessPolicy in the Cloud Resource Hierarchy. Format: organizations/{organization_id}
        :param title: Human readable title. Does not affect behavior.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AccessContextManagerAccessPolicyConfig(parent=parent, title=title, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AccessContextManagerAccessPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="createTime")
    def create_time(self) -> str:
        return jsii.get(self, "createTime")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="updateTime")
    def update_time(self) -> str:
        return jsii.get(self, "updateTime")

    @builtins.property
    @jsii.member(jsii_name="parent")
    def parent(self) -> str:
        return jsii.get(self, "parent")

    @parent.setter
    def parent(self, value: str) -> None:
        jsii.set(self, "parent", value)

    @builtins.property
    @jsii.member(jsii_name="title")
    def title(self) -> str:
        return jsii.get(self, "title")

    @title.setter
    def title(self, value: str) -> None:
        jsii.set(self, "title", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AccessContextManagerAccessPolicyTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AccessContextManagerAccessPolicyTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessPolicyConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'parent': 'parent', 'title': 'title', 'timeouts': 'timeouts'})
class AccessContextManagerAccessPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, parent: str, title: str, timeouts: typing.Optional["AccessContextManagerAccessPolicyTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param parent: The parent of this AccessPolicy in the Cloud Resource Hierarchy. Format: organizations/{organization_id}
        :param title: Human readable title. Does not affect behavior.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AccessContextManagerAccessPolicyTimeouts(**timeouts)
        self._values = {
            'parent': parent,
            'title': title,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def parent(self) -> str:
        """The parent of this AccessPolicy in the Cloud Resource Hierarchy.

        Format: organizations/{organization_id}
        """
        return self._values.get('parent')

    @builtins.property
    def title(self) -> str:
        """Human readable title.

        Does not affect behavior.
        """
        return self._values.get('title')

    @builtins.property
    def timeouts(self) -> typing.Optional["AccessContextManagerAccessPolicyTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessPolicyConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerAccessPolicyTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class AccessContextManagerAccessPolicyTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerAccessPolicyTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AccessContextManagerServicePerimeter(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeter"):
    def __init__(self, scope: constructs.Construct, id: str, *, name: str, parent: str, title: str, description: typing.Optional[str]=None, perimeter_type: typing.Optional[str]=None, spec: typing.Optional[typing.List["AccessContextManagerServicePerimeterSpec"]]=None, status: typing.Optional[typing.List["AccessContextManagerServicePerimeterStatus"]]=None, timeouts: typing.Optional["AccessContextManagerServicePerimeterTimeouts"]=None, use_explicit_dry_run_spec: typing.Optional[bool]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param name: Resource name for the ServicePerimeter. The short_name component must begin with a letter and only include alphanumeric and '_'. Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        :param parent: The AccessPolicy this ServicePerimeter lives in. Format: accessPolicies/{policy_id}
        :param title: Human readable title. Must be unique within the Policy.
        :param description: Description of the ServicePerimeter and its use. Does not affect behavior.
        :param perimeter_type: Specifies the type of the Perimeter. There are two types: regular and bridge. Regular Service Perimeter contains resources, access levels, and restricted services. Every resource can be in at most ONE regular Service Perimeter. In addition to being in a regular service perimeter, a resource can also be in zero or more perimeter bridges. A perimeter bridge only contains resources. Cross project operations are permitted if all effected resources share some perimeter (whether bridge or regular). Perimeter Bridge does not contain access levels or services: those are governed entirely by the regular perimeter that resource is in. Perimeter Bridges are typically useful when building more complex topologies with many independent perimeters that need to share some data with a common perimeter, but should not be able to share data among themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
        :param spec: spec block.
        :param status: status block.
        :param timeouts: timeouts block.
        :param use_explicit_dry_run_spec: Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists for all Service Perimeters, and that spec is identical to the status for those Service Perimeters. When this flag is set, it inhibits the generation of the implicit spec, thereby allowing the user to explicitly provide a configuration ("spec") to use in a dry-run version of the Service Perimeter. This allows the user to test changes to the enforced config ("status") without actually enforcing them. This testing is done through analyzing the differences between currently enforced and suggested restrictions. useExplicitDryRunSpec must bet set to True if any of the fields in the spec are set to non-default values.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AccessContextManagerServicePerimeterConfig(name=name, parent=parent, title=title, description=description, perimeter_type=perimeter_type, spec=spec, status=status, timeouts=timeouts, use_explicit_dry_run_spec=use_explicit_dry_run_spec, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AccessContextManagerServicePerimeter, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="createTime")
    def create_time(self) -> str:
        return jsii.get(self, "createTime")

    @builtins.property
    @jsii.member(jsii_name="updateTime")
    def update_time(self) -> str:
        return jsii.get(self, "updateTime")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="parent")
    def parent(self) -> str:
        return jsii.get(self, "parent")

    @parent.setter
    def parent(self, value: str) -> None:
        jsii.set(self, "parent", value)

    @builtins.property
    @jsii.member(jsii_name="title")
    def title(self) -> str:
        return jsii.get(self, "title")

    @title.setter
    def title(self, value: str) -> None:
        jsii.set(self, "title", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="perimeterType")
    def perimeter_type(self) -> typing.Optional[str]:
        return jsii.get(self, "perimeterType")

    @perimeter_type.setter
    def perimeter_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "perimeterType", value)

    @builtins.property
    @jsii.member(jsii_name="spec")
    def spec(self) -> typing.Optional[typing.List["AccessContextManagerServicePerimeterSpec"]]:
        return jsii.get(self, "spec")

    @spec.setter
    def spec(self, value: typing.Optional[typing.List["AccessContextManagerServicePerimeterSpec"]]) -> None:
        jsii.set(self, "spec", value)

    @builtins.property
    @jsii.member(jsii_name="status")
    def status(self) -> typing.Optional[typing.List["AccessContextManagerServicePerimeterStatus"]]:
        return jsii.get(self, "status")

    @status.setter
    def status(self, value: typing.Optional[typing.List["AccessContextManagerServicePerimeterStatus"]]) -> None:
        jsii.set(self, "status", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AccessContextManagerServicePerimeterTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AccessContextManagerServicePerimeterTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="useExplicitDryRunSpec")
    def use_explicit_dry_run_spec(self) -> typing.Optional[bool]:
        return jsii.get(self, "useExplicitDryRunSpec")

    @use_explicit_dry_run_spec.setter
    def use_explicit_dry_run_spec(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "useExplicitDryRunSpec", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeterConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'name': 'name', 'parent': 'parent', 'title': 'title', 'description': 'description', 'perimeter_type': 'perimeterType', 'spec': 'spec', 'status': 'status', 'timeouts': 'timeouts', 'use_explicit_dry_run_spec': 'useExplicitDryRunSpec'})
class AccessContextManagerServicePerimeterConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, name: str, parent: str, title: str, description: typing.Optional[str]=None, perimeter_type: typing.Optional[str]=None, spec: typing.Optional[typing.List["AccessContextManagerServicePerimeterSpec"]]=None, status: typing.Optional[typing.List["AccessContextManagerServicePerimeterStatus"]]=None, timeouts: typing.Optional["AccessContextManagerServicePerimeterTimeouts"]=None, use_explicit_dry_run_spec: typing.Optional[bool]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: Resource name for the ServicePerimeter. The short_name component must begin with a letter and only include alphanumeric and '_'. Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        :param parent: The AccessPolicy this ServicePerimeter lives in. Format: accessPolicies/{policy_id}
        :param title: Human readable title. Must be unique within the Policy.
        :param description: Description of the ServicePerimeter and its use. Does not affect behavior.
        :param perimeter_type: Specifies the type of the Perimeter. There are two types: regular and bridge. Regular Service Perimeter contains resources, access levels, and restricted services. Every resource can be in at most ONE regular Service Perimeter. In addition to being in a regular service perimeter, a resource can also be in zero or more perimeter bridges. A perimeter bridge only contains resources. Cross project operations are permitted if all effected resources share some perimeter (whether bridge or regular). Perimeter Bridge does not contain access levels or services: those are governed entirely by the regular perimeter that resource is in. Perimeter Bridges are typically useful when building more complex topologies with many independent perimeters that need to share some data with a common perimeter, but should not be able to share data among themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
        :param spec: spec block.
        :param status: status block.
        :param timeouts: timeouts block.
        :param use_explicit_dry_run_spec: Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists for all Service Perimeters, and that spec is identical to the status for those Service Perimeters. When this flag is set, it inhibits the generation of the implicit spec, thereby allowing the user to explicitly provide a configuration ("spec") to use in a dry-run version of the Service Perimeter. This allows the user to test changes to the enforced config ("status") without actually enforcing them. This testing is done through analyzing the differences between currently enforced and suggested restrictions. useExplicitDryRunSpec must bet set to True if any of the fields in the spec are set to non-default values.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AccessContextManagerServicePerimeterTimeouts(**timeouts)
        self._values = {
            'name': name,
            'parent': parent,
            'title': title,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if description is not None: self._values["description"] = description
        if perimeter_type is not None: self._values["perimeter_type"] = perimeter_type
        if spec is not None: self._values["spec"] = spec
        if status is not None: self._values["status"] = status
        if timeouts is not None: self._values["timeouts"] = timeouts
        if use_explicit_dry_run_spec is not None: self._values["use_explicit_dry_run_spec"] = use_explicit_dry_run_spec

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def name(self) -> str:
        """Resource name for the ServicePerimeter.

        The short_name component must
        begin with a letter and only include alphanumeric and '_'.
        Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
        """
        return self._values.get('name')

    @builtins.property
    def parent(self) -> str:
        """The AccessPolicy this ServicePerimeter lives in.

        Format: accessPolicies/{policy_id}
        """
        return self._values.get('parent')

    @builtins.property
    def title(self) -> str:
        """Human readable title.

        Must be unique within the Policy.
        """
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """Description of the ServicePerimeter and its use.

        Does not affect
        behavior.
        """
        return self._values.get('description')

    @builtins.property
    def perimeter_type(self) -> typing.Optional[str]:
        """Specifies the type of the Perimeter.

        There are two types: regular and
        bridge. Regular Service Perimeter contains resources, access levels,
        and restricted services. Every resource can be in at most
        ONE regular Service Perimeter.

        In addition to being in a regular service perimeter, a resource can also
        be in zero or more perimeter bridges. A perimeter bridge only contains
        resources. Cross project operations are permitted if all effected
        resources share some perimeter (whether bridge or regular). Perimeter
        Bridge does not contain access levels or services: those are governed
        entirely by the regular perimeter that resource is in.

        Perimeter Bridges are typically useful when building more complex
        topologies with many independent perimeters that need to share some data
        with a common perimeter, but should not be able to share data among
        themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
        """
        return self._values.get('perimeter_type')

    @builtins.property
    def spec(self) -> typing.Optional[typing.List["AccessContextManagerServicePerimeterSpec"]]:
        """spec block."""
        return self._values.get('spec')

    @builtins.property
    def status(self) -> typing.Optional[typing.List["AccessContextManagerServicePerimeterStatus"]]:
        """status block."""
        return self._values.get('status')

    @builtins.property
    def timeouts(self) -> typing.Optional["AccessContextManagerServicePerimeterTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    @builtins.property
    def use_explicit_dry_run_spec(self) -> typing.Optional[bool]:
        """Use explicit dry run spec flag.

        Ordinarily, a dry-run spec implicitly exists
        for all Service Perimeters, and that spec is identical to the status for those
        Service Perimeters. When this flag is set, it inhibits the generation of the
        implicit spec, thereby allowing the user to explicitly provide a
        configuration ("spec") to use in a dry-run version of the Service Perimeter.
        This allows the user to test changes to the enforced config ("status") without
        actually enforcing them. This testing is done through analyzing the differences
        between currently enforced and suggested restrictions. useExplicitDryRunSpec must
        bet set to True if any of the fields in the spec are set to non-default values.
        """
        return self._values.get('use_explicit_dry_run_spec')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerServicePerimeterConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AccessContextManagerServicePerimeterResource(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeterResource"):
    def __init__(self, scope: constructs.Construct, id: str, *, perimeter_name: str, resource: str, timeouts: typing.Optional["AccessContextManagerServicePerimeterResourceTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param perimeter_name: The name of the Service Perimeter to add this resource to.
        :param resource: A GCP resource that is inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AccessContextManagerServicePerimeterResourceConfig(perimeter_name=perimeter_name, resource=resource, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AccessContextManagerServicePerimeterResource, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="perimeterName")
    def perimeter_name(self) -> str:
        return jsii.get(self, "perimeterName")

    @perimeter_name.setter
    def perimeter_name(self, value: str) -> None:
        jsii.set(self, "perimeterName", value)

    @builtins.property
    @jsii.member(jsii_name="resource")
    def resource(self) -> str:
        return jsii.get(self, "resource")

    @resource.setter
    def resource(self, value: str) -> None:
        jsii.set(self, "resource", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AccessContextManagerServicePerimeterResourceTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AccessContextManagerServicePerimeterResourceTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeterResourceConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'perimeter_name': 'perimeterName', 'resource': 'resource', 'timeouts': 'timeouts'})
class AccessContextManagerServicePerimeterResourceConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, perimeter_name: str, resource: str, timeouts: typing.Optional["AccessContextManagerServicePerimeterResourceTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param perimeter_name: The name of the Service Perimeter to add this resource to.
        :param resource: A GCP resource that is inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AccessContextManagerServicePerimeterResourceTimeouts(**timeouts)
        self._values = {
            'perimeter_name': perimeter_name,
            'resource': resource,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def perimeter_name(self) -> str:
        """The name of the Service Perimeter to add this resource to."""
        return self._values.get('perimeter_name')

    @builtins.property
    def resource(self) -> str:
        """A GCP resource that is inside of the service perimeter.

        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return self._values.get('resource')

    @builtins.property
    def timeouts(self) -> typing.Optional["AccessContextManagerServicePerimeterResourceTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerServicePerimeterResourceConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeterResourceTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete'})
class AccessContextManagerServicePerimeterResourceTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerServicePerimeterResourceTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeterSpec", jsii_struct_bases=[], name_mapping={'access_levels': 'accessLevels', 'resources': 'resources', 'restricted_services': 'restrictedServices', 'vpc_accessible_services': 'vpcAccessibleServices'})
class AccessContextManagerServicePerimeterSpec():
    def __init__(self, *, access_levels: typing.Optional[typing.List[str]]=None, resources: typing.Optional[typing.List[str]]=None, restricted_services: typing.Optional[typing.List[str]]=None, vpc_accessible_services: typing.Optional[typing.List["AccessContextManagerServicePerimeterSpecVpcAccessibleServices"]]=None) -> None:
        """
        :param access_levels: A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet. AccessLevels listed must be in the same policy as this ServicePerimeter. Referencing a nonexistent AccessLevel is a syntax error. If no AccessLevel names are listed, resources within the perimeter can only be accessed via GCP calls with request origins within the perimeter. For Service Perimeter Bridge, must be empty. Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param resources: A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}
        :param restricted_services: GCP services that are subject to the Service Perimeter restrictions. Must contain a list of services. For example, if 'storage.googleapis.com' is specified, access to the storage buckets inside the perimeter must meet the perimeter's access restrictions.
        :param vpc_accessible_services: vpc_accessible_services block.
        """
        self._values = {
        }
        if access_levels is not None: self._values["access_levels"] = access_levels
        if resources is not None: self._values["resources"] = resources
        if restricted_services is not None: self._values["restricted_services"] = restricted_services
        if vpc_accessible_services is not None: self._values["vpc_accessible_services"] = vpc_accessible_services

    @builtins.property
    def access_levels(self) -> typing.Optional[typing.List[str]]:
        """A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.

        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.

        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return self._values.get('access_levels')

    @builtins.property
    def resources(self) -> typing.Optional[typing.List[str]]:
        """A list of GCP resources that are inside of the service perimeter.

        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return self._values.get('resources')

    @builtins.property
    def restricted_services(self) -> typing.Optional[typing.List[str]]:
        """GCP services that are subject to the Service Perimeter restrictions.

        Must contain a list of services. For example, if
        'storage.googleapis.com' is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return self._values.get('restricted_services')

    @builtins.property
    def vpc_accessible_services(self) -> typing.Optional[typing.List["AccessContextManagerServicePerimeterSpecVpcAccessibleServices"]]:
        """vpc_accessible_services block."""
        return self._values.get('vpc_accessible_services')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerServicePerimeterSpec(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeterSpecVpcAccessibleServices", jsii_struct_bases=[], name_mapping={'allowed_services': 'allowedServices', 'enable_restriction': 'enableRestriction'})
class AccessContextManagerServicePerimeterSpecVpcAccessibleServices():
    def __init__(self, *, allowed_services: typing.Optional[typing.List[str]]=None, enable_restriction: typing.Optional[bool]=None) -> None:
        """
        :param allowed_services: The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
        :param enable_restriction: Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
        """
        self._values = {
        }
        if allowed_services is not None: self._values["allowed_services"] = allowed_services
        if enable_restriction is not None: self._values["enable_restriction"] = enable_restriction

    @builtins.property
    def allowed_services(self) -> typing.Optional[typing.List[str]]:
        """The list of APIs usable within the Service Perimeter.

        Must be empty unless 'enableRestriction' is True.
        """
        return self._values.get('allowed_services')

    @builtins.property
    def enable_restriction(self) -> typing.Optional[bool]:
        """Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'."""
        return self._values.get('enable_restriction')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerServicePerimeterSpecVpcAccessibleServices(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeterStatus", jsii_struct_bases=[], name_mapping={'access_levels': 'accessLevels', 'resources': 'resources', 'restricted_services': 'restrictedServices', 'vpc_accessible_services': 'vpcAccessibleServices'})
class AccessContextManagerServicePerimeterStatus():
    def __init__(self, *, access_levels: typing.Optional[typing.List[str]]=None, resources: typing.Optional[typing.List[str]]=None, restricted_services: typing.Optional[typing.List[str]]=None, vpc_accessible_services: typing.Optional[typing.List["AccessContextManagerServicePerimeterStatusVpcAccessibleServices"]]=None) -> None:
        """
        :param access_levels: A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet. AccessLevels listed must be in the same policy as this ServicePerimeter. Referencing a nonexistent AccessLevel is a syntax error. If no AccessLevel names are listed, resources within the perimeter can only be accessed via GCP calls with request origins within the perimeter. For Service Perimeter Bridge, must be empty. Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        :param resources: A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}
        :param restricted_services: GCP services that are subject to the Service Perimeter restrictions. Must contain a list of services. For example, if 'storage.googleapis.com' is specified, access to the storage buckets inside the perimeter must meet the perimeter's access restrictions.
        :param vpc_accessible_services: vpc_accessible_services block.
        """
        self._values = {
        }
        if access_levels is not None: self._values["access_levels"] = access_levels
        if resources is not None: self._values["resources"] = resources
        if restricted_services is not None: self._values["restricted_services"] = restricted_services
        if vpc_accessible_services is not None: self._values["vpc_accessible_services"] = vpc_accessible_services

    @builtins.property
    def access_levels(self) -> typing.Optional[typing.List[str]]:
        """A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.

        AccessLevels listed must be in the same policy as this
        ServicePerimeter. Referencing a nonexistent AccessLevel is a
        syntax error. If no AccessLevel names are listed, resources within
        the perimeter can only be accessed via GCP calls with request
        origins within the perimeter. For Service Perimeter Bridge, must
        be empty.

        Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
        """
        return self._values.get('access_levels')

    @builtins.property
    def resources(self) -> typing.Optional[typing.List[str]]:
        """A list of GCP resources that are inside of the service perimeter.

        Currently only projects are allowed.
        Format: projects/{project_number}
        """
        return self._values.get('resources')

    @builtins.property
    def restricted_services(self) -> typing.Optional[typing.List[str]]:
        """GCP services that are subject to the Service Perimeter restrictions.

        Must contain a list of services. For example, if
        'storage.googleapis.com' is specified, access to the storage
        buckets inside the perimeter must meet the perimeter's access
        restrictions.
        """
        return self._values.get('restricted_services')

    @builtins.property
    def vpc_accessible_services(self) -> typing.Optional[typing.List["AccessContextManagerServicePerimeterStatusVpcAccessibleServices"]]:
        """vpc_accessible_services block."""
        return self._values.get('vpc_accessible_services')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerServicePerimeterStatus(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeterStatusVpcAccessibleServices", jsii_struct_bases=[], name_mapping={'allowed_services': 'allowedServices', 'enable_restriction': 'enableRestriction'})
class AccessContextManagerServicePerimeterStatusVpcAccessibleServices():
    def __init__(self, *, allowed_services: typing.Optional[typing.List[str]]=None, enable_restriction: typing.Optional[bool]=None) -> None:
        """
        :param allowed_services: The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
        :param enable_restriction: Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
        """
        self._values = {
        }
        if allowed_services is not None: self._values["allowed_services"] = allowed_services
        if enable_restriction is not None: self._values["enable_restriction"] = enable_restriction

    @builtins.property
    def allowed_services(self) -> typing.Optional[typing.List[str]]:
        """The list of APIs usable within the Service Perimeter.

        Must be empty unless 'enableRestriction' is True.
        """
        return self._values.get('allowed_services')

    @builtins.property
    def enable_restriction(self) -> typing.Optional[bool]:
        """Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'."""
        return self._values.get('enable_restriction')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerServicePerimeterStatusVpcAccessibleServices(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AccessContextManagerServicePerimeterTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class AccessContextManagerServicePerimeterTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AccessContextManagerServicePerimeterTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class ActiveDirectoryDomain(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.ActiveDirectoryDomain"):
    def __init__(self, scope: constructs.Construct, id: str, *, domain_name: str, locations: typing.List[str], reserved_ip_range: str, admin: typing.Optional[str]=None, authorized_networks: typing.Optional[typing.List[str]]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["ActiveDirectoryDomainTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param domain_name: The fully qualified domain name. e.g. mydomain.myorganization.com, with the restrictions, https://cloud.google.com/managed-microsoft-ad/reference/rest/v1/projects.locations.global.domains.
        :param locations: Locations where domain needs to be provisioned. [regions][compute/docs/regions-zones/] e.g. us-west1 or us-east4 Service supports up to 4 locations at once. Each location will use a /26 block.
        :param reserved_ip_range: The CIDR range of internal addresses that are reserved for this domain. Reserved networks must be /24 or larger. Ranges must be unique and non-overlapping with existing subnets in authorizedNetworks
        :param admin: The name of delegated administrator account used to perform Active Directory operations. If not specified, setupadmin will be used.
        :param authorized_networks: The full names of the Google Compute Engine networks the domain instance is connected to. The domain is only available on networks listed in authorizedNetworks. If CIDR subnets overlap between networks, domain creation will fail.
        :param labels: Resource labels that can contain user-provided metadata.
        :param project: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ActiveDirectoryDomainConfig(domain_name=domain_name, locations=locations, reserved_ip_range=reserved_ip_range, admin=admin, authorized_networks=authorized_networks, labels=labels, project=project, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(ActiveDirectoryDomain, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="fqdn")
    def fqdn(self) -> str:
        return jsii.get(self, "fqdn")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> str:
        return jsii.get(self, "domainName")

    @domain_name.setter
    def domain_name(self, value: str) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property
    @jsii.member(jsii_name="locations")
    def locations(self) -> typing.List[str]:
        return jsii.get(self, "locations")

    @locations.setter
    def locations(self, value: typing.List[str]) -> None:
        jsii.set(self, "locations", value)

    @builtins.property
    @jsii.member(jsii_name="reservedIpRange")
    def reserved_ip_range(self) -> str:
        return jsii.get(self, "reservedIpRange")

    @reserved_ip_range.setter
    def reserved_ip_range(self, value: str) -> None:
        jsii.set(self, "reservedIpRange", value)

    @builtins.property
    @jsii.member(jsii_name="admin")
    def admin(self) -> typing.Optional[str]:
        return jsii.get(self, "admin")

    @admin.setter
    def admin(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "admin", value)

    @builtins.property
    @jsii.member(jsii_name="authorizedNetworks")
    def authorized_networks(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "authorizedNetworks")

    @authorized_networks.setter
    def authorized_networks(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "authorizedNetworks", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="labels")
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "labels")

    @labels.setter
    def labels(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "labels", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["ActiveDirectoryDomainTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["ActiveDirectoryDomainTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.ActiveDirectoryDomainConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'domain_name': 'domainName', 'locations': 'locations', 'reserved_ip_range': 'reservedIpRange', 'admin': 'admin', 'authorized_networks': 'authorizedNetworks', 'labels': 'labels', 'project': 'project', 'timeouts': 'timeouts'})
class ActiveDirectoryDomainConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, domain_name: str, locations: typing.List[str], reserved_ip_range: str, admin: typing.Optional[str]=None, authorized_networks: typing.Optional[typing.List[str]]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["ActiveDirectoryDomainTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param domain_name: The fully qualified domain name. e.g. mydomain.myorganization.com, with the restrictions, https://cloud.google.com/managed-microsoft-ad/reference/rest/v1/projects.locations.global.domains.
        :param locations: Locations where domain needs to be provisioned. [regions][compute/docs/regions-zones/] e.g. us-west1 or us-east4 Service supports up to 4 locations at once. Each location will use a /26 block.
        :param reserved_ip_range: The CIDR range of internal addresses that are reserved for this domain. Reserved networks must be /24 or larger. Ranges must be unique and non-overlapping with existing subnets in authorizedNetworks
        :param admin: The name of delegated administrator account used to perform Active Directory operations. If not specified, setupadmin will be used.
        :param authorized_networks: The full names of the Google Compute Engine networks the domain instance is connected to. The domain is only available on networks listed in authorizedNetworks. If CIDR subnets overlap between networks, domain creation will fail.
        :param labels: Resource labels that can contain user-provided metadata.
        :param project: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = ActiveDirectoryDomainTimeouts(**timeouts)
        self._values = {
            'domain_name': domain_name,
            'locations': locations,
            'reserved_ip_range': reserved_ip_range,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if admin is not None: self._values["admin"] = admin
        if authorized_networks is not None: self._values["authorized_networks"] = authorized_networks
        if labels is not None: self._values["labels"] = labels
        if project is not None: self._values["project"] = project
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def domain_name(self) -> str:
        """The fully qualified domain name.

        e.g. mydomain.myorganization.com, with the restrictions,
        https://cloud.google.com/managed-microsoft-ad/reference/rest/v1/projects.locations.global.domains.
        """
        return self._values.get('domain_name')

    @builtins.property
    def locations(self) -> typing.List[str]:
        """Locations where domain needs to be provisioned.

        [regions][compute/docs/regions-zones/]
        e.g. us-west1 or us-east4 Service supports up to 4 locations at once. Each location will use a /26 block.
        """
        return self._values.get('locations')

    @builtins.property
    def reserved_ip_range(self) -> str:
        """The CIDR range of internal addresses that are reserved for this domain.

        Reserved networks must be /24 or larger.
        Ranges must be unique and non-overlapping with existing subnets in authorizedNetworks
        """
        return self._values.get('reserved_ip_range')

    @builtins.property
    def admin(self) -> typing.Optional[str]:
        """The name of delegated administrator account used to perform Active Directory operations.

        If not specified, setupadmin will be used.
        """
        return self._values.get('admin')

    @builtins.property
    def authorized_networks(self) -> typing.Optional[typing.List[str]]:
        """The full names of the Google Compute Engine networks the domain instance is connected to.

        The domain is only available on networks listed in authorizedNetworks.
        If CIDR subnets overlap between networks, domain creation will fail.
        """
        return self._values.get('authorized_networks')

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Resource labels that can contain user-provided metadata."""
        return self._values.get('labels')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def timeouts(self) -> typing.Optional["ActiveDirectoryDomainTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'ActiveDirectoryDomainConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.ActiveDirectoryDomainTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class ActiveDirectoryDomainTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'ActiveDirectoryDomainTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AppEngineApplication(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AppEngineApplication"):
    def __init__(self, scope: constructs.Construct, id: str, *, location_id: str, auth_domain: typing.Optional[str]=None, database_type: typing.Optional[str]=None, feature_settings: typing.Optional[typing.List["AppEngineApplicationFeatureSettings"]]=None, iap: typing.Optional[typing.List["AppEngineApplicationIap"]]=None, project: typing.Optional[str]=None, serving_status: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineApplicationTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param location_id: The location to serve the app from.
        :param auth_domain: The domain to authenticate users with when using App Engine's User API.
        :param database_type: 
        :param feature_settings: feature_settings block.
        :param iap: iap block.
        :param project: The project ID to create the application under.
        :param serving_status: The serving status of the app.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppEngineApplicationConfig(location_id=location_id, auth_domain=auth_domain, database_type=database_type, feature_settings=feature_settings, iap=iap, project=project, serving_status=serving_status, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AppEngineApplication, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @jsii.member(jsii_name="urlDispatchRule")
    def url_dispatch_rule(self, index: str) -> "AppEngineApplicationUrlDispatchRule":
        """
        :param index: -
        """
        return jsii.invoke(self, "urlDispatchRule", [index])

    @builtins.property
    @jsii.member(jsii_name="appId")
    def app_id(self) -> str:
        return jsii.get(self, "appId")

    @builtins.property
    @jsii.member(jsii_name="codeBucket")
    def code_bucket(self) -> str:
        return jsii.get(self, "codeBucket")

    @builtins.property
    @jsii.member(jsii_name="defaultBucket")
    def default_bucket(self) -> str:
        return jsii.get(self, "defaultBucket")

    @builtins.property
    @jsii.member(jsii_name="defaultHostname")
    def default_hostname(self) -> str:
        return jsii.get(self, "defaultHostname")

    @builtins.property
    @jsii.member(jsii_name="gcrDomain")
    def gcr_domain(self) -> str:
        return jsii.get(self, "gcrDomain")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="locationId")
    def location_id(self) -> str:
        return jsii.get(self, "locationId")

    @location_id.setter
    def location_id(self, value: str) -> None:
        jsii.set(self, "locationId", value)

    @builtins.property
    @jsii.member(jsii_name="authDomain")
    def auth_domain(self) -> typing.Optional[str]:
        return jsii.get(self, "authDomain")

    @auth_domain.setter
    def auth_domain(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "authDomain", value)

    @builtins.property
    @jsii.member(jsii_name="databaseType")
    def database_type(self) -> typing.Optional[str]:
        return jsii.get(self, "databaseType")

    @database_type.setter
    def database_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "databaseType", value)

    @builtins.property
    @jsii.member(jsii_name="featureSettings")
    def feature_settings(self) -> typing.Optional[typing.List["AppEngineApplicationFeatureSettings"]]:
        return jsii.get(self, "featureSettings")

    @feature_settings.setter
    def feature_settings(self, value: typing.Optional[typing.List["AppEngineApplicationFeatureSettings"]]) -> None:
        jsii.set(self, "featureSettings", value)

    @builtins.property
    @jsii.member(jsii_name="iap")
    def iap(self) -> typing.Optional[typing.List["AppEngineApplicationIap"]]:
        return jsii.get(self, "iap")

    @iap.setter
    def iap(self, value: typing.Optional[typing.List["AppEngineApplicationIap"]]) -> None:
        jsii.set(self, "iap", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="servingStatus")
    def serving_status(self) -> typing.Optional[str]:
        return jsii.get(self, "servingStatus")

    @serving_status.setter
    def serving_status(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "servingStatus", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AppEngineApplicationTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AppEngineApplicationTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineApplicationConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'location_id': 'locationId', 'auth_domain': 'authDomain', 'database_type': 'databaseType', 'feature_settings': 'featureSettings', 'iap': 'iap', 'project': 'project', 'serving_status': 'servingStatus', 'timeouts': 'timeouts'})
class AppEngineApplicationConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, location_id: str, auth_domain: typing.Optional[str]=None, database_type: typing.Optional[str]=None, feature_settings: typing.Optional[typing.List["AppEngineApplicationFeatureSettings"]]=None, iap: typing.Optional[typing.List["AppEngineApplicationIap"]]=None, project: typing.Optional[str]=None, serving_status: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineApplicationTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location_id: The location to serve the app from.
        :param auth_domain: The domain to authenticate users with when using App Engine's User API.
        :param database_type: 
        :param feature_settings: feature_settings block.
        :param iap: iap block.
        :param project: The project ID to create the application under.
        :param serving_status: The serving status of the app.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AppEngineApplicationTimeouts(**timeouts)
        self._values = {
            'location_id': location_id,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if auth_domain is not None: self._values["auth_domain"] = auth_domain
        if database_type is not None: self._values["database_type"] = database_type
        if feature_settings is not None: self._values["feature_settings"] = feature_settings
        if iap is not None: self._values["iap"] = iap
        if project is not None: self._values["project"] = project
        if serving_status is not None: self._values["serving_status"] = serving_status
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def location_id(self) -> str:
        """The location to serve the app from."""
        return self._values.get('location_id')

    @builtins.property
    def auth_domain(self) -> typing.Optional[str]:
        """The domain to authenticate users with when using App Engine's User API."""
        return self._values.get('auth_domain')

    @builtins.property
    def database_type(self) -> typing.Optional[str]:
        return self._values.get('database_type')

    @builtins.property
    def feature_settings(self) -> typing.Optional[typing.List["AppEngineApplicationFeatureSettings"]]:
        """feature_settings block."""
        return self._values.get('feature_settings')

    @builtins.property
    def iap(self) -> typing.Optional[typing.List["AppEngineApplicationIap"]]:
        """iap block."""
        return self._values.get('iap')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        """The project ID to create the application under."""
        return self._values.get('project')

    @builtins.property
    def serving_status(self) -> typing.Optional[str]:
        """The serving status of the app."""
        return self._values.get('serving_status')

    @builtins.property
    def timeouts(self) -> typing.Optional["AppEngineApplicationTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineApplicationConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineApplicationFeatureSettings", jsii_struct_bases=[], name_mapping={'split_health_checks': 'splitHealthChecks'})
class AppEngineApplicationFeatureSettings():
    def __init__(self, *, split_health_checks: bool) -> None:
        """
        :param split_health_checks: 
        """
        self._values = {
            'split_health_checks': split_health_checks,
        }

    @builtins.property
    def split_health_checks(self) -> bool:
        return self._values.get('split_health_checks')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineApplicationFeatureSettings(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineApplicationIap", jsii_struct_bases=[], name_mapping={'oauth2_client_id': 'oauth2ClientId', 'oauth2_client_secret': 'oauth2ClientSecret', 'enabled': 'enabled'})
class AppEngineApplicationIap():
    def __init__(self, *, oauth2_client_id: str, oauth2_client_secret: str, enabled: typing.Optional[bool]=None) -> None:
        """
        :param oauth2_client_id: OAuth2 client ID to use for the authentication flow.
        :param oauth2_client_secret: OAuth2 client secret to use for the authentication flow. The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
        :param enabled: Adapted for use with the app.
        """
        self._values = {
            'oauth2_client_id': oauth2_client_id,
            'oauth2_client_secret': oauth2_client_secret,
        }
        if enabled is not None: self._values["enabled"] = enabled

    @builtins.property
    def oauth2_client_id(self) -> str:
        """OAuth2 client ID to use for the authentication flow."""
        return self._values.get('oauth2_client_id')

    @builtins.property
    def oauth2_client_secret(self) -> str:
        """OAuth2 client secret to use for the authentication flow.

        The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
        """
        return self._values.get('oauth2_client_secret')

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        """Adapted for use with the app."""
        return self._values.get('enabled')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineApplicationIap(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineApplicationTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'update': 'update'})
class AppEngineApplicationTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineApplicationTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AppEngineApplicationUrlDispatchRule(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AppEngineApplicationUrlDispatchRule"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(AppEngineApplicationUrlDispatchRule, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="domain")
    def domain(self) -> str:
        return jsii.get(self, "domain")

    @builtins.property
    @jsii.member(jsii_name="path")
    def path(self) -> str:
        return jsii.get(self, "path")

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> str:
        return jsii.get(self, "service")


class AppEngineApplicationUrlDispatchRules(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AppEngineApplicationUrlDispatchRules"):
    def __init__(self, scope: constructs.Construct, id: str, *, dispatch_rules: typing.List["AppEngineApplicationUrlDispatchRulesDispatchRules"], project: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineApplicationUrlDispatchRulesTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param dispatch_rules: dispatch_rules block.
        :param project: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppEngineApplicationUrlDispatchRulesConfig(dispatch_rules=dispatch_rules, project=project, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AppEngineApplicationUrlDispatchRules, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="dispatchRules")
    def dispatch_rules(self) -> typing.List["AppEngineApplicationUrlDispatchRulesDispatchRules"]:
        return jsii.get(self, "dispatchRules")

    @dispatch_rules.setter
    def dispatch_rules(self, value: typing.List["AppEngineApplicationUrlDispatchRulesDispatchRules"]) -> None:
        jsii.set(self, "dispatchRules", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AppEngineApplicationUrlDispatchRulesTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AppEngineApplicationUrlDispatchRulesTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineApplicationUrlDispatchRulesConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'dispatch_rules': 'dispatchRules', 'project': 'project', 'timeouts': 'timeouts'})
class AppEngineApplicationUrlDispatchRulesConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, dispatch_rules: typing.List["AppEngineApplicationUrlDispatchRulesDispatchRules"], project: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineApplicationUrlDispatchRulesTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param dispatch_rules: dispatch_rules block.
        :param project: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AppEngineApplicationUrlDispatchRulesTimeouts(**timeouts)
        self._values = {
            'dispatch_rules': dispatch_rules,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if project is not None: self._values["project"] = project
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def dispatch_rules(self) -> typing.List["AppEngineApplicationUrlDispatchRulesDispatchRules"]:
        """dispatch_rules block."""
        return self._values.get('dispatch_rules')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def timeouts(self) -> typing.Optional["AppEngineApplicationUrlDispatchRulesTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineApplicationUrlDispatchRulesConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineApplicationUrlDispatchRulesDispatchRules", jsii_struct_bases=[], name_mapping={'path': 'path', 'service': 'service', 'domain': 'domain'})
class AppEngineApplicationUrlDispatchRulesDispatchRules():
    def __init__(self, *, path: str, service: str, domain: typing.Optional[str]=None) -> None:
        """
        :param path: Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path. The sum of the lengths of the domain and path may not exceed 100 characters.
        :param service: Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path. The sum of the lengths of the domain and path may not exceed 100 characters.
        :param domain: Domain name to match against. The wildcard "*" is supported if specified before a period: "*.". Defaults to matching all domains: "*".
        """
        self._values = {
            'path': path,
            'service': service,
        }
        if domain is not None: self._values["domain"] = domain

    @builtins.property
    def path(self) -> str:
        """Pathname within the host.

        Must start with a "/". A single "*" can be included at the end of the path.
        The sum of the lengths of the domain and path may not exceed 100 characters.
        """
        return self._values.get('path')

    @builtins.property
    def service(self) -> str:
        """Pathname within the host.

        Must start with a "/". A single "*" can be included at the end of the path.
        The sum of the lengths of the domain and path may not exceed 100 characters.
        """
        return self._values.get('service')

    @builtins.property
    def domain(self) -> typing.Optional[str]:
        """Domain name to match against.

        The wildcard "*" is supported if specified before a period: "*.".
        Defaults to matching all domains: "*".
        """
        return self._values.get('domain')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineApplicationUrlDispatchRulesDispatchRules(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineApplicationUrlDispatchRulesTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class AppEngineApplicationUrlDispatchRulesTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineApplicationUrlDispatchRulesTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AppEngineDomainMapping(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AppEngineDomainMapping"):
    def __init__(self, scope: constructs.Construct, id: str, *, domain_name: str, override_strategy: typing.Optional[str]=None, project: typing.Optional[str]=None, ssl_settings: typing.Optional[typing.List["AppEngineDomainMappingSslSettings"]]=None, timeouts: typing.Optional["AppEngineDomainMappingTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param domain_name: Relative name of the domain serving the application. Example: example.com.
        :param override_strategy: Whether the domain creation should override any existing mappings for this domain. By default, overrides are rejected. Default value: "STRICT" Possible values: ["STRICT", "OVERRIDE"]
        :param project: 
        :param ssl_settings: ssl_settings block.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppEngineDomainMappingConfig(domain_name=domain_name, override_strategy=override_strategy, project=project, ssl_settings=ssl_settings, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AppEngineDomainMapping, self, [scope, id, config])

    @jsii.member(jsii_name="resourceRecords")
    def resource_records(self, index: str) -> "AppEngineDomainMappingResourceRecords":
        """
        :param index: -
        """
        return jsii.invoke(self, "resourceRecords", [index])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> str:
        return jsii.get(self, "domainName")

    @domain_name.setter
    def domain_name(self, value: str) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="overrideStrategy")
    def override_strategy(self) -> typing.Optional[str]:
        return jsii.get(self, "overrideStrategy")

    @override_strategy.setter
    def override_strategy(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "overrideStrategy", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="sslSettings")
    def ssl_settings(self) -> typing.Optional[typing.List["AppEngineDomainMappingSslSettings"]]:
        return jsii.get(self, "sslSettings")

    @ssl_settings.setter
    def ssl_settings(self, value: typing.Optional[typing.List["AppEngineDomainMappingSslSettings"]]) -> None:
        jsii.set(self, "sslSettings", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AppEngineDomainMappingTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AppEngineDomainMappingTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineDomainMappingConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'domain_name': 'domainName', 'override_strategy': 'overrideStrategy', 'project': 'project', 'ssl_settings': 'sslSettings', 'timeouts': 'timeouts'})
class AppEngineDomainMappingConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, domain_name: str, override_strategy: typing.Optional[str]=None, project: typing.Optional[str]=None, ssl_settings: typing.Optional[typing.List["AppEngineDomainMappingSslSettings"]]=None, timeouts: typing.Optional["AppEngineDomainMappingTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param domain_name: Relative name of the domain serving the application. Example: example.com.
        :param override_strategy: Whether the domain creation should override any existing mappings for this domain. By default, overrides are rejected. Default value: "STRICT" Possible values: ["STRICT", "OVERRIDE"]
        :param project: 
        :param ssl_settings: ssl_settings block.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AppEngineDomainMappingTimeouts(**timeouts)
        self._values = {
            'domain_name': domain_name,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if override_strategy is not None: self._values["override_strategy"] = override_strategy
        if project is not None: self._values["project"] = project
        if ssl_settings is not None: self._values["ssl_settings"] = ssl_settings
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def domain_name(self) -> str:
        """Relative name of the domain serving the application.

        Example: example.com.
        """
        return self._values.get('domain_name')

    @builtins.property
    def override_strategy(self) -> typing.Optional[str]:
        """Whether the domain creation should override any existing mappings for this domain.

        By default, overrides are rejected. Default value: "STRICT" Possible values: ["STRICT", "OVERRIDE"]
        """
        return self._values.get('override_strategy')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def ssl_settings(self) -> typing.Optional[typing.List["AppEngineDomainMappingSslSettings"]]:
        """ssl_settings block."""
        return self._values.get('ssl_settings')

    @builtins.property
    def timeouts(self) -> typing.Optional["AppEngineDomainMappingTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineDomainMappingConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AppEngineDomainMappingResourceRecords(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AppEngineDomainMappingResourceRecords"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(AppEngineDomainMappingResourceRecords, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="rrdata")
    def rrdata(self) -> str:
        return jsii.get(self, "rrdata")

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> str:
        return jsii.get(self, "type")


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineDomainMappingSslSettings", jsii_struct_bases=[], name_mapping={'ssl_management_type': 'sslManagementType', 'certificate_id': 'certificateId'})
class AppEngineDomainMappingSslSettings():
    def __init__(self, *, ssl_management_type: str, certificate_id: typing.Optional[str]=None) -> None:
        """
        :param ssl_management_type: SSL management type for this domain. If 'AUTOMATIC', a managed certificate is automatically provisioned. If 'MANUAL', 'certificateId' must be manually specified in order to configure SSL for this domain. Possible values: ["AUTOMATIC", "MANUAL"]
        :param certificate_id: ID of the AuthorizedCertificate resource configuring SSL for the application. Clearing this field will remove SSL support. By default, a managed certificate is automatically created for every domain mapping. To omit SSL support or to configure SSL manually, specify 'SslManagementType.MANUAL' on a 'CREATE' or 'UPDATE' request. You must be authorized to administer the 'AuthorizedCertificate' resource to manually map it to a DomainMapping resource. Example: 12345.
        """
        self._values = {
            'ssl_management_type': ssl_management_type,
        }
        if certificate_id is not None: self._values["certificate_id"] = certificate_id

    @builtins.property
    def ssl_management_type(self) -> str:
        """SSL management type for this domain.

        If 'AUTOMATIC', a managed certificate is automatically provisioned.
        If 'MANUAL', 'certificateId' must be manually specified in order to configure SSL for this domain. Possible values: ["AUTOMATIC", "MANUAL"]
        """
        return self._values.get('ssl_management_type')

    @builtins.property
    def certificate_id(self) -> typing.Optional[str]:
        """ID of the AuthorizedCertificate resource configuring SSL for the application.

        Clearing this field will
        remove SSL support.
        By default, a managed certificate is automatically created for every domain mapping. To omit SSL support
        or to configure SSL manually, specify 'SslManagementType.MANUAL' on a 'CREATE' or 'UPDATE' request. You must be
        authorized to administer the 'AuthorizedCertificate' resource to manually map it to a DomainMapping resource.
        Example: 12345.
        """
        return self._values.get('certificate_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineDomainMappingSslSettings(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineDomainMappingTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class AppEngineDomainMappingTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineDomainMappingTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AppEngineFirewallRule(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AppEngineFirewallRule"):
    def __init__(self, scope: constructs.Construct, id: str, *, action: str, source_range: str, description: typing.Optional[str]=None, priority: typing.Optional[jsii.Number]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineFirewallRuleTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param action: The action to take if this rule matches. Possible values: ["UNSPECIFIED_ACTION", "ALLOW", "DENY"]
        :param source_range: IP address or range, defined using CIDR notation, of requests that this rule applies to.
        :param description: An optional string description of this rule.
        :param priority: A positive integer that defines the order of rule evaluation. Rules with the lowest priority are evaluated first. A default rule at priority Int32.MaxValue matches all IPv4 and IPv6 traffic when no previous rule matches. Only the action of this rule can be modified by the user.
        :param project: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppEngineFirewallRuleConfig(action=action, source_range=source_range, description=description, priority=priority, project=project, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AppEngineFirewallRule, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="action")
    def action(self) -> str:
        return jsii.get(self, "action")

    @action.setter
    def action(self, value: str) -> None:
        jsii.set(self, "action", value)

    @builtins.property
    @jsii.member(jsii_name="sourceRange")
    def source_range(self) -> str:
        return jsii.get(self, "sourceRange")

    @source_range.setter
    def source_range(self, value: str) -> None:
        jsii.set(self, "sourceRange", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="priority")
    def priority(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "priority")

    @priority.setter
    def priority(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "priority", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AppEngineFirewallRuleTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AppEngineFirewallRuleTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFirewallRuleConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'action': 'action', 'source_range': 'sourceRange', 'description': 'description', 'priority': 'priority', 'project': 'project', 'timeouts': 'timeouts'})
class AppEngineFirewallRuleConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, action: str, source_range: str, description: typing.Optional[str]=None, priority: typing.Optional[jsii.Number]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineFirewallRuleTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param action: The action to take if this rule matches. Possible values: ["UNSPECIFIED_ACTION", "ALLOW", "DENY"]
        :param source_range: IP address or range, defined using CIDR notation, of requests that this rule applies to.
        :param description: An optional string description of this rule.
        :param priority: A positive integer that defines the order of rule evaluation. Rules with the lowest priority are evaluated first. A default rule at priority Int32.MaxValue matches all IPv4 and IPv6 traffic when no previous rule matches. Only the action of this rule can be modified by the user.
        :param project: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AppEngineFirewallRuleTimeouts(**timeouts)
        self._values = {
            'action': action,
            'source_range': source_range,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if description is not None: self._values["description"] = description
        if priority is not None: self._values["priority"] = priority
        if project is not None: self._values["project"] = project
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def action(self) -> str:
        """The action to take if this rule matches.

        Possible values: ["UNSPECIFIED_ACTION", "ALLOW", "DENY"]
        """
        return self._values.get('action')

    @builtins.property
    def source_range(self) -> str:
        """IP address or range, defined using CIDR notation, of requests that this rule applies to."""
        return self._values.get('source_range')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """An optional string description of this rule."""
        return self._values.get('description')

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        """A positive integer that defines the order of rule evaluation. Rules with the lowest priority are evaluated first.

        A default rule at priority Int32.MaxValue matches all IPv4 and
        IPv6 traffic when no previous rule matches. Only the action of
        this rule can be modified by the user.
        """
        return self._values.get('priority')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def timeouts(self) -> typing.Optional["AppEngineFirewallRuleTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFirewallRuleConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFirewallRuleTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class AppEngineFirewallRuleTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFirewallRuleTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AppEngineFlexibleAppVersion(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersion"):
    def __init__(self, scope: constructs.Construct, id: str, *, liveness_check: typing.List["AppEngineFlexibleAppVersionLivenessCheck"], readiness_check: typing.List["AppEngineFlexibleAppVersionReadinessCheck"], runtime: str, service: str, api_config: typing.Optional[typing.List["AppEngineFlexibleAppVersionApiConfig"]]=None, automatic_scaling: typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScaling"]]=None, beta_settings: typing.Optional[typing.Mapping[str, str]]=None, default_expiration: typing.Optional[str]=None, delete_service_on_destroy: typing.Optional[bool]=None, deployment: typing.Optional[typing.List["AppEngineFlexibleAppVersionDeployment"]]=None, endpoints_api_service: typing.Optional[typing.List["AppEngineFlexibleAppVersionEndpointsApiService"]]=None, entrypoint: typing.Optional[typing.List["AppEngineFlexibleAppVersionEntrypoint"]]=None, env_variables: typing.Optional[typing.Mapping[str, str]]=None, handlers: typing.Optional[typing.List["AppEngineFlexibleAppVersionHandlers"]]=None, inbound_services: typing.Optional[typing.List[str]]=None, instance_class: typing.Optional[str]=None, manual_scaling: typing.Optional[typing.List["AppEngineFlexibleAppVersionManualScaling"]]=None, network: typing.Optional[typing.List["AppEngineFlexibleAppVersionNetwork"]]=None, nobuild_files_regex: typing.Optional[str]=None, noop_on_destroy: typing.Optional[bool]=None, project: typing.Optional[str]=None, resources: typing.Optional[typing.List["AppEngineFlexibleAppVersionResources"]]=None, runtime_api_version: typing.Optional[str]=None, runtime_channel: typing.Optional[str]=None, runtime_main_executable_path: typing.Optional[str]=None, serving_status: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineFlexibleAppVersionTimeouts"]=None, version_id: typing.Optional[str]=None, vpc_access_connector: typing.Optional[typing.List["AppEngineFlexibleAppVersionVpcAccessConnector"]]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param liveness_check: liveness_check block.
        :param readiness_check: readiness_check block.
        :param runtime: Desired runtime. Example python27.
        :param service: AppEngine service resource.
        :param api_config: api_config block.
        :param automatic_scaling: automatic_scaling block.
        :param beta_settings: Metadata settings that are supplied to this version to enable beta runtime features.
        :param default_expiration: Duration that static files should be cached by web proxies and browsers. Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        :param delete_service_on_destroy: 
        :param deployment: deployment block.
        :param endpoints_api_service: endpoints_api_service block.
        :param entrypoint: entrypoint block.
        :param env_variables: Environment variables available to the application. As these are not returned in the API request, Terraform will not detect any changes made outside of the Terraform config.
        :param handlers: handlers block.
        :param inbound_services: A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
        :param instance_class: Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G ManualScaling: B1, B2, B4, B8, B4_1G Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        :param manual_scaling: manual_scaling block.
        :param network: network block.
        :param nobuild_files_regex: Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
        :param noop_on_destroy: 
        :param project: 
        :param resources: resources block.
        :param runtime_api_version: The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref
        :param runtime_channel: The channel of the runtime to use. Only available for some runtimes.
        :param runtime_main_executable_path: The path or name of the app's main executable.
        :param serving_status: Current serving status of this version. Only the versions with a SERVING status create instances and can be billed. Default value: "SERVING" Possible values: ["SERVING", "STOPPED"]
        :param timeouts: timeouts block.
        :param version_id: Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param vpc_access_connector: vpc_access_connector block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppEngineFlexibleAppVersionConfig(liveness_check=liveness_check, readiness_check=readiness_check, runtime=runtime, service=service, api_config=api_config, automatic_scaling=automatic_scaling, beta_settings=beta_settings, default_expiration=default_expiration, delete_service_on_destroy=delete_service_on_destroy, deployment=deployment, endpoints_api_service=endpoints_api_service, entrypoint=entrypoint, env_variables=env_variables, handlers=handlers, inbound_services=inbound_services, instance_class=instance_class, manual_scaling=manual_scaling, network=network, nobuild_files_regex=nobuild_files_regex, noop_on_destroy=noop_on_destroy, project=project, resources=resources, runtime_api_version=runtime_api_version, runtime_channel=runtime_channel, runtime_main_executable_path=runtime_main_executable_path, serving_status=serving_status, timeouts=timeouts, version_id=version_id, vpc_access_connector=vpc_access_connector, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AppEngineFlexibleAppVersion, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="livenessCheck")
    def liveness_check(self) -> typing.List["AppEngineFlexibleAppVersionLivenessCheck"]:
        return jsii.get(self, "livenessCheck")

    @liveness_check.setter
    def liveness_check(self, value: typing.List["AppEngineFlexibleAppVersionLivenessCheck"]) -> None:
        jsii.set(self, "livenessCheck", value)

    @builtins.property
    @jsii.member(jsii_name="readinessCheck")
    def readiness_check(self) -> typing.List["AppEngineFlexibleAppVersionReadinessCheck"]:
        return jsii.get(self, "readinessCheck")

    @readiness_check.setter
    def readiness_check(self, value: typing.List["AppEngineFlexibleAppVersionReadinessCheck"]) -> None:
        jsii.set(self, "readinessCheck", value)

    @builtins.property
    @jsii.member(jsii_name="runtime")
    def runtime(self) -> str:
        return jsii.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: str) -> None:
        jsii.set(self, "runtime", value)

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> str:
        return jsii.get(self, "service")

    @service.setter
    def service(self, value: str) -> None:
        jsii.set(self, "service", value)

    @builtins.property
    @jsii.member(jsii_name="apiConfig")
    def api_config(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionApiConfig"]]:
        return jsii.get(self, "apiConfig")

    @api_config.setter
    def api_config(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionApiConfig"]]) -> None:
        jsii.set(self, "apiConfig", value)

    @builtins.property
    @jsii.member(jsii_name="automaticScaling")
    def automatic_scaling(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScaling"]]:
        return jsii.get(self, "automaticScaling")

    @automatic_scaling.setter
    def automatic_scaling(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScaling"]]) -> None:
        jsii.set(self, "automaticScaling", value)

    @builtins.property
    @jsii.member(jsii_name="betaSettings")
    def beta_settings(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "betaSettings")

    @beta_settings.setter
    def beta_settings(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "betaSettings", value)

    @builtins.property
    @jsii.member(jsii_name="defaultExpiration")
    def default_expiration(self) -> typing.Optional[str]:
        return jsii.get(self, "defaultExpiration")

    @default_expiration.setter
    def default_expiration(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "defaultExpiration", value)

    @builtins.property
    @jsii.member(jsii_name="deleteServiceOnDestroy")
    def delete_service_on_destroy(self) -> typing.Optional[bool]:
        return jsii.get(self, "deleteServiceOnDestroy")

    @delete_service_on_destroy.setter
    def delete_service_on_destroy(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "deleteServiceOnDestroy", value)

    @builtins.property
    @jsii.member(jsii_name="deployment")
    def deployment(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionDeployment"]]:
        return jsii.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionDeployment"]]) -> None:
        jsii.set(self, "deployment", value)

    @builtins.property
    @jsii.member(jsii_name="endpointsApiService")
    def endpoints_api_service(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionEndpointsApiService"]]:
        return jsii.get(self, "endpointsApiService")

    @endpoints_api_service.setter
    def endpoints_api_service(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionEndpointsApiService"]]) -> None:
        jsii.set(self, "endpointsApiService", value)

    @builtins.property
    @jsii.member(jsii_name="entrypoint")
    def entrypoint(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionEntrypoint"]]:
        return jsii.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionEntrypoint"]]) -> None:
        jsii.set(self, "entrypoint", value)

    @builtins.property
    @jsii.member(jsii_name="envVariables")
    def env_variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "envVariables")

    @env_variables.setter
    def env_variables(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "envVariables", value)

    @builtins.property
    @jsii.member(jsii_name="handlers")
    def handlers(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionHandlers"]]:
        return jsii.get(self, "handlers")

    @handlers.setter
    def handlers(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionHandlers"]]) -> None:
        jsii.set(self, "handlers", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="inboundServices")
    def inbound_services(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "inboundServices")

    @inbound_services.setter
    def inbound_services(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "inboundServices", value)

    @builtins.property
    @jsii.member(jsii_name="instanceClass")
    def instance_class(self) -> typing.Optional[str]:
        return jsii.get(self, "instanceClass")

    @instance_class.setter
    def instance_class(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "instanceClass", value)

    @builtins.property
    @jsii.member(jsii_name="manualScaling")
    def manual_scaling(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionManualScaling"]]:
        return jsii.get(self, "manualScaling")

    @manual_scaling.setter
    def manual_scaling(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionManualScaling"]]) -> None:
        jsii.set(self, "manualScaling", value)

    @builtins.property
    @jsii.member(jsii_name="network")
    def network(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionNetwork"]]:
        return jsii.get(self, "network")

    @network.setter
    def network(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionNetwork"]]) -> None:
        jsii.set(self, "network", value)

    @builtins.property
    @jsii.member(jsii_name="nobuildFilesRegex")
    def nobuild_files_regex(self) -> typing.Optional[str]:
        return jsii.get(self, "nobuildFilesRegex")

    @nobuild_files_regex.setter
    def nobuild_files_regex(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "nobuildFilesRegex", value)

    @builtins.property
    @jsii.member(jsii_name="noopOnDestroy")
    def noop_on_destroy(self) -> typing.Optional[bool]:
        return jsii.get(self, "noopOnDestroy")

    @noop_on_destroy.setter
    def noop_on_destroy(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "noopOnDestroy", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="resources")
    def resources(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionResources"]]:
        return jsii.get(self, "resources")

    @resources.setter
    def resources(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionResources"]]) -> None:
        jsii.set(self, "resources", value)

    @builtins.property
    @jsii.member(jsii_name="runtimeApiVersion")
    def runtime_api_version(self) -> typing.Optional[str]:
        return jsii.get(self, "runtimeApiVersion")

    @runtime_api_version.setter
    def runtime_api_version(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "runtimeApiVersion", value)

    @builtins.property
    @jsii.member(jsii_name="runtimeChannel")
    def runtime_channel(self) -> typing.Optional[str]:
        return jsii.get(self, "runtimeChannel")

    @runtime_channel.setter
    def runtime_channel(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "runtimeChannel", value)

    @builtins.property
    @jsii.member(jsii_name="runtimeMainExecutablePath")
    def runtime_main_executable_path(self) -> typing.Optional[str]:
        return jsii.get(self, "runtimeMainExecutablePath")

    @runtime_main_executable_path.setter
    def runtime_main_executable_path(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "runtimeMainExecutablePath", value)

    @builtins.property
    @jsii.member(jsii_name="servingStatus")
    def serving_status(self) -> typing.Optional[str]:
        return jsii.get(self, "servingStatus")

    @serving_status.setter
    def serving_status(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "servingStatus", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AppEngineFlexibleAppVersionTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AppEngineFlexibleAppVersionTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="versionId")
    def version_id(self) -> typing.Optional[str]:
        return jsii.get(self, "versionId")

    @version_id.setter
    def version_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "versionId", value)

    @builtins.property
    @jsii.member(jsii_name="vpcAccessConnector")
    def vpc_access_connector(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionVpcAccessConnector"]]:
        return jsii.get(self, "vpcAccessConnector")

    @vpc_access_connector.setter
    def vpc_access_connector(self, value: typing.Optional[typing.List["AppEngineFlexibleAppVersionVpcAccessConnector"]]) -> None:
        jsii.set(self, "vpcAccessConnector", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionApiConfig", jsii_struct_bases=[], name_mapping={'script': 'script', 'auth_fail_action': 'authFailAction', 'login': 'login', 'security_level': 'securityLevel', 'url': 'url'})
class AppEngineFlexibleAppVersionApiConfig():
    def __init__(self, *, script: str, auth_fail_action: typing.Optional[str]=None, login: typing.Optional[str]=None, security_level: typing.Optional[str]=None, url: typing.Optional[str]=None) -> None:
        """
        :param script: Path to the script from the application root directory.
        :param auth_fail_action: Action to take when users access resources that require authentication. Default value: "AUTH_FAIL_ACTION_REDIRECT" Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
        :param login: Level of login required to access this resource. Default value: "LOGIN_OPTIONAL" Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
        :param security_level: Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
        :param url: URL to serve the endpoint at.
        """
        self._values = {
            'script': script,
        }
        if auth_fail_action is not None: self._values["auth_fail_action"] = auth_fail_action
        if login is not None: self._values["login"] = login
        if security_level is not None: self._values["security_level"] = security_level
        if url is not None: self._values["url"] = url

    @builtins.property
    def script(self) -> str:
        """Path to the script from the application root directory."""
        return self._values.get('script')

    @builtins.property
    def auth_fail_action(self) -> typing.Optional[str]:
        """Action to take when users access resources that require authentication.

        Default value: "AUTH_FAIL_ACTION_REDIRECT" Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
        """
        return self._values.get('auth_fail_action')

    @builtins.property
    def login(self) -> typing.Optional[str]:
        """Level of login required to access this resource.

        Default value: "LOGIN_OPTIONAL" Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
        """
        return self._values.get('login')

    @builtins.property
    def security_level(self) -> typing.Optional[str]:
        """Security (HTTPS) enforcement for this URL.

        Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
        """
        return self._values.get('security_level')

    @builtins.property
    def url(self) -> typing.Optional[str]:
        """URL to serve the endpoint at."""
        return self._values.get('url')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionApiConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionAutomaticScaling", jsii_struct_bases=[], name_mapping={'cpu_utilization': 'cpuUtilization', 'cool_down_period': 'coolDownPeriod', 'disk_utilization': 'diskUtilization', 'max_concurrent_requests': 'maxConcurrentRequests', 'max_idle_instances': 'maxIdleInstances', 'max_pending_latency': 'maxPendingLatency', 'max_total_instances': 'maxTotalInstances', 'min_idle_instances': 'minIdleInstances', 'min_pending_latency': 'minPendingLatency', 'min_total_instances': 'minTotalInstances', 'network_utilization': 'networkUtilization', 'request_utilization': 'requestUtilization'})
class AppEngineFlexibleAppVersionAutomaticScaling():
    def __init__(self, *, cpu_utilization: typing.List["AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization"], cool_down_period: typing.Optional[str]=None, disk_utilization: typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization"]]=None, max_concurrent_requests: typing.Optional[jsii.Number]=None, max_idle_instances: typing.Optional[jsii.Number]=None, max_pending_latency: typing.Optional[str]=None, max_total_instances: typing.Optional[jsii.Number]=None, min_idle_instances: typing.Optional[jsii.Number]=None, min_pending_latency: typing.Optional[str]=None, min_total_instances: typing.Optional[jsii.Number]=None, network_utilization: typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization"]]=None, request_utilization: typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization"]]=None) -> None:
        """
        :param cpu_utilization: cpu_utilization block.
        :param cool_down_period: The time period that the Autoscaler should wait before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. Default: 120s
        :param disk_utilization: disk_utilization block.
        :param max_concurrent_requests: Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance. Defaults to a runtime-specific value.
        :param max_idle_instances: Maximum number of idle instances that should be maintained for this version.
        :param max_pending_latency: Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
        :param max_total_instances: Maximum number of instances that should be started to handle requests for this version. Default: 20
        :param min_idle_instances: Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        :param min_pending_latency: Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
        :param min_total_instances: Minimum number of running instances that should be maintained for this version. Default: 2
        :param network_utilization: network_utilization block.
        :param request_utilization: request_utilization block.
        """
        self._values = {
            'cpu_utilization': cpu_utilization,
        }
        if cool_down_period is not None: self._values["cool_down_period"] = cool_down_period
        if disk_utilization is not None: self._values["disk_utilization"] = disk_utilization
        if max_concurrent_requests is not None: self._values["max_concurrent_requests"] = max_concurrent_requests
        if max_idle_instances is not None: self._values["max_idle_instances"] = max_idle_instances
        if max_pending_latency is not None: self._values["max_pending_latency"] = max_pending_latency
        if max_total_instances is not None: self._values["max_total_instances"] = max_total_instances
        if min_idle_instances is not None: self._values["min_idle_instances"] = min_idle_instances
        if min_pending_latency is not None: self._values["min_pending_latency"] = min_pending_latency
        if min_total_instances is not None: self._values["min_total_instances"] = min_total_instances
        if network_utilization is not None: self._values["network_utilization"] = network_utilization
        if request_utilization is not None: self._values["request_utilization"] = request_utilization

    @builtins.property
    def cpu_utilization(self) -> typing.List["AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization"]:
        """cpu_utilization block."""
        return self._values.get('cpu_utilization')

    @builtins.property
    def cool_down_period(self) -> typing.Optional[str]:
        """The time period that the Autoscaler should wait before it starts collecting information from a new instance.

        This prevents the autoscaler from collecting information when the instance is initializing,
        during which the collected usage would not be reliable. Default: 120s
        """
        return self._values.get('cool_down_period')

    @builtins.property
    def disk_utilization(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization"]]:
        """disk_utilization block."""
        return self._values.get('disk_utilization')

    @builtins.property
    def max_concurrent_requests(self) -> typing.Optional[jsii.Number]:
        """Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.

        Defaults to a runtime-specific value.
        """
        return self._values.get('max_concurrent_requests')

    @builtins.property
    def max_idle_instances(self) -> typing.Optional[jsii.Number]:
        """Maximum number of idle instances that should be maintained for this version."""
        return self._values.get('max_idle_instances')

    @builtins.property
    def max_pending_latency(self) -> typing.Optional[str]:
        """Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it."""
        return self._values.get('max_pending_latency')

    @builtins.property
    def max_total_instances(self) -> typing.Optional[jsii.Number]:
        """Maximum number of instances that should be started to handle requests for this version.

        Default: 20
        """
        return self._values.get('max_total_instances')

    @builtins.property
    def min_idle_instances(self) -> typing.Optional[jsii.Number]:
        """Minimum number of idle instances that should be maintained for this version.

        Only applicable for the default version of a service.
        """
        return self._values.get('min_idle_instances')

    @builtins.property
    def min_pending_latency(self) -> typing.Optional[str]:
        """Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it."""
        return self._values.get('min_pending_latency')

    @builtins.property
    def min_total_instances(self) -> typing.Optional[jsii.Number]:
        """Minimum number of running instances that should be maintained for this version.

        Default: 2
        """
        return self._values.get('min_total_instances')

    @builtins.property
    def network_utilization(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization"]]:
        """network_utilization block."""
        return self._values.get('network_utilization')

    @builtins.property
    def request_utilization(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization"]]:
        """request_utilization block."""
        return self._values.get('request_utilization')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionAutomaticScaling(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization", jsii_struct_bases=[], name_mapping={'target_utilization': 'targetUtilization', 'aggregation_window_length': 'aggregationWindowLength'})
class AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization():
    def __init__(self, *, target_utilization: jsii.Number, aggregation_window_length: typing.Optional[str]=None) -> None:
        """
        :param target_utilization: Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
        :param aggregation_window_length: Period of time over which CPU utilization is calculated.
        """
        self._values = {
            'target_utilization': target_utilization,
        }
        if aggregation_window_length is not None: self._values["aggregation_window_length"] = aggregation_window_length

    @builtins.property
    def target_utilization(self) -> jsii.Number:
        """Target CPU utilization ratio to maintain when scaling.

        Must be between 0 and 1.
        """
        return self._values.get('target_utilization')

    @builtins.property
    def aggregation_window_length(self) -> typing.Optional[str]:
        """Period of time over which CPU utilization is calculated."""
        return self._values.get('aggregation_window_length')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization", jsii_struct_bases=[], name_mapping={'target_read_bytes_per_second': 'targetReadBytesPerSecond', 'target_read_ops_per_second': 'targetReadOpsPerSecond', 'target_write_bytes_per_second': 'targetWriteBytesPerSecond', 'target_write_ops_per_second': 'targetWriteOpsPerSecond'})
class AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization():
    def __init__(self, *, target_read_bytes_per_second: typing.Optional[jsii.Number]=None, target_read_ops_per_second: typing.Optional[jsii.Number]=None, target_write_bytes_per_second: typing.Optional[jsii.Number]=None, target_write_ops_per_second: typing.Optional[jsii.Number]=None) -> None:
        """
        :param target_read_bytes_per_second: Target bytes read per second.
        :param target_read_ops_per_second: Target ops read per seconds.
        :param target_write_bytes_per_second: Target bytes written per second.
        :param target_write_ops_per_second: Target ops written per second.
        """
        self._values = {
        }
        if target_read_bytes_per_second is not None: self._values["target_read_bytes_per_second"] = target_read_bytes_per_second
        if target_read_ops_per_second is not None: self._values["target_read_ops_per_second"] = target_read_ops_per_second
        if target_write_bytes_per_second is not None: self._values["target_write_bytes_per_second"] = target_write_bytes_per_second
        if target_write_ops_per_second is not None: self._values["target_write_ops_per_second"] = target_write_ops_per_second

    @builtins.property
    def target_read_bytes_per_second(self) -> typing.Optional[jsii.Number]:
        """Target bytes read per second."""
        return self._values.get('target_read_bytes_per_second')

    @builtins.property
    def target_read_ops_per_second(self) -> typing.Optional[jsii.Number]:
        """Target ops read per seconds."""
        return self._values.get('target_read_ops_per_second')

    @builtins.property
    def target_write_bytes_per_second(self) -> typing.Optional[jsii.Number]:
        """Target bytes written per second."""
        return self._values.get('target_write_bytes_per_second')

    @builtins.property
    def target_write_ops_per_second(self) -> typing.Optional[jsii.Number]:
        """Target ops written per second."""
        return self._values.get('target_write_ops_per_second')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization", jsii_struct_bases=[], name_mapping={'target_received_bytes_per_second': 'targetReceivedBytesPerSecond', 'target_received_packets_per_second': 'targetReceivedPacketsPerSecond', 'target_sent_bytes_per_second': 'targetSentBytesPerSecond', 'target_sent_packets_per_second': 'targetSentPacketsPerSecond'})
class AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization():
    def __init__(self, *, target_received_bytes_per_second: typing.Optional[jsii.Number]=None, target_received_packets_per_second: typing.Optional[jsii.Number]=None, target_sent_bytes_per_second: typing.Optional[jsii.Number]=None, target_sent_packets_per_second: typing.Optional[jsii.Number]=None) -> None:
        """
        :param target_received_bytes_per_second: Target bytes received per second.
        :param target_received_packets_per_second: Target packets received per second.
        :param target_sent_bytes_per_second: Target bytes sent per second.
        :param target_sent_packets_per_second: Target packets sent per second.
        """
        self._values = {
        }
        if target_received_bytes_per_second is not None: self._values["target_received_bytes_per_second"] = target_received_bytes_per_second
        if target_received_packets_per_second is not None: self._values["target_received_packets_per_second"] = target_received_packets_per_second
        if target_sent_bytes_per_second is not None: self._values["target_sent_bytes_per_second"] = target_sent_bytes_per_second
        if target_sent_packets_per_second is not None: self._values["target_sent_packets_per_second"] = target_sent_packets_per_second

    @builtins.property
    def target_received_bytes_per_second(self) -> typing.Optional[jsii.Number]:
        """Target bytes received per second."""
        return self._values.get('target_received_bytes_per_second')

    @builtins.property
    def target_received_packets_per_second(self) -> typing.Optional[jsii.Number]:
        """Target packets received per second."""
        return self._values.get('target_received_packets_per_second')

    @builtins.property
    def target_sent_bytes_per_second(self) -> typing.Optional[jsii.Number]:
        """Target bytes sent per second."""
        return self._values.get('target_sent_bytes_per_second')

    @builtins.property
    def target_sent_packets_per_second(self) -> typing.Optional[jsii.Number]:
        """Target packets sent per second."""
        return self._values.get('target_sent_packets_per_second')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization", jsii_struct_bases=[], name_mapping={'target_concurrent_requests': 'targetConcurrentRequests', 'target_request_count_per_second': 'targetRequestCountPerSecond'})
class AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization():
    def __init__(self, *, target_concurrent_requests: typing.Optional[jsii.Number]=None, target_request_count_per_second: typing.Optional[str]=None) -> None:
        """
        :param target_concurrent_requests: Target number of concurrent requests.
        :param target_request_count_per_second: Target requests per second.
        """
        self._values = {
        }
        if target_concurrent_requests is not None: self._values["target_concurrent_requests"] = target_concurrent_requests
        if target_request_count_per_second is not None: self._values["target_request_count_per_second"] = target_request_count_per_second

    @builtins.property
    def target_concurrent_requests(self) -> typing.Optional[jsii.Number]:
        """Target number of concurrent requests."""
        return self._values.get('target_concurrent_requests')

    @builtins.property
    def target_request_count_per_second(self) -> typing.Optional[str]:
        """Target requests per second."""
        return self._values.get('target_request_count_per_second')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'liveness_check': 'livenessCheck', 'readiness_check': 'readinessCheck', 'runtime': 'runtime', 'service': 'service', 'api_config': 'apiConfig', 'automatic_scaling': 'automaticScaling', 'beta_settings': 'betaSettings', 'default_expiration': 'defaultExpiration', 'delete_service_on_destroy': 'deleteServiceOnDestroy', 'deployment': 'deployment', 'endpoints_api_service': 'endpointsApiService', 'entrypoint': 'entrypoint', 'env_variables': 'envVariables', 'handlers': 'handlers', 'inbound_services': 'inboundServices', 'instance_class': 'instanceClass', 'manual_scaling': 'manualScaling', 'network': 'network', 'nobuild_files_regex': 'nobuildFilesRegex', 'noop_on_destroy': 'noopOnDestroy', 'project': 'project', 'resources': 'resources', 'runtime_api_version': 'runtimeApiVersion', 'runtime_channel': 'runtimeChannel', 'runtime_main_executable_path': 'runtimeMainExecutablePath', 'serving_status': 'servingStatus', 'timeouts': 'timeouts', 'version_id': 'versionId', 'vpc_access_connector': 'vpcAccessConnector'})
class AppEngineFlexibleAppVersionConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, liveness_check: typing.List["AppEngineFlexibleAppVersionLivenessCheck"], readiness_check: typing.List["AppEngineFlexibleAppVersionReadinessCheck"], runtime: str, service: str, api_config: typing.Optional[typing.List["AppEngineFlexibleAppVersionApiConfig"]]=None, automatic_scaling: typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScaling"]]=None, beta_settings: typing.Optional[typing.Mapping[str, str]]=None, default_expiration: typing.Optional[str]=None, delete_service_on_destroy: typing.Optional[bool]=None, deployment: typing.Optional[typing.List["AppEngineFlexibleAppVersionDeployment"]]=None, endpoints_api_service: typing.Optional[typing.List["AppEngineFlexibleAppVersionEndpointsApiService"]]=None, entrypoint: typing.Optional[typing.List["AppEngineFlexibleAppVersionEntrypoint"]]=None, env_variables: typing.Optional[typing.Mapping[str, str]]=None, handlers: typing.Optional[typing.List["AppEngineFlexibleAppVersionHandlers"]]=None, inbound_services: typing.Optional[typing.List[str]]=None, instance_class: typing.Optional[str]=None, manual_scaling: typing.Optional[typing.List["AppEngineFlexibleAppVersionManualScaling"]]=None, network: typing.Optional[typing.List["AppEngineFlexibleAppVersionNetwork"]]=None, nobuild_files_regex: typing.Optional[str]=None, noop_on_destroy: typing.Optional[bool]=None, project: typing.Optional[str]=None, resources: typing.Optional[typing.List["AppEngineFlexibleAppVersionResources"]]=None, runtime_api_version: typing.Optional[str]=None, runtime_channel: typing.Optional[str]=None, runtime_main_executable_path: typing.Optional[str]=None, serving_status: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineFlexibleAppVersionTimeouts"]=None, version_id: typing.Optional[str]=None, vpc_access_connector: typing.Optional[typing.List["AppEngineFlexibleAppVersionVpcAccessConnector"]]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param liveness_check: liveness_check block.
        :param readiness_check: readiness_check block.
        :param runtime: Desired runtime. Example python27.
        :param service: AppEngine service resource.
        :param api_config: api_config block.
        :param automatic_scaling: automatic_scaling block.
        :param beta_settings: Metadata settings that are supplied to this version to enable beta runtime features.
        :param default_expiration: Duration that static files should be cached by web proxies and browsers. Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        :param delete_service_on_destroy: 
        :param deployment: deployment block.
        :param endpoints_api_service: endpoints_api_service block.
        :param entrypoint: entrypoint block.
        :param env_variables: Environment variables available to the application. As these are not returned in the API request, Terraform will not detect any changes made outside of the Terraform config.
        :param handlers: handlers block.
        :param inbound_services: A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
        :param instance_class: Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G ManualScaling: B1, B2, B4, B8, B4_1G Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        :param manual_scaling: manual_scaling block.
        :param network: network block.
        :param nobuild_files_regex: Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
        :param noop_on_destroy: 
        :param project: 
        :param resources: resources block.
        :param runtime_api_version: The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref
        :param runtime_channel: The channel of the runtime to use. Only available for some runtimes.
        :param runtime_main_executable_path: The path or name of the app's main executable.
        :param serving_status: Current serving status of this version. Only the versions with a SERVING status create instances and can be billed. Default value: "SERVING" Possible values: ["SERVING", "STOPPED"]
        :param timeouts: timeouts block.
        :param version_id: Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param vpc_access_connector: vpc_access_connector block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AppEngineFlexibleAppVersionTimeouts(**timeouts)
        self._values = {
            'liveness_check': liveness_check,
            'readiness_check': readiness_check,
            'runtime': runtime,
            'service': service,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if api_config is not None: self._values["api_config"] = api_config
        if automatic_scaling is not None: self._values["automatic_scaling"] = automatic_scaling
        if beta_settings is not None: self._values["beta_settings"] = beta_settings
        if default_expiration is not None: self._values["default_expiration"] = default_expiration
        if delete_service_on_destroy is not None: self._values["delete_service_on_destroy"] = delete_service_on_destroy
        if deployment is not None: self._values["deployment"] = deployment
        if endpoints_api_service is not None: self._values["endpoints_api_service"] = endpoints_api_service
        if entrypoint is not None: self._values["entrypoint"] = entrypoint
        if env_variables is not None: self._values["env_variables"] = env_variables
        if handlers is not None: self._values["handlers"] = handlers
        if inbound_services is not None: self._values["inbound_services"] = inbound_services
        if instance_class is not None: self._values["instance_class"] = instance_class
        if manual_scaling is not None: self._values["manual_scaling"] = manual_scaling
        if network is not None: self._values["network"] = network
        if nobuild_files_regex is not None: self._values["nobuild_files_regex"] = nobuild_files_regex
        if noop_on_destroy is not None: self._values["noop_on_destroy"] = noop_on_destroy
        if project is not None: self._values["project"] = project
        if resources is not None: self._values["resources"] = resources
        if runtime_api_version is not None: self._values["runtime_api_version"] = runtime_api_version
        if runtime_channel is not None: self._values["runtime_channel"] = runtime_channel
        if runtime_main_executable_path is not None: self._values["runtime_main_executable_path"] = runtime_main_executable_path
        if serving_status is not None: self._values["serving_status"] = serving_status
        if timeouts is not None: self._values["timeouts"] = timeouts
        if version_id is not None: self._values["version_id"] = version_id
        if vpc_access_connector is not None: self._values["vpc_access_connector"] = vpc_access_connector

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def liveness_check(self) -> typing.List["AppEngineFlexibleAppVersionLivenessCheck"]:
        """liveness_check block."""
        return self._values.get('liveness_check')

    @builtins.property
    def readiness_check(self) -> typing.List["AppEngineFlexibleAppVersionReadinessCheck"]:
        """readiness_check block."""
        return self._values.get('readiness_check')

    @builtins.property
    def runtime(self) -> str:
        """Desired runtime.

        Example python27.
        """
        return self._values.get('runtime')

    @builtins.property
    def service(self) -> str:
        """AppEngine service resource."""
        return self._values.get('service')

    @builtins.property
    def api_config(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionApiConfig"]]:
        """api_config block."""
        return self._values.get('api_config')

    @builtins.property
    def automatic_scaling(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionAutomaticScaling"]]:
        """automatic_scaling block."""
        return self._values.get('automatic_scaling')

    @builtins.property
    def beta_settings(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Metadata settings that are supplied to this version to enable beta runtime features."""
        return self._values.get('beta_settings')

    @builtins.property
    def default_expiration(self) -> typing.Optional[str]:
        """Duration that static files should be cached by web proxies and browsers.

        Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
        """
        return self._values.get('default_expiration')

    @builtins.property
    def delete_service_on_destroy(self) -> typing.Optional[bool]:
        return self._values.get('delete_service_on_destroy')

    @builtins.property
    def deployment(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionDeployment"]]:
        """deployment block."""
        return self._values.get('deployment')

    @builtins.property
    def endpoints_api_service(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionEndpointsApiService"]]:
        """endpoints_api_service block."""
        return self._values.get('endpoints_api_service')

    @builtins.property
    def entrypoint(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionEntrypoint"]]:
        """entrypoint block."""
        return self._values.get('entrypoint')

    @builtins.property
    def env_variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Environment variables available to the application.

        As these are not returned in the API request, Terraform will not detect any changes made outside of the Terraform config.
        """
        return self._values.get('env_variables')

    @builtins.property
    def handlers(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionHandlers"]]:
        """handlers block."""
        return self._values.get('handlers')

    @builtins.property
    def inbound_services(self) -> typing.Optional[typing.List[str]]:
        """A list of the types of messages that this application is able to receive.

        Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
        """
        return self._values.get('inbound_services')

    @builtins.property
    def instance_class(self) -> typing.Optional[str]:
        """Instance class that is used to run this version.

        Valid values are
        AutomaticScaling: F1, F2, F4, F4_1G
        ManualScaling: B1, B2, B4, B8, B4_1G
        Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
        """
        return self._values.get('instance_class')

    @builtins.property
    def manual_scaling(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionManualScaling"]]:
        """manual_scaling block."""
        return self._values.get('manual_scaling')

    @builtins.property
    def network(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionNetwork"]]:
        """network block."""
        return self._values.get('network')

    @builtins.property
    def nobuild_files_regex(self) -> typing.Optional[str]:
        """Files that match this pattern will not be built into this version.

        Only applicable for Go runtimes.
        """
        return self._values.get('nobuild_files_regex')

    @builtins.property
    def noop_on_destroy(self) -> typing.Optional[bool]:
        return self._values.get('noop_on_destroy')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def resources(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionResources"]]:
        """resources block."""
        return self._values.get('resources')

    @builtins.property
    def runtime_api_version(self) -> typing.Optional[str]:
        """The version of the API in the given runtime environment.

        Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref
        """
        return self._values.get('runtime_api_version')

    @builtins.property
    def runtime_channel(self) -> typing.Optional[str]:
        """The channel of the runtime to use.

        Only available for some runtimes.
        """
        return self._values.get('runtime_channel')

    @builtins.property
    def runtime_main_executable_path(self) -> typing.Optional[str]:
        """The path or name of the app's main executable."""
        return self._values.get('runtime_main_executable_path')

    @builtins.property
    def serving_status(self) -> typing.Optional[str]:
        """Current serving status of this version.

        Only the versions with a SERVING status create instances and can be billed. Default value: "SERVING" Possible values: ["SERVING", "STOPPED"]
        """
        return self._values.get('serving_status')

    @builtins.property
    def timeouts(self) -> typing.Optional["AppEngineFlexibleAppVersionTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    @builtins.property
    def version_id(self) -> typing.Optional[str]:
        """Relative name of the version within the service.

        For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens.
        Reserved names,"default", "latest", and any name with the prefix "ah-".
        """
        return self._values.get('version_id')

    @builtins.property
    def vpc_access_connector(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionVpcAccessConnector"]]:
        """vpc_access_connector block."""
        return self._values.get('vpc_access_connector')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionDeployment", jsii_struct_bases=[], name_mapping={'cloud_build_options': 'cloudBuildOptions', 'container': 'container', 'files': 'files', 'zip': 'zip'})
class AppEngineFlexibleAppVersionDeployment():
    def __init__(self, *, cloud_build_options: typing.Optional[typing.List["AppEngineFlexibleAppVersionDeploymentCloudBuildOptions"]]=None, container: typing.Optional[typing.List["AppEngineFlexibleAppVersionDeploymentContainer"]]=None, files: typing.Optional[typing.List["AppEngineFlexibleAppVersionDeploymentFiles"]]=None, zip: typing.Optional[typing.List["AppEngineFlexibleAppVersionDeploymentZip"]]=None) -> None:
        """
        :param cloud_build_options: cloud_build_options block.
        :param container: container block.
        :param files: files block.
        :param zip: zip block.
        """
        self._values = {
        }
        if cloud_build_options is not None: self._values["cloud_build_options"] = cloud_build_options
        if container is not None: self._values["container"] = container
        if files is not None: self._values["files"] = files
        if zip is not None: self._values["zip"] = zip

    @builtins.property
    def cloud_build_options(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionDeploymentCloudBuildOptions"]]:
        """cloud_build_options block."""
        return self._values.get('cloud_build_options')

    @builtins.property
    def container(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionDeploymentContainer"]]:
        """container block."""
        return self._values.get('container')

    @builtins.property
    def files(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionDeploymentFiles"]]:
        """files block."""
        return self._values.get('files')

    @builtins.property
    def zip(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionDeploymentZip"]]:
        """zip block."""
        return self._values.get('zip')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionDeployment(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionDeploymentCloudBuildOptions", jsii_struct_bases=[], name_mapping={'app_yaml_path': 'appYamlPath', 'cloud_build_timeout': 'cloudBuildTimeout'})
class AppEngineFlexibleAppVersionDeploymentCloudBuildOptions():
    def __init__(self, *, app_yaml_path: str, cloud_build_timeout: typing.Optional[str]=None) -> None:
        """
        :param app_yaml_path: Path to the yaml file used in deployment, used to determine runtime configuration details.
        :param cloud_build_timeout: The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        self._values = {
            'app_yaml_path': app_yaml_path,
        }
        if cloud_build_timeout is not None: self._values["cloud_build_timeout"] = cloud_build_timeout

    @builtins.property
    def app_yaml_path(self) -> str:
        """Path to the yaml file used in deployment, used to determine runtime configuration details."""
        return self._values.get('app_yaml_path')

    @builtins.property
    def cloud_build_timeout(self) -> typing.Optional[str]:
        """The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.

        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return self._values.get('cloud_build_timeout')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionDeploymentCloudBuildOptions(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionDeploymentContainer", jsii_struct_bases=[], name_mapping={'image': 'image'})
class AppEngineFlexibleAppVersionDeploymentContainer():
    def __init__(self, *, image: str) -> None:
        """
        :param image: URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest. Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
        """
        self._values = {
            'image': image,
        }

    @builtins.property
    def image(self) -> str:
        """URI to the hosted container image in Google Container Registry.

        The URI must be fully qualified and include a tag or digest.
        Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
        """
        return self._values.get('image')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionDeploymentContainer(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionDeploymentFiles", jsii_struct_bases=[], name_mapping={'name': 'name', 'source_url': 'sourceUrl', 'sha1_sum': 'sha1Sum'})
class AppEngineFlexibleAppVersionDeploymentFiles():
    def __init__(self, *, name: str, source_url: str, sha1_sum: typing.Optional[str]=None) -> None:
        """
        :param name: 
        :param source_url: Source URL.
        :param sha1_sum: SHA1 checksum of the file.
        """
        self._values = {
            'name': name,
            'source_url': source_url,
        }
        if sha1_sum is not None: self._values["sha1_sum"] = sha1_sum

    @builtins.property
    def name(self) -> str:
        return self._values.get('name')

    @builtins.property
    def source_url(self) -> str:
        """Source URL."""
        return self._values.get('source_url')

    @builtins.property
    def sha1_sum(self) -> typing.Optional[str]:
        """SHA1 checksum of the file."""
        return self._values.get('sha1_sum')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionDeploymentFiles(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionDeploymentZip", jsii_struct_bases=[], name_mapping={'source_url': 'sourceUrl', 'files_count': 'filesCount'})
class AppEngineFlexibleAppVersionDeploymentZip():
    def __init__(self, *, source_url: str, files_count: typing.Optional[jsii.Number]=None) -> None:
        """
        :param source_url: Source URL.
        :param files_count: files count.
        """
        self._values = {
            'source_url': source_url,
        }
        if files_count is not None: self._values["files_count"] = files_count

    @builtins.property
    def source_url(self) -> str:
        """Source URL."""
        return self._values.get('source_url')

    @builtins.property
    def files_count(self) -> typing.Optional[jsii.Number]:
        """files count."""
        return self._values.get('files_count')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionDeploymentZip(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionEndpointsApiService", jsii_struct_bases=[], name_mapping={'name': 'name', 'config_id': 'configId', 'disable_trace_sampling': 'disableTraceSampling', 'rollout_strategy': 'rolloutStrategy'})
class AppEngineFlexibleAppVersionEndpointsApiService():
    def __init__(self, *, name: str, config_id: typing.Optional[str]=None, disable_trace_sampling: typing.Optional[bool]=None, rollout_strategy: typing.Optional[str]=None) -> None:
        """
        :param name: Endpoints service name which is the name of the "service" resource in the Service Management API. For example "myapi.endpoints.myproject.cloud.goog"
        :param config_id: Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1". By default, the rollout strategy for Endpoints is "FIXED". This means that Endpoints starts up with a particular configuration ID. When a new configuration is rolled out, Endpoints must be given the new configuration ID. The configId field is used to give the configuration ID and is required in this case. Endpoints also has a rollout strategy called "MANAGED". When using this, Endpoints fetches the latest configuration and does not need the configuration ID. In this case, configId must be omitted.
        :param disable_trace_sampling: Enable or disable trace sampling. By default, this is set to false for enabled.
        :param rollout_strategy: Endpoints rollout strategy. If FIXED, configId must be specified. If MANAGED, configId must be omitted. Default value: "FIXED" Possible values: ["FIXED", "MANAGED"]
        """
        self._values = {
            'name': name,
        }
        if config_id is not None: self._values["config_id"] = config_id
        if disable_trace_sampling is not None: self._values["disable_trace_sampling"] = disable_trace_sampling
        if rollout_strategy is not None: self._values["rollout_strategy"] = rollout_strategy

    @builtins.property
    def name(self) -> str:
        """Endpoints service name which is the name of the "service" resource in the Service Management API.

        For example "myapi.endpoints.myproject.cloud.goog"
        """
        return self._values.get('name')

    @builtins.property
    def config_id(self) -> typing.Optional[str]:
        """Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".

        By default, the rollout strategy for Endpoints is "FIXED". This means that Endpoints starts up with a particular configuration ID.
        When a new configuration is rolled out, Endpoints must be given the new configuration ID. The configId field is used to give the configuration ID
        and is required in this case.

        Endpoints also has a rollout strategy called "MANAGED". When using this, Endpoints fetches the latest configuration and does not need
        the configuration ID. In this case, configId must be omitted.
        """
        return self._values.get('config_id')

    @builtins.property
    def disable_trace_sampling(self) -> typing.Optional[bool]:
        """Enable or disable trace sampling.

        By default, this is set to false for enabled.
        """
        return self._values.get('disable_trace_sampling')

    @builtins.property
    def rollout_strategy(self) -> typing.Optional[str]:
        """Endpoints rollout strategy.

        If FIXED, configId must be specified. If MANAGED, configId must be omitted. Default value: "FIXED" Possible values: ["FIXED", "MANAGED"]
        """
        return self._values.get('rollout_strategy')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionEndpointsApiService(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionEntrypoint", jsii_struct_bases=[], name_mapping={'shell': 'shell'})
class AppEngineFlexibleAppVersionEntrypoint():
    def __init__(self, *, shell: str) -> None:
        """
        :param shell: The format should be a shell command that can be fed to bash -c.
        """
        self._values = {
            'shell': shell,
        }

    @builtins.property
    def shell(self) -> str:
        """The format should be a shell command that can be fed to bash -c."""
        return self._values.get('shell')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionEntrypoint(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionHandlers", jsii_struct_bases=[], name_mapping={'auth_fail_action': 'authFailAction', 'login': 'login', 'redirect_http_response_code': 'redirectHttpResponseCode', 'script': 'script', 'security_level': 'securityLevel', 'static_files': 'staticFiles', 'url_regex': 'urlRegex'})
class AppEngineFlexibleAppVersionHandlers():
    def __init__(self, *, auth_fail_action: typing.Optional[str]=None, login: typing.Optional[str]=None, redirect_http_response_code: typing.Optional[str]=None, script: typing.Optional[typing.List["AppEngineFlexibleAppVersionHandlersScript"]]=None, security_level: typing.Optional[str]=None, static_files: typing.Optional[typing.List["AppEngineFlexibleAppVersionHandlersStaticFiles"]]=None, url_regex: typing.Optional[str]=None) -> None:
        """
        :param auth_fail_action: Actions to take when the user is not logged in. Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
        :param login: Methods to restrict access to a URL based on login status. Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
        :param redirect_http_response_code: 30x code to use when performing redirects for the secure field. Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"]
        :param script: script block.
        :param security_level: Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
        :param static_files: static_files block.
        :param url_regex: URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings. All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        self._values = {
        }
        if auth_fail_action is not None: self._values["auth_fail_action"] = auth_fail_action
        if login is not None: self._values["login"] = login
        if redirect_http_response_code is not None: self._values["redirect_http_response_code"] = redirect_http_response_code
        if script is not None: self._values["script"] = script
        if security_level is not None: self._values["security_level"] = security_level
        if static_files is not None: self._values["static_files"] = static_files
        if url_regex is not None: self._values["url_regex"] = url_regex

    @builtins.property
    def auth_fail_action(self) -> typing.Optional[str]:
        """Actions to take when the user is not logged in.

        Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
        """
        return self._values.get('auth_fail_action')

    @builtins.property
    def login(self) -> typing.Optional[str]:
        """Methods to restrict access to a URL based on login status.

        Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
        """
        return self._values.get('login')

    @builtins.property
    def redirect_http_response_code(self) -> typing.Optional[str]:
        """30x code to use when performing redirects for the secure field.

        Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"]
        """
        return self._values.get('redirect_http_response_code')

    @builtins.property
    def script(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionHandlersScript"]]:
        """script block."""
        return self._values.get('script')

    @builtins.property
    def security_level(self) -> typing.Optional[str]:
        """Security (HTTPS) enforcement for this URL.

        Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
        """
        return self._values.get('security_level')

    @builtins.property
    def static_files(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionHandlersStaticFiles"]]:
        """static_files block."""
        return self._values.get('static_files')

    @builtins.property
    def url_regex(self) -> typing.Optional[str]:
        """URL prefix.

        Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
        All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        return self._values.get('url_regex')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionHandlers(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionHandlersScript", jsii_struct_bases=[], name_mapping={'script_path': 'scriptPath'})
class AppEngineFlexibleAppVersionHandlersScript():
    def __init__(self, *, script_path: str) -> None:
        """
        :param script_path: Path to the script from the application root directory.
        """
        self._values = {
            'script_path': script_path,
        }

    @builtins.property
    def script_path(self) -> str:
        """Path to the script from the application root directory."""
        return self._values.get('script_path')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionHandlersScript(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionHandlersStaticFiles", jsii_struct_bases=[], name_mapping={'application_readable': 'applicationReadable', 'expiration': 'expiration', 'http_headers': 'httpHeaders', 'mime_type': 'mimeType', 'path': 'path', 'require_matching_file': 'requireMatchingFile', 'upload_path_regex': 'uploadPathRegex'})
class AppEngineFlexibleAppVersionHandlersStaticFiles():
    def __init__(self, *, application_readable: typing.Optional[bool]=None, expiration: typing.Optional[str]=None, http_headers: typing.Optional[typing.Mapping[str, str]]=None, mime_type: typing.Optional[str]=None, path: typing.Optional[str]=None, require_matching_file: typing.Optional[bool]=None, upload_path_regex: typing.Optional[str]=None) -> None:
        """
        :param application_readable: Whether files should also be uploaded as code data. By default, files declared in static file handlers are uploaded as static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged against both your code and static data storage resource quotas.
        :param expiration: Time a static file served by this handler should be cached by web proxies and browsers. A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s". Default is '0s'
        :param http_headers: HTTP headers to use for all responses from these URLs. An object containing a list of "key:value" value pairs.".
        :param mime_type: MIME type used to serve all files served by this handler. Defaults to file-specific MIME types, which are derived from each file's filename extension.
        :param path: Path to the static files matched by the URL pattern, from the application root directory. The path can refer to text matched in groupings in the URL pattern.
        :param require_matching_file: Whether this handler should match the request if the file referenced by the handler does not exist.
        :param upload_path_regex: Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        self._values = {
        }
        if application_readable is not None: self._values["application_readable"] = application_readable
        if expiration is not None: self._values["expiration"] = expiration
        if http_headers is not None: self._values["http_headers"] = http_headers
        if mime_type is not None: self._values["mime_type"] = mime_type
        if path is not None: self._values["path"] = path
        if require_matching_file is not None: self._values["require_matching_file"] = require_matching_file
        if upload_path_regex is not None: self._values["upload_path_regex"] = upload_path_regex

    @builtins.property
    def application_readable(self) -> typing.Optional[bool]:
        """Whether files should also be uploaded as code data.

        By default, files declared in static file handlers are
        uploaded as static data and are only served to end users; they cannot be read by the application. If enabled,
        uploads are charged against both your code and static data storage resource quotas.
        """
        return self._values.get('application_readable')

    @builtins.property
    def expiration(self) -> typing.Optional[str]:
        """Time a static file served by this handler should be cached by web proxies and browsers.

        A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
        Default is '0s'
        """
        return self._values.get('expiration')

    @builtins.property
    def http_headers(self) -> typing.Optional[typing.Mapping[str, str]]:
        """HTTP headers to use for all responses from these URLs.

        An object containing a list of "key:value" value pairs.".
        """
        return self._values.get('http_headers')

    @builtins.property
    def mime_type(self) -> typing.Optional[str]:
        """MIME type used to serve all files served by this handler.

        Defaults to file-specific MIME types, which are derived from each file's filename extension.
        """
        return self._values.get('mime_type')

    @builtins.property
    def path(self) -> typing.Optional[str]:
        """Path to the static files matched by the URL pattern, from the application root directory.

        The path can refer to text matched in groupings in the URL pattern.
        """
        return self._values.get('path')

    @builtins.property
    def require_matching_file(self) -> typing.Optional[bool]:
        """Whether this handler should match the request if the file referenced by the handler does not exist."""
        return self._values.get('require_matching_file')

    @builtins.property
    def upload_path_regex(self) -> typing.Optional[str]:
        """Regular expression that matches the file paths for all files that should be referenced by this handler."""
        return self._values.get('upload_path_regex')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionHandlersStaticFiles(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionLivenessCheck", jsii_struct_bases=[], name_mapping={'path': 'path', 'check_interval': 'checkInterval', 'failure_threshold': 'failureThreshold', 'host': 'host', 'initial_delay': 'initialDelay', 'success_threshold': 'successThreshold', 'timeout': 'timeout'})
class AppEngineFlexibleAppVersionLivenessCheck():
    def __init__(self, *, path: str, check_interval: typing.Optional[str]=None, failure_threshold: typing.Optional[jsii.Number]=None, host: typing.Optional[str]=None, initial_delay: typing.Optional[str]=None, success_threshold: typing.Optional[jsii.Number]=None, timeout: typing.Optional[str]=None) -> None:
        """
        :param path: The request path.
        :param check_interval: Interval between health checks.
        :param failure_threshold: Number of consecutive failed checks required before considering the VM unhealthy. Default: 4.
        :param host: Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        :param initial_delay: The initial delay before starting to execute the checks. Default: "300s"
        :param success_threshold: Number of consecutive successful checks required before considering the VM healthy. Default: 2.
        :param timeout: Time before the check is considered failed. Default: "4s"
        """
        self._values = {
            'path': path,
        }
        if check_interval is not None: self._values["check_interval"] = check_interval
        if failure_threshold is not None: self._values["failure_threshold"] = failure_threshold
        if host is not None: self._values["host"] = host
        if initial_delay is not None: self._values["initial_delay"] = initial_delay
        if success_threshold is not None: self._values["success_threshold"] = success_threshold
        if timeout is not None: self._values["timeout"] = timeout

    @builtins.property
    def path(self) -> str:
        """The request path."""
        return self._values.get('path')

    @builtins.property
    def check_interval(self) -> typing.Optional[str]:
        """Interval between health checks."""
        return self._values.get('check_interval')

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        """Number of consecutive failed checks required before considering the VM unhealthy.

        Default: 4.
        """
        return self._values.get('failure_threshold')

    @builtins.property
    def host(self) -> typing.Optional[str]:
        """Host header to send when performing a HTTP Readiness check.

        Example: "myapp.appspot.com"
        """
        return self._values.get('host')

    @builtins.property
    def initial_delay(self) -> typing.Optional[str]:
        """The initial delay before starting to execute the checks.

        Default: "300s"
        """
        return self._values.get('initial_delay')

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        """Number of consecutive successful checks required before considering the VM healthy.

        Default: 2.
        """
        return self._values.get('success_threshold')

    @builtins.property
    def timeout(self) -> typing.Optional[str]:
        """Time before the check is considered failed.

        Default: "4s"
        """
        return self._values.get('timeout')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionLivenessCheck(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionManualScaling", jsii_struct_bases=[], name_mapping={'instances': 'instances'})
class AppEngineFlexibleAppVersionManualScaling():
    def __init__(self, *, instances: jsii.Number) -> None:
        """
        :param instances: Number of instances to assign to the service at the start. *Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2 Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
        """
        self._values = {
            'instances': instances,
        }

    @builtins.property
    def instances(self) -> jsii.Number:
        """Number of instances to assign to the service at the start.

        *Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
        Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
        """
        return self._values.get('instances')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionManualScaling(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionNetwork", jsii_struct_bases=[], name_mapping={'name': 'name', 'forwarded_ports': 'forwardedPorts', 'instance_tag': 'instanceTag', 'session_affinity': 'sessionAffinity', 'subnetwork': 'subnetwork'})
class AppEngineFlexibleAppVersionNetwork():
    def __init__(self, *, name: str, forwarded_ports: typing.Optional[typing.List[str]]=None, instance_tag: typing.Optional[str]=None, session_affinity: typing.Optional[bool]=None, subnetwork: typing.Optional[str]=None) -> None:
        """
        :param name: Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.
        :param forwarded_ports: List of ports, or port pairs, to forward from the virtual machine to the application container.
        :param instance_tag: Tag to apply to the instance during creation.
        :param session_affinity: Enable session affinity.
        :param subnetwork: Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path. If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range. If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetworkName) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network. If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetworkName must be specified and the IP address is created from the IPCidrRange of the subnetwork. If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
        """
        self._values = {
            'name': name,
        }
        if forwarded_ports is not None: self._values["forwarded_ports"] = forwarded_ports
        if instance_tag is not None: self._values["instance_tag"] = instance_tag
        if session_affinity is not None: self._values["session_affinity"] = session_affinity
        if subnetwork is not None: self._values["subnetwork"] = subnetwork

    @builtins.property
    def name(self) -> str:
        """Google Compute Engine network where the virtual machines are created.

        Specify the short name, not the resource path.
        """
        return self._values.get('name')

    @builtins.property
    def forwarded_ports(self) -> typing.Optional[typing.List[str]]:
        """List of ports, or port pairs, to forward from the virtual machine to the application container."""
        return self._values.get('forwarded_ports')

    @builtins.property
    def instance_tag(self) -> typing.Optional[str]:
        """Tag to apply to the instance during creation."""
        return self._values.get('instance_tag')

    @builtins.property
    def session_affinity(self) -> typing.Optional[bool]:
        """Enable session affinity."""
        return self._values.get('session_affinity')

    @builtins.property
    def subnetwork(self) -> typing.Optional[str]:
        """Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.

        If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range.
        If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetworkName) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network.
        If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetworkName must be specified and the IP address is created from the IPCidrRange of the subnetwork.
        If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
        """
        return self._values.get('subnetwork')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionNetwork(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionReadinessCheck", jsii_struct_bases=[], name_mapping={'path': 'path', 'app_start_timeout': 'appStartTimeout', 'check_interval': 'checkInterval', 'failure_threshold': 'failureThreshold', 'host': 'host', 'success_threshold': 'successThreshold', 'timeout': 'timeout'})
class AppEngineFlexibleAppVersionReadinessCheck():
    def __init__(self, *, path: str, app_start_timeout: typing.Optional[str]=None, check_interval: typing.Optional[str]=None, failure_threshold: typing.Optional[jsii.Number]=None, host: typing.Optional[str]=None, success_threshold: typing.Optional[jsii.Number]=None, timeout: typing.Optional[str]=None) -> None:
        """
        :param path: The request path.
        :param app_start_timeout: A maximum time limit on application initialization, measured from moment the application successfully replies to a healthcheck until it is ready to serve traffic. Default: "300s"
        :param check_interval: Interval between health checks. Default: "5s".
        :param failure_threshold: Number of consecutive failed checks required before removing traffic. Default: 2.
        :param host: Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        :param success_threshold: Number of consecutive successful checks required before receiving traffic. Default: 2.
        :param timeout: Time before the check is considered failed. Default: "4s"
        """
        self._values = {
            'path': path,
        }
        if app_start_timeout is not None: self._values["app_start_timeout"] = app_start_timeout
        if check_interval is not None: self._values["check_interval"] = check_interval
        if failure_threshold is not None: self._values["failure_threshold"] = failure_threshold
        if host is not None: self._values["host"] = host
        if success_threshold is not None: self._values["success_threshold"] = success_threshold
        if timeout is not None: self._values["timeout"] = timeout

    @builtins.property
    def path(self) -> str:
        """The request path."""
        return self._values.get('path')

    @builtins.property
    def app_start_timeout(self) -> typing.Optional[str]:
        """A maximum time limit on application initialization, measured from moment the application successfully replies to a healthcheck until it is ready to serve traffic.

        Default: "300s"
        """
        return self._values.get('app_start_timeout')

    @builtins.property
    def check_interval(self) -> typing.Optional[str]:
        """Interval between health checks.

        Default: "5s".
        """
        return self._values.get('check_interval')

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        """Number of consecutive failed checks required before removing traffic.

        Default: 2.
        """
        return self._values.get('failure_threshold')

    @builtins.property
    def host(self) -> typing.Optional[str]:
        """Host header to send when performing a HTTP Readiness check.

        Example: "myapp.appspot.com"
        """
        return self._values.get('host')

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        """Number of consecutive successful checks required before receiving traffic.

        Default: 2.
        """
        return self._values.get('success_threshold')

    @builtins.property
    def timeout(self) -> typing.Optional[str]:
        """Time before the check is considered failed.

        Default: "4s"
        """
        return self._values.get('timeout')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionReadinessCheck(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionResources", jsii_struct_bases=[], name_mapping={'cpu': 'cpu', 'disk_gb': 'diskGb', 'memory_gb': 'memoryGb', 'volumes': 'volumes'})
class AppEngineFlexibleAppVersionResources():
    def __init__(self, *, cpu: typing.Optional[jsii.Number]=None, disk_gb: typing.Optional[jsii.Number]=None, memory_gb: typing.Optional[jsii.Number]=None, volumes: typing.Optional[typing.List["AppEngineFlexibleAppVersionResourcesVolumes"]]=None) -> None:
        """
        :param cpu: Number of CPU cores needed.
        :param disk_gb: Disk size (GB) needed.
        :param memory_gb: Memory (GB) needed.
        :param volumes: volumes block.
        """
        self._values = {
        }
        if cpu is not None: self._values["cpu"] = cpu
        if disk_gb is not None: self._values["disk_gb"] = disk_gb
        if memory_gb is not None: self._values["memory_gb"] = memory_gb
        if volumes is not None: self._values["volumes"] = volumes

    @builtins.property
    def cpu(self) -> typing.Optional[jsii.Number]:
        """Number of CPU cores needed."""
        return self._values.get('cpu')

    @builtins.property
    def disk_gb(self) -> typing.Optional[jsii.Number]:
        """Disk size (GB) needed."""
        return self._values.get('disk_gb')

    @builtins.property
    def memory_gb(self) -> typing.Optional[jsii.Number]:
        """Memory (GB) needed."""
        return self._values.get('memory_gb')

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List["AppEngineFlexibleAppVersionResourcesVolumes"]]:
        """volumes block."""
        return self._values.get('volumes')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionResources(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionResourcesVolumes", jsii_struct_bases=[], name_mapping={'name': 'name', 'size_gb': 'sizeGb', 'volume_type': 'volumeType'})
class AppEngineFlexibleAppVersionResourcesVolumes():
    def __init__(self, *, name: str, size_gb: jsii.Number, volume_type: str) -> None:
        """
        :param name: Unique name for the volume.
        :param size_gb: Volume size in gigabytes.
        :param volume_type: Underlying volume type, e.g. 'tmpfs'.
        """
        self._values = {
            'name': name,
            'size_gb': size_gb,
            'volume_type': volume_type,
        }

    @builtins.property
    def name(self) -> str:
        """Unique name for the volume."""
        return self._values.get('name')

    @builtins.property
    def size_gb(self) -> jsii.Number:
        """Volume size in gigabytes."""
        return self._values.get('size_gb')

    @builtins.property
    def volume_type(self) -> str:
        """Underlying volume type, e.g. 'tmpfs'."""
        return self._values.get('volume_type')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionResourcesVolumes(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class AppEngineFlexibleAppVersionTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineFlexibleAppVersionVpcAccessConnector", jsii_struct_bases=[], name_mapping={'name': 'name'})
class AppEngineFlexibleAppVersionVpcAccessConnector():
    def __init__(self, *, name: str) -> None:
        """
        :param name: Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        self._values = {
            'name': name,
        }

    @builtins.property
    def name(self) -> str:
        """Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1."""
        return self._values.get('name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineFlexibleAppVersionVpcAccessConnector(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AppEngineServiceSplitTraffic(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AppEngineServiceSplitTraffic"):
    def __init__(self, scope: constructs.Construct, id: str, *, service: str, split: typing.List["AppEngineServiceSplitTrafficSplit"], migrate_traffic: typing.Optional[bool]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineServiceSplitTrafficTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param service: The name of the service these settings apply to.
        :param split: split block.
        :param migrate_traffic: If set to true traffic will be migrated to this version.
        :param project: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppEngineServiceSplitTrafficConfig(service=service, split=split, migrate_traffic=migrate_traffic, project=project, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AppEngineServiceSplitTraffic, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> str:
        return jsii.get(self, "service")

    @service.setter
    def service(self, value: str) -> None:
        jsii.set(self, "service", value)

    @builtins.property
    @jsii.member(jsii_name="split")
    def split(self) -> typing.List["AppEngineServiceSplitTrafficSplit"]:
        return jsii.get(self, "split")

    @split.setter
    def split(self, value: typing.List["AppEngineServiceSplitTrafficSplit"]) -> None:
        jsii.set(self, "split", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="migrateTraffic")
    def migrate_traffic(self) -> typing.Optional[bool]:
        return jsii.get(self, "migrateTraffic")

    @migrate_traffic.setter
    def migrate_traffic(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "migrateTraffic", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AppEngineServiceSplitTrafficTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AppEngineServiceSplitTrafficTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineServiceSplitTrafficConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'service': 'service', 'split': 'split', 'migrate_traffic': 'migrateTraffic', 'project': 'project', 'timeouts': 'timeouts'})
class AppEngineServiceSplitTrafficConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, service: str, split: typing.List["AppEngineServiceSplitTrafficSplit"], migrate_traffic: typing.Optional[bool]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["AppEngineServiceSplitTrafficTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param service: The name of the service these settings apply to.
        :param split: split block.
        :param migrate_traffic: If set to true traffic will be migrated to this version.
        :param project: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AppEngineServiceSplitTrafficTimeouts(**timeouts)
        self._values = {
            'service': service,
            'split': split,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if migrate_traffic is not None: self._values["migrate_traffic"] = migrate_traffic
        if project is not None: self._values["project"] = project
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def service(self) -> str:
        """The name of the service these settings apply to."""
        return self._values.get('service')

    @builtins.property
    def split(self) -> typing.List["AppEngineServiceSplitTrafficSplit"]:
        """split block."""
        return self._values.get('split')

    @builtins.property
    def migrate_traffic(self) -> typing.Optional[bool]:
        """If set to true traffic will be migrated to this version."""
        return self._values.get('migrate_traffic')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def timeouts(self) -> typing.Optional["AppEngineServiceSplitTrafficTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineServiceSplitTrafficConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineServiceSplitTrafficSplit", jsii_struct_bases=[], name_mapping={'allocations': 'allocations', 'shard_by': 'shardBy'})
class AppEngineServiceSplitTrafficSplit():
    def __init__(self, *, allocations: typing.Mapping[str, str], shard_by: typing.Optional[str]=None) -> None:
        """
        :param allocations: Mapping from version IDs within the service to fractional (0.000, 1] allocations of traffic for that version. Each version can be specified only once, but some versions in the service may not have any traffic allocation. Services that have traffic allocated cannot be deleted until either the service is deleted or their traffic allocation is removed. Allocations must sum to 1. Up to two decimal place precision is supported for IP-based splits and up to three decimal places is supported for cookie-based splits.
        :param shard_by: Mechanism used to determine which version a request is sent to. The traffic selection algorithm will be stable for either type until allocations are changed. Possible values: ["UNSPECIFIED", "COOKIE", "IP", "RANDOM"]
        """
        self._values = {
            'allocations': allocations,
        }
        if shard_by is not None: self._values["shard_by"] = shard_by

    @builtins.property
    def allocations(self) -> typing.Mapping[str, str]:
        """Mapping from version IDs within the service to fractional (0.000, 1] allocations of traffic for that version. Each version can be specified only once, but some versions in the service may not have any traffic allocation. Services that have traffic allocated cannot be deleted until either the service is deleted or their traffic allocation is removed. Allocations must sum to 1. Up to two decimal place precision is supported for IP-based splits and up to three decimal places is supported for cookie-based splits."""
        return self._values.get('allocations')

    @builtins.property
    def shard_by(self) -> typing.Optional[str]:
        """Mechanism used to determine which version a request is sent to.

        The traffic selection algorithm will be stable for either type until allocations are changed. Possible values: ["UNSPECIFIED", "COOKIE", "IP", "RANDOM"]
        """
        return self._values.get('shard_by')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineServiceSplitTrafficSplit(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineServiceSplitTrafficTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class AppEngineServiceSplitTrafficTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineServiceSplitTrafficTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class AppEngineStandardAppVersion(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.AppEngineStandardAppVersion"):
    def __init__(self, scope: constructs.Construct, id: str, *, deployment: typing.List["AppEngineStandardAppVersionDeployment"], runtime: str, service: str, automatic_scaling: typing.Optional[typing.List["AppEngineStandardAppVersionAutomaticScaling"]]=None, basic_scaling: typing.Optional[typing.List["AppEngineStandardAppVersionBasicScaling"]]=None, delete_service_on_destroy: typing.Optional[bool]=None, entrypoint: typing.Optional[typing.List["AppEngineStandardAppVersionEntrypoint"]]=None, env_variables: typing.Optional[typing.Mapping[str, str]]=None, handlers: typing.Optional[typing.List["AppEngineStandardAppVersionHandlers"]]=None, inbound_services: typing.Optional[typing.List[str]]=None, instance_class: typing.Optional[str]=None, libraries: typing.Optional[typing.List["AppEngineStandardAppVersionLibraries"]]=None, manual_scaling: typing.Optional[typing.List["AppEngineStandardAppVersionManualScaling"]]=None, noop_on_destroy: typing.Optional[bool]=None, project: typing.Optional[str]=None, runtime_api_version: typing.Optional[str]=None, threadsafe: typing.Optional[bool]=None, timeouts: typing.Optional["AppEngineStandardAppVersionTimeouts"]=None, version_id: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param deployment: deployment block.
        :param runtime: Desired runtime. Example python27.
        :param service: AppEngine service resource.
        :param automatic_scaling: automatic_scaling block.
        :param basic_scaling: basic_scaling block.
        :param delete_service_on_destroy: 
        :param entrypoint: entrypoint block.
        :param env_variables: Environment variables available to the application.
        :param handlers: handlers block.
        :param inbound_services: A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
        :param instance_class: Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G BasicScaling or ManualScaling: B1, B2, B4, B4_1G, B8 Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If no scaling is specified, AutomaticScaling is chosen.
        :param libraries: libraries block.
        :param manual_scaling: manual_scaling block.
        :param noop_on_destroy: 
        :param project: 
        :param runtime_api_version: The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref
        :param threadsafe: Whether multiple requests can be dispatched to this version at once.
        :param timeouts: timeouts block.
        :param version_id: Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppEngineStandardAppVersionConfig(deployment=deployment, runtime=runtime, service=service, automatic_scaling=automatic_scaling, basic_scaling=basic_scaling, delete_service_on_destroy=delete_service_on_destroy, entrypoint=entrypoint, env_variables=env_variables, handlers=handlers, inbound_services=inbound_services, instance_class=instance_class, libraries=libraries, manual_scaling=manual_scaling, noop_on_destroy=noop_on_destroy, project=project, runtime_api_version=runtime_api_version, threadsafe=threadsafe, timeouts=timeouts, version_id=version_id, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(AppEngineStandardAppVersion, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="deployment")
    def deployment(self) -> typing.List["AppEngineStandardAppVersionDeployment"]:
        return jsii.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: typing.List["AppEngineStandardAppVersionDeployment"]) -> None:
        jsii.set(self, "deployment", value)

    @builtins.property
    @jsii.member(jsii_name="runtime")
    def runtime(self) -> str:
        return jsii.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: str) -> None:
        jsii.set(self, "runtime", value)

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> str:
        return jsii.get(self, "service")

    @service.setter
    def service(self, value: str) -> None:
        jsii.set(self, "service", value)

    @builtins.property
    @jsii.member(jsii_name="automaticScaling")
    def automatic_scaling(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionAutomaticScaling"]]:
        return jsii.get(self, "automaticScaling")

    @automatic_scaling.setter
    def automatic_scaling(self, value: typing.Optional[typing.List["AppEngineStandardAppVersionAutomaticScaling"]]) -> None:
        jsii.set(self, "automaticScaling", value)

    @builtins.property
    @jsii.member(jsii_name="basicScaling")
    def basic_scaling(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionBasicScaling"]]:
        return jsii.get(self, "basicScaling")

    @basic_scaling.setter
    def basic_scaling(self, value: typing.Optional[typing.List["AppEngineStandardAppVersionBasicScaling"]]) -> None:
        jsii.set(self, "basicScaling", value)

    @builtins.property
    @jsii.member(jsii_name="deleteServiceOnDestroy")
    def delete_service_on_destroy(self) -> typing.Optional[bool]:
        return jsii.get(self, "deleteServiceOnDestroy")

    @delete_service_on_destroy.setter
    def delete_service_on_destroy(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "deleteServiceOnDestroy", value)

    @builtins.property
    @jsii.member(jsii_name="entrypoint")
    def entrypoint(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionEntrypoint"]]:
        return jsii.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: typing.Optional[typing.List["AppEngineStandardAppVersionEntrypoint"]]) -> None:
        jsii.set(self, "entrypoint", value)

    @builtins.property
    @jsii.member(jsii_name="envVariables")
    def env_variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "envVariables")

    @env_variables.setter
    def env_variables(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "envVariables", value)

    @builtins.property
    @jsii.member(jsii_name="handlers")
    def handlers(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionHandlers"]]:
        return jsii.get(self, "handlers")

    @handlers.setter
    def handlers(self, value: typing.Optional[typing.List["AppEngineStandardAppVersionHandlers"]]) -> None:
        jsii.set(self, "handlers", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="inboundServices")
    def inbound_services(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "inboundServices")

    @inbound_services.setter
    def inbound_services(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "inboundServices", value)

    @builtins.property
    @jsii.member(jsii_name="instanceClass")
    def instance_class(self) -> typing.Optional[str]:
        return jsii.get(self, "instanceClass")

    @instance_class.setter
    def instance_class(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "instanceClass", value)

    @builtins.property
    @jsii.member(jsii_name="libraries")
    def libraries(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionLibraries"]]:
        return jsii.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: typing.Optional[typing.List["AppEngineStandardAppVersionLibraries"]]) -> None:
        jsii.set(self, "libraries", value)

    @builtins.property
    @jsii.member(jsii_name="manualScaling")
    def manual_scaling(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionManualScaling"]]:
        return jsii.get(self, "manualScaling")

    @manual_scaling.setter
    def manual_scaling(self, value: typing.Optional[typing.List["AppEngineStandardAppVersionManualScaling"]]) -> None:
        jsii.set(self, "manualScaling", value)

    @builtins.property
    @jsii.member(jsii_name="noopOnDestroy")
    def noop_on_destroy(self) -> typing.Optional[bool]:
        return jsii.get(self, "noopOnDestroy")

    @noop_on_destroy.setter
    def noop_on_destroy(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "noopOnDestroy", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="runtimeApiVersion")
    def runtime_api_version(self) -> typing.Optional[str]:
        return jsii.get(self, "runtimeApiVersion")

    @runtime_api_version.setter
    def runtime_api_version(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "runtimeApiVersion", value)

    @builtins.property
    @jsii.member(jsii_name="threadsafe")
    def threadsafe(self) -> typing.Optional[bool]:
        return jsii.get(self, "threadsafe")

    @threadsafe.setter
    def threadsafe(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "threadsafe", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AppEngineStandardAppVersionTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AppEngineStandardAppVersionTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="versionId")
    def version_id(self) -> typing.Optional[str]:
        return jsii.get(self, "versionId")

    @version_id.setter
    def version_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "versionId", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionAutomaticScaling", jsii_struct_bases=[], name_mapping={'max_concurrent_requests': 'maxConcurrentRequests', 'max_idle_instances': 'maxIdleInstances', 'max_pending_latency': 'maxPendingLatency', 'min_idle_instances': 'minIdleInstances', 'min_pending_latency': 'minPendingLatency', 'standard_scheduler_settings': 'standardSchedulerSettings'})
class AppEngineStandardAppVersionAutomaticScaling():
    def __init__(self, *, max_concurrent_requests: typing.Optional[jsii.Number]=None, max_idle_instances: typing.Optional[jsii.Number]=None, max_pending_latency: typing.Optional[str]=None, min_idle_instances: typing.Optional[jsii.Number]=None, min_pending_latency: typing.Optional[str]=None, standard_scheduler_settings: typing.Optional[typing.List["AppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings"]]=None) -> None:
        """
        :param max_concurrent_requests: Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance. Defaults to a runtime-specific value.
        :param max_idle_instances: Maximum number of idle instances that should be maintained for this version.
        :param max_pending_latency: Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param min_idle_instances: Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        :param min_pending_latency: Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param standard_scheduler_settings: standard_scheduler_settings block.
        """
        self._values = {
        }
        if max_concurrent_requests is not None: self._values["max_concurrent_requests"] = max_concurrent_requests
        if max_idle_instances is not None: self._values["max_idle_instances"] = max_idle_instances
        if max_pending_latency is not None: self._values["max_pending_latency"] = max_pending_latency
        if min_idle_instances is not None: self._values["min_idle_instances"] = min_idle_instances
        if min_pending_latency is not None: self._values["min_pending_latency"] = min_pending_latency
        if standard_scheduler_settings is not None: self._values["standard_scheduler_settings"] = standard_scheduler_settings

    @builtins.property
    def max_concurrent_requests(self) -> typing.Optional[jsii.Number]:
        """Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.

        Defaults to a runtime-specific value.
        """
        return self._values.get('max_concurrent_requests')

    @builtins.property
    def max_idle_instances(self) -> typing.Optional[jsii.Number]:
        """Maximum number of idle instances that should be maintained for this version."""
        return self._values.get('max_idle_instances')

    @builtins.property
    def max_pending_latency(self) -> typing.Optional[str]:
        """Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.

        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return self._values.get('max_pending_latency')

    @builtins.property
    def min_idle_instances(self) -> typing.Optional[jsii.Number]:
        """Minimum number of idle instances that should be maintained for this version.

        Only applicable for the default version of a service.
        """
        return self._values.get('min_idle_instances')

    @builtins.property
    def min_pending_latency(self) -> typing.Optional[str]:
        """Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.

        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return self._values.get('min_pending_latency')

    @builtins.property
    def standard_scheduler_settings(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings"]]:
        """standard_scheduler_settings block."""
        return self._values.get('standard_scheduler_settings')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionAutomaticScaling(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings", jsii_struct_bases=[], name_mapping={'max_instances': 'maxInstances', 'min_instances': 'minInstances', 'target_cpu_utilization': 'targetCpuUtilization', 'target_throughput_utilization': 'targetThroughputUtilization'})
class AppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings():
    def __init__(self, *, max_instances: typing.Optional[jsii.Number]=None, min_instances: typing.Optional[jsii.Number]=None, target_cpu_utilization: typing.Optional[jsii.Number]=None, target_throughput_utilization: typing.Optional[jsii.Number]=None) -> None:
        """
        :param max_instances: Maximum number of instances to run for this version. Set to zero to disable maxInstances configuration.
        :param min_instances: Minimum number of instances to run for this version. Set to zero to disable minInstances configuration.
        :param target_cpu_utilization: Target CPU utilization ratio to maintain when scaling. Should be a value in the range [0.50, 0.95], zero, or a negative value.
        :param target_throughput_utilization: Target throughput utilization ratio to maintain when scaling. Should be a value in the range [0.50, 0.95], zero, or a negative value.
        """
        self._values = {
        }
        if max_instances is not None: self._values["max_instances"] = max_instances
        if min_instances is not None: self._values["min_instances"] = min_instances
        if target_cpu_utilization is not None: self._values["target_cpu_utilization"] = target_cpu_utilization
        if target_throughput_utilization is not None: self._values["target_throughput_utilization"] = target_throughput_utilization

    @builtins.property
    def max_instances(self) -> typing.Optional[jsii.Number]:
        """Maximum number of instances to run for this version.

        Set to zero to disable maxInstances configuration.
        """
        return self._values.get('max_instances')

    @builtins.property
    def min_instances(self) -> typing.Optional[jsii.Number]:
        """Minimum number of instances to run for this version.

        Set to zero to disable minInstances configuration.
        """
        return self._values.get('min_instances')

    @builtins.property
    def target_cpu_utilization(self) -> typing.Optional[jsii.Number]:
        """Target CPU utilization ratio to maintain when scaling.

        Should be a value in the range [0.50, 0.95], zero, or a negative value.
        """
        return self._values.get('target_cpu_utilization')

    @builtins.property
    def target_throughput_utilization(self) -> typing.Optional[jsii.Number]:
        """Target throughput utilization ratio to maintain when scaling.

        Should be a value in the range [0.50, 0.95], zero, or a negative value.
        """
        return self._values.get('target_throughput_utilization')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionBasicScaling", jsii_struct_bases=[], name_mapping={'max_instances': 'maxInstances', 'idle_timeout': 'idleTimeout'})
class AppEngineStandardAppVersionBasicScaling():
    def __init__(self, *, max_instances: jsii.Number, idle_timeout: typing.Optional[str]=None) -> None:
        """
        :param max_instances: Maximum number of instances to create for this version. Must be in the range [1.0, 200.0].
        :param idle_timeout: Duration of time after the last request that an instance must wait before the instance is shut down. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
        """
        self._values = {
            'max_instances': max_instances,
        }
        if idle_timeout is not None: self._values["idle_timeout"] = idle_timeout

    @builtins.property
    def max_instances(self) -> jsii.Number:
        """Maximum number of instances to create for this version.

        Must be in the range [1.0, 200.0].
        """
        return self._values.get('max_instances')

    @builtins.property
    def idle_timeout(self) -> typing.Optional[str]:
        """Duration of time after the last request that an instance must wait before the instance is shut down.

        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
        """
        return self._values.get('idle_timeout')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionBasicScaling(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'deployment': 'deployment', 'runtime': 'runtime', 'service': 'service', 'automatic_scaling': 'automaticScaling', 'basic_scaling': 'basicScaling', 'delete_service_on_destroy': 'deleteServiceOnDestroy', 'entrypoint': 'entrypoint', 'env_variables': 'envVariables', 'handlers': 'handlers', 'inbound_services': 'inboundServices', 'instance_class': 'instanceClass', 'libraries': 'libraries', 'manual_scaling': 'manualScaling', 'noop_on_destroy': 'noopOnDestroy', 'project': 'project', 'runtime_api_version': 'runtimeApiVersion', 'threadsafe': 'threadsafe', 'timeouts': 'timeouts', 'version_id': 'versionId'})
class AppEngineStandardAppVersionConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, deployment: typing.List["AppEngineStandardAppVersionDeployment"], runtime: str, service: str, automatic_scaling: typing.Optional[typing.List["AppEngineStandardAppVersionAutomaticScaling"]]=None, basic_scaling: typing.Optional[typing.List["AppEngineStandardAppVersionBasicScaling"]]=None, delete_service_on_destroy: typing.Optional[bool]=None, entrypoint: typing.Optional[typing.List["AppEngineStandardAppVersionEntrypoint"]]=None, env_variables: typing.Optional[typing.Mapping[str, str]]=None, handlers: typing.Optional[typing.List["AppEngineStandardAppVersionHandlers"]]=None, inbound_services: typing.Optional[typing.List[str]]=None, instance_class: typing.Optional[str]=None, libraries: typing.Optional[typing.List["AppEngineStandardAppVersionLibraries"]]=None, manual_scaling: typing.Optional[typing.List["AppEngineStandardAppVersionManualScaling"]]=None, noop_on_destroy: typing.Optional[bool]=None, project: typing.Optional[str]=None, runtime_api_version: typing.Optional[str]=None, threadsafe: typing.Optional[bool]=None, timeouts: typing.Optional["AppEngineStandardAppVersionTimeouts"]=None, version_id: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param deployment: deployment block.
        :param runtime: Desired runtime. Example python27.
        :param service: AppEngine service resource.
        :param automatic_scaling: automatic_scaling block.
        :param basic_scaling: basic_scaling block.
        :param delete_service_on_destroy: 
        :param entrypoint: entrypoint block.
        :param env_variables: Environment variables available to the application.
        :param handlers: handlers block.
        :param inbound_services: A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
        :param instance_class: Instance class that is used to run this version. Valid values are AutomaticScaling: F1, F2, F4, F4_1G BasicScaling or ManualScaling: B1, B2, B4, B4_1G, B8 Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If no scaling is specified, AutomaticScaling is chosen.
        :param libraries: libraries block.
        :param manual_scaling: manual_scaling block.
        :param noop_on_destroy: 
        :param project: 
        :param runtime_api_version: The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref
        :param threadsafe: Whether multiple requests can be dispatched to this version at once.
        :param timeouts: timeouts block.
        :param version_id: Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = AppEngineStandardAppVersionTimeouts(**timeouts)
        self._values = {
            'deployment': deployment,
            'runtime': runtime,
            'service': service,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if automatic_scaling is not None: self._values["automatic_scaling"] = automatic_scaling
        if basic_scaling is not None: self._values["basic_scaling"] = basic_scaling
        if delete_service_on_destroy is not None: self._values["delete_service_on_destroy"] = delete_service_on_destroy
        if entrypoint is not None: self._values["entrypoint"] = entrypoint
        if env_variables is not None: self._values["env_variables"] = env_variables
        if handlers is not None: self._values["handlers"] = handlers
        if inbound_services is not None: self._values["inbound_services"] = inbound_services
        if instance_class is not None: self._values["instance_class"] = instance_class
        if libraries is not None: self._values["libraries"] = libraries
        if manual_scaling is not None: self._values["manual_scaling"] = manual_scaling
        if noop_on_destroy is not None: self._values["noop_on_destroy"] = noop_on_destroy
        if project is not None: self._values["project"] = project
        if runtime_api_version is not None: self._values["runtime_api_version"] = runtime_api_version
        if threadsafe is not None: self._values["threadsafe"] = threadsafe
        if timeouts is not None: self._values["timeouts"] = timeouts
        if version_id is not None: self._values["version_id"] = version_id

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def deployment(self) -> typing.List["AppEngineStandardAppVersionDeployment"]:
        """deployment block."""
        return self._values.get('deployment')

    @builtins.property
    def runtime(self) -> str:
        """Desired runtime.

        Example python27.
        """
        return self._values.get('runtime')

    @builtins.property
    def service(self) -> str:
        """AppEngine service resource."""
        return self._values.get('service')

    @builtins.property
    def automatic_scaling(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionAutomaticScaling"]]:
        """automatic_scaling block."""
        return self._values.get('automatic_scaling')

    @builtins.property
    def basic_scaling(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionBasicScaling"]]:
        """basic_scaling block."""
        return self._values.get('basic_scaling')

    @builtins.property
    def delete_service_on_destroy(self) -> typing.Optional[bool]:
        return self._values.get('delete_service_on_destroy')

    @builtins.property
    def entrypoint(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionEntrypoint"]]:
        """entrypoint block."""
        return self._values.get('entrypoint')

    @builtins.property
    def env_variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Environment variables available to the application."""
        return self._values.get('env_variables')

    @builtins.property
    def handlers(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionHandlers"]]:
        """handlers block."""
        return self._values.get('handlers')

    @builtins.property
    def inbound_services(self) -> typing.Optional[typing.List[str]]:
        """A list of the types of messages that this application is able to receive.

        Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
        """
        return self._values.get('inbound_services')

    @builtins.property
    def instance_class(self) -> typing.Optional[str]:
        """Instance class that is used to run this version.

        Valid values are
        AutomaticScaling: F1, F2, F4, F4_1G
        BasicScaling or ManualScaling: B1, B2, B4, B4_1G, B8
        Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If no scaling is specified, AutomaticScaling is chosen.
        """
        return self._values.get('instance_class')

    @builtins.property
    def libraries(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionLibraries"]]:
        """libraries block."""
        return self._values.get('libraries')

    @builtins.property
    def manual_scaling(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionManualScaling"]]:
        """manual_scaling block."""
        return self._values.get('manual_scaling')

    @builtins.property
    def noop_on_destroy(self) -> typing.Optional[bool]:
        return self._values.get('noop_on_destroy')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def runtime_api_version(self) -> typing.Optional[str]:
        """The version of the API in the given runtime environment.

        Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref
        """
        return self._values.get('runtime_api_version')

    @builtins.property
    def threadsafe(self) -> typing.Optional[bool]:
        """Whether multiple requests can be dispatched to this version at once."""
        return self._values.get('threadsafe')

    @builtins.property
    def timeouts(self) -> typing.Optional["AppEngineStandardAppVersionTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    @builtins.property
    def version_id(self) -> typing.Optional[str]:
        """Relative name of the version within the service.

        For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
        """
        return self._values.get('version_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionDeployment", jsii_struct_bases=[], name_mapping={'files': 'files', 'zip': 'zip'})
class AppEngineStandardAppVersionDeployment():
    def __init__(self, *, files: typing.Optional[typing.List["AppEngineStandardAppVersionDeploymentFiles"]]=None, zip: typing.Optional[typing.List["AppEngineStandardAppVersionDeploymentZip"]]=None) -> None:
        """
        :param files: files block.
        :param zip: zip block.
        """
        self._values = {
        }
        if files is not None: self._values["files"] = files
        if zip is not None: self._values["zip"] = zip

    @builtins.property
    def files(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionDeploymentFiles"]]:
        """files block."""
        return self._values.get('files')

    @builtins.property
    def zip(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionDeploymentZip"]]:
        """zip block."""
        return self._values.get('zip')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionDeployment(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionDeploymentFiles", jsii_struct_bases=[], name_mapping={'name': 'name', 'source_url': 'sourceUrl', 'sha1_sum': 'sha1Sum'})
class AppEngineStandardAppVersionDeploymentFiles():
    def __init__(self, *, name: str, source_url: str, sha1_sum: typing.Optional[str]=None) -> None:
        """
        :param name: 
        :param source_url: Source URL.
        :param sha1_sum: SHA1 checksum of the file.
        """
        self._values = {
            'name': name,
            'source_url': source_url,
        }
        if sha1_sum is not None: self._values["sha1_sum"] = sha1_sum

    @builtins.property
    def name(self) -> str:
        return self._values.get('name')

    @builtins.property
    def source_url(self) -> str:
        """Source URL."""
        return self._values.get('source_url')

    @builtins.property
    def sha1_sum(self) -> typing.Optional[str]:
        """SHA1 checksum of the file."""
        return self._values.get('sha1_sum')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionDeploymentFiles(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionDeploymentZip", jsii_struct_bases=[], name_mapping={'source_url': 'sourceUrl', 'files_count': 'filesCount'})
class AppEngineStandardAppVersionDeploymentZip():
    def __init__(self, *, source_url: str, files_count: typing.Optional[jsii.Number]=None) -> None:
        """
        :param source_url: Source URL.
        :param files_count: files count.
        """
        self._values = {
            'source_url': source_url,
        }
        if files_count is not None: self._values["files_count"] = files_count

    @builtins.property
    def source_url(self) -> str:
        """Source URL."""
        return self._values.get('source_url')

    @builtins.property
    def files_count(self) -> typing.Optional[jsii.Number]:
        """files count."""
        return self._values.get('files_count')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionDeploymentZip(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionEntrypoint", jsii_struct_bases=[], name_mapping={'shell': 'shell'})
class AppEngineStandardAppVersionEntrypoint():
    def __init__(self, *, shell: str) -> None:
        """
        :param shell: The format should be a shell command that can be fed to bash -c.
        """
        self._values = {
            'shell': shell,
        }

    @builtins.property
    def shell(self) -> str:
        """The format should be a shell command that can be fed to bash -c."""
        return self._values.get('shell')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionEntrypoint(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionHandlers", jsii_struct_bases=[], name_mapping={'auth_fail_action': 'authFailAction', 'login': 'login', 'redirect_http_response_code': 'redirectHttpResponseCode', 'script': 'script', 'security_level': 'securityLevel', 'static_files': 'staticFiles', 'url_regex': 'urlRegex'})
class AppEngineStandardAppVersionHandlers():
    def __init__(self, *, auth_fail_action: typing.Optional[str]=None, login: typing.Optional[str]=None, redirect_http_response_code: typing.Optional[str]=None, script: typing.Optional[typing.List["AppEngineStandardAppVersionHandlersScript"]]=None, security_level: typing.Optional[str]=None, static_files: typing.Optional[typing.List["AppEngineStandardAppVersionHandlersStaticFiles"]]=None, url_regex: typing.Optional[str]=None) -> None:
        """
        :param auth_fail_action: Actions to take when the user is not logged in. Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
        :param login: Methods to restrict access to a URL based on login status. Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
        :param redirect_http_response_code: 30x code to use when performing redirects for the secure field. Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"]
        :param script: script block.
        :param security_level: Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
        :param static_files: static_files block.
        :param url_regex: URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings. All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        self._values = {
        }
        if auth_fail_action is not None: self._values["auth_fail_action"] = auth_fail_action
        if login is not None: self._values["login"] = login
        if redirect_http_response_code is not None: self._values["redirect_http_response_code"] = redirect_http_response_code
        if script is not None: self._values["script"] = script
        if security_level is not None: self._values["security_level"] = security_level
        if static_files is not None: self._values["static_files"] = static_files
        if url_regex is not None: self._values["url_regex"] = url_regex

    @builtins.property
    def auth_fail_action(self) -> typing.Optional[str]:
        """Actions to take when the user is not logged in.

        Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
        """
        return self._values.get('auth_fail_action')

    @builtins.property
    def login(self) -> typing.Optional[str]:
        """Methods to restrict access to a URL based on login status.

        Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
        """
        return self._values.get('login')

    @builtins.property
    def redirect_http_response_code(self) -> typing.Optional[str]:
        """30x code to use when performing redirects for the secure field.

        Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"]
        """
        return self._values.get('redirect_http_response_code')

    @builtins.property
    def script(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionHandlersScript"]]:
        """script block."""
        return self._values.get('script')

    @builtins.property
    def security_level(self) -> typing.Optional[str]:
        """Security (HTTPS) enforcement for this URL.

        Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
        """
        return self._values.get('security_level')

    @builtins.property
    def static_files(self) -> typing.Optional[typing.List["AppEngineStandardAppVersionHandlersStaticFiles"]]:
        """static_files block."""
        return self._values.get('static_files')

    @builtins.property
    def url_regex(self) -> typing.Optional[str]:
        """URL prefix.

        Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
        All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        return self._values.get('url_regex')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionHandlers(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionHandlersScript", jsii_struct_bases=[], name_mapping={'script_path': 'scriptPath'})
class AppEngineStandardAppVersionHandlersScript():
    def __init__(self, *, script_path: str) -> None:
        """
        :param script_path: Path to the script from the application root directory.
        """
        self._values = {
            'script_path': script_path,
        }

    @builtins.property
    def script_path(self) -> str:
        """Path to the script from the application root directory."""
        return self._values.get('script_path')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionHandlersScript(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionHandlersStaticFiles", jsii_struct_bases=[], name_mapping={'application_readable': 'applicationReadable', 'expiration': 'expiration', 'http_headers': 'httpHeaders', 'mime_type': 'mimeType', 'path': 'path', 'require_matching_file': 'requireMatchingFile', 'upload_path_regex': 'uploadPathRegex'})
class AppEngineStandardAppVersionHandlersStaticFiles():
    def __init__(self, *, application_readable: typing.Optional[bool]=None, expiration: typing.Optional[str]=None, http_headers: typing.Optional[typing.Mapping[str, str]]=None, mime_type: typing.Optional[str]=None, path: typing.Optional[str]=None, require_matching_file: typing.Optional[bool]=None, upload_path_regex: typing.Optional[str]=None) -> None:
        """
        :param application_readable: Whether files should also be uploaded as code data. By default, files declared in static file handlers are uploaded as static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged against both your code and static data storage resource quotas.
        :param expiration: Time a static file served by this handler should be cached by web proxies and browsers. A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
        :param http_headers: HTTP headers to use for all responses from these URLs. An object containing a list of "key:value" value pairs.".
        :param mime_type: MIME type used to serve all files served by this handler. Defaults to file-specific MIME types, which are derived from each file's filename extension.
        :param path: Path to the static files matched by the URL pattern, from the application root directory. The path can refer to text matched in groupings in the URL pattern.
        :param require_matching_file: Whether this handler should match the request if the file referenced by the handler does not exist.
        :param upload_path_regex: Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        self._values = {
        }
        if application_readable is not None: self._values["application_readable"] = application_readable
        if expiration is not None: self._values["expiration"] = expiration
        if http_headers is not None: self._values["http_headers"] = http_headers
        if mime_type is not None: self._values["mime_type"] = mime_type
        if path is not None: self._values["path"] = path
        if require_matching_file is not None: self._values["require_matching_file"] = require_matching_file
        if upload_path_regex is not None: self._values["upload_path_regex"] = upload_path_regex

    @builtins.property
    def application_readable(self) -> typing.Optional[bool]:
        """Whether files should also be uploaded as code data.

        By default, files declared in static file handlers are uploaded as
        static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged
        against both your code and static data storage resource quotas.
        """
        return self._values.get('application_readable')

    @builtins.property
    def expiration(self) -> typing.Optional[str]:
        """Time a static file served by this handler should be cached by web proxies and browsers.

        A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
        """
        return self._values.get('expiration')

    @builtins.property
    def http_headers(self) -> typing.Optional[typing.Mapping[str, str]]:
        """HTTP headers to use for all responses from these URLs.

        An object containing a list of "key:value" value pairs.".
        """
        return self._values.get('http_headers')

    @builtins.property
    def mime_type(self) -> typing.Optional[str]:
        """MIME type used to serve all files served by this handler.

        Defaults to file-specific MIME types, which are derived from each file's filename extension.
        """
        return self._values.get('mime_type')

    @builtins.property
    def path(self) -> typing.Optional[str]:
        """Path to the static files matched by the URL pattern, from the application root directory.

        The path can refer to text matched in groupings in the URL pattern.
        """
        return self._values.get('path')

    @builtins.property
    def require_matching_file(self) -> typing.Optional[bool]:
        """Whether this handler should match the request if the file referenced by the handler does not exist."""
        return self._values.get('require_matching_file')

    @builtins.property
    def upload_path_regex(self) -> typing.Optional[str]:
        """Regular expression that matches the file paths for all files that should be referenced by this handler."""
        return self._values.get('upload_path_regex')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionHandlersStaticFiles(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionLibraries", jsii_struct_bases=[], name_mapping={'name': 'name', 'version': 'version'})
class AppEngineStandardAppVersionLibraries():
    def __init__(self, *, name: typing.Optional[str]=None, version: typing.Optional[str]=None) -> None:
        """
        :param name: Name of the library. Example "django".
        :param version: Version of the library to select, or "latest".
        """
        self._values = {
        }
        if name is not None: self._values["name"] = name
        if version is not None: self._values["version"] = version

    @builtins.property
    def name(self) -> typing.Optional[str]:
        """Name of the library.

        Example "django".
        """
        return self._values.get('name')

    @builtins.property
    def version(self) -> typing.Optional[str]:
        """Version of the library to select, or "latest"."""
        return self._values.get('version')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionLibraries(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionManualScaling", jsii_struct_bases=[], name_mapping={'instances': 'instances'})
class AppEngineStandardAppVersionManualScaling():
    def __init__(self, *, instances: jsii.Number) -> None:
        """
        :param instances: Number of instances to assign to the service at the start. *Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2 Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
        """
        self._values = {
            'instances': instances,
        }

    @builtins.property
    def instances(self) -> jsii.Number:
        """Number of instances to assign to the service at the start.

        *Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
        Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
        """
        return self._values.get('instances')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionManualScaling(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.AppEngineStandardAppVersionTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class AppEngineStandardAppVersionTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'AppEngineStandardAppVersionTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigqueryDataTransferConfig(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigqueryDataTransferConfig"):
    def __init__(self, scope: constructs.Construct, id: str, *, data_source_id: str, destination_dataset_id: str, display_name: str, params: typing.Mapping[str, str], data_refresh_window_days: typing.Optional[jsii.Number]=None, disabled: typing.Optional[bool]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None, schedule: typing.Optional[str]=None, service_account_name: typing.Optional[str]=None, timeouts: typing.Optional["BigqueryDataTransferConfigTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param data_source_id: The data source id. Cannot be changed once the transfer config is created.
        :param destination_dataset_id: The BigQuery target dataset id.
        :param display_name: The user specified display name for the transfer config.
        :param params: These parameters are specific to each data source.
        :param data_refresh_window_days: The number of days to look back to automatically refresh the data. For example, if dataRefreshWindowDays = 10, then every day BigQuery reingests data for [today-10, today-1], rather than ingesting data for just [today-1]. Only valid if the data source supports the feature. Set the value to 0 to use the default value.
        :param disabled: When set to true, no runs are scheduled for a given transfer.
        :param location: The geographic location where the transfer config should reside. Examples: US, EU, asia-northeast1. The default value is US.
        :param project: 
        :param schedule: Data transfer schedule. If the data source does not support a custom schedule, this should be empty. If it is empty, the default value for the data source will be used. The specified times are in UTC. Examples of valid format: 1st,3rd monday of month 15:30, every wed,fri of jan, jun 13:15, and first sunday of quarter 00:00. See more explanation about the format here: https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format NOTE: the granularity should be at least 8 hours, or less frequent.
        :param service_account_name: Optional service account name. If this field is set, transfer config will be created with this service account credentials. It requires that requesting user calling this API has permissions to act as this service account.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigqueryDataTransferConfigConfig(data_source_id=data_source_id, destination_dataset_id=destination_dataset_id, display_name=display_name, params=params, data_refresh_window_days=data_refresh_window_days, disabled=disabled, location=location, project=project, schedule=schedule, service_account_name=service_account_name, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigqueryDataTransferConfig, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="dataSourceId")
    def data_source_id(self) -> str:
        return jsii.get(self, "dataSourceId")

    @data_source_id.setter
    def data_source_id(self, value: str) -> None:
        jsii.set(self, "dataSourceId", value)

    @builtins.property
    @jsii.member(jsii_name="destinationDatasetId")
    def destination_dataset_id(self) -> str:
        return jsii.get(self, "destinationDatasetId")

    @destination_dataset_id.setter
    def destination_dataset_id(self, value: str) -> None:
        jsii.set(self, "destinationDatasetId", value)

    @builtins.property
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> str:
        return jsii.get(self, "displayName")

    @display_name.setter
    def display_name(self, value: str) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property
    @jsii.member(jsii_name="params")
    def params(self) -> typing.Mapping[str, str]:
        return jsii.get(self, "params")

    @params.setter
    def params(self, value: typing.Mapping[str, str]) -> None:
        jsii.set(self, "params", value)

    @builtins.property
    @jsii.member(jsii_name="dataRefreshWindowDays")
    def data_refresh_window_days(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "dataRefreshWindowDays")

    @data_refresh_window_days.setter
    def data_refresh_window_days(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "dataRefreshWindowDays", value)

    @builtins.property
    @jsii.member(jsii_name="disabled")
    def disabled(self) -> typing.Optional[bool]:
        return jsii.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "disabled", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> typing.Optional[str]:
        return jsii.get(self, "location")

    @location.setter
    def location(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="schedule")
    def schedule(self) -> typing.Optional[str]:
        return jsii.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "schedule", value)

    @builtins.property
    @jsii.member(jsii_name="serviceAccountName")
    def service_account_name(self) -> typing.Optional[str]:
        return jsii.get(self, "serviceAccountName")

    @service_account_name.setter
    def service_account_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "serviceAccountName", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["BigqueryDataTransferConfigTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["BigqueryDataTransferConfigTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDataTransferConfigConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'data_source_id': 'dataSourceId', 'destination_dataset_id': 'destinationDatasetId', 'display_name': 'displayName', 'params': 'params', 'data_refresh_window_days': 'dataRefreshWindowDays', 'disabled': 'disabled', 'location': 'location', 'project': 'project', 'schedule': 'schedule', 'service_account_name': 'serviceAccountName', 'timeouts': 'timeouts'})
class BigqueryDataTransferConfigConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, data_source_id: str, destination_dataset_id: str, display_name: str, params: typing.Mapping[str, str], data_refresh_window_days: typing.Optional[jsii.Number]=None, disabled: typing.Optional[bool]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None, schedule: typing.Optional[str]=None, service_account_name: typing.Optional[str]=None, timeouts: typing.Optional["BigqueryDataTransferConfigTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param data_source_id: The data source id. Cannot be changed once the transfer config is created.
        :param destination_dataset_id: The BigQuery target dataset id.
        :param display_name: The user specified display name for the transfer config.
        :param params: These parameters are specific to each data source.
        :param data_refresh_window_days: The number of days to look back to automatically refresh the data. For example, if dataRefreshWindowDays = 10, then every day BigQuery reingests data for [today-10, today-1], rather than ingesting data for just [today-1]. Only valid if the data source supports the feature. Set the value to 0 to use the default value.
        :param disabled: When set to true, no runs are scheduled for a given transfer.
        :param location: The geographic location where the transfer config should reside. Examples: US, EU, asia-northeast1. The default value is US.
        :param project: 
        :param schedule: Data transfer schedule. If the data source does not support a custom schedule, this should be empty. If it is empty, the default value for the data source will be used. The specified times are in UTC. Examples of valid format: 1st,3rd monday of month 15:30, every wed,fri of jan, jun 13:15, and first sunday of quarter 00:00. See more explanation about the format here: https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format NOTE: the granularity should be at least 8 hours, or less frequent.
        :param service_account_name: Optional service account name. If this field is set, transfer config will be created with this service account credentials. It requires that requesting user calling this API has permissions to act as this service account.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = BigqueryDataTransferConfigTimeouts(**timeouts)
        self._values = {
            'data_source_id': data_source_id,
            'destination_dataset_id': destination_dataset_id,
            'display_name': display_name,
            'params': params,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if data_refresh_window_days is not None: self._values["data_refresh_window_days"] = data_refresh_window_days
        if disabled is not None: self._values["disabled"] = disabled
        if location is not None: self._values["location"] = location
        if project is not None: self._values["project"] = project
        if schedule is not None: self._values["schedule"] = schedule
        if service_account_name is not None: self._values["service_account_name"] = service_account_name
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def data_source_id(self) -> str:
        """The data source id.

        Cannot be changed once the transfer config is created.
        """
        return self._values.get('data_source_id')

    @builtins.property
    def destination_dataset_id(self) -> str:
        """The BigQuery target dataset id."""
        return self._values.get('destination_dataset_id')

    @builtins.property
    def display_name(self) -> str:
        """The user specified display name for the transfer config."""
        return self._values.get('display_name')

    @builtins.property
    def params(self) -> typing.Mapping[str, str]:
        """These parameters are specific to each data source."""
        return self._values.get('params')

    @builtins.property
    def data_refresh_window_days(self) -> typing.Optional[jsii.Number]:
        """The number of days to look back to automatically refresh the data.

        For example, if dataRefreshWindowDays = 10, then every day BigQuery
        reingests data for [today-10, today-1], rather than ingesting data for
        just [today-1]. Only valid if the data source supports the feature.
        Set the value to 0 to use the default value.
        """
        return self._values.get('data_refresh_window_days')

    @builtins.property
    def disabled(self) -> typing.Optional[bool]:
        """When set to true, no runs are scheduled for a given transfer."""
        return self._values.get('disabled')

    @builtins.property
    def location(self) -> typing.Optional[str]:
        """The geographic location where the transfer config should reside.

        Examples: US, EU, asia-northeast1. The default value is US.
        """
        return self._values.get('location')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def schedule(self) -> typing.Optional[str]:
        """Data transfer schedule.

        If the data source does not support a custom
        schedule, this should be empty. If it is empty, the default value for
        the data source will be used. The specified times are in UTC. Examples
        of valid format: 1st,3rd monday of month 15:30, every wed,fri of jan,
        jun 13:15, and first sunday of quarter 00:00. See more explanation
        about the format here:
        https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
        NOTE: the granularity should be at least 8 hours, or less frequent.
        """
        return self._values.get('schedule')

    @builtins.property
    def service_account_name(self) -> typing.Optional[str]:
        """Optional service account name.

        If this field is set, transfer config will
        be created with this service account credentials. It requires that
        requesting user calling this API has permissions to act as this service account.
        """
        return self._values.get('service_account_name')

    @builtins.property
    def timeouts(self) -> typing.Optional["BigqueryDataTransferConfigTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDataTransferConfigConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDataTransferConfigTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class BigqueryDataTransferConfigTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDataTransferConfigTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigqueryDataset(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigqueryDataset"):
    def __init__(self, scope: constructs.Construct, id: str, *, dataset_id: str, access: typing.Optional[typing.List["BigqueryDatasetAccess"]]=None, default_encryption_configuration: typing.Optional[typing.List["BigqueryDatasetDefaultEncryptionConfiguration"]]=None, default_partition_expiration_ms: typing.Optional[jsii.Number]=None, default_table_expiration_ms: typing.Optional[jsii.Number]=None, delete_contents_on_destroy: typing.Optional[bool]=None, description: typing.Optional[str]=None, friendly_name: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["BigqueryDatasetTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param dataset_id: A unique ID for this dataset, without the project name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        :param access: access block.
        :param default_encryption_configuration: default_encryption_configuration block.
        :param default_partition_expiration_ms: The default partition expiration for all partitioned tables in the dataset, in milliseconds. Once this property is set, all newly-created partitioned tables in the dataset will have an 'expirationMs' property in the 'timePartitioning' settings set to this value, and changing the value will only affect new tables, not existing ones. The storage in a partition will have an expiration time of its partition time plus this value. Setting this property overrides the use of 'defaultTableExpirationMs' for partitioned tables: only one of 'defaultTableExpirationMs' and 'defaultPartitionExpirationMs' will be used for any new partitioned table. If you provide an explicit 'timePartitioning.expirationMs' when creating or updating a partitioned table, that value takes precedence over the default partition expiration time indicated by this property.
        :param default_table_expiration_ms: The default lifetime of all tables in the dataset, in milliseconds. The minimum value is 3600000 milliseconds (one hour). Once this property is set, all newly-created tables in the dataset will have an 'expirationTime' property set to the creation time plus the value in this property, and changing the value will only affect new tables, not existing ones. When the 'expirationTime' for a given table is reached, that table will be deleted automatically. If a table's 'expirationTime' is modified or removed before the table expires, or if you provide an explicit 'expirationTime' when creating a table, that value takes precedence over the default expiration time indicated by this property.
        :param delete_contents_on_destroy: 
        :param description: A user-friendly description of the dataset.
        :param friendly_name: A descriptive name for the dataset.
        :param labels: The labels associated with this dataset. You can use these to organize and group your datasets
        :param location: The geographic location where the dataset should reside. See `official docs <https://cloud.google.com/bigquery/docs/dataset-locations>`_. There are two types of locations, regional or multi-regional. A regional location is a specific geographic place, such as Tokyo, and a multi-regional location is a large geographic area, such as the United States, that contains at least two geographic places. Possible regional values include: 'asia-east1', 'asia-northeast1', 'asia-southeast1', 'australia-southeast1', 'europe-north1', 'europe-west2' and 'us-east4'. Possible multi-regional values: 'EU' and 'US'. The default value is multi-regional location 'US'. Changing this forces a new resource to be created.
        :param project: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigqueryDatasetConfig(dataset_id=dataset_id, access=access, default_encryption_configuration=default_encryption_configuration, default_partition_expiration_ms=default_partition_expiration_ms, default_table_expiration_ms=default_table_expiration_ms, delete_contents_on_destroy=delete_contents_on_destroy, description=description, friendly_name=friendly_name, labels=labels, location=location, project=project, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigqueryDataset, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="creationTime")
    def creation_time(self) -> jsii.Number:
        return jsii.get(self, "creationTime")

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="lastModifiedTime")
    def last_modified_time(self) -> jsii.Number:
        return jsii.get(self, "lastModifiedTime")

    @builtins.property
    @jsii.member(jsii_name="selfLink")
    def self_link(self) -> str:
        return jsii.get(self, "selfLink")

    @builtins.property
    @jsii.member(jsii_name="datasetId")
    def dataset_id(self) -> str:
        return jsii.get(self, "datasetId")

    @dataset_id.setter
    def dataset_id(self, value: str) -> None:
        jsii.set(self, "datasetId", value)

    @builtins.property
    @jsii.member(jsii_name="access")
    def access(self) -> typing.Optional[typing.List["BigqueryDatasetAccess"]]:
        return jsii.get(self, "access")

    @access.setter
    def access(self, value: typing.Optional[typing.List["BigqueryDatasetAccess"]]) -> None:
        jsii.set(self, "access", value)

    @builtins.property
    @jsii.member(jsii_name="defaultEncryptionConfiguration")
    def default_encryption_configuration(self) -> typing.Optional[typing.List["BigqueryDatasetDefaultEncryptionConfiguration"]]:
        return jsii.get(self, "defaultEncryptionConfiguration")

    @default_encryption_configuration.setter
    def default_encryption_configuration(self, value: typing.Optional[typing.List["BigqueryDatasetDefaultEncryptionConfiguration"]]) -> None:
        jsii.set(self, "defaultEncryptionConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="defaultPartitionExpirationMs")
    def default_partition_expiration_ms(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "defaultPartitionExpirationMs")

    @default_partition_expiration_ms.setter
    def default_partition_expiration_ms(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "defaultPartitionExpirationMs", value)

    @builtins.property
    @jsii.member(jsii_name="defaultTableExpirationMs")
    def default_table_expiration_ms(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "defaultTableExpirationMs")

    @default_table_expiration_ms.setter
    def default_table_expiration_ms(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "defaultTableExpirationMs", value)

    @builtins.property
    @jsii.member(jsii_name="deleteContentsOnDestroy")
    def delete_contents_on_destroy(self) -> typing.Optional[bool]:
        return jsii.get(self, "deleteContentsOnDestroy")

    @delete_contents_on_destroy.setter
    def delete_contents_on_destroy(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "deleteContentsOnDestroy", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="friendlyName")
    def friendly_name(self) -> typing.Optional[str]:
        return jsii.get(self, "friendlyName")

    @friendly_name.setter
    def friendly_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "friendlyName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="labels")
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "labels")

    @labels.setter
    def labels(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "labels", value)

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> typing.Optional[str]:
        return jsii.get(self, "location")

    @location.setter
    def location(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["BigqueryDatasetTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["BigqueryDatasetTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetAccess", jsii_struct_bases=[], name_mapping={'domain': 'domain', 'group_by_email': 'groupByEmail', 'role': 'role', 'special_group': 'specialGroup', 'user_by_email': 'userByEmail', 'view': 'view'})
class BigqueryDatasetAccess():
    def __init__(self, *, domain: typing.Optional[str]=None, group_by_email: typing.Optional[str]=None, role: typing.Optional[str]=None, special_group: typing.Optional[str]=None, user_by_email: typing.Optional[str]=None, view: typing.Optional[typing.List["BigqueryDatasetAccessView"]]=None) -> None:
        """
        :param domain: A domain to grant access to. Any users signed in with the domain specified will be granted the specified access
        :param group_by_email: An email address of a Google Group to grant access to.
        :param role: Describes the rights granted to the user specified by the other member of the access object. Primitive, Predefined and custom roles are supported. Predefined roles that have equivalent primitive roles are swapped by the API to their Primitive counterparts. See `official docs <https://cloud.google.com/bigquery/docs/access-control>`_.
        :param special_group: A special group to grant access to. Possible values include:. 'projectOwners': Owners of the enclosing project. 'projectReaders': Readers of the enclosing project. 'projectWriters': Writers of the enclosing project. 'allAuthenticatedUsers': All authenticated BigQuery users.
        :param user_by_email: An email address of a user to grant access to. For example: fred@example.com
        :param view: view block.
        """
        self._values = {
        }
        if domain is not None: self._values["domain"] = domain
        if group_by_email is not None: self._values["group_by_email"] = group_by_email
        if role is not None: self._values["role"] = role
        if special_group is not None: self._values["special_group"] = special_group
        if user_by_email is not None: self._values["user_by_email"] = user_by_email
        if view is not None: self._values["view"] = view

    @builtins.property
    def domain(self) -> typing.Optional[str]:
        """A domain to grant access to.

        Any users signed in with the
        domain specified will be granted the specified access
        """
        return self._values.get('domain')

    @builtins.property
    def group_by_email(self) -> typing.Optional[str]:
        """An email address of a Google Group to grant access to."""
        return self._values.get('group_by_email')

    @builtins.property
    def role(self) -> typing.Optional[str]:
        """Describes the rights granted to the user specified by the other member of the access object.

        Primitive, Predefined and custom
        roles are supported. Predefined roles that have equivalent
        primitive roles are swapped by the API to their Primitive
        counterparts. See
        `official docs <https://cloud.google.com/bigquery/docs/access-control>`_.
        """
        return self._values.get('role')

    @builtins.property
    def special_group(self) -> typing.Optional[str]:
        """A special group to grant access to. Possible values include:.

        'projectOwners': Owners of the enclosing project.

        'projectReaders': Readers of the enclosing project.

        'projectWriters': Writers of the enclosing project.

        'allAuthenticatedUsers': All authenticated BigQuery users.
        """
        return self._values.get('special_group')

    @builtins.property
    def user_by_email(self) -> typing.Optional[str]:
        """An email address of a user to grant access to.

        For example:
        fred@example.com
        """
        return self._values.get('user_by_email')

    @builtins.property
    def view(self) -> typing.Optional[typing.List["BigqueryDatasetAccessView"]]:
        """view block."""
        return self._values.get('view')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetAccess(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigqueryDatasetAccessA(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigqueryDatasetAccessA"):
    def __init__(self, scope: constructs.Construct, id: str, *, dataset_id: str, domain: typing.Optional[str]=None, group_by_email: typing.Optional[str]=None, iam_member: typing.Optional[str]=None, project: typing.Optional[str]=None, role: typing.Optional[str]=None, special_group: typing.Optional[str]=None, timeouts: typing.Optional["BigqueryDatasetAccessTimeouts"]=None, user_by_email: typing.Optional[str]=None, view: typing.Optional[typing.List["BigqueryDatasetAccessViewA"]]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param dataset_id: A unique ID for this dataset, without the project name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        :param domain: A domain to grant access to. Any users signed in with the domain specified will be granted the specified access
        :param group_by_email: An email address of a Google Group to grant access to.
        :param iam_member: Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group. For example: 'allUsers'
        :param project: 
        :param role: Describes the rights granted to the user specified by the other member of the access object. Primitive, Predefined and custom roles are supported. Predefined roles that have equivalent primitive roles are swapped by the API to their Primitive counterparts, and will show a diff post-create. See `official docs <https://cloud.google.com/bigquery/docs/access-control>`_.
        :param special_group: A special group to grant access to. Possible values include:. 'projectOwners': Owners of the enclosing project. 'projectReaders': Readers of the enclosing project. 'projectWriters': Writers of the enclosing project. 'allAuthenticatedUsers': All authenticated BigQuery users.
        :param timeouts: timeouts block.
        :param user_by_email: An email address of a user to grant access to. For example: fred@example.com
        :param view: view block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigqueryDatasetAccessAConfig(dataset_id=dataset_id, domain=domain, group_by_email=group_by_email, iam_member=iam_member, project=project, role=role, special_group=special_group, timeouts=timeouts, user_by_email=user_by_email, view=view, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigqueryDatasetAccessA, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="datasetId")
    def dataset_id(self) -> str:
        return jsii.get(self, "datasetId")

    @dataset_id.setter
    def dataset_id(self, value: str) -> None:
        jsii.set(self, "datasetId", value)

    @builtins.property
    @jsii.member(jsii_name="domain")
    def domain(self) -> typing.Optional[str]:
        return jsii.get(self, "domain")

    @domain.setter
    def domain(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "domain", value)

    @builtins.property
    @jsii.member(jsii_name="groupByEmail")
    def group_by_email(self) -> typing.Optional[str]:
        return jsii.get(self, "groupByEmail")

    @group_by_email.setter
    def group_by_email(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "groupByEmail", value)

    @builtins.property
    @jsii.member(jsii_name="iamMember")
    def iam_member(self) -> typing.Optional[str]:
        return jsii.get(self, "iamMember")

    @iam_member.setter
    def iam_member(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "iamMember", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> typing.Optional[str]:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="specialGroup")
    def special_group(self) -> typing.Optional[str]:
        return jsii.get(self, "specialGroup")

    @special_group.setter
    def special_group(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "specialGroup", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["BigqueryDatasetAccessTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["BigqueryDatasetAccessTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="userByEmail")
    def user_by_email(self) -> typing.Optional[str]:
        return jsii.get(self, "userByEmail")

    @user_by_email.setter
    def user_by_email(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "userByEmail", value)

    @builtins.property
    @jsii.member(jsii_name="view")
    def view(self) -> typing.Optional[typing.List["BigqueryDatasetAccessViewA"]]:
        return jsii.get(self, "view")

    @view.setter
    def view(self, value: typing.Optional[typing.List["BigqueryDatasetAccessViewA"]]) -> None:
        jsii.set(self, "view", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetAccessAConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'dataset_id': 'datasetId', 'domain': 'domain', 'group_by_email': 'groupByEmail', 'iam_member': 'iamMember', 'project': 'project', 'role': 'role', 'special_group': 'specialGroup', 'timeouts': 'timeouts', 'user_by_email': 'userByEmail', 'view': 'view'})
class BigqueryDatasetAccessAConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, dataset_id: str, domain: typing.Optional[str]=None, group_by_email: typing.Optional[str]=None, iam_member: typing.Optional[str]=None, project: typing.Optional[str]=None, role: typing.Optional[str]=None, special_group: typing.Optional[str]=None, timeouts: typing.Optional["BigqueryDatasetAccessTimeouts"]=None, user_by_email: typing.Optional[str]=None, view: typing.Optional[typing.List["BigqueryDatasetAccessViewA"]]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param dataset_id: A unique ID for this dataset, without the project name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        :param domain: A domain to grant access to. Any users signed in with the domain specified will be granted the specified access
        :param group_by_email: An email address of a Google Group to grant access to.
        :param iam_member: Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group. For example: 'allUsers'
        :param project: 
        :param role: Describes the rights granted to the user specified by the other member of the access object. Primitive, Predefined and custom roles are supported. Predefined roles that have equivalent primitive roles are swapped by the API to their Primitive counterparts, and will show a diff post-create. See `official docs <https://cloud.google.com/bigquery/docs/access-control>`_.
        :param special_group: A special group to grant access to. Possible values include:. 'projectOwners': Owners of the enclosing project. 'projectReaders': Readers of the enclosing project. 'projectWriters': Writers of the enclosing project. 'allAuthenticatedUsers': All authenticated BigQuery users.
        :param timeouts: timeouts block.
        :param user_by_email: An email address of a user to grant access to. For example: fred@example.com
        :param view: view block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = BigqueryDatasetAccessTimeouts(**timeouts)
        self._values = {
            'dataset_id': dataset_id,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if domain is not None: self._values["domain"] = domain
        if group_by_email is not None: self._values["group_by_email"] = group_by_email
        if iam_member is not None: self._values["iam_member"] = iam_member
        if project is not None: self._values["project"] = project
        if role is not None: self._values["role"] = role
        if special_group is not None: self._values["special_group"] = special_group
        if timeouts is not None: self._values["timeouts"] = timeouts
        if user_by_email is not None: self._values["user_by_email"] = user_by_email
        if view is not None: self._values["view"] = view

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def dataset_id(self) -> str:
        """A unique ID for this dataset, without the project name.

        The ID
        must contain only letters (a-z, A-Z), numbers (0-9), or
        underscores (_). The maximum length is 1,024 characters.
        """
        return self._values.get('dataset_id')

    @builtins.property
    def domain(self) -> typing.Optional[str]:
        """A domain to grant access to.

        Any users signed in with the
        domain specified will be granted the specified access
        """
        return self._values.get('domain')

    @builtins.property
    def group_by_email(self) -> typing.Optional[str]:
        """An email address of a Google Group to grant access to."""
        return self._values.get('group_by_email')

    @builtins.property
    def iam_member(self) -> typing.Optional[str]:
        """Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group.

        For example: 'allUsers'
        """
        return self._values.get('iam_member')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def role(self) -> typing.Optional[str]:
        """Describes the rights granted to the user specified by the other member of the access object.

        Primitive, Predefined and custom
        roles are supported. Predefined roles that have equivalent
        primitive roles are swapped by the API to their Primitive
        counterparts, and will show a diff post-create. See
        `official docs <https://cloud.google.com/bigquery/docs/access-control>`_.
        """
        return self._values.get('role')

    @builtins.property
    def special_group(self) -> typing.Optional[str]:
        """A special group to grant access to. Possible values include:.

        'projectOwners': Owners of the enclosing project.

        'projectReaders': Readers of the enclosing project.

        'projectWriters': Writers of the enclosing project.

        'allAuthenticatedUsers': All authenticated BigQuery users.
        """
        return self._values.get('special_group')

    @builtins.property
    def timeouts(self) -> typing.Optional["BigqueryDatasetAccessTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    @builtins.property
    def user_by_email(self) -> typing.Optional[str]:
        """An email address of a user to grant access to.

        For example:
        fred@example.com
        """
        return self._values.get('user_by_email')

    @builtins.property
    def view(self) -> typing.Optional[typing.List["BigqueryDatasetAccessViewA"]]:
        """view block."""
        return self._values.get('view')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetAccessAConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetAccessTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete'})
class BigqueryDatasetAccessTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetAccessTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetAccessView", jsii_struct_bases=[], name_mapping={'dataset_id': 'datasetId', 'project_id': 'projectId', 'table_id': 'tableId'})
class BigqueryDatasetAccessView():
    def __init__(self, *, dataset_id: str, project_id: str, table_id: str) -> None:
        """
        :param dataset_id: The ID of the dataset containing this table.
        :param project_id: The ID of the project containing this table.
        :param table_id: The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        self._values = {
            'dataset_id': dataset_id,
            'project_id': project_id,
            'table_id': table_id,
        }

    @builtins.property
    def dataset_id(self) -> str:
        """The ID of the dataset containing this table."""
        return self._values.get('dataset_id')

    @builtins.property
    def project_id(self) -> str:
        """The ID of the project containing this table."""
        return self._values.get('project_id')

    @builtins.property
    def table_id(self) -> str:
        """The ID of the table.

        The ID must contain only letters (a-z,
        A-Z), numbers (0-9), or underscores (_). The maximum length
        is 1,024 characters.
        """
        return self._values.get('table_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetAccessView(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetAccessViewA", jsii_struct_bases=[], name_mapping={'dataset_id': 'datasetId', 'project_id': 'projectId', 'table_id': 'tableId'})
class BigqueryDatasetAccessViewA():
    def __init__(self, *, dataset_id: str, project_id: str, table_id: str) -> None:
        """
        :param dataset_id: The ID of the dataset containing this table.
        :param project_id: The ID of the project containing this table.
        :param table_id: The ID of the table. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        """
        self._values = {
            'dataset_id': dataset_id,
            'project_id': project_id,
            'table_id': table_id,
        }

    @builtins.property
    def dataset_id(self) -> str:
        """The ID of the dataset containing this table."""
        return self._values.get('dataset_id')

    @builtins.property
    def project_id(self) -> str:
        """The ID of the project containing this table."""
        return self._values.get('project_id')

    @builtins.property
    def table_id(self) -> str:
        """The ID of the table.

        The ID must contain only letters (a-z,
        A-Z), numbers (0-9), or underscores (_). The maximum length
        is 1,024 characters.
        """
        return self._values.get('table_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetAccessViewA(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'dataset_id': 'datasetId', 'access': 'access', 'default_encryption_configuration': 'defaultEncryptionConfiguration', 'default_partition_expiration_ms': 'defaultPartitionExpirationMs', 'default_table_expiration_ms': 'defaultTableExpirationMs', 'delete_contents_on_destroy': 'deleteContentsOnDestroy', 'description': 'description', 'friendly_name': 'friendlyName', 'labels': 'labels', 'location': 'location', 'project': 'project', 'timeouts': 'timeouts'})
class BigqueryDatasetConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, dataset_id: str, access: typing.Optional[typing.List["BigqueryDatasetAccess"]]=None, default_encryption_configuration: typing.Optional[typing.List["BigqueryDatasetDefaultEncryptionConfiguration"]]=None, default_partition_expiration_ms: typing.Optional[jsii.Number]=None, default_table_expiration_ms: typing.Optional[jsii.Number]=None, delete_contents_on_destroy: typing.Optional[bool]=None, description: typing.Optional[str]=None, friendly_name: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["BigqueryDatasetTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param dataset_id: A unique ID for this dataset, without the project name. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
        :param access: access block.
        :param default_encryption_configuration: default_encryption_configuration block.
        :param default_partition_expiration_ms: The default partition expiration for all partitioned tables in the dataset, in milliseconds. Once this property is set, all newly-created partitioned tables in the dataset will have an 'expirationMs' property in the 'timePartitioning' settings set to this value, and changing the value will only affect new tables, not existing ones. The storage in a partition will have an expiration time of its partition time plus this value. Setting this property overrides the use of 'defaultTableExpirationMs' for partitioned tables: only one of 'defaultTableExpirationMs' and 'defaultPartitionExpirationMs' will be used for any new partitioned table. If you provide an explicit 'timePartitioning.expirationMs' when creating or updating a partitioned table, that value takes precedence over the default partition expiration time indicated by this property.
        :param default_table_expiration_ms: The default lifetime of all tables in the dataset, in milliseconds. The minimum value is 3600000 milliseconds (one hour). Once this property is set, all newly-created tables in the dataset will have an 'expirationTime' property set to the creation time plus the value in this property, and changing the value will only affect new tables, not existing ones. When the 'expirationTime' for a given table is reached, that table will be deleted automatically. If a table's 'expirationTime' is modified or removed before the table expires, or if you provide an explicit 'expirationTime' when creating a table, that value takes precedence over the default expiration time indicated by this property.
        :param delete_contents_on_destroy: 
        :param description: A user-friendly description of the dataset.
        :param friendly_name: A descriptive name for the dataset.
        :param labels: The labels associated with this dataset. You can use these to organize and group your datasets
        :param location: The geographic location where the dataset should reside. See `official docs <https://cloud.google.com/bigquery/docs/dataset-locations>`_. There are two types of locations, regional or multi-regional. A regional location is a specific geographic place, such as Tokyo, and a multi-regional location is a large geographic area, such as the United States, that contains at least two geographic places. Possible regional values include: 'asia-east1', 'asia-northeast1', 'asia-southeast1', 'australia-southeast1', 'europe-north1', 'europe-west2' and 'us-east4'. Possible multi-regional values: 'EU' and 'US'. The default value is multi-regional location 'US'. Changing this forces a new resource to be created.
        :param project: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = BigqueryDatasetTimeouts(**timeouts)
        self._values = {
            'dataset_id': dataset_id,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if access is not None: self._values["access"] = access
        if default_encryption_configuration is not None: self._values["default_encryption_configuration"] = default_encryption_configuration
        if default_partition_expiration_ms is not None: self._values["default_partition_expiration_ms"] = default_partition_expiration_ms
        if default_table_expiration_ms is not None: self._values["default_table_expiration_ms"] = default_table_expiration_ms
        if delete_contents_on_destroy is not None: self._values["delete_contents_on_destroy"] = delete_contents_on_destroy
        if description is not None: self._values["description"] = description
        if friendly_name is not None: self._values["friendly_name"] = friendly_name
        if labels is not None: self._values["labels"] = labels
        if location is not None: self._values["location"] = location
        if project is not None: self._values["project"] = project
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def dataset_id(self) -> str:
        """A unique ID for this dataset, without the project name.

        The ID
        must contain only letters (a-z, A-Z), numbers (0-9), or
        underscores (_). The maximum length is 1,024 characters.
        """
        return self._values.get('dataset_id')

    @builtins.property
    def access(self) -> typing.Optional[typing.List["BigqueryDatasetAccess"]]:
        """access block."""
        return self._values.get('access')

    @builtins.property
    def default_encryption_configuration(self) -> typing.Optional[typing.List["BigqueryDatasetDefaultEncryptionConfiguration"]]:
        """default_encryption_configuration block."""
        return self._values.get('default_encryption_configuration')

    @builtins.property
    def default_partition_expiration_ms(self) -> typing.Optional[jsii.Number]:
        """The default partition expiration for all partitioned tables in the dataset, in milliseconds.

        Once this property is set, all newly-created partitioned tables in
        the dataset will have an 'expirationMs' property in the 'timePartitioning'
        settings set to this value, and changing the value will only
        affect new tables, not existing ones. The storage in a partition will
        have an expiration time of its partition time plus this value.
        Setting this property overrides the use of 'defaultTableExpirationMs'
        for partitioned tables: only one of 'defaultTableExpirationMs' and
        'defaultPartitionExpirationMs' will be used for any new partitioned
        table. If you provide an explicit 'timePartitioning.expirationMs' when
        creating or updating a partitioned table, that value takes precedence
        over the default partition expiration time indicated by this property.
        """
        return self._values.get('default_partition_expiration_ms')

    @builtins.property
    def default_table_expiration_ms(self) -> typing.Optional[jsii.Number]:
        """The default lifetime of all tables in the dataset, in milliseconds. The minimum value is 3600000 milliseconds (one hour).

        Once this property is set, all newly-created tables in the dataset
        will have an 'expirationTime' property set to the creation time plus
        the value in this property, and changing the value will only affect
        new tables, not existing ones. When the 'expirationTime' for a given
        table is reached, that table will be deleted automatically.
        If a table's 'expirationTime' is modified or removed before the
        table expires, or if you provide an explicit 'expirationTime' when
        creating a table, that value takes precedence over the default
        expiration time indicated by this property.
        """
        return self._values.get('default_table_expiration_ms')

    @builtins.property
    def delete_contents_on_destroy(self) -> typing.Optional[bool]:
        return self._values.get('delete_contents_on_destroy')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """A user-friendly description of the dataset."""
        return self._values.get('description')

    @builtins.property
    def friendly_name(self) -> typing.Optional[str]:
        """A descriptive name for the dataset."""
        return self._values.get('friendly_name')

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        """The labels associated with this dataset.

        You can use these to
        organize and group your datasets
        """
        return self._values.get('labels')

    @builtins.property
    def location(self) -> typing.Optional[str]:
        """The geographic location where the dataset should reside. See `official docs <https://cloud.google.com/bigquery/docs/dataset-locations>`_.

        There are two types of locations, regional or multi-regional. A regional
        location is a specific geographic place, such as Tokyo, and a multi-regional
        location is a large geographic area, such as the United States, that
        contains at least two geographic places.

        Possible regional values include: 'asia-east1', 'asia-northeast1',
        'asia-southeast1', 'australia-southeast1', 'europe-north1',
        'europe-west2' and 'us-east4'.

        Possible multi-regional values: 'EU' and 'US'.

        The default value is multi-regional location 'US'.
        Changing this forces a new resource to be created.
        """
        return self._values.get('location')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def timeouts(self) -> typing.Optional["BigqueryDatasetTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetDefaultEncryptionConfiguration", jsii_struct_bases=[], name_mapping={'kms_key_name': 'kmsKeyName'})
class BigqueryDatasetDefaultEncryptionConfiguration():
    def __init__(self, *, kms_key_name: str) -> None:
        """
        :param kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        self._values = {
            'kms_key_name': kms_key_name,
        }

    @builtins.property
    def kms_key_name(self) -> str:
        """Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.

        The BigQuery Service Account associated with your project requires
        access to this encryption key.
        """
        return self._values.get('kms_key_name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetDefaultEncryptionConfiguration(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigqueryDatasetIamBinding(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigqueryDatasetIamBinding"):
    def __init__(self, scope: constructs.Construct, id: str, *, dataset_id: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["BigqueryDatasetIamBindingCondition"]]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param dataset_id: 
        :param members: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigqueryDatasetIamBindingConfig(dataset_id=dataset_id, members=members, role=role, condition=condition, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigqueryDatasetIamBinding, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="datasetId")
    def dataset_id(self) -> str:
        return jsii.get(self, "datasetId")

    @dataset_id.setter
    def dataset_id(self, value: str) -> None:
        jsii.set(self, "datasetId", value)

    @builtins.property
    @jsii.member(jsii_name="members")
    def members(self) -> typing.List[str]:
        return jsii.get(self, "members")

    @members.setter
    def members(self, value: typing.List[str]) -> None:
        jsii.set(self, "members", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["BigqueryDatasetIamBindingCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["BigqueryDatasetIamBindingCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetIamBindingCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class BigqueryDatasetIamBindingCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetIamBindingCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetIamBindingConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'dataset_id': 'datasetId', 'members': 'members', 'role': 'role', 'condition': 'condition', 'project': 'project'})
class BigqueryDatasetIamBindingConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, dataset_id: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["BigqueryDatasetIamBindingCondition"]]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param dataset_id: 
        :param members: 
        :param role: 
        :param condition: condition block.
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'dataset_id': dataset_id,
            'members': members,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def dataset_id(self) -> str:
        return self._values.get('dataset_id')

    @builtins.property
    def members(self) -> typing.List[str]:
        return self._values.get('members')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["BigqueryDatasetIamBindingCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetIamBindingConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigqueryDatasetIamMember(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigqueryDatasetIamMember"):
    def __init__(self, scope: constructs.Construct, id: str, *, dataset_id: str, member: str, role: str, condition: typing.Optional[typing.List["BigqueryDatasetIamMemberCondition"]]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param dataset_id: 
        :param member: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigqueryDatasetIamMemberConfig(dataset_id=dataset_id, member=member, role=role, condition=condition, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigqueryDatasetIamMember, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="datasetId")
    def dataset_id(self) -> str:
        return jsii.get(self, "datasetId")

    @dataset_id.setter
    def dataset_id(self, value: str) -> None:
        jsii.set(self, "datasetId", value)

    @builtins.property
    @jsii.member(jsii_name="member")
    def member(self) -> str:
        return jsii.get(self, "member")

    @member.setter
    def member(self, value: str) -> None:
        jsii.set(self, "member", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["BigqueryDatasetIamMemberCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["BigqueryDatasetIamMemberCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetIamMemberCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class BigqueryDatasetIamMemberCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetIamMemberCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetIamMemberConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'dataset_id': 'datasetId', 'member': 'member', 'role': 'role', 'condition': 'condition', 'project': 'project'})
class BigqueryDatasetIamMemberConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, dataset_id: str, member: str, role: str, condition: typing.Optional[typing.List["BigqueryDatasetIamMemberCondition"]]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param dataset_id: 
        :param member: 
        :param role: 
        :param condition: condition block.
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'dataset_id': dataset_id,
            'member': member,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def dataset_id(self) -> str:
        return self._values.get('dataset_id')

    @builtins.property
    def member(self) -> str:
        return self._values.get('member')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["BigqueryDatasetIamMemberCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetIamMemberConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigqueryDatasetIamPolicy(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigqueryDatasetIamPolicy"):
    def __init__(self, scope: constructs.Construct, id: str, *, dataset_id: str, policy_data: str, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param dataset_id: 
        :param policy_data: 
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigqueryDatasetIamPolicyConfig(dataset_id=dataset_id, policy_data=policy_data, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigqueryDatasetIamPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="datasetId")
    def dataset_id(self) -> str:
        return jsii.get(self, "datasetId")

    @dataset_id.setter
    def dataset_id(self, value: str) -> None:
        jsii.set(self, "datasetId", value)

    @builtins.property
    @jsii.member(jsii_name="policyData")
    def policy_data(self) -> str:
        return jsii.get(self, "policyData")

    @policy_data.setter
    def policy_data(self, value: str) -> None:
        jsii.set(self, "policyData", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetIamPolicyConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'dataset_id': 'datasetId', 'policy_data': 'policyData', 'project': 'project'})
class BigqueryDatasetIamPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, dataset_id: str, policy_data: str, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param dataset_id: 
        :param policy_data: 
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'dataset_id': dataset_id,
            'policy_data': policy_data,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def dataset_id(self) -> str:
        return self._values.get('dataset_id')

    @builtins.property
    def policy_data(self) -> str:
        return self._values.get('policy_data')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetIamPolicyConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryDatasetTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class BigqueryDatasetTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryDatasetTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigqueryJob(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigqueryJob"):
    def __init__(self, scope: constructs.Construct, id: str, *, job_id: str, copy: typing.Optional[typing.List["BigqueryJobCopy"]]=None, extract: typing.Optional[typing.List["BigqueryJobExtract"]]=None, job_timeout_ms: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, load: typing.Optional[typing.List["BigqueryJobLoad"]]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None, query: typing.Optional[typing.List["BigqueryJobQuery"]]=None, timeouts: typing.Optional["BigqueryJobTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param job_id: The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        :param copy: copy block.
        :param extract: extract block.
        :param job_timeout_ms: Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        :param labels: The labels associated with this job. You can use these to organize and group your jobs.
        :param load: load block.
        :param location: The geographic location of the job. The default value is US.
        :param project: 
        :param query: query block.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigqueryJobConfig(job_id=job_id, copy=copy, extract=extract, job_timeout_ms=job_timeout_ms, labels=labels, load=load, location=location, project=project, query=query, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigqueryJob, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="jobType")
    def job_type(self) -> str:
        return jsii.get(self, "jobType")

    @builtins.property
    @jsii.member(jsii_name="userEmail")
    def user_email(self) -> str:
        return jsii.get(self, "userEmail")

    @builtins.property
    @jsii.member(jsii_name="jobId")
    def job_id(self) -> str:
        return jsii.get(self, "jobId")

    @job_id.setter
    def job_id(self, value: str) -> None:
        jsii.set(self, "jobId", value)

    @builtins.property
    @jsii.member(jsii_name="copy")
    def copy(self) -> typing.Optional[typing.List["BigqueryJobCopy"]]:
        return jsii.get(self, "copy")

    @copy.setter
    def copy(self, value: typing.Optional[typing.List["BigqueryJobCopy"]]) -> None:
        jsii.set(self, "copy", value)

    @builtins.property
    @jsii.member(jsii_name="extract")
    def extract(self) -> typing.Optional[typing.List["BigqueryJobExtract"]]:
        return jsii.get(self, "extract")

    @extract.setter
    def extract(self, value: typing.Optional[typing.List["BigqueryJobExtract"]]) -> None:
        jsii.set(self, "extract", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="jobTimeoutMs")
    def job_timeout_ms(self) -> typing.Optional[str]:
        return jsii.get(self, "jobTimeoutMs")

    @job_timeout_ms.setter
    def job_timeout_ms(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "jobTimeoutMs", value)

    @builtins.property
    @jsii.member(jsii_name="labels")
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "labels")

    @labels.setter
    def labels(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "labels", value)

    @builtins.property
    @jsii.member(jsii_name="load")
    def load(self) -> typing.Optional[typing.List["BigqueryJobLoad"]]:
        return jsii.get(self, "load")

    @load.setter
    def load(self, value: typing.Optional[typing.List["BigqueryJobLoad"]]) -> None:
        jsii.set(self, "load", value)

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> typing.Optional[str]:
        return jsii.get(self, "location")

    @location.setter
    def location(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="query")
    def query(self) -> typing.Optional[typing.List["BigqueryJobQuery"]]:
        return jsii.get(self, "query")

    @query.setter
    def query(self, value: typing.Optional[typing.List["BigqueryJobQuery"]]) -> None:
        jsii.set(self, "query", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["BigqueryJobTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["BigqueryJobTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'job_id': 'jobId', 'copy': 'copy', 'extract': 'extract', 'job_timeout_ms': 'jobTimeoutMs', 'labels': 'labels', 'load': 'load', 'location': 'location', 'project': 'project', 'query': 'query', 'timeouts': 'timeouts'})
class BigqueryJobConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, job_id: str, copy: typing.Optional[typing.List["BigqueryJobCopy"]]=None, extract: typing.Optional[typing.List["BigqueryJobExtract"]]=None, job_timeout_ms: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, load: typing.Optional[typing.List["BigqueryJobLoad"]]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None, query: typing.Optional[typing.List["BigqueryJobQuery"]]=None, timeouts: typing.Optional["BigqueryJobTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param job_id: The ID of the job. The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        :param copy: copy block.
        :param extract: extract block.
        :param job_timeout_ms: Job timeout in milliseconds. If this time limit is exceeded, BigQuery may attempt to terminate the job.
        :param labels: The labels associated with this job. You can use these to organize and group your jobs.
        :param load: load block.
        :param location: The geographic location of the job. The default value is US.
        :param project: 
        :param query: query block.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = BigqueryJobTimeouts(**timeouts)
        self._values = {
            'job_id': job_id,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if copy is not None: self._values["copy"] = copy
        if extract is not None: self._values["extract"] = extract
        if job_timeout_ms is not None: self._values["job_timeout_ms"] = job_timeout_ms
        if labels is not None: self._values["labels"] = labels
        if load is not None: self._values["load"] = load
        if location is not None: self._values["location"] = location
        if project is not None: self._values["project"] = project
        if query is not None: self._values["query"] = query
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def job_id(self) -> str:
        """The ID of the job.

        The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is 1,024 characters.
        """
        return self._values.get('job_id')

    @builtins.property
    def copy(self) -> typing.Optional[typing.List["BigqueryJobCopy"]]:
        """copy block."""
        return self._values.get('copy')

    @builtins.property
    def extract(self) -> typing.Optional[typing.List["BigqueryJobExtract"]]:
        """extract block."""
        return self._values.get('extract')

    @builtins.property
    def job_timeout_ms(self) -> typing.Optional[str]:
        """Job timeout in milliseconds.

        If this time limit is exceeded, BigQuery may attempt to terminate the job.
        """
        return self._values.get('job_timeout_ms')

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        """The labels associated with this job.

        You can use these to organize and group your jobs.
        """
        return self._values.get('labels')

    @builtins.property
    def load(self) -> typing.Optional[typing.List["BigqueryJobLoad"]]:
        """load block."""
        return self._values.get('load')

    @builtins.property
    def location(self) -> typing.Optional[str]:
        """The geographic location of the job.

        The default value is US.
        """
        return self._values.get('location')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def query(self) -> typing.Optional[typing.List["BigqueryJobQuery"]]:
        """query block."""
        return self._values.get('query')

    @builtins.property
    def timeouts(self) -> typing.Optional["BigqueryJobTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobCopy", jsii_struct_bases=[], name_mapping={'source_tables': 'sourceTables', 'create_disposition': 'createDisposition', 'destination_encryption_configuration': 'destinationEncryptionConfiguration', 'destination_table': 'destinationTable', 'write_disposition': 'writeDisposition'})
class BigqueryJobCopy():
    def __init__(self, *, source_tables: typing.List["BigqueryJobCopySourceTables"], create_disposition: typing.Optional[str]=None, destination_encryption_configuration: typing.Optional[typing.List["BigqueryJobCopyDestinationEncryptionConfiguration"]]=None, destination_table: typing.Optional[typing.List["BigqueryJobCopyDestinationTable"]]=None, write_disposition: typing.Optional[str]=None) -> None:
        """
        :param source_tables: source_tables block.
        :param create_disposition: Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
        :param destination_encryption_configuration: destination_encryption_configuration block.
        :param destination_table: destination_table block.
        :param write_disposition: Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
        """
        self._values = {
            'source_tables': source_tables,
        }
        if create_disposition is not None: self._values["create_disposition"] = create_disposition
        if destination_encryption_configuration is not None: self._values["destination_encryption_configuration"] = destination_encryption_configuration
        if destination_table is not None: self._values["destination_table"] = destination_table
        if write_disposition is not None: self._values["write_disposition"] = write_disposition

    @builtins.property
    def source_tables(self) -> typing.List["BigqueryJobCopySourceTables"]:
        """source_tables block."""
        return self._values.get('source_tables')

    @builtins.property
    def create_disposition(self) -> typing.Optional[str]:
        """Specifies whether the job is allowed to create new tables.

        The following values are supported:
        CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
        CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
        Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
        """
        return self._values.get('create_disposition')

    @builtins.property
    def destination_encryption_configuration(self) -> typing.Optional[typing.List["BigqueryJobCopyDestinationEncryptionConfiguration"]]:
        """destination_encryption_configuration block."""
        return self._values.get('destination_encryption_configuration')

    @builtins.property
    def destination_table(self) -> typing.Optional[typing.List["BigqueryJobCopyDestinationTable"]]:
        """destination_table block."""
        return self._values.get('destination_table')

    @builtins.property
    def write_disposition(self) -> typing.Optional[str]:
        """Specifies the action that occurs if the destination table already exists.

        The following values are supported:
        WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
        WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
        WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
        Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
        Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
        """
        return self._values.get('write_disposition')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobCopy(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobCopyDestinationEncryptionConfiguration", jsii_struct_bases=[], name_mapping={'kms_key_name': 'kmsKeyName'})
class BigqueryJobCopyDestinationEncryptionConfiguration():
    def __init__(self, *, kms_key_name: str) -> None:
        """
        :param kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        self._values = {
            'kms_key_name': kms_key_name,
        }

    @builtins.property
    def kms_key_name(self) -> str:
        """Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.

        The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return self._values.get('kms_key_name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobCopyDestinationEncryptionConfiguration(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobCopyDestinationTable", jsii_struct_bases=[], name_mapping={'table_id': 'tableId', 'dataset_id': 'datasetId', 'project_id': 'projectId'})
class BigqueryJobCopyDestinationTable():
    def __init__(self, *, table_id: str, dataset_id: typing.Optional[str]=None, project_id: typing.Optional[str]=None) -> None:
        """
        :param table_id: The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        :param dataset_id: The ID of the dataset containing this table.
        :param project_id: The ID of the project containing this table.
        """
        self._values = {
            'table_id': table_id,
        }
        if dataset_id is not None: self._values["dataset_id"] = dataset_id
        if project_id is not None: self._values["project_id"] = project_id

    @builtins.property
    def table_id(self) -> str:
        """The table.

        Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
        or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        """
        return self._values.get('table_id')

    @builtins.property
    def dataset_id(self) -> typing.Optional[str]:
        """The ID of the dataset containing this table."""
        return self._values.get('dataset_id')

    @builtins.property
    def project_id(self) -> typing.Optional[str]:
        """The ID of the project containing this table."""
        return self._values.get('project_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobCopyDestinationTable(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobCopySourceTables", jsii_struct_bases=[], name_mapping={'table_id': 'tableId', 'dataset_id': 'datasetId', 'project_id': 'projectId'})
class BigqueryJobCopySourceTables():
    def __init__(self, *, table_id: str, dataset_id: typing.Optional[str]=None, project_id: typing.Optional[str]=None) -> None:
        """
        :param table_id: The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        :param dataset_id: The ID of the dataset containing this table.
        :param project_id: The ID of the project containing this table.
        """
        self._values = {
            'table_id': table_id,
        }
        if dataset_id is not None: self._values["dataset_id"] = dataset_id
        if project_id is not None: self._values["project_id"] = project_id

    @builtins.property
    def table_id(self) -> str:
        """The table.

        Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
        or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        """
        return self._values.get('table_id')

    @builtins.property
    def dataset_id(self) -> typing.Optional[str]:
        """The ID of the dataset containing this table."""
        return self._values.get('dataset_id')

    @builtins.property
    def project_id(self) -> typing.Optional[str]:
        """The ID of the project containing this table."""
        return self._values.get('project_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobCopySourceTables(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobExtract", jsii_struct_bases=[], name_mapping={'destination_uris': 'destinationUris', 'compression': 'compression', 'destination_format': 'destinationFormat', 'field_delimiter': 'fieldDelimiter', 'print_header': 'printHeader', 'source_model': 'sourceModel', 'source_table': 'sourceTable', 'use_avro_logical_types': 'useAvroLogicalTypes'})
class BigqueryJobExtract():
    def __init__(self, *, destination_uris: typing.List[str], compression: typing.Optional[str]=None, destination_format: typing.Optional[str]=None, field_delimiter: typing.Optional[str]=None, print_header: typing.Optional[bool]=None, source_model: typing.Optional[typing.List["BigqueryJobExtractSourceModel"]]=None, source_table: typing.Optional[typing.List["BigqueryJobExtractSourceTable"]]=None, use_avro_logical_types: typing.Optional[bool]=None) -> None:
        """
        :param destination_uris: A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
        :param compression: The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE. The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.
        :param destination_format: The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models. The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV. The default value for models is SAVED_MODEL.
        :param field_delimiter: When extracting data in CSV format, this defines the delimiter to use between fields in the exported data. Default is ','
        :param print_header: Whether to print out a header row in the results. Default is true.
        :param source_model: source_model block.
        :param source_table: source_table block.
        :param use_avro_logical_types: Whether to use logical types when extracting to AVRO format.
        """
        self._values = {
            'destination_uris': destination_uris,
        }
        if compression is not None: self._values["compression"] = compression
        if destination_format is not None: self._values["destination_format"] = destination_format
        if field_delimiter is not None: self._values["field_delimiter"] = field_delimiter
        if print_header is not None: self._values["print_header"] = print_header
        if source_model is not None: self._values["source_model"] = source_model
        if source_table is not None: self._values["source_table"] = source_table
        if use_avro_logical_types is not None: self._values["use_avro_logical_types"] = use_avro_logical_types

    @builtins.property
    def destination_uris(self) -> typing.List[str]:
        """A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written."""
        return self._values.get('destination_uris')

    @builtins.property
    def compression(self) -> typing.Optional[str]:
        """The compression type to use for exported files.

        Possible values include GZIP, DEFLATE, SNAPPY, and NONE.
        The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.
        """
        return self._values.get('compression')

    @builtins.property
    def destination_format(self) -> typing.Optional[str]:
        """The exported file format.

        Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models.
        The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV.
        The default value for models is SAVED_MODEL.
        """
        return self._values.get('destination_format')

    @builtins.property
    def field_delimiter(self) -> typing.Optional[str]:
        """When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.

        Default is ','
        """
        return self._values.get('field_delimiter')

    @builtins.property
    def print_header(self) -> typing.Optional[bool]:
        """Whether to print out a header row in the results.

        Default is true.
        """
        return self._values.get('print_header')

    @builtins.property
    def source_model(self) -> typing.Optional[typing.List["BigqueryJobExtractSourceModel"]]:
        """source_model block."""
        return self._values.get('source_model')

    @builtins.property
    def source_table(self) -> typing.Optional[typing.List["BigqueryJobExtractSourceTable"]]:
        """source_table block."""
        return self._values.get('source_table')

    @builtins.property
    def use_avro_logical_types(self) -> typing.Optional[bool]:
        """Whether to use logical types when extracting to AVRO format."""
        return self._values.get('use_avro_logical_types')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobExtract(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobExtractSourceModel", jsii_struct_bases=[], name_mapping={'dataset_id': 'datasetId', 'model_id': 'modelId', 'project_id': 'projectId'})
class BigqueryJobExtractSourceModel():
    def __init__(self, *, dataset_id: str, model_id: str, project_id: str) -> None:
        """
        :param dataset_id: The ID of the dataset containing this model.
        :param model_id: The ID of the model.
        :param project_id: The ID of the project containing this model.
        """
        self._values = {
            'dataset_id': dataset_id,
            'model_id': model_id,
            'project_id': project_id,
        }

    @builtins.property
    def dataset_id(self) -> str:
        """The ID of the dataset containing this model."""
        return self._values.get('dataset_id')

    @builtins.property
    def model_id(self) -> str:
        """The ID of the model."""
        return self._values.get('model_id')

    @builtins.property
    def project_id(self) -> str:
        """The ID of the project containing this model."""
        return self._values.get('project_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobExtractSourceModel(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobExtractSourceTable", jsii_struct_bases=[], name_mapping={'table_id': 'tableId', 'dataset_id': 'datasetId', 'project_id': 'projectId'})
class BigqueryJobExtractSourceTable():
    def __init__(self, *, table_id: str, dataset_id: typing.Optional[str]=None, project_id: typing.Optional[str]=None) -> None:
        """
        :param table_id: The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        :param dataset_id: The ID of the dataset containing this table.
        :param project_id: The ID of the project containing this table.
        """
        self._values = {
            'table_id': table_id,
        }
        if dataset_id is not None: self._values["dataset_id"] = dataset_id
        if project_id is not None: self._values["project_id"] = project_id

    @builtins.property
    def table_id(self) -> str:
        """The table.

        Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
        or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        """
        return self._values.get('table_id')

    @builtins.property
    def dataset_id(self) -> typing.Optional[str]:
        """The ID of the dataset containing this table."""
        return self._values.get('dataset_id')

    @builtins.property
    def project_id(self) -> typing.Optional[str]:
        """The ID of the project containing this table."""
        return self._values.get('project_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobExtractSourceTable(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobLoad", jsii_struct_bases=[], name_mapping={'destination_table': 'destinationTable', 'source_uris': 'sourceUris', 'allow_jagged_rows': 'allowJaggedRows', 'allow_quoted_newlines': 'allowQuotedNewlines', 'autodetect': 'autodetect', 'create_disposition': 'createDisposition', 'destination_encryption_configuration': 'destinationEncryptionConfiguration', 'encoding': 'encoding', 'field_delimiter': 'fieldDelimiter', 'ignore_unknown_values': 'ignoreUnknownValues', 'max_bad_records': 'maxBadRecords', 'null_marker': 'nullMarker', 'projection_fields': 'projectionFields', 'quote': 'quote', 'schema_update_options': 'schemaUpdateOptions', 'skip_leading_rows': 'skipLeadingRows', 'source_format': 'sourceFormat', 'time_partitioning': 'timePartitioning', 'write_disposition': 'writeDisposition'})
class BigqueryJobLoad():
    def __init__(self, *, destination_table: typing.List["BigqueryJobLoadDestinationTable"], source_uris: typing.List[str], allow_jagged_rows: typing.Optional[bool]=None, allow_quoted_newlines: typing.Optional[bool]=None, autodetect: typing.Optional[bool]=None, create_disposition: typing.Optional[str]=None, destination_encryption_configuration: typing.Optional[typing.List["BigqueryJobLoadDestinationEncryptionConfiguration"]]=None, encoding: typing.Optional[str]=None, field_delimiter: typing.Optional[str]=None, ignore_unknown_values: typing.Optional[bool]=None, max_bad_records: typing.Optional[jsii.Number]=None, null_marker: typing.Optional[str]=None, projection_fields: typing.Optional[typing.List[str]]=None, quote: typing.Optional[str]=None, schema_update_options: typing.Optional[typing.List[str]]=None, skip_leading_rows: typing.Optional[jsii.Number]=None, source_format: typing.Optional[str]=None, time_partitioning: typing.Optional[typing.List["BigqueryJobLoadTimePartitioning"]]=None, write_disposition: typing.Optional[str]=None) -> None:
        """
        :param destination_table: destination_table block.
        :param source_uris: The fully-qualified URIs that point to your data in Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character and it must come after the 'bucket' name. Size limits related to load jobs apply to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        :param allow_jagged_rows: Accept rows that are missing trailing optional columns. The missing values are treated as nulls. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        :param allow_quoted_newlines: Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        :param autodetect: Indicates if we should automatically infer the options and schema for CSV and JSON sources.
        :param create_disposition: Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
        :param destination_encryption_configuration: destination_encryption_configuration block.
        :param encoding: The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
        :param field_delimiter: The separator for fields in a CSV file. The separator can be any ISO-8859-1 single-byte character. To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
        :param ignore_unknown_values: Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false. The sourceFormat property determines what BigQuery treats as an extra value: CSV: Trailing columns JSON: Named values that don't match any column names
        :param max_bad_records: The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value, an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.
        :param null_marker: Specifies a string that represents a null value in a CSV file. For example, if you specify "\N", BigQuery interprets "\N" as a null value when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as an empty value.
        :param projection_fields: If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup. Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties. If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        :param quote: The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        :param schema_update_options: Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param skip_leading_rows: The number of rows at the top of a CSV file that BigQuery will skip when loading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped. When autodetect is on, the behavior is the following: skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        :param source_format: The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP". For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET". For orc, specify "ORC". The default value is CSV.
        :param time_partitioning: time_partitioning block.
        :param write_disposition: Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
        """
        self._values = {
            'destination_table': destination_table,
            'source_uris': source_uris,
        }
        if allow_jagged_rows is not None: self._values["allow_jagged_rows"] = allow_jagged_rows
        if allow_quoted_newlines is not None: self._values["allow_quoted_newlines"] = allow_quoted_newlines
        if autodetect is not None: self._values["autodetect"] = autodetect
        if create_disposition is not None: self._values["create_disposition"] = create_disposition
        if destination_encryption_configuration is not None: self._values["destination_encryption_configuration"] = destination_encryption_configuration
        if encoding is not None: self._values["encoding"] = encoding
        if field_delimiter is not None: self._values["field_delimiter"] = field_delimiter
        if ignore_unknown_values is not None: self._values["ignore_unknown_values"] = ignore_unknown_values
        if max_bad_records is not None: self._values["max_bad_records"] = max_bad_records
        if null_marker is not None: self._values["null_marker"] = null_marker
        if projection_fields is not None: self._values["projection_fields"] = projection_fields
        if quote is not None: self._values["quote"] = quote
        if schema_update_options is not None: self._values["schema_update_options"] = schema_update_options
        if skip_leading_rows is not None: self._values["skip_leading_rows"] = skip_leading_rows
        if source_format is not None: self._values["source_format"] = source_format
        if time_partitioning is not None: self._values["time_partitioning"] = time_partitioning
        if write_disposition is not None: self._values["write_disposition"] = write_disposition

    @builtins.property
    def destination_table(self) -> typing.List["BigqueryJobLoadDestinationTable"]:
        """destination_table block."""
        return self._values.get('destination_table')

    @builtins.property
    def source_uris(self) -> typing.List[str]:
        """The fully-qualified URIs that point to your data in Google Cloud.

        For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character
        and it must come after the 'bucket' name. Size limits related to load jobs apply
        to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be
        specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
        For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        """
        return self._values.get('source_uris')

    @builtins.property
    def allow_jagged_rows(self) -> typing.Optional[bool]:
        """Accept rows that are missing trailing optional columns.

        The missing values are treated as nulls.
        If false, records with missing trailing columns are treated as bad records, and if there are too many bad records,
        an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        """
        return self._values.get('allow_jagged_rows')

    @builtins.property
    def allow_quoted_newlines(self) -> typing.Optional[bool]:
        """Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.

        The default value is false.
        """
        return self._values.get('allow_quoted_newlines')

    @builtins.property
    def autodetect(self) -> typing.Optional[bool]:
        """Indicates if we should automatically infer the options and schema for CSV and JSON sources."""
        return self._values.get('autodetect')

    @builtins.property
    def create_disposition(self) -> typing.Optional[str]:
        """Specifies whether the job is allowed to create new tables.

        The following values are supported:
        CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
        CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
        Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
        """
        return self._values.get('create_disposition')

    @builtins.property
    def destination_encryption_configuration(self) -> typing.Optional[typing.List["BigqueryJobLoadDestinationEncryptionConfiguration"]]:
        """destination_encryption_configuration block."""
        return self._values.get('destination_encryption_configuration')

    @builtins.property
    def encoding(self) -> typing.Optional[str]:
        """The character encoding of the data.

        The supported values are UTF-8 or ISO-8859-1.
        The default value is UTF-8. BigQuery decodes the data after the raw, binary data
        has been split using the values of the quote and fieldDelimiter properties.
        """
        return self._values.get('encoding')

    @builtins.property
    def field_delimiter(self) -> typing.Optional[str]:
        """The separator for fields in a CSV file.

        The separator can be any ISO-8859-1 single-byte character.
        To use a character in the range 128-255, you must encode the character as UTF8. BigQuery converts
        the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the
        data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator.
        The default value is a comma (',').
        """
        return self._values.get('field_delimiter')

    @builtins.property
    def ignore_unknown_values(self) -> typing.Optional[bool]:
        """Indicates if BigQuery should allow extra values that are not represented in the table schema.

        If true, the extra values are ignored. If false, records with extra columns are treated as bad records,
        and if there are too many bad records, an invalid error is returned in the job result.
        The default value is false. The sourceFormat property determines what BigQuery treats as an extra value:
        CSV: Trailing columns
        JSON: Named values that don't match any column names
        """
        return self._values.get('ignore_unknown_values')

    @builtins.property
    def max_bad_records(self) -> typing.Optional[jsii.Number]:
        """The maximum number of bad records that BigQuery can ignore when running the job.

        If the number of bad records exceeds this value,
        an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.
        """
        return self._values.get('max_bad_records')

    @builtins.property
    def null_marker(self) -> typing.Optional[str]:
        """Specifies a string that represents a null value in a CSV file.

        For example, if you specify "\N", BigQuery interprets "\N" as a null value
        when loading a CSV file. The default value is the empty string. If you set this property to a custom value, BigQuery throws an error if an
        empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as
        an empty value.
        """
        return self._values.get('null_marker')

    @builtins.property
    def projection_fields(self) -> typing.Optional[typing.List[str]]:
        """If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup.

        Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties.
        If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        """
        return self._values.get('projection_fields')

    @builtins.property
    def quote(self) -> typing.Optional[str]:
        """The value that is used to quote data sections in a CSV file.

        BigQuery converts the string to ISO-8859-1 encoding,
        and then uses the first byte of the encoded string to split the data in its raw, binary state.
        The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string.
        If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        """
        return self._values.get('quote')

    @builtins.property
    def schema_update_options(self) -> typing.Optional[typing.List[str]]:
        """Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or supplied in the job configuration.

        Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
        when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
        For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
        ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
        ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return self._values.get('schema_update_options')

    @builtins.property
    def skip_leading_rows(self) -> typing.Optional[jsii.Number]:
        """The number of rows at the top of a CSV file that BigQuery will skip when loading the data.

        The default value is 0. This property is useful if you have header rows in the file that should be skipped.
        When autodetect is on, the behavior is the following:
        skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
        the row is read as data. Otherwise data is read starting from the second row.
        skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row.
        skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected,
        row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        return self._values.get('skip_leading_rows')

    @builtins.property
    def source_format(self) -> typing.Optional[str]:
        """The format of the data files.

        For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP".
        For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET".
        For orc, specify "ORC". The default value is CSV.
        """
        return self._values.get('source_format')

    @builtins.property
    def time_partitioning(self) -> typing.Optional[typing.List["BigqueryJobLoadTimePartitioning"]]:
        """time_partitioning block."""
        return self._values.get('time_partitioning')

    @builtins.property
    def write_disposition(self) -> typing.Optional[str]:
        """Specifies the action that occurs if the destination table already exists.

        The following values are supported:
        WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
        WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
        WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
        Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
        Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
        """
        return self._values.get('write_disposition')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobLoad(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobLoadDestinationEncryptionConfiguration", jsii_struct_bases=[], name_mapping={'kms_key_name': 'kmsKeyName'})
class BigqueryJobLoadDestinationEncryptionConfiguration():
    def __init__(self, *, kms_key_name: str) -> None:
        """
        :param kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        self._values = {
            'kms_key_name': kms_key_name,
        }

    @builtins.property
    def kms_key_name(self) -> str:
        """Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.

        The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return self._values.get('kms_key_name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobLoadDestinationEncryptionConfiguration(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobLoadDestinationTable", jsii_struct_bases=[], name_mapping={'table_id': 'tableId', 'dataset_id': 'datasetId', 'project_id': 'projectId'})
class BigqueryJobLoadDestinationTable():
    def __init__(self, *, table_id: str, dataset_id: typing.Optional[str]=None, project_id: typing.Optional[str]=None) -> None:
        """
        :param table_id: The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        :param dataset_id: The ID of the dataset containing this table.
        :param project_id: The ID of the project containing this table.
        """
        self._values = {
            'table_id': table_id,
        }
        if dataset_id is not None: self._values["dataset_id"] = dataset_id
        if project_id is not None: self._values["project_id"] = project_id

    @builtins.property
    def table_id(self) -> str:
        """The table.

        Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
        or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        """
        return self._values.get('table_id')

    @builtins.property
    def dataset_id(self) -> typing.Optional[str]:
        """The ID of the dataset containing this table."""
        return self._values.get('dataset_id')

    @builtins.property
    def project_id(self) -> typing.Optional[str]:
        """The ID of the project containing this table."""
        return self._values.get('project_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobLoadDestinationTable(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobLoadTimePartitioning", jsii_struct_bases=[], name_mapping={'type': 'type', 'expiration_ms': 'expirationMs', 'field': 'field'})
class BigqueryJobLoadTimePartitioning():
    def __init__(self, *, type: str, expiration_ms: typing.Optional[str]=None, field: typing.Optional[str]=None) -> None:
        """
        :param type: The only type supported is DAY, which will generate one partition per day. Providing an empty string used to cause an error, but in OnePlatform the field will be treated as unset.
        :param expiration_ms: Number of milliseconds for which to keep the storage for a partition. A wrapper is used here because 0 is an invalid value.
        :param field: If not set, the table is partitioned by pseudo column '_PARTITIONTIME'; if set, the table is partitioned by this field. The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED. A wrapper is used here because an empty string is an invalid value.
        """
        self._values = {
            'type': type,
        }
        if expiration_ms is not None: self._values["expiration_ms"] = expiration_ms
        if field is not None: self._values["field"] = field

    @builtins.property
    def type(self) -> str:
        """The only type supported is DAY, which will generate one partition per day.

        Providing an empty string used to cause an error,
        but in OnePlatform the field will be treated as unset.
        """
        return self._values.get('type')

    @builtins.property
    def expiration_ms(self) -> typing.Optional[str]:
        """Number of milliseconds for which to keep the storage for a partition.

        A wrapper is used here because 0 is an invalid value.
        """
        return self._values.get('expiration_ms')

    @builtins.property
    def field(self) -> typing.Optional[str]:
        """If not set, the table is partitioned by pseudo column '_PARTITIONTIME';

        if set, the table is partitioned by this field.
        The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
        A wrapper is used here because an empty string is an invalid value.
        """
        return self._values.get('field')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobLoadTimePartitioning(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobQuery", jsii_struct_bases=[], name_mapping={'query': 'query', 'allow_large_results': 'allowLargeResults', 'create_disposition': 'createDisposition', 'default_dataset': 'defaultDataset', 'destination_encryption_configuration': 'destinationEncryptionConfiguration', 'destination_table': 'destinationTable', 'flatten_results': 'flattenResults', 'maximum_billing_tier': 'maximumBillingTier', 'maximum_bytes_billed': 'maximumBytesBilled', 'parameter_mode': 'parameterMode', 'priority': 'priority', 'schema_update_options': 'schemaUpdateOptions', 'script_options': 'scriptOptions', 'use_legacy_sql': 'useLegacySql', 'use_query_cache': 'useQueryCache', 'user_defined_function_resources': 'userDefinedFunctionResources', 'write_disposition': 'writeDisposition'})
class BigqueryJobQuery():
    def __init__(self, *, query: str, allow_large_results: typing.Optional[bool]=None, create_disposition: typing.Optional[str]=None, default_dataset: typing.Optional[typing.List["BigqueryJobQueryDefaultDataset"]]=None, destination_encryption_configuration: typing.Optional[typing.List["BigqueryJobQueryDestinationEncryptionConfiguration"]]=None, destination_table: typing.Optional[typing.List["BigqueryJobQueryDestinationTable"]]=None, flatten_results: typing.Optional[bool]=None, maximum_billing_tier: typing.Optional[jsii.Number]=None, maximum_bytes_billed: typing.Optional[str]=None, parameter_mode: typing.Optional[str]=None, priority: typing.Optional[str]=None, schema_update_options: typing.Optional[typing.List[str]]=None, script_options: typing.Optional[typing.List["BigqueryJobQueryScriptOptions"]]=None, use_legacy_sql: typing.Optional[bool]=None, use_query_cache: typing.Optional[bool]=None, user_defined_function_resources: typing.Optional[typing.List["BigqueryJobQueryUserDefinedFunctionResources"]]=None, write_disposition: typing.Optional[str]=None) -> None:
        """
        :param query: SQL query text to execute. The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
        :param allow_large_results: If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance. Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed. However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        :param create_disposition: Specifies whether the job is allowed to create new tables. The following values are supported: CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table. CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result. Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
        :param default_dataset: default_dataset block.
        :param destination_encryption_configuration: destination_encryption_configuration block.
        :param destination_table: destination_table block.
        :param flatten_results: If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results. allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        :param maximum_billing_tier: Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge). If unspecified, this will be set to your project default.
        :param maximum_bytes_billed: Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge). If unspecified, this will be set to your project default.
        :param parameter_mode: Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        :param priority: Specifies a priority for the query. Default value: "INTERACTIVE" Possible values: ["INTERACTIVE", "BATCH"]
        :param schema_update_options: Allows the schema of the destination table to be updated as a side effect of the query job. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified: ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema. ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param script_options: script_options block.
        :param use_legacy_sql: Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true. If set to false, the query will use BigQuery's standard SQL.
        :param use_query_cache: Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified. The default value is true.
        :param user_defined_function_resources: user_defined_function_resources block.
        :param write_disposition: Specifies the action that occurs if the destination table already exists. The following values are supported: WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result. WRITE_APPEND: If the table already exists, BigQuery appends the data to the table. WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result. Each action is atomic and only occurs if BigQuery is able to complete the job successfully. Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
        """
        self._values = {
            'query': query,
        }
        if allow_large_results is not None: self._values["allow_large_results"] = allow_large_results
        if create_disposition is not None: self._values["create_disposition"] = create_disposition
        if default_dataset is not None: self._values["default_dataset"] = default_dataset
        if destination_encryption_configuration is not None: self._values["destination_encryption_configuration"] = destination_encryption_configuration
        if destination_table is not None: self._values["destination_table"] = destination_table
        if flatten_results is not None: self._values["flatten_results"] = flatten_results
        if maximum_billing_tier is not None: self._values["maximum_billing_tier"] = maximum_billing_tier
        if maximum_bytes_billed is not None: self._values["maximum_bytes_billed"] = maximum_bytes_billed
        if parameter_mode is not None: self._values["parameter_mode"] = parameter_mode
        if priority is not None: self._values["priority"] = priority
        if schema_update_options is not None: self._values["schema_update_options"] = schema_update_options
        if script_options is not None: self._values["script_options"] = script_options
        if use_legacy_sql is not None: self._values["use_legacy_sql"] = use_legacy_sql
        if use_query_cache is not None: self._values["use_query_cache"] = use_query_cache
        if user_defined_function_resources is not None: self._values["user_defined_function_resources"] = user_defined_function_resources
        if write_disposition is not None: self._values["write_disposition"] = write_disposition

    @builtins.property
    def query(self) -> str:
        """SQL query text to execute.

        The useLegacySql field can be used to indicate whether the query uses legacy SQL or standard SQL.
        """
        return self._values.get('query')

    @builtins.property
    def allow_large_results(self) -> typing.Optional[bool]:
        """If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.

        Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
        However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        """
        return self._values.get('allow_large_results')

    @builtins.property
    def create_disposition(self) -> typing.Optional[str]:
        """Specifies whether the job is allowed to create new tables.

        The following values are supported:
        CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
        CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
        Creation, truncation and append actions occur as one atomic update upon job completion Default value: "CREATE_IF_NEEDED" Possible values: ["CREATE_IF_NEEDED", "CREATE_NEVER"]
        """
        return self._values.get('create_disposition')

    @builtins.property
    def default_dataset(self) -> typing.Optional[typing.List["BigqueryJobQueryDefaultDataset"]]:
        """default_dataset block."""
        return self._values.get('default_dataset')

    @builtins.property
    def destination_encryption_configuration(self) -> typing.Optional[typing.List["BigqueryJobQueryDestinationEncryptionConfiguration"]]:
        """destination_encryption_configuration block."""
        return self._values.get('destination_encryption_configuration')

    @builtins.property
    def destination_table(self) -> typing.Optional[typing.List["BigqueryJobQueryDestinationTable"]]:
        """destination_table block."""
        return self._values.get('destination_table')

    @builtins.property
    def flatten_results(self) -> typing.Optional[bool]:
        """If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.

        allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        """
        return self._values.get('flatten_results')

    @builtins.property
    def maximum_billing_tier(self) -> typing.Optional[jsii.Number]:
        """Limits the billing tier for this job.

        Queries that have resource usage beyond this tier will fail (without incurring a charge).
        If unspecified, this will be set to your project default.
        """
        return self._values.get('maximum_billing_tier')

    @builtins.property
    def maximum_bytes_billed(self) -> typing.Optional[str]:
        """Limits the bytes billed for this job.

        Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
        If unspecified, this will be set to your project default.
        """
        return self._values.get('maximum_bytes_billed')

    @builtins.property
    def parameter_mode(self) -> typing.Optional[str]:
        """Standard SQL only.

        Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        """
        return self._values.get('parameter_mode')

    @builtins.property
    def priority(self) -> typing.Optional[str]:
        """Specifies a priority for the query.

        Default value: "INTERACTIVE" Possible values: ["INTERACTIVE", "BATCH"]
        """
        return self._values.get('priority')

    @builtins.property
    def schema_update_options(self) -> typing.Optional[typing.List[str]]:
        """Allows the schema of the destination table to be updated as a side effect of the query job.

        Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
        when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table,
        specified by partition decorators. For normal tables, WRITE_TRUNCATE will always overwrite the schema.
        One or more of the following values are specified:
        ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
        ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return self._values.get('schema_update_options')

    @builtins.property
    def script_options(self) -> typing.Optional[typing.List["BigqueryJobQueryScriptOptions"]]:
        """script_options block."""
        return self._values.get('script_options')

    @builtins.property
    def use_legacy_sql(self) -> typing.Optional[bool]:
        """Specifies whether to use BigQuery's legacy SQL dialect for this query.

        The default value is true.
        If set to false, the query will use BigQuery's standard SQL.
        """
        return self._values.get('use_legacy_sql')

    @builtins.property
    def use_query_cache(self) -> typing.Optional[bool]:
        """Whether to look for the result in the query cache.

        The query cache is a best-effort cache that will be flushed whenever
        tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
        The default value is true.
        """
        return self._values.get('use_query_cache')

    @builtins.property
    def user_defined_function_resources(self) -> typing.Optional[typing.List["BigqueryJobQueryUserDefinedFunctionResources"]]:
        """user_defined_function_resources block."""
        return self._values.get('user_defined_function_resources')

    @builtins.property
    def write_disposition(self) -> typing.Optional[str]:
        """Specifies the action that occurs if the destination table already exists.

        The following values are supported:
        WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
        WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
        WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
        Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
        Creation, truncation and append actions occur as one atomic update upon job completion. Default value: "WRITE_EMPTY" Possible values: ["WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"]
        """
        return self._values.get('write_disposition')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobQuery(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobQueryDefaultDataset", jsii_struct_bases=[], name_mapping={'dataset_id': 'datasetId', 'project_id': 'projectId'})
class BigqueryJobQueryDefaultDataset():
    def __init__(self, *, dataset_id: str, project_id: typing.Optional[str]=None) -> None:
        """
        :param dataset_id: The dataset. Can be specified '{{dataset_id}}' if 'project_id' is also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}' if not.
        :param project_id: The ID of the project containing this table.
        """
        self._values = {
            'dataset_id': dataset_id,
        }
        if project_id is not None: self._values["project_id"] = project_id

    @builtins.property
    def dataset_id(self) -> str:
        """The dataset.

        Can be specified '{{dataset_id}}' if 'project_id' is also set,
        or of the form 'projects/{{project}}/datasets/{{dataset_id}}' if not.
        """
        return self._values.get('dataset_id')

    @builtins.property
    def project_id(self) -> typing.Optional[str]:
        """The ID of the project containing this table."""
        return self._values.get('project_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobQueryDefaultDataset(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobQueryDestinationEncryptionConfiguration", jsii_struct_bases=[], name_mapping={'kms_key_name': 'kmsKeyName'})
class BigqueryJobQueryDestinationEncryptionConfiguration():
    def __init__(self, *, kms_key_name: str) -> None:
        """
        :param kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        self._values = {
            'kms_key_name': kms_key_name,
        }

    @builtins.property
    def kms_key_name(self) -> str:
        """Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.

        The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return self._values.get('kms_key_name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobQueryDestinationEncryptionConfiguration(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobQueryDestinationTable", jsii_struct_bases=[], name_mapping={'table_id': 'tableId', 'dataset_id': 'datasetId', 'project_id': 'projectId'})
class BigqueryJobQueryDestinationTable():
    def __init__(self, *, table_id: str, dataset_id: typing.Optional[str]=None, project_id: typing.Optional[str]=None) -> None:
        """
        :param table_id: The table. Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set, or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        :param dataset_id: The ID of the dataset containing this table.
        :param project_id: The ID of the project containing this table.
        """
        self._values = {
            'table_id': table_id,
        }
        if dataset_id is not None: self._values["dataset_id"] = dataset_id
        if project_id is not None: self._values["project_id"] = project_id

    @builtins.property
    def table_id(self) -> str:
        """The table.

        Can be specified '{{table_id}}' if 'project_id' and 'dataset_id' are also set,
        or of the form 'projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}' if not.
        """
        return self._values.get('table_id')

    @builtins.property
    def dataset_id(self) -> typing.Optional[str]:
        """The ID of the dataset containing this table."""
        return self._values.get('dataset_id')

    @builtins.property
    def project_id(self) -> typing.Optional[str]:
        """The ID of the project containing this table."""
        return self._values.get('project_id')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobQueryDestinationTable(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobQueryScriptOptions", jsii_struct_bases=[], name_mapping={'key_result_statement': 'keyResultStatement', 'statement_byte_budget': 'statementByteBudget', 'statement_timeout_ms': 'statementTimeoutMs'})
class BigqueryJobQueryScriptOptions():
    def __init__(self, *, key_result_statement: typing.Optional[str]=None, statement_byte_budget: typing.Optional[str]=None, statement_timeout_ms: typing.Optional[str]=None) -> None:
        """
        :param key_result_statement: Determines which statement in the script represents the "key result", used to populate the schema and query results of the script job. Possible values: ["LAST", "FIRST_SELECT"]
        :param statement_byte_budget: Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
        :param statement_timeout_ms: Timeout period for each statement in a script.
        """
        self._values = {
        }
        if key_result_statement is not None: self._values["key_result_statement"] = key_result_statement
        if statement_byte_budget is not None: self._values["statement_byte_budget"] = statement_byte_budget
        if statement_timeout_ms is not None: self._values["statement_timeout_ms"] = statement_timeout_ms

    @builtins.property
    def key_result_statement(self) -> typing.Optional[str]:
        """Determines which statement in the script represents the "key result", used to populate the schema and query results of the script job.

        Possible values: ["LAST", "FIRST_SELECT"]
        """
        return self._values.get('key_result_statement')

    @builtins.property
    def statement_byte_budget(self) -> typing.Optional[str]:
        """Limit on the number of bytes billed per statement.

        Exceeding this budget results in an error.
        """
        return self._values.get('statement_byte_budget')

    @builtins.property
    def statement_timeout_ms(self) -> typing.Optional[str]:
        """Timeout period for each statement in a script."""
        return self._values.get('statement_timeout_ms')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobQueryScriptOptions(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobQueryUserDefinedFunctionResources", jsii_struct_bases=[], name_mapping={'inline_code': 'inlineCode', 'resource_uri': 'resourceUri'})
class BigqueryJobQueryUserDefinedFunctionResources():
    def __init__(self, *, inline_code: typing.Optional[str]=None, resource_uri: typing.Optional[str]=None) -> None:
        """
        :param inline_code: An inline resource that contains code for a user-defined function (UDF). Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        :param resource_uri: A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
        """
        self._values = {
        }
        if inline_code is not None: self._values["inline_code"] = inline_code
        if resource_uri is not None: self._values["resource_uri"] = resource_uri

    @builtins.property
    def inline_code(self) -> typing.Optional[str]:
        """An inline resource that contains code for a user-defined function (UDF).

        Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        """
        return self._values.get('inline_code')

    @builtins.property
    def resource_uri(self) -> typing.Optional[str]:
        """A code resource to load from a Google Cloud Storage URI (gs://bucket/path)."""
        return self._values.get('resource_uri')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobQueryUserDefinedFunctionResources(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryJobTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete'})
class BigqueryJobTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryJobTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigqueryTable(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigqueryTable"):
    def __init__(self, scope: constructs.Construct, id: str, *, dataset_id: str, table_id: str, clustering: typing.Optional[typing.List[str]]=None, description: typing.Optional[str]=None, encryption_configuration: typing.Optional[typing.List["BigqueryTableEncryptionConfiguration"]]=None, expiration_time: typing.Optional[jsii.Number]=None, external_data_configuration: typing.Optional[typing.List["BigqueryTableExternalDataConfiguration"]]=None, friendly_name: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, project: typing.Optional[str]=None, range_partitioning: typing.Optional[typing.List["BigqueryTableRangePartitioning"]]=None, schema: typing.Optional[str]=None, time_partitioning: typing.Optional[typing.List["BigqueryTableTimePartitioning"]]=None, view: typing.Optional[typing.List["BigqueryTableView"]]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param dataset_id: The dataset ID to create the table in. Changing this forces a new resource to be created.
        :param table_id: A unique ID for the resource. Changing this forces a new resource to be created.
        :param clustering: Specifies column names to use for data clustering. Up to four top-level columns are allowed, and should be specified in descending priority order.
        :param description: The field description.
        :param encryption_configuration: encryption_configuration block.
        :param expiration_time: The time when this table expires, in milliseconds since the epoch. If not present, the table will persist indefinitely. Expired tables will be deleted and their storage reclaimed.
        :param external_data_configuration: external_data_configuration block.
        :param friendly_name: A descriptive name for the table.
        :param labels: A mapping of labels to assign to the resource.
        :param project: The ID of the project in which the resource belongs.
        :param range_partitioning: range_partitioning block.
        :param schema: A JSON schema for the table.
        :param time_partitioning: time_partitioning block.
        :param view: view block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigqueryTableConfig(dataset_id=dataset_id, table_id=table_id, clustering=clustering, description=description, encryption_configuration=encryption_configuration, expiration_time=expiration_time, external_data_configuration=external_data_configuration, friendly_name=friendly_name, labels=labels, project=project, range_partitioning=range_partitioning, schema=schema, time_partitioning=time_partitioning, view=view, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigqueryTable, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="creationTime")
    def creation_time(self) -> jsii.Number:
        return jsii.get(self, "creationTime")

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="lastModifiedTime")
    def last_modified_time(self) -> jsii.Number:
        return jsii.get(self, "lastModifiedTime")

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> str:
        return jsii.get(self, "location")

    @builtins.property
    @jsii.member(jsii_name="numBytes")
    def num_bytes(self) -> jsii.Number:
        return jsii.get(self, "numBytes")

    @builtins.property
    @jsii.member(jsii_name="numLongTermBytes")
    def num_long_term_bytes(self) -> jsii.Number:
        return jsii.get(self, "numLongTermBytes")

    @builtins.property
    @jsii.member(jsii_name="numRows")
    def num_rows(self) -> jsii.Number:
        return jsii.get(self, "numRows")

    @builtins.property
    @jsii.member(jsii_name="selfLink")
    def self_link(self) -> str:
        return jsii.get(self, "selfLink")

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> str:
        return jsii.get(self, "type")

    @builtins.property
    @jsii.member(jsii_name="datasetId")
    def dataset_id(self) -> str:
        return jsii.get(self, "datasetId")

    @dataset_id.setter
    def dataset_id(self, value: str) -> None:
        jsii.set(self, "datasetId", value)

    @builtins.property
    @jsii.member(jsii_name="tableId")
    def table_id(self) -> str:
        return jsii.get(self, "tableId")

    @table_id.setter
    def table_id(self, value: str) -> None:
        jsii.set(self, "tableId", value)

    @builtins.property
    @jsii.member(jsii_name="clustering")
    def clustering(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "clustering")

    @clustering.setter
    def clustering(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "clustering", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="encryptionConfiguration")
    def encryption_configuration(self) -> typing.Optional[typing.List["BigqueryTableEncryptionConfiguration"]]:
        return jsii.get(self, "encryptionConfiguration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: typing.Optional[typing.List["BigqueryTableEncryptionConfiguration"]]) -> None:
        jsii.set(self, "encryptionConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="expirationTime")
    def expiration_time(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "expirationTime")

    @expiration_time.setter
    def expiration_time(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "expirationTime", value)

    @builtins.property
    @jsii.member(jsii_name="externalDataConfiguration")
    def external_data_configuration(self) -> typing.Optional[typing.List["BigqueryTableExternalDataConfiguration"]]:
        return jsii.get(self, "externalDataConfiguration")

    @external_data_configuration.setter
    def external_data_configuration(self, value: typing.Optional[typing.List["BigqueryTableExternalDataConfiguration"]]) -> None:
        jsii.set(self, "externalDataConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="friendlyName")
    def friendly_name(self) -> typing.Optional[str]:
        return jsii.get(self, "friendlyName")

    @friendly_name.setter
    def friendly_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "friendlyName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="labels")
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "labels")

    @labels.setter
    def labels(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "labels", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="rangePartitioning")
    def range_partitioning(self) -> typing.Optional[typing.List["BigqueryTableRangePartitioning"]]:
        return jsii.get(self, "rangePartitioning")

    @range_partitioning.setter
    def range_partitioning(self, value: typing.Optional[typing.List["BigqueryTableRangePartitioning"]]) -> None:
        jsii.set(self, "rangePartitioning", value)

    @builtins.property
    @jsii.member(jsii_name="schema")
    def schema(self) -> typing.Optional[str]:
        return jsii.get(self, "schema")

    @schema.setter
    def schema(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "schema", value)

    @builtins.property
    @jsii.member(jsii_name="timePartitioning")
    def time_partitioning(self) -> typing.Optional[typing.List["BigqueryTableTimePartitioning"]]:
        return jsii.get(self, "timePartitioning")

    @time_partitioning.setter
    def time_partitioning(self, value: typing.Optional[typing.List["BigqueryTableTimePartitioning"]]) -> None:
        jsii.set(self, "timePartitioning", value)

    @builtins.property
    @jsii.member(jsii_name="view")
    def view(self) -> typing.Optional[typing.List["BigqueryTableView"]]:
        return jsii.get(self, "view")

    @view.setter
    def view(self, value: typing.Optional[typing.List["BigqueryTableView"]]) -> None:
        jsii.set(self, "view", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'dataset_id': 'datasetId', 'table_id': 'tableId', 'clustering': 'clustering', 'description': 'description', 'encryption_configuration': 'encryptionConfiguration', 'expiration_time': 'expirationTime', 'external_data_configuration': 'externalDataConfiguration', 'friendly_name': 'friendlyName', 'labels': 'labels', 'project': 'project', 'range_partitioning': 'rangePartitioning', 'schema': 'schema', 'time_partitioning': 'timePartitioning', 'view': 'view'})
class BigqueryTableConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, dataset_id: str, table_id: str, clustering: typing.Optional[typing.List[str]]=None, description: typing.Optional[str]=None, encryption_configuration: typing.Optional[typing.List["BigqueryTableEncryptionConfiguration"]]=None, expiration_time: typing.Optional[jsii.Number]=None, external_data_configuration: typing.Optional[typing.List["BigqueryTableExternalDataConfiguration"]]=None, friendly_name: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, project: typing.Optional[str]=None, range_partitioning: typing.Optional[typing.List["BigqueryTableRangePartitioning"]]=None, schema: typing.Optional[str]=None, time_partitioning: typing.Optional[typing.List["BigqueryTableTimePartitioning"]]=None, view: typing.Optional[typing.List["BigqueryTableView"]]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param dataset_id: The dataset ID to create the table in. Changing this forces a new resource to be created.
        :param table_id: A unique ID for the resource. Changing this forces a new resource to be created.
        :param clustering: Specifies column names to use for data clustering. Up to four top-level columns are allowed, and should be specified in descending priority order.
        :param description: The field description.
        :param encryption_configuration: encryption_configuration block.
        :param expiration_time: The time when this table expires, in milliseconds since the epoch. If not present, the table will persist indefinitely. Expired tables will be deleted and their storage reclaimed.
        :param external_data_configuration: external_data_configuration block.
        :param friendly_name: A descriptive name for the table.
        :param labels: A mapping of labels to assign to the resource.
        :param project: The ID of the project in which the resource belongs.
        :param range_partitioning: range_partitioning block.
        :param schema: A JSON schema for the table.
        :param time_partitioning: time_partitioning block.
        :param view: view block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'dataset_id': dataset_id,
            'table_id': table_id,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if clustering is not None: self._values["clustering"] = clustering
        if description is not None: self._values["description"] = description
        if encryption_configuration is not None: self._values["encryption_configuration"] = encryption_configuration
        if expiration_time is not None: self._values["expiration_time"] = expiration_time
        if external_data_configuration is not None: self._values["external_data_configuration"] = external_data_configuration
        if friendly_name is not None: self._values["friendly_name"] = friendly_name
        if labels is not None: self._values["labels"] = labels
        if project is not None: self._values["project"] = project
        if range_partitioning is not None: self._values["range_partitioning"] = range_partitioning
        if schema is not None: self._values["schema"] = schema
        if time_partitioning is not None: self._values["time_partitioning"] = time_partitioning
        if view is not None: self._values["view"] = view

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def dataset_id(self) -> str:
        """The dataset ID to create the table in.

        Changing this forces a new resource to be created.
        """
        return self._values.get('dataset_id')

    @builtins.property
    def table_id(self) -> str:
        """A unique ID for the resource.

        Changing this forces a new resource to be created.
        """
        return self._values.get('table_id')

    @builtins.property
    def clustering(self) -> typing.Optional[typing.List[str]]:
        """Specifies column names to use for data clustering.

        Up to four top-level columns are allowed, and should be specified in descending priority order.
        """
        return self._values.get('clustering')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """The field description."""
        return self._values.get('description')

    @builtins.property
    def encryption_configuration(self) -> typing.Optional[typing.List["BigqueryTableEncryptionConfiguration"]]:
        """encryption_configuration block."""
        return self._values.get('encryption_configuration')

    @builtins.property
    def expiration_time(self) -> typing.Optional[jsii.Number]:
        """The time when this table expires, in milliseconds since the epoch.

        If not present, the table will persist indefinitely. Expired tables will be deleted and their storage reclaimed.
        """
        return self._values.get('expiration_time')

    @builtins.property
    def external_data_configuration(self) -> typing.Optional[typing.List["BigqueryTableExternalDataConfiguration"]]:
        """external_data_configuration block."""
        return self._values.get('external_data_configuration')

    @builtins.property
    def friendly_name(self) -> typing.Optional[str]:
        """A descriptive name for the table."""
        return self._values.get('friendly_name')

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        """A mapping of labels to assign to the resource."""
        return self._values.get('labels')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        """The ID of the project in which the resource belongs."""
        return self._values.get('project')

    @builtins.property
    def range_partitioning(self) -> typing.Optional[typing.List["BigqueryTableRangePartitioning"]]:
        """range_partitioning block."""
        return self._values.get('range_partitioning')

    @builtins.property
    def schema(self) -> typing.Optional[str]:
        """A JSON schema for the table."""
        return self._values.get('schema')

    @builtins.property
    def time_partitioning(self) -> typing.Optional[typing.List["BigqueryTableTimePartitioning"]]:
        """time_partitioning block."""
        return self._values.get('time_partitioning')

    @builtins.property
    def view(self) -> typing.Optional[typing.List["BigqueryTableView"]]:
        """view block."""
        return self._values.get('view')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableEncryptionConfiguration", jsii_struct_bases=[], name_mapping={'kms_key_name': 'kmsKeyName'})
class BigqueryTableEncryptionConfiguration():
    def __init__(self, *, kms_key_name: str) -> None:
        """
        :param kms_key_name: The self link or full name of a key which should be used to encrypt this table. Note that the default bigquery service account will need to have encrypt/decrypt permissions on this key - you may want to see the google_bigquery_default_service_account datasource and the google_kms_crypto_key_iam_binding resource.
        """
        self._values = {
            'kms_key_name': kms_key_name,
        }

    @builtins.property
    def kms_key_name(self) -> str:
        """The self link or full name of a key which should be used to encrypt this table.

        Note that the default bigquery service account will need to have encrypt/decrypt permissions on this key - you may want to see the google_bigquery_default_service_account datasource and the google_kms_crypto_key_iam_binding resource.
        """
        return self._values.get('kms_key_name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableEncryptionConfiguration(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableExternalDataConfiguration", jsii_struct_bases=[], name_mapping={'autodetect': 'autodetect', 'source_format': 'sourceFormat', 'source_uris': 'sourceUris', 'compression': 'compression', 'csv_options': 'csvOptions', 'google_sheets_options': 'googleSheetsOptions', 'hive_partitioning_options': 'hivePartitioningOptions', 'ignore_unknown_values': 'ignoreUnknownValues', 'max_bad_records': 'maxBadRecords', 'schema': 'schema'})
class BigqueryTableExternalDataConfiguration():
    def __init__(self, *, autodetect: bool, source_format: str, source_uris: typing.List[str], compression: typing.Optional[str]=None, csv_options: typing.Optional[typing.List["BigqueryTableExternalDataConfigurationCsvOptions"]]=None, google_sheets_options: typing.Optional[typing.List["BigqueryTableExternalDataConfigurationGoogleSheetsOptions"]]=None, hive_partitioning_options: typing.Optional[typing.List["BigqueryTableExternalDataConfigurationHivePartitioningOptions"]]=None, ignore_unknown_values: typing.Optional[bool]=None, max_bad_records: typing.Optional[jsii.Number]=None, schema: typing.Optional[str]=None) -> None:
        """
        :param autodetect: Let BigQuery try to autodetect the schema and format of the table.
        :param source_format: The data format. Supported values are: "CSV", "GOOGLE_SHEETS", "NEWLINE_DELIMITED_JSON", "AVRO", "PARQUET", and "DATSTORE_BACKUP". To use "GOOGLE_SHEETS" the scopes must include "googleapis.com/auth/drive.readonly".
        :param source_uris: A list of the fully-qualified URIs that point to your data in Google Cloud.
        :param compression: The compression type of the data source. Valid values are "NONE" or "GZIP".
        :param csv_options: csv_options block.
        :param google_sheets_options: google_sheets_options block.
        :param hive_partitioning_options: hive_partitioning_options block.
        :param ignore_unknown_values: Indicates if BigQuery should allow extra values that are not represented in the table schema. If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
        :param max_bad_records: The maximum number of bad records that BigQuery can ignore when reading data.
        :param schema: A JSON schema for the external table. Schema is required for CSV and JSON formats and is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats when using external tables.
        """
        self._values = {
            'autodetect': autodetect,
            'source_format': source_format,
            'source_uris': source_uris,
        }
        if compression is not None: self._values["compression"] = compression
        if csv_options is not None: self._values["csv_options"] = csv_options
        if google_sheets_options is not None: self._values["google_sheets_options"] = google_sheets_options
        if hive_partitioning_options is not None: self._values["hive_partitioning_options"] = hive_partitioning_options
        if ignore_unknown_values is not None: self._values["ignore_unknown_values"] = ignore_unknown_values
        if max_bad_records is not None: self._values["max_bad_records"] = max_bad_records
        if schema is not None: self._values["schema"] = schema

    @builtins.property
    def autodetect(self) -> bool:
        """Let BigQuery try to autodetect the schema and format of the table."""
        return self._values.get('autodetect')

    @builtins.property
    def source_format(self) -> str:
        """The data format.

        Supported values are: "CSV", "GOOGLE_SHEETS", "NEWLINE_DELIMITED_JSON", "AVRO", "PARQUET", and "DATSTORE_BACKUP". To use "GOOGLE_SHEETS" the scopes must include "googleapis.com/auth/drive.readonly".
        """
        return self._values.get('source_format')

    @builtins.property
    def source_uris(self) -> typing.List[str]:
        """A list of the fully-qualified URIs that point to your data in Google Cloud."""
        return self._values.get('source_uris')

    @builtins.property
    def compression(self) -> typing.Optional[str]:
        """The compression type of the data source.

        Valid values are "NONE" or "GZIP".
        """
        return self._values.get('compression')

    @builtins.property
    def csv_options(self) -> typing.Optional[typing.List["BigqueryTableExternalDataConfigurationCsvOptions"]]:
        """csv_options block."""
        return self._values.get('csv_options')

    @builtins.property
    def google_sheets_options(self) -> typing.Optional[typing.List["BigqueryTableExternalDataConfigurationGoogleSheetsOptions"]]:
        """google_sheets_options block."""
        return self._values.get('google_sheets_options')

    @builtins.property
    def hive_partitioning_options(self) -> typing.Optional[typing.List["BigqueryTableExternalDataConfigurationHivePartitioningOptions"]]:
        """hive_partitioning_options block."""
        return self._values.get('hive_partitioning_options')

    @builtins.property
    def ignore_unknown_values(self) -> typing.Optional[bool]:
        """Indicates if BigQuery should allow extra values that are not represented in the table schema.

        If true, the extra values are ignored. If false, records with extra columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
        """
        return self._values.get('ignore_unknown_values')

    @builtins.property
    def max_bad_records(self) -> typing.Optional[jsii.Number]:
        """The maximum number of bad records that BigQuery can ignore when reading data."""
        return self._values.get('max_bad_records')

    @builtins.property
    def schema(self) -> typing.Optional[str]:
        """A JSON schema for the external table.

        Schema is required for CSV and JSON formats and is disallowed for Google Cloud Bigtable, Cloud Datastore backups, and Avro formats when using external tables.
        """
        return self._values.get('schema')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableExternalDataConfiguration(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableExternalDataConfigurationCsvOptions", jsii_struct_bases=[], name_mapping={'quote': 'quote', 'allow_jagged_rows': 'allowJaggedRows', 'allow_quoted_newlines': 'allowQuotedNewlines', 'encoding': 'encoding', 'field_delimiter': 'fieldDelimiter', 'skip_leading_rows': 'skipLeadingRows'})
class BigqueryTableExternalDataConfigurationCsvOptions():
    def __init__(self, *, quote: str, allow_jagged_rows: typing.Optional[bool]=None, allow_quoted_newlines: typing.Optional[bool]=None, encoding: typing.Optional[str]=None, field_delimiter: typing.Optional[str]=None, skip_leading_rows: typing.Optional[jsii.Number]=None) -> None:
        """
        :param quote: The value that is used to quote data sections in a CSV file. If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allow_quoted_newlines property to true. The API-side default is ", specified in Terraform escaped as ". Due to limitations with Terraform default values, this value is required to be explicitly set.
        :param allow_jagged_rows: Indicates if BigQuery should accept rows that are missing trailing optional columns.
        :param allow_quoted_newlines: Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
        :param encoding: The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
        :param field_delimiter: The separator for fields in a CSV file.
        :param skip_leading_rows: The number of rows at the top of a CSV file that BigQuery will skip when reading the data.
        """
        self._values = {
            'quote': quote,
        }
        if allow_jagged_rows is not None: self._values["allow_jagged_rows"] = allow_jagged_rows
        if allow_quoted_newlines is not None: self._values["allow_quoted_newlines"] = allow_quoted_newlines
        if encoding is not None: self._values["encoding"] = encoding
        if field_delimiter is not None: self._values["field_delimiter"] = field_delimiter
        if skip_leading_rows is not None: self._values["skip_leading_rows"] = skip_leading_rows

    @builtins.property
    def quote(self) -> str:
        """The value that is used to quote data sections in a CSV file.

        If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allow_quoted_newlines property to true. The API-side default is ", specified in Terraform escaped as ". Due to limitations with Terraform default values, this value is required to be explicitly set.
        """
        return self._values.get('quote')

    @builtins.property
    def allow_jagged_rows(self) -> typing.Optional[bool]:
        """Indicates if BigQuery should accept rows that are missing trailing optional columns."""
        return self._values.get('allow_jagged_rows')

    @builtins.property
    def allow_quoted_newlines(self) -> typing.Optional[bool]:
        """Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.

        The default value is false.
        """
        return self._values.get('allow_quoted_newlines')

    @builtins.property
    def encoding(self) -> typing.Optional[str]:
        """The character encoding of the data.

        The supported values are UTF-8 or ISO-8859-1.
        """
        return self._values.get('encoding')

    @builtins.property
    def field_delimiter(self) -> typing.Optional[str]:
        """The separator for fields in a CSV file."""
        return self._values.get('field_delimiter')

    @builtins.property
    def skip_leading_rows(self) -> typing.Optional[jsii.Number]:
        """The number of rows at the top of a CSV file that BigQuery will skip when reading the data."""
        return self._values.get('skip_leading_rows')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableExternalDataConfigurationCsvOptions(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableExternalDataConfigurationGoogleSheetsOptions", jsii_struct_bases=[], name_mapping={'range': 'range', 'skip_leading_rows': 'skipLeadingRows'})
class BigqueryTableExternalDataConfigurationGoogleSheetsOptions():
    def __init__(self, *, range: typing.Optional[str]=None, skip_leading_rows: typing.Optional[jsii.Number]=None) -> None:
        """
        :param range: Range of a sheet to query from. Only used when non-empty. At least one of range or skip_leading_rows must be set. Typical format: "sheet_name!top_left_cell_id:bottom_right_cell_id" For example: "sheet1!A1:B20"
        :param skip_leading_rows: The number of rows at the top of the sheet that BigQuery will skip when reading the data. At least one of range or skip_leading_rows must be set.
        """
        self._values = {
        }
        if range is not None: self._values["range"] = range
        if skip_leading_rows is not None: self._values["skip_leading_rows"] = skip_leading_rows

    @builtins.property
    def range(self) -> typing.Optional[str]:
        """Range of a sheet to query from.

        Only used when non-empty. At least one of range or skip_leading_rows must be set. Typical format: "sheet_name!top_left_cell_id:bottom_right_cell_id" For example: "sheet1!A1:B20"
        """
        return self._values.get('range')

    @builtins.property
    def skip_leading_rows(self) -> typing.Optional[jsii.Number]:
        """The number of rows at the top of the sheet that BigQuery will skip when reading the data.

        At least one of range or skip_leading_rows must be set.
        """
        return self._values.get('skip_leading_rows')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableExternalDataConfigurationGoogleSheetsOptions(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableExternalDataConfigurationHivePartitioningOptions", jsii_struct_bases=[], name_mapping={'mode': 'mode', 'source_uri_prefix': 'sourceUriPrefix'})
class BigqueryTableExternalDataConfigurationHivePartitioningOptions():
    def __init__(self, *, mode: typing.Optional[str]=None, source_uri_prefix: typing.Optional[str]=None) -> None:
        """
        :param mode: When set, what mode of hive partitioning to use when reading data.
        :param source_uri_prefix: When hive partition detection is requested, a common for all source uris must be required. The prefix must end immediately before the partition key encoding begins.
        """
        self._values = {
        }
        if mode is not None: self._values["mode"] = mode
        if source_uri_prefix is not None: self._values["source_uri_prefix"] = source_uri_prefix

    @builtins.property
    def mode(self) -> typing.Optional[str]:
        """When set, what mode of hive partitioning to use when reading data."""
        return self._values.get('mode')

    @builtins.property
    def source_uri_prefix(self) -> typing.Optional[str]:
        """When hive partition detection is requested, a common for all source uris must be required.

        The prefix must end immediately before the partition key encoding begins.
        """
        return self._values.get('source_uri_prefix')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableExternalDataConfigurationHivePartitioningOptions(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableRangePartitioning", jsii_struct_bases=[], name_mapping={'field': 'field', 'range': 'range'})
class BigqueryTableRangePartitioning():
    def __init__(self, *, field: str, range: typing.List["BigqueryTableRangePartitioningRange"]) -> None:
        """
        :param field: The field used to determine how to create a range-based partition.
        :param range: range block.
        """
        self._values = {
            'field': field,
            'range': range,
        }

    @builtins.property
    def field(self) -> str:
        """The field used to determine how to create a range-based partition."""
        return self._values.get('field')

    @builtins.property
    def range(self) -> typing.List["BigqueryTableRangePartitioningRange"]:
        """range block."""
        return self._values.get('range')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableRangePartitioning(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableRangePartitioningRange", jsii_struct_bases=[], name_mapping={'end': 'end', 'interval': 'interval', 'start': 'start'})
class BigqueryTableRangePartitioningRange():
    def __init__(self, *, end: jsii.Number, interval: jsii.Number, start: jsii.Number) -> None:
        """
        :param end: End of the range partitioning, exclusive.
        :param interval: The width of each range within the partition.
        :param start: Start of the range partitioning, inclusive.
        """
        self._values = {
            'end': end,
            'interval': interval,
            'start': start,
        }

    @builtins.property
    def end(self) -> jsii.Number:
        """End of the range partitioning, exclusive."""
        return self._values.get('end')

    @builtins.property
    def interval(self) -> jsii.Number:
        """The width of each range within the partition."""
        return self._values.get('interval')

    @builtins.property
    def start(self) -> jsii.Number:
        """Start of the range partitioning, inclusive."""
        return self._values.get('start')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableRangePartitioningRange(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableTimePartitioning", jsii_struct_bases=[], name_mapping={'type': 'type', 'expiration_ms': 'expirationMs', 'field': 'field', 'require_partition_filter': 'requirePartitionFilter'})
class BigqueryTableTimePartitioning():
    def __init__(self, *, type: str, expiration_ms: typing.Optional[jsii.Number]=None, field: typing.Optional[str]=None, require_partition_filter: typing.Optional[bool]=None) -> None:
        """
        :param type: The supported types are DAY and HOUR, which will generate one partition per day or hour based on data loading time.
        :param expiration_ms: Number of milliseconds for which to keep the storage for a partition.
        :param field: The field used to determine how to create a time-based partition. If time-based partitioning is enabled without this value, the table is partitioned based on the load time.
        :param require_partition_filter: If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified.
        """
        self._values = {
            'type': type,
        }
        if expiration_ms is not None: self._values["expiration_ms"] = expiration_ms
        if field is not None: self._values["field"] = field
        if require_partition_filter is not None: self._values["require_partition_filter"] = require_partition_filter

    @builtins.property
    def type(self) -> str:
        """The supported types are DAY and HOUR, which will generate one partition per day or hour based on data loading time."""
        return self._values.get('type')

    @builtins.property
    def expiration_ms(self) -> typing.Optional[jsii.Number]:
        """Number of milliseconds for which to keep the storage for a partition."""
        return self._values.get('expiration_ms')

    @builtins.property
    def field(self) -> typing.Optional[str]:
        """The field used to determine how to create a time-based partition.

        If time-based partitioning is enabled without this value, the table is partitioned based on the load time.
        """
        return self._values.get('field')

    @builtins.property
    def require_partition_filter(self) -> typing.Optional[bool]:
        """If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified."""
        return self._values.get('require_partition_filter')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableTimePartitioning(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigqueryTableView", jsii_struct_bases=[], name_mapping={'query': 'query', 'use_legacy_sql': 'useLegacySql'})
class BigqueryTableView():
    def __init__(self, *, query: str, use_legacy_sql: typing.Optional[bool]=None) -> None:
        """
        :param query: A query that BigQuery executes when the view is referenced.
        :param use_legacy_sql: Specifies whether to use BigQuery's legacy SQL for this view. The default value is true. If set to false, the view will use BigQuery's standard SQL
        """
        self._values = {
            'query': query,
        }
        if use_legacy_sql is not None: self._values["use_legacy_sql"] = use_legacy_sql

    @builtins.property
    def query(self) -> str:
        """A query that BigQuery executes when the view is referenced."""
        return self._values.get('query')

    @builtins.property
    def use_legacy_sql(self) -> typing.Optional[bool]:
        """Specifies whether to use BigQuery's legacy SQL for this view.

        The default value is true. If set to false, the view will use BigQuery's standard SQL
        """
        return self._values.get('use_legacy_sql')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigqueryTableView(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigtableAppProfile(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigtableAppProfile"):
    def __init__(self, scope: constructs.Construct, id: str, *, app_profile_id: str, description: typing.Optional[str]=None, ignore_warnings: typing.Optional[bool]=None, instance: typing.Optional[str]=None, multi_cluster_routing_use_any: typing.Optional[bool]=None, project: typing.Optional[str]=None, single_cluster_routing: typing.Optional[typing.List["BigtableAppProfileSingleClusterRouting"]]=None, timeouts: typing.Optional["BigtableAppProfileTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param app_profile_id: The unique name of the app profile in the form '[*a-zA-Z0-9][-*.a-zA-Z0-9]*'.
        :param description: Long form description of the use case for this app profile.
        :param ignore_warnings: If true, ignore safety checks when deleting/updating the app profile.
        :param instance: The name of the instance to create the app profile within.
        :param multi_cluster_routing_use_any: If true, read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available in the event of transient errors or delays. Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes consistency to improve availability.
        :param project: 
        :param single_cluster_routing: single_cluster_routing block.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigtableAppProfileConfig(app_profile_id=app_profile_id, description=description, ignore_warnings=ignore_warnings, instance=instance, multi_cluster_routing_use_any=multi_cluster_routing_use_any, project=project, single_cluster_routing=single_cluster_routing, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigtableAppProfile, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="appProfileId")
    def app_profile_id(self) -> str:
        return jsii.get(self, "appProfileId")

    @app_profile_id.setter
    def app_profile_id(self, value: str) -> None:
        jsii.set(self, "appProfileId", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="ignoreWarnings")
    def ignore_warnings(self) -> typing.Optional[bool]:
        return jsii.get(self, "ignoreWarnings")

    @ignore_warnings.setter
    def ignore_warnings(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "ignoreWarnings", value)

    @builtins.property
    @jsii.member(jsii_name="instance")
    def instance(self) -> typing.Optional[str]:
        return jsii.get(self, "instance")

    @instance.setter
    def instance(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "instance", value)

    @builtins.property
    @jsii.member(jsii_name="multiClusterRoutingUseAny")
    def multi_cluster_routing_use_any(self) -> typing.Optional[bool]:
        return jsii.get(self, "multiClusterRoutingUseAny")

    @multi_cluster_routing_use_any.setter
    def multi_cluster_routing_use_any(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "multiClusterRoutingUseAny", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="singleClusterRouting")
    def single_cluster_routing(self) -> typing.Optional[typing.List["BigtableAppProfileSingleClusterRouting"]]:
        return jsii.get(self, "singleClusterRouting")

    @single_cluster_routing.setter
    def single_cluster_routing(self, value: typing.Optional[typing.List["BigtableAppProfileSingleClusterRouting"]]) -> None:
        jsii.set(self, "singleClusterRouting", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["BigtableAppProfileTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["BigtableAppProfileTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableAppProfileConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'app_profile_id': 'appProfileId', 'description': 'description', 'ignore_warnings': 'ignoreWarnings', 'instance': 'instance', 'multi_cluster_routing_use_any': 'multiClusterRoutingUseAny', 'project': 'project', 'single_cluster_routing': 'singleClusterRouting', 'timeouts': 'timeouts'})
class BigtableAppProfileConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, app_profile_id: str, description: typing.Optional[str]=None, ignore_warnings: typing.Optional[bool]=None, instance: typing.Optional[str]=None, multi_cluster_routing_use_any: typing.Optional[bool]=None, project: typing.Optional[str]=None, single_cluster_routing: typing.Optional[typing.List["BigtableAppProfileSingleClusterRouting"]]=None, timeouts: typing.Optional["BigtableAppProfileTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param app_profile_id: The unique name of the app profile in the form '[*a-zA-Z0-9][-*.a-zA-Z0-9]*'.
        :param description: Long form description of the use case for this app profile.
        :param ignore_warnings: If true, ignore safety checks when deleting/updating the app profile.
        :param instance: The name of the instance to create the app profile within.
        :param multi_cluster_routing_use_any: If true, read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available in the event of transient errors or delays. Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes consistency to improve availability.
        :param project: 
        :param single_cluster_routing: single_cluster_routing block.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = BigtableAppProfileTimeouts(**timeouts)
        self._values = {
            'app_profile_id': app_profile_id,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if description is not None: self._values["description"] = description
        if ignore_warnings is not None: self._values["ignore_warnings"] = ignore_warnings
        if instance is not None: self._values["instance"] = instance
        if multi_cluster_routing_use_any is not None: self._values["multi_cluster_routing_use_any"] = multi_cluster_routing_use_any
        if project is not None: self._values["project"] = project
        if single_cluster_routing is not None: self._values["single_cluster_routing"] = single_cluster_routing
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def app_profile_id(self) -> str:
        """The unique name of the app profile in the form '[*a-zA-Z0-9][-*.a-zA-Z0-9]*'."""
        return self._values.get('app_profile_id')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """Long form description of the use case for this app profile."""
        return self._values.get('description')

    @builtins.property
    def ignore_warnings(self) -> typing.Optional[bool]:
        """If true, ignore safety checks when deleting/updating the app profile."""
        return self._values.get('ignore_warnings')

    @builtins.property
    def instance(self) -> typing.Optional[str]:
        """The name of the instance to create the app profile within."""
        return self._values.get('instance')

    @builtins.property
    def multi_cluster_routing_use_any(self) -> typing.Optional[bool]:
        """If true, read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available in the event of transient errors or delays.

        Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes
        consistency to improve availability.
        """
        return self._values.get('multi_cluster_routing_use_any')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def single_cluster_routing(self) -> typing.Optional[typing.List["BigtableAppProfileSingleClusterRouting"]]:
        """single_cluster_routing block."""
        return self._values.get('single_cluster_routing')

    @builtins.property
    def timeouts(self) -> typing.Optional["BigtableAppProfileTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableAppProfileConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableAppProfileSingleClusterRouting", jsii_struct_bases=[], name_mapping={'cluster_id': 'clusterId', 'allow_transactional_writes': 'allowTransactionalWrites'})
class BigtableAppProfileSingleClusterRouting():
    def __init__(self, *, cluster_id: str, allow_transactional_writes: typing.Optional[bool]=None) -> None:
        """
        :param cluster_id: The cluster to which read/write requests should be routed.
        :param allow_transactional_writes: If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile. It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        self._values = {
            'cluster_id': cluster_id,
        }
        if allow_transactional_writes is not None: self._values["allow_transactional_writes"] = allow_transactional_writes

    @builtins.property
    def cluster_id(self) -> str:
        """The cluster to which read/write requests should be routed."""
        return self._values.get('cluster_id')

    @builtins.property
    def allow_transactional_writes(self) -> typing.Optional[bool]:
        """If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.

        It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        return self._values.get('allow_transactional_writes')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableAppProfileSingleClusterRouting(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableAppProfileTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class BigtableAppProfileTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableAppProfileTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigtableGcPolicy(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigtableGcPolicy"):
    def __init__(self, scope: constructs.Construct, id: str, *, column_family: str, instance_name: str, table: str, max_age: typing.Optional[typing.List["BigtableGcPolicyMaxAge"]]=None, max_version: typing.Optional[typing.List["BigtableGcPolicyMaxVersion"]]=None, mode: typing.Optional[str]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param column_family: The name of the column family.
        :param instance_name: The name of the Bigtable instance.
        :param table: The name of the table.
        :param max_age: max_age block.
        :param max_version: max_version block.
        :param mode: If multiple policies are set, you should choose between UNION OR INTERSECTION.
        :param project: The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigtableGcPolicyConfig(column_family=column_family, instance_name=instance_name, table=table, max_age=max_age, max_version=max_version, mode=mode, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigtableGcPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="columnFamily")
    def column_family(self) -> str:
        return jsii.get(self, "columnFamily")

    @column_family.setter
    def column_family(self, value: str) -> None:
        jsii.set(self, "columnFamily", value)

    @builtins.property
    @jsii.member(jsii_name="instanceName")
    def instance_name(self) -> str:
        return jsii.get(self, "instanceName")

    @instance_name.setter
    def instance_name(self, value: str) -> None:
        jsii.set(self, "instanceName", value)

    @builtins.property
    @jsii.member(jsii_name="table")
    def table(self) -> str:
        return jsii.get(self, "table")

    @table.setter
    def table(self, value: str) -> None:
        jsii.set(self, "table", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="maxAge")
    def max_age(self) -> typing.Optional[typing.List["BigtableGcPolicyMaxAge"]]:
        return jsii.get(self, "maxAge")

    @max_age.setter
    def max_age(self, value: typing.Optional[typing.List["BigtableGcPolicyMaxAge"]]) -> None:
        jsii.set(self, "maxAge", value)

    @builtins.property
    @jsii.member(jsii_name="maxVersion")
    def max_version(self) -> typing.Optional[typing.List["BigtableGcPolicyMaxVersion"]]:
        return jsii.get(self, "maxVersion")

    @max_version.setter
    def max_version(self, value: typing.Optional[typing.List["BigtableGcPolicyMaxVersion"]]) -> None:
        jsii.set(self, "maxVersion", value)

    @builtins.property
    @jsii.member(jsii_name="mode")
    def mode(self) -> typing.Optional[str]:
        return jsii.get(self, "mode")

    @mode.setter
    def mode(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "mode", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableGcPolicyConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'column_family': 'columnFamily', 'instance_name': 'instanceName', 'table': 'table', 'max_age': 'maxAge', 'max_version': 'maxVersion', 'mode': 'mode', 'project': 'project'})
class BigtableGcPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, column_family: str, instance_name: str, table: str, max_age: typing.Optional[typing.List["BigtableGcPolicyMaxAge"]]=None, max_version: typing.Optional[typing.List["BigtableGcPolicyMaxVersion"]]=None, mode: typing.Optional[str]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param column_family: The name of the column family.
        :param instance_name: The name of the Bigtable instance.
        :param table: The name of the table.
        :param max_age: max_age block.
        :param max_version: max_version block.
        :param mode: If multiple policies are set, you should choose between UNION OR INTERSECTION.
        :param project: The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'column_family': column_family,
            'instance_name': instance_name,
            'table': table,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if max_age is not None: self._values["max_age"] = max_age
        if max_version is not None: self._values["max_version"] = max_version
        if mode is not None: self._values["mode"] = mode
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def column_family(self) -> str:
        """The name of the column family."""
        return self._values.get('column_family')

    @builtins.property
    def instance_name(self) -> str:
        """The name of the Bigtable instance."""
        return self._values.get('instance_name')

    @builtins.property
    def table(self) -> str:
        """The name of the table."""
        return self._values.get('table')

    @builtins.property
    def max_age(self) -> typing.Optional[typing.List["BigtableGcPolicyMaxAge"]]:
        """max_age block."""
        return self._values.get('max_age')

    @builtins.property
    def max_version(self) -> typing.Optional[typing.List["BigtableGcPolicyMaxVersion"]]:
        """max_version block."""
        return self._values.get('max_version')

    @builtins.property
    def mode(self) -> typing.Optional[str]:
        """If multiple policies are set, you should choose between UNION OR INTERSECTION."""
        return self._values.get('mode')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        """The ID of the project in which the resource belongs.

        If it is not provided, the provider project is used.
        """
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableGcPolicyConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableGcPolicyMaxAge", jsii_struct_bases=[], name_mapping={'days': 'days'})
class BigtableGcPolicyMaxAge():
    def __init__(self, *, days: jsii.Number) -> None:
        """
        :param days: Number of days before applying GC policy.
        """
        self._values = {
            'days': days,
        }

    @builtins.property
    def days(self) -> jsii.Number:
        """Number of days before applying GC policy."""
        return self._values.get('days')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableGcPolicyMaxAge(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableGcPolicyMaxVersion", jsii_struct_bases=[], name_mapping={'number': 'number'})
class BigtableGcPolicyMaxVersion():
    def __init__(self, *, number: jsii.Number) -> None:
        """
        :param number: Number of version before applying the GC policy.
        """
        self._values = {
            'number': number,
        }

    @builtins.property
    def number(self) -> jsii.Number:
        """Number of version before applying the GC policy."""
        return self._values.get('number')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableGcPolicyMaxVersion(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigtableInstance(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigtableInstance"):
    def __init__(self, scope: constructs.Construct, id: str, *, name: str, cluster: typing.Optional[typing.List["BigtableInstanceCluster"]]=None, deletion_protection: typing.Optional[bool]=None, display_name: typing.Optional[str]=None, instance_type: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param name: The name (also called Instance Id in the Cloud Console) of the Cloud Bigtable instance.
        :param cluster: cluster block.
        :param deletion_protection: Whether or not to allow Terraform to destroy the instance. Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the instance will fail.
        :param display_name: The human-readable display name of the Bigtable instance. Defaults to the instance name.
        :param instance_type: The instance type to create. One of "DEVELOPMENT" or "PRODUCTION". Defaults to "PRODUCTION".
        :param labels: A mapping of labels to assign to the resource.
        :param project: The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigtableInstanceConfig(name=name, cluster=cluster, deletion_protection=deletion_protection, display_name=display_name, instance_type=instance_type, labels=labels, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigtableInstance, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="cluster")
    def cluster(self) -> typing.Optional[typing.List["BigtableInstanceCluster"]]:
        return jsii.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: typing.Optional[typing.List["BigtableInstanceCluster"]]) -> None:
        jsii.set(self, "cluster", value)

    @builtins.property
    @jsii.member(jsii_name="deletionProtection")
    def deletion_protection(self) -> typing.Optional[bool]:
        return jsii.get(self, "deletionProtection")

    @deletion_protection.setter
    def deletion_protection(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "deletionProtection", value)

    @builtins.property
    @jsii.member(jsii_name="displayName")
    def display_name(self) -> typing.Optional[str]:
        return jsii.get(self, "displayName")

    @display_name.setter
    def display_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "displayName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="instanceType")
    def instance_type(self) -> typing.Optional[str]:
        return jsii.get(self, "instanceType")

    @instance_type.setter
    def instance_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "instanceType", value)

    @builtins.property
    @jsii.member(jsii_name="labels")
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "labels")

    @labels.setter
    def labels(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "labels", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableInstanceCluster", jsii_struct_bases=[], name_mapping={'cluster_id': 'clusterId', 'zone': 'zone', 'num_nodes': 'numNodes', 'storage_type': 'storageType'})
class BigtableInstanceCluster():
    def __init__(self, *, cluster_id: str, zone: str, num_nodes: typing.Optional[jsii.Number]=None, storage_type: typing.Optional[str]=None) -> None:
        """
        :param cluster_id: The ID of the Cloud Bigtable cluster.
        :param zone: The zone to create the Cloud Bigtable cluster in. Each cluster must have a different zone in the same region. Zones that support Bigtable instances are noted on the Cloud Bigtable locations page.
        :param num_nodes: The number of nodes in your Cloud Bigtable cluster. Required, with a minimum of 1 for a PRODUCTION instance. Must be left unset for a DEVELOPMENT instance.
        :param storage_type: The storage type to use. One of "SSD" or "HDD". Defaults to "SSD".
        """
        self._values = {
            'cluster_id': cluster_id,
            'zone': zone,
        }
        if num_nodes is not None: self._values["num_nodes"] = num_nodes
        if storage_type is not None: self._values["storage_type"] = storage_type

    @builtins.property
    def cluster_id(self) -> str:
        """The ID of the Cloud Bigtable cluster."""
        return self._values.get('cluster_id')

    @builtins.property
    def zone(self) -> str:
        """The zone to create the Cloud Bigtable cluster in.

        Each cluster must have a different zone in the same region. Zones that support Bigtable instances are noted on the Cloud Bigtable locations page.
        """
        return self._values.get('zone')

    @builtins.property
    def num_nodes(self) -> typing.Optional[jsii.Number]:
        """The number of nodes in your Cloud Bigtable cluster.

        Required, with a minimum of 1 for a PRODUCTION instance. Must be left unset for a DEVELOPMENT instance.
        """
        return self._values.get('num_nodes')

    @builtins.property
    def storage_type(self) -> typing.Optional[str]:
        """The storage type to use.

        One of "SSD" or "HDD". Defaults to "SSD".
        """
        return self._values.get('storage_type')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableInstanceCluster(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableInstanceConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'name': 'name', 'cluster': 'cluster', 'deletion_protection': 'deletionProtection', 'display_name': 'displayName', 'instance_type': 'instanceType', 'labels': 'labels', 'project': 'project'})
class BigtableInstanceConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, name: str, cluster: typing.Optional[typing.List["BigtableInstanceCluster"]]=None, deletion_protection: typing.Optional[bool]=None, display_name: typing.Optional[str]=None, instance_type: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: The name (also called Instance Id in the Cloud Console) of the Cloud Bigtable instance.
        :param cluster: cluster block.
        :param deletion_protection: Whether or not to allow Terraform to destroy the instance. Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the instance will fail.
        :param display_name: The human-readable display name of the Bigtable instance. Defaults to the instance name.
        :param instance_type: The instance type to create. One of "DEVELOPMENT" or "PRODUCTION". Defaults to "PRODUCTION".
        :param labels: A mapping of labels to assign to the resource.
        :param project: The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'name': name,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if cluster is not None: self._values["cluster"] = cluster
        if deletion_protection is not None: self._values["deletion_protection"] = deletion_protection
        if display_name is not None: self._values["display_name"] = display_name
        if instance_type is not None: self._values["instance_type"] = instance_type
        if labels is not None: self._values["labels"] = labels
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def name(self) -> str:
        """The name (also called Instance Id in the Cloud Console) of the Cloud Bigtable instance."""
        return self._values.get('name')

    @builtins.property
    def cluster(self) -> typing.Optional[typing.List["BigtableInstanceCluster"]]:
        """cluster block."""
        return self._values.get('cluster')

    @builtins.property
    def deletion_protection(self) -> typing.Optional[bool]:
        """Whether or not to allow Terraform to destroy the instance.

        Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the instance will fail.
        """
        return self._values.get('deletion_protection')

    @builtins.property
    def display_name(self) -> typing.Optional[str]:
        """The human-readable display name of the Bigtable instance.

        Defaults to the instance name.
        """
        return self._values.get('display_name')

    @builtins.property
    def instance_type(self) -> typing.Optional[str]:
        """The instance type to create.

        One of "DEVELOPMENT" or "PRODUCTION". Defaults to "PRODUCTION".
        """
        return self._values.get('instance_type')

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        """A mapping of labels to assign to the resource."""
        return self._values.get('labels')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        """The ID of the project in which the resource belongs.

        If it is not provided, the provider project is used.
        """
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableInstanceConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigtableInstanceIamBinding(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigtableInstanceIamBinding"):
    def __init__(self, scope: constructs.Construct, id: str, *, instance: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["BigtableInstanceIamBindingCondition"]]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param instance: 
        :param members: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigtableInstanceIamBindingConfig(instance=instance, members=members, role=role, condition=condition, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigtableInstanceIamBinding, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="instance")
    def instance(self) -> str:
        return jsii.get(self, "instance")

    @instance.setter
    def instance(self, value: str) -> None:
        jsii.set(self, "instance", value)

    @builtins.property
    @jsii.member(jsii_name="members")
    def members(self) -> typing.List[str]:
        return jsii.get(self, "members")

    @members.setter
    def members(self, value: typing.List[str]) -> None:
        jsii.set(self, "members", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["BigtableInstanceIamBindingCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["BigtableInstanceIamBindingCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableInstanceIamBindingCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class BigtableInstanceIamBindingCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableInstanceIamBindingCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableInstanceIamBindingConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'instance': 'instance', 'members': 'members', 'role': 'role', 'condition': 'condition', 'project': 'project'})
class BigtableInstanceIamBindingConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, instance: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["BigtableInstanceIamBindingCondition"]]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param instance: 
        :param members: 
        :param role: 
        :param condition: condition block.
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'instance': instance,
            'members': members,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def instance(self) -> str:
        return self._values.get('instance')

    @builtins.property
    def members(self) -> typing.List[str]:
        return self._values.get('members')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["BigtableInstanceIamBindingCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableInstanceIamBindingConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigtableInstanceIamMember(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigtableInstanceIamMember"):
    def __init__(self, scope: constructs.Construct, id: str, *, instance: str, member: str, role: str, condition: typing.Optional[typing.List["BigtableInstanceIamMemberCondition"]]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param instance: 
        :param member: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigtableInstanceIamMemberConfig(instance=instance, member=member, role=role, condition=condition, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigtableInstanceIamMember, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="instance")
    def instance(self) -> str:
        return jsii.get(self, "instance")

    @instance.setter
    def instance(self, value: str) -> None:
        jsii.set(self, "instance", value)

    @builtins.property
    @jsii.member(jsii_name="member")
    def member(self) -> str:
        return jsii.get(self, "member")

    @member.setter
    def member(self, value: str) -> None:
        jsii.set(self, "member", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["BigtableInstanceIamMemberCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["BigtableInstanceIamMemberCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableInstanceIamMemberCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class BigtableInstanceIamMemberCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableInstanceIamMemberCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableInstanceIamMemberConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'instance': 'instance', 'member': 'member', 'role': 'role', 'condition': 'condition', 'project': 'project'})
class BigtableInstanceIamMemberConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, instance: str, member: str, role: str, condition: typing.Optional[typing.List["BigtableInstanceIamMemberCondition"]]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param instance: 
        :param member: 
        :param role: 
        :param condition: condition block.
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'instance': instance,
            'member': member,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def instance(self) -> str:
        return self._values.get('instance')

    @builtins.property
    def member(self) -> str:
        return self._values.get('member')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["BigtableInstanceIamMemberCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableInstanceIamMemberConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigtableInstanceIamPolicy(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigtableInstanceIamPolicy"):
    def __init__(self, scope: constructs.Construct, id: str, *, instance: str, policy_data: str, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param instance: 
        :param policy_data: 
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigtableInstanceIamPolicyConfig(instance=instance, policy_data=policy_data, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigtableInstanceIamPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="instance")
    def instance(self) -> str:
        return jsii.get(self, "instance")

    @instance.setter
    def instance(self, value: str) -> None:
        jsii.set(self, "instance", value)

    @builtins.property
    @jsii.member(jsii_name="policyData")
    def policy_data(self) -> str:
        return jsii.get(self, "policyData")

    @policy_data.setter
    def policy_data(self, value: str) -> None:
        jsii.set(self, "policyData", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableInstanceIamPolicyConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'instance': 'instance', 'policy_data': 'policyData', 'project': 'project'})
class BigtableInstanceIamPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, instance: str, policy_data: str, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param instance: 
        :param policy_data: 
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'instance': instance,
            'policy_data': policy_data,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def instance(self) -> str:
        return self._values.get('instance')

    @builtins.property
    def policy_data(self) -> str:
        return self._values.get('policy_data')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableInstanceIamPolicyConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BigtableTable(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BigtableTable"):
    def __init__(self, scope: constructs.Construct, id: str, *, instance_name: str, name: str, column_family: typing.Optional[typing.List["BigtableTableColumnFamily"]]=None, project: typing.Optional[str]=None, split_keys: typing.Optional[typing.List[str]]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param instance_name: The name of the Bigtable instance.
        :param name: The name of the table.
        :param column_family: column_family block.
        :param project: The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
        :param split_keys: A list of predefined keys to split the table on. !> Warning: Modifying the split_keys of an existing table will cause Terraform to delete/recreate the entire google_bigtable_table resource.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BigtableTableConfig(instance_name=instance_name, name=name, column_family=column_family, project=project, split_keys=split_keys, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BigtableTable, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="instanceName")
    def instance_name(self) -> str:
        return jsii.get(self, "instanceName")

    @instance_name.setter
    def instance_name(self, value: str) -> None:
        jsii.set(self, "instanceName", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="columnFamily")
    def column_family(self) -> typing.Optional[typing.List["BigtableTableColumnFamily"]]:
        return jsii.get(self, "columnFamily")

    @column_family.setter
    def column_family(self, value: typing.Optional[typing.List["BigtableTableColumnFamily"]]) -> None:
        jsii.set(self, "columnFamily", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="splitKeys")
    def split_keys(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "splitKeys")

    @split_keys.setter
    def split_keys(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "splitKeys", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableTableColumnFamily", jsii_struct_bases=[], name_mapping={'family': 'family'})
class BigtableTableColumnFamily():
    def __init__(self, *, family: str) -> None:
        """
        :param family: The name of the column family.
        """
        self._values = {
            'family': family,
        }

    @builtins.property
    def family(self) -> str:
        """The name of the column family."""
        return self._values.get('family')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableTableColumnFamily(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BigtableTableConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'instance_name': 'instanceName', 'name': 'name', 'column_family': 'columnFamily', 'project': 'project', 'split_keys': 'splitKeys'})
class BigtableTableConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, instance_name: str, name: str, column_family: typing.Optional[typing.List["BigtableTableColumnFamily"]]=None, project: typing.Optional[str]=None, split_keys: typing.Optional[typing.List[str]]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param instance_name: The name of the Bigtable instance.
        :param name: The name of the table.
        :param column_family: column_family block.
        :param project: The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
        :param split_keys: A list of predefined keys to split the table on. !> Warning: Modifying the split_keys of an existing table will cause Terraform to delete/recreate the entire google_bigtable_table resource.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'instance_name': instance_name,
            'name': name,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if column_family is not None: self._values["column_family"] = column_family
        if project is not None: self._values["project"] = project
        if split_keys is not None: self._values["split_keys"] = split_keys

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def instance_name(self) -> str:
        """The name of the Bigtable instance."""
        return self._values.get('instance_name')

    @builtins.property
    def name(self) -> str:
        """The name of the table."""
        return self._values.get('name')

    @builtins.property
    def column_family(self) -> typing.Optional[typing.List["BigtableTableColumnFamily"]]:
        """column_family block."""
        return self._values.get('column_family')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        """The ID of the project in which the resource belongs.

        If it is not provided, the provider project is used.
        """
        return self._values.get('project')

    @builtins.property
    def split_keys(self) -> typing.Optional[typing.List[str]]:
        """A list of predefined keys to split the table on.

        !> Warning: Modifying the split_keys of an existing table will cause Terraform to delete/recreate the entire google_bigtable_table resource.
        """
        return self._values.get('split_keys')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BigtableTableConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BillingAccountIamBinding(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BillingAccountIamBinding"):
    def __init__(self, scope: constructs.Construct, id: str, *, billing_account_id: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["BillingAccountIamBindingCondition"]]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param billing_account_id: 
        :param members: 
        :param role: 
        :param condition: condition block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BillingAccountIamBindingConfig(billing_account_id=billing_account_id, members=members, role=role, condition=condition, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BillingAccountIamBinding, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="billingAccountId")
    def billing_account_id(self) -> str:
        return jsii.get(self, "billingAccountId")

    @billing_account_id.setter
    def billing_account_id(self, value: str) -> None:
        jsii.set(self, "billingAccountId", value)

    @builtins.property
    @jsii.member(jsii_name="members")
    def members(self) -> typing.List[str]:
        return jsii.get(self, "members")

    @members.setter
    def members(self, value: typing.List[str]) -> None:
        jsii.set(self, "members", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["BillingAccountIamBindingCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["BillingAccountIamBindingCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BillingAccountIamBindingCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class BillingAccountIamBindingCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BillingAccountIamBindingCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BillingAccountIamBindingConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'billing_account_id': 'billingAccountId', 'members': 'members', 'role': 'role', 'condition': 'condition'})
class BillingAccountIamBindingConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, billing_account_id: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["BillingAccountIamBindingCondition"]]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param billing_account_id: 
        :param members: 
        :param role: 
        :param condition: condition block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'billing_account_id': billing_account_id,
            'members': members,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def billing_account_id(self) -> str:
        return self._values.get('billing_account_id')

    @builtins.property
    def members(self) -> typing.List[str]:
        return self._values.get('members')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["BillingAccountIamBindingCondition"]]:
        """condition block."""
        return self._values.get('condition')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BillingAccountIamBindingConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BillingAccountIamMember(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BillingAccountIamMember"):
    def __init__(self, scope: constructs.Construct, id: str, *, billing_account_id: str, member: str, role: str, condition: typing.Optional[typing.List["BillingAccountIamMemberCondition"]]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param billing_account_id: 
        :param member: 
        :param role: 
        :param condition: condition block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BillingAccountIamMemberConfig(billing_account_id=billing_account_id, member=member, role=role, condition=condition, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BillingAccountIamMember, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="billingAccountId")
    def billing_account_id(self) -> str:
        return jsii.get(self, "billingAccountId")

    @billing_account_id.setter
    def billing_account_id(self, value: str) -> None:
        jsii.set(self, "billingAccountId", value)

    @builtins.property
    @jsii.member(jsii_name="member")
    def member(self) -> str:
        return jsii.get(self, "member")

    @member.setter
    def member(self, value: str) -> None:
        jsii.set(self, "member", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["BillingAccountIamMemberCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["BillingAccountIamMemberCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BillingAccountIamMemberCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class BillingAccountIamMemberCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BillingAccountIamMemberCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BillingAccountIamMemberConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'billing_account_id': 'billingAccountId', 'member': 'member', 'role': 'role', 'condition': 'condition'})
class BillingAccountIamMemberConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, billing_account_id: str, member: str, role: str, condition: typing.Optional[typing.List["BillingAccountIamMemberCondition"]]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param billing_account_id: 
        :param member: 
        :param role: 
        :param condition: condition block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'billing_account_id': billing_account_id,
            'member': member,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def billing_account_id(self) -> str:
        return self._values.get('billing_account_id')

    @builtins.property
    def member(self) -> str:
        return self._values.get('member')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["BillingAccountIamMemberCondition"]]:
        """condition block."""
        return self._values.get('condition')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BillingAccountIamMemberConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BillingAccountIamPolicy(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BillingAccountIamPolicy"):
    def __init__(self, scope: constructs.Construct, id: str, *, billing_account_id: str, policy_data: str, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param billing_account_id: 
        :param policy_data: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BillingAccountIamPolicyConfig(billing_account_id=billing_account_id, policy_data=policy_data, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BillingAccountIamPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="billingAccountId")
    def billing_account_id(self) -> str:
        return jsii.get(self, "billingAccountId")

    @billing_account_id.setter
    def billing_account_id(self, value: str) -> None:
        jsii.set(self, "billingAccountId", value)

    @builtins.property
    @jsii.member(jsii_name="policyData")
    def policy_data(self) -> str:
        return jsii.get(self, "policyData")

    @policy_data.setter
    def policy_data(self, value: str) -> None:
        jsii.set(self, "policyData", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BillingAccountIamPolicyConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'billing_account_id': 'billingAccountId', 'policy_data': 'policyData'})
class BillingAccountIamPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, billing_account_id: str, policy_data: str) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param billing_account_id: 
        :param policy_data: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'billing_account_id': billing_account_id,
            'policy_data': policy_data,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def billing_account_id(self) -> str:
        return self._values.get('billing_account_id')

    @builtins.property
    def policy_data(self) -> str:
        return self._values.get('policy_data')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BillingAccountIamPolicyConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BinaryAuthorizationAttestor(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestor"):
    def __init__(self, scope: constructs.Construct, id: str, *, attestation_authority_note: typing.List["BinaryAuthorizationAttestorAttestationAuthorityNote"], name: str, description: typing.Optional[str]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["BinaryAuthorizationAttestorTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param attestation_authority_note: attestation_authority_note block.
        :param name: The resource name.
        :param description: A descriptive comment. This field may be updated. The field may be displayed in chooser dialogs.
        :param project: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BinaryAuthorizationAttestorConfig(attestation_authority_note=attestation_authority_note, name=name, description=description, project=project, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BinaryAuthorizationAttestor, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="attestationAuthorityNote")
    def attestation_authority_note(self) -> typing.List["BinaryAuthorizationAttestorAttestationAuthorityNote"]:
        return jsii.get(self, "attestationAuthorityNote")

    @attestation_authority_note.setter
    def attestation_authority_note(self, value: typing.List["BinaryAuthorizationAttestorAttestationAuthorityNote"]) -> None:
        jsii.set(self, "attestationAuthorityNote", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["BinaryAuthorizationAttestorTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["BinaryAuthorizationAttestorTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorAttestationAuthorityNote", jsii_struct_bases=[], name_mapping={'note_reference': 'noteReference', 'public_keys': 'publicKeys'})
class BinaryAuthorizationAttestorAttestationAuthorityNote():
    def __init__(self, *, note_reference: str, public_keys: typing.Optional[typing.List["BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys"]]=None) -> None:
        """
        :param note_reference: The resource name of a ATTESTATION_AUTHORITY Note, created by the user. If the Note is in a different project from the Attestor, it should be specified in the format 'projects/*/notes/*' (or the legacy 'providers/*/notes/*'). This field may not be updated. An attestation by this attestor is stored as a Container Analysis ATTESTATION_AUTHORITY Occurrence that names a container image and that links to this Note.
        :param public_keys: public_keys block.
        """
        self._values = {
            'note_reference': note_reference,
        }
        if public_keys is not None: self._values["public_keys"] = public_keys

    @builtins.property
    def note_reference(self) -> str:
        """The resource name of a ATTESTATION_AUTHORITY Note, created by the user.

        If the Note is in a different project from the Attestor, it
        should be specified in the format 'projects/*/notes/*' (or the legacy
        'providers/*/notes/*'). This field may not be updated.
        An attestation by this attestor is stored as a Container Analysis
        ATTESTATION_AUTHORITY Occurrence that names a container image
        and that links to this Note.
        """
        return self._values.get('note_reference')

    @builtins.property
    def public_keys(self) -> typing.Optional[typing.List["BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys"]]:
        """public_keys block."""
        return self._values.get('public_keys')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorAttestationAuthorityNote(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys", jsii_struct_bases=[], name_mapping={'ascii_armored_pgp_public_key': 'asciiArmoredPgpPublicKey', 'comment': 'comment', 'id': 'id', 'pkix_public_key': 'pkixPublicKey'})
class BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys():
    def __init__(self, *, ascii_armored_pgp_public_key: typing.Optional[str]=None, comment: typing.Optional[str]=None, id: typing.Optional[str]=None, pkix_public_key: typing.Optional[typing.List["BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey"]]=None) -> None:
        """
        :param ascii_armored_pgp_public_key: ASCII-armored representation of a PGP public key, as the entire output by the command 'gpg --export --armor foo@example.com' (either LF or CRLF line endings). When using this field, id should be left blank. The BinAuthz API handlers will calculate the ID and fill it in automatically. BinAuthz computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as upper-case hex. If id is provided by the caller, it will be overwritten by the API-calculated ID.
        :param comment: A descriptive comment. This field may be updated.
        :param id: The ID of this public key. Signatures verified by BinAuthz must include the ID of the public key that can be used to verify them, and that ID must match the contents of this field exactly. Additional restrictions on this field can be imposed based on which public key type is encapsulated. See the documentation on publicKey cases below for details.
        :param pkix_public_key: pkix_public_key block.
        """
        self._values = {
        }
        if ascii_armored_pgp_public_key is not None: self._values["ascii_armored_pgp_public_key"] = ascii_armored_pgp_public_key
        if comment is not None: self._values["comment"] = comment
        if id is not None: self._values["id"] = id
        if pkix_public_key is not None: self._values["pkix_public_key"] = pkix_public_key

    @builtins.property
    def ascii_armored_pgp_public_key(self) -> typing.Optional[str]:
        """ASCII-armored representation of a PGP public key, as the entire output by the command 'gpg --export --armor foo@example.com' (either LF or CRLF line endings). When using this field, id should be left blank. The BinAuthz API handlers will calculate the ID and fill it in automatically. BinAuthz computes this ID as the OpenPGP RFC4880 V4 fingerprint, represented as upper-case hex. If id is provided by the caller, it will be overwritten by the API-calculated ID."""
        return self._values.get('ascii_armored_pgp_public_key')

    @builtins.property
    def comment(self) -> typing.Optional[str]:
        """A descriptive comment.

        This field may be updated.
        """
        return self._values.get('comment')

    @builtins.property
    def id(self) -> typing.Optional[str]:
        """The ID of this public key.

        Signatures verified by BinAuthz
        must include the ID of the public key that can be used to
        verify them, and that ID must match the contents of this
        field exactly. Additional restrictions on this field can
        be imposed based on which public key type is encapsulated.
        See the documentation on publicKey cases below for details.
        """
        return self._values.get('id')

    @builtins.property
    def pkix_public_key(self) -> typing.Optional[typing.List["BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey"]]:
        """pkix_public_key block."""
        return self._values.get('pkix_public_key')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey", jsii_struct_bases=[], name_mapping={'public_key_pem': 'publicKeyPem', 'signature_algorithm': 'signatureAlgorithm'})
class BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey():
    def __init__(self, *, public_key_pem: typing.Optional[str]=None, signature_algorithm: typing.Optional[str]=None) -> None:
        """
        :param public_key_pem: A PEM-encoded public key, as described in 'https://tools.ietf.org/html/rfc7468#section-13'.
        :param signature_algorithm: The signature algorithm used to verify a message against a signature using this key. These signature algorithm must match the structure and any object identifiers encoded in publicKeyPem (i.e. this algorithm must match that of the public key).
        """
        self._values = {
        }
        if public_key_pem is not None: self._values["public_key_pem"] = public_key_pem
        if signature_algorithm is not None: self._values["signature_algorithm"] = signature_algorithm

    @builtins.property
    def public_key_pem(self) -> typing.Optional[str]:
        """A PEM-encoded public key, as described in 'https://tools.ietf.org/html/rfc7468#section-13'."""
        return self._values.get('public_key_pem')

    @builtins.property
    def signature_algorithm(self) -> typing.Optional[str]:
        """The signature algorithm used to verify a message against a signature using this key.

        These signature algorithm must
        match the structure and any object identifiers encoded in
        publicKeyPem (i.e. this algorithm must match that of the
        public key).
        """
        return self._values.get('signature_algorithm')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'attestation_authority_note': 'attestationAuthorityNote', 'name': 'name', 'description': 'description', 'project': 'project', 'timeouts': 'timeouts'})
class BinaryAuthorizationAttestorConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, attestation_authority_note: typing.List["BinaryAuthorizationAttestorAttestationAuthorityNote"], name: str, description: typing.Optional[str]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["BinaryAuthorizationAttestorTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param attestation_authority_note: attestation_authority_note block.
        :param name: The resource name.
        :param description: A descriptive comment. This field may be updated. The field may be displayed in chooser dialogs.
        :param project: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = BinaryAuthorizationAttestorTimeouts(**timeouts)
        self._values = {
            'attestation_authority_note': attestation_authority_note,
            'name': name,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if description is not None: self._values["description"] = description
        if project is not None: self._values["project"] = project
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def attestation_authority_note(self) -> typing.List["BinaryAuthorizationAttestorAttestationAuthorityNote"]:
        """attestation_authority_note block."""
        return self._values.get('attestation_authority_note')

    @builtins.property
    def name(self) -> str:
        """The resource name."""
        return self._values.get('name')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """A descriptive comment.

        This field may be updated. The field may be
        displayed in chooser dialogs.
        """
        return self._values.get('description')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def timeouts(self) -> typing.Optional["BinaryAuthorizationAttestorTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BinaryAuthorizationAttestorIamBinding(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorIamBinding"):
    def __init__(self, scope: constructs.Construct, id: str, *, attestor: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["BinaryAuthorizationAttestorIamBindingCondition"]]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param attestor: 
        :param members: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BinaryAuthorizationAttestorIamBindingConfig(attestor=attestor, members=members, role=role, condition=condition, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BinaryAuthorizationAttestorIamBinding, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="attestor")
    def attestor(self) -> str:
        return jsii.get(self, "attestor")

    @attestor.setter
    def attestor(self, value: str) -> None:
        jsii.set(self, "attestor", value)

    @builtins.property
    @jsii.member(jsii_name="members")
    def members(self) -> typing.List[str]:
        return jsii.get(self, "members")

    @members.setter
    def members(self, value: typing.List[str]) -> None:
        jsii.set(self, "members", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["BinaryAuthorizationAttestorIamBindingCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["BinaryAuthorizationAttestorIamBindingCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorIamBindingCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class BinaryAuthorizationAttestorIamBindingCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorIamBindingCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorIamBindingConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'attestor': 'attestor', 'members': 'members', 'role': 'role', 'condition': 'condition', 'project': 'project'})
class BinaryAuthorizationAttestorIamBindingConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, attestor: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["BinaryAuthorizationAttestorIamBindingCondition"]]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param attestor: 
        :param members: 
        :param role: 
        :param condition: condition block.
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'attestor': attestor,
            'members': members,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def attestor(self) -> str:
        return self._values.get('attestor')

    @builtins.property
    def members(self) -> typing.List[str]:
        return self._values.get('members')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["BinaryAuthorizationAttestorIamBindingCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorIamBindingConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BinaryAuthorizationAttestorIamMember(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorIamMember"):
    def __init__(self, scope: constructs.Construct, id: str, *, attestor: str, member: str, role: str, condition: typing.Optional[typing.List["BinaryAuthorizationAttestorIamMemberCondition"]]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param attestor: 
        :param member: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BinaryAuthorizationAttestorIamMemberConfig(attestor=attestor, member=member, role=role, condition=condition, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BinaryAuthorizationAttestorIamMember, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="attestor")
    def attestor(self) -> str:
        return jsii.get(self, "attestor")

    @attestor.setter
    def attestor(self, value: str) -> None:
        jsii.set(self, "attestor", value)

    @builtins.property
    @jsii.member(jsii_name="member")
    def member(self) -> str:
        return jsii.get(self, "member")

    @member.setter
    def member(self, value: str) -> None:
        jsii.set(self, "member", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["BinaryAuthorizationAttestorIamMemberCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["BinaryAuthorizationAttestorIamMemberCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorIamMemberCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class BinaryAuthorizationAttestorIamMemberCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorIamMemberCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorIamMemberConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'attestor': 'attestor', 'member': 'member', 'role': 'role', 'condition': 'condition', 'project': 'project'})
class BinaryAuthorizationAttestorIamMemberConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, attestor: str, member: str, role: str, condition: typing.Optional[typing.List["BinaryAuthorizationAttestorIamMemberCondition"]]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param attestor: 
        :param member: 
        :param role: 
        :param condition: condition block.
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'attestor': attestor,
            'member': member,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def attestor(self) -> str:
        return self._values.get('attestor')

    @builtins.property
    def member(self) -> str:
        return self._values.get('member')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["BinaryAuthorizationAttestorIamMemberCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorIamMemberConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BinaryAuthorizationAttestorIamPolicy(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorIamPolicy"):
    def __init__(self, scope: constructs.Construct, id: str, *, attestor: str, policy_data: str, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param attestor: 
        :param policy_data: 
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BinaryAuthorizationAttestorIamPolicyConfig(attestor=attestor, policy_data=policy_data, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BinaryAuthorizationAttestorIamPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="attestor")
    def attestor(self) -> str:
        return jsii.get(self, "attestor")

    @attestor.setter
    def attestor(self, value: str) -> None:
        jsii.set(self, "attestor", value)

    @builtins.property
    @jsii.member(jsii_name="policyData")
    def policy_data(self) -> str:
        return jsii.get(self, "policyData")

    @policy_data.setter
    def policy_data(self, value: str) -> None:
        jsii.set(self, "policyData", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorIamPolicyConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'attestor': 'attestor', 'policy_data': 'policyData', 'project': 'project'})
class BinaryAuthorizationAttestorIamPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, attestor: str, policy_data: str, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param attestor: 
        :param policy_data: 
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'attestor': attestor,
            'policy_data': policy_data,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def attestor(self) -> str:
        return self._values.get('attestor')

    @builtins.property
    def policy_data(self) -> str:
        return self._values.get('policy_data')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorIamPolicyConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationAttestorTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class BinaryAuthorizationAttestorTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationAttestorTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class BinaryAuthorizationPolicy(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.BinaryAuthorizationPolicy"):
    def __init__(self, scope: constructs.Construct, id: str, *, default_admission_rule: typing.List["BinaryAuthorizationPolicyDefaultAdmissionRule"], admission_whitelist_patterns: typing.Optional[typing.List["BinaryAuthorizationPolicyAdmissionWhitelistPatterns"]]=None, cluster_admission_rules: typing.Optional[typing.List["BinaryAuthorizationPolicyClusterAdmissionRules"]]=None, description: typing.Optional[str]=None, global_policy_evaluation_mode: typing.Optional[str]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["BinaryAuthorizationPolicyTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param default_admission_rule: default_admission_rule block.
        :param admission_whitelist_patterns: admission_whitelist_patterns block.
        :param cluster_admission_rules: cluster_admission_rules block.
        :param description: A descriptive comment.
        :param global_policy_evaluation_mode: Controls the evaluation of a Google-maintained global admission policy for common system-level images. Images not covered by the global policy will be subject to the project admission policy. Possible values: ["ENABLE", "DISABLE"]
        :param project: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = BinaryAuthorizationPolicyConfig(default_admission_rule=default_admission_rule, admission_whitelist_patterns=admission_whitelist_patterns, cluster_admission_rules=cluster_admission_rules, description=description, global_policy_evaluation_mode=global_policy_evaluation_mode, project=project, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(BinaryAuthorizationPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="defaultAdmissionRule")
    def default_admission_rule(self) -> typing.List["BinaryAuthorizationPolicyDefaultAdmissionRule"]:
        return jsii.get(self, "defaultAdmissionRule")

    @default_admission_rule.setter
    def default_admission_rule(self, value: typing.List["BinaryAuthorizationPolicyDefaultAdmissionRule"]) -> None:
        jsii.set(self, "defaultAdmissionRule", value)

    @builtins.property
    @jsii.member(jsii_name="admissionWhitelistPatterns")
    def admission_whitelist_patterns(self) -> typing.Optional[typing.List["BinaryAuthorizationPolicyAdmissionWhitelistPatterns"]]:
        return jsii.get(self, "admissionWhitelistPatterns")

    @admission_whitelist_patterns.setter
    def admission_whitelist_patterns(self, value: typing.Optional[typing.List["BinaryAuthorizationPolicyAdmissionWhitelistPatterns"]]) -> None:
        jsii.set(self, "admissionWhitelistPatterns", value)

    @builtins.property
    @jsii.member(jsii_name="clusterAdmissionRules")
    def cluster_admission_rules(self) -> typing.Optional[typing.List["BinaryAuthorizationPolicyClusterAdmissionRules"]]:
        return jsii.get(self, "clusterAdmissionRules")

    @cluster_admission_rules.setter
    def cluster_admission_rules(self, value: typing.Optional[typing.List["BinaryAuthorizationPolicyClusterAdmissionRules"]]) -> None:
        jsii.set(self, "clusterAdmissionRules", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="globalPolicyEvaluationMode")
    def global_policy_evaluation_mode(self) -> typing.Optional[str]:
        return jsii.get(self, "globalPolicyEvaluationMode")

    @global_policy_evaluation_mode.setter
    def global_policy_evaluation_mode(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "globalPolicyEvaluationMode", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["BinaryAuthorizationPolicyTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["BinaryAuthorizationPolicyTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationPolicyAdmissionWhitelistPatterns", jsii_struct_bases=[], name_mapping={'name_pattern': 'namePattern'})
class BinaryAuthorizationPolicyAdmissionWhitelistPatterns():
    def __init__(self, *, name_pattern: str) -> None:
        """
        :param name_pattern: An image name pattern to whitelist, in the form 'registry/path/to/image'. This supports a trailing * as a wildcard, but this is allowed only in text after the registry/ part.
        """
        self._values = {
            'name_pattern': name_pattern,
        }

    @builtins.property
    def name_pattern(self) -> str:
        """An image name pattern to whitelist, in the form 'registry/path/to/image'.

        This supports a trailing * as a
        wildcard, but this is allowed only in text after the registry/
        part.
        """
        return self._values.get('name_pattern')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationPolicyAdmissionWhitelistPatterns(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationPolicyClusterAdmissionRules", jsii_struct_bases=[], name_mapping={'cluster': 'cluster', 'enforcement_mode': 'enforcementMode', 'evaluation_mode': 'evaluationMode', 'require_attestations_by': 'requireAttestationsBy'})
class BinaryAuthorizationPolicyClusterAdmissionRules():
    def __init__(self, *, cluster: str, enforcement_mode: str, evaluation_mode: str, require_attestations_by: typing.Optional[typing.List[str]]=None) -> None:
        """
        :param cluster: 
        :param enforcement_mode: The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"]
        :param evaluation_mode: How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"]
        :param require_attestations_by: The resource names of the attestors that must attest to a container image. If the attestor is in a different project from the policy, it should be specified in the format 'projects/*/attestors/*'. Each attestor must exist before a policy can reference it. To add an attestor to a policy the principal issuing the policy change request must be able to read the attestor resource. Note: this field must be non-empty when the evaluation_mode field specifies REQUIRE_ATTESTATION, otherwise it must be empty.
        """
        self._values = {
            'cluster': cluster,
            'enforcement_mode': enforcement_mode,
            'evaluation_mode': evaluation_mode,
        }
        if require_attestations_by is not None: self._values["require_attestations_by"] = require_attestations_by

    @builtins.property
    def cluster(self) -> str:
        return self._values.get('cluster')

    @builtins.property
    def enforcement_mode(self) -> str:
        """The action when a pod creation is denied by the admission rule.

        Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"]
        """
        return self._values.get('enforcement_mode')

    @builtins.property
    def evaluation_mode(self) -> str:
        """How this admission rule will be evaluated.

        Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"]
        """
        return self._values.get('evaluation_mode')

    @builtins.property
    def require_attestations_by(self) -> typing.Optional[typing.List[str]]:
        """The resource names of the attestors that must attest to a container image.

        If the attestor is in a different project from the
        policy, it should be specified in the format 'projects/*/attestors/*'.
        Each attestor must exist before a policy can reference it. To add an
        attestor to a policy the principal issuing the policy change
        request must be able to read the attestor resource.

        Note: this field must be non-empty when the evaluation_mode field
        specifies REQUIRE_ATTESTATION, otherwise it must be empty.
        """
        return self._values.get('require_attestations_by')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationPolicyClusterAdmissionRules(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationPolicyConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'default_admission_rule': 'defaultAdmissionRule', 'admission_whitelist_patterns': 'admissionWhitelistPatterns', 'cluster_admission_rules': 'clusterAdmissionRules', 'description': 'description', 'global_policy_evaluation_mode': 'globalPolicyEvaluationMode', 'project': 'project', 'timeouts': 'timeouts'})
class BinaryAuthorizationPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, default_admission_rule: typing.List["BinaryAuthorizationPolicyDefaultAdmissionRule"], admission_whitelist_patterns: typing.Optional[typing.List["BinaryAuthorizationPolicyAdmissionWhitelistPatterns"]]=None, cluster_admission_rules: typing.Optional[typing.List["BinaryAuthorizationPolicyClusterAdmissionRules"]]=None, description: typing.Optional[str]=None, global_policy_evaluation_mode: typing.Optional[str]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["BinaryAuthorizationPolicyTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param default_admission_rule: default_admission_rule block.
        :param admission_whitelist_patterns: admission_whitelist_patterns block.
        :param cluster_admission_rules: cluster_admission_rules block.
        :param description: A descriptive comment.
        :param global_policy_evaluation_mode: Controls the evaluation of a Google-maintained global admission policy for common system-level images. Images not covered by the global policy will be subject to the project admission policy. Possible values: ["ENABLE", "DISABLE"]
        :param project: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = BinaryAuthorizationPolicyTimeouts(**timeouts)
        self._values = {
            'default_admission_rule': default_admission_rule,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if admission_whitelist_patterns is not None: self._values["admission_whitelist_patterns"] = admission_whitelist_patterns
        if cluster_admission_rules is not None: self._values["cluster_admission_rules"] = cluster_admission_rules
        if description is not None: self._values["description"] = description
        if global_policy_evaluation_mode is not None: self._values["global_policy_evaluation_mode"] = global_policy_evaluation_mode
        if project is not None: self._values["project"] = project
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def default_admission_rule(self) -> typing.List["BinaryAuthorizationPolicyDefaultAdmissionRule"]:
        """default_admission_rule block."""
        return self._values.get('default_admission_rule')

    @builtins.property
    def admission_whitelist_patterns(self) -> typing.Optional[typing.List["BinaryAuthorizationPolicyAdmissionWhitelistPatterns"]]:
        """admission_whitelist_patterns block."""
        return self._values.get('admission_whitelist_patterns')

    @builtins.property
    def cluster_admission_rules(self) -> typing.Optional[typing.List["BinaryAuthorizationPolicyClusterAdmissionRules"]]:
        """cluster_admission_rules block."""
        return self._values.get('cluster_admission_rules')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """A descriptive comment."""
        return self._values.get('description')

    @builtins.property
    def global_policy_evaluation_mode(self) -> typing.Optional[str]:
        """Controls the evaluation of a Google-maintained global admission policy for common system-level images.

        Images not covered by the global
        policy will be subject to the project admission policy. Possible values: ["ENABLE", "DISABLE"]
        """
        return self._values.get('global_policy_evaluation_mode')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def timeouts(self) -> typing.Optional["BinaryAuthorizationPolicyTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationPolicyConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationPolicyDefaultAdmissionRule", jsii_struct_bases=[], name_mapping={'enforcement_mode': 'enforcementMode', 'evaluation_mode': 'evaluationMode', 'require_attestations_by': 'requireAttestationsBy'})
class BinaryAuthorizationPolicyDefaultAdmissionRule():
    def __init__(self, *, enforcement_mode: str, evaluation_mode: str, require_attestations_by: typing.Optional[typing.List[str]]=None) -> None:
        """
        :param enforcement_mode: The action when a pod creation is denied by the admission rule. Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"]
        :param evaluation_mode: How this admission rule will be evaluated. Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"]
        :param require_attestations_by: The resource names of the attestors that must attest to a container image. If the attestor is in a different project from the policy, it should be specified in the format 'projects/*/attestors/*'. Each attestor must exist before a policy can reference it. To add an attestor to a policy the principal issuing the policy change request must be able to read the attestor resource. Note: this field must be non-empty when the evaluation_mode field specifies REQUIRE_ATTESTATION, otherwise it must be empty.
        """
        self._values = {
            'enforcement_mode': enforcement_mode,
            'evaluation_mode': evaluation_mode,
        }
        if require_attestations_by is not None: self._values["require_attestations_by"] = require_attestations_by

    @builtins.property
    def enforcement_mode(self) -> str:
        """The action when a pod creation is denied by the admission rule.

        Possible values: ["ENFORCED_BLOCK_AND_AUDIT_LOG", "DRYRUN_AUDIT_LOG_ONLY"]
        """
        return self._values.get('enforcement_mode')

    @builtins.property
    def evaluation_mode(self) -> str:
        """How this admission rule will be evaluated.

        Possible values: ["ALWAYS_ALLOW", "REQUIRE_ATTESTATION", "ALWAYS_DENY"]
        """
        return self._values.get('evaluation_mode')

    @builtins.property
    def require_attestations_by(self) -> typing.Optional[typing.List[str]]:
        """The resource names of the attestors that must attest to a container image.

        If the attestor is in a different project from the
        policy, it should be specified in the format 'projects/*/attestors/*'.
        Each attestor must exist before a policy can reference it. To add an
        attestor to a policy the principal issuing the policy change
        request must be able to read the attestor resource.

        Note: this field must be non-empty when the evaluation_mode field
        specifies REQUIRE_ATTESTATION, otherwise it must be empty.
        """
        return self._values.get('require_attestations_by')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationPolicyDefaultAdmissionRule(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.BinaryAuthorizationPolicyTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class BinaryAuthorizationPolicyTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'BinaryAuthorizationPolicyTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudAssetFolderFeed(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudAssetFolderFeed"):
    def __init__(self, scope: constructs.Construct, id: str, *, billing_project: str, feed_id: str, feed_output_config: typing.List["CloudAssetFolderFeedFeedOutputConfig"], folder: str, asset_names: typing.Optional[typing.List[str]]=None, asset_types: typing.Optional[typing.List[str]]=None, content_type: typing.Optional[str]=None, timeouts: typing.Optional["CloudAssetFolderFeedTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param billing_project: The project whose identity will be used when sending messages to the destination pubsub topic. It also specifies the project for API enablement check, quota, and billing.
        :param feed_id: This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
        :param feed_output_config: feed_output_config block.
        :param folder: The folder this feed should be created in.
        :param asset_names: A list of the full names of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1. See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
        :param asset_types: A list of types of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: "compute.googleapis.com/Disk" See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all supported asset types.
        :param content_type: Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudAssetFolderFeedConfig(billing_project=billing_project, feed_id=feed_id, feed_output_config=feed_output_config, folder=folder, asset_names=asset_names, asset_types=asset_types, content_type=content_type, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudAssetFolderFeed, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="folderId")
    def folder_id(self) -> str:
        return jsii.get(self, "folderId")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="billingProject")
    def billing_project(self) -> str:
        return jsii.get(self, "billingProject")

    @billing_project.setter
    def billing_project(self, value: str) -> None:
        jsii.set(self, "billingProject", value)

    @builtins.property
    @jsii.member(jsii_name="feedId")
    def feed_id(self) -> str:
        return jsii.get(self, "feedId")

    @feed_id.setter
    def feed_id(self, value: str) -> None:
        jsii.set(self, "feedId", value)

    @builtins.property
    @jsii.member(jsii_name="feedOutputConfig")
    def feed_output_config(self) -> typing.List["CloudAssetFolderFeedFeedOutputConfig"]:
        return jsii.get(self, "feedOutputConfig")

    @feed_output_config.setter
    def feed_output_config(self, value: typing.List["CloudAssetFolderFeedFeedOutputConfig"]) -> None:
        jsii.set(self, "feedOutputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="folder")
    def folder(self) -> str:
        return jsii.get(self, "folder")

    @folder.setter
    def folder(self, value: str) -> None:
        jsii.set(self, "folder", value)

    @builtins.property
    @jsii.member(jsii_name="assetNames")
    def asset_names(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "assetNames")

    @asset_names.setter
    def asset_names(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "assetNames", value)

    @builtins.property
    @jsii.member(jsii_name="assetTypes")
    def asset_types(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "assetTypes")

    @asset_types.setter
    def asset_types(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "assetTypes", value)

    @builtins.property
    @jsii.member(jsii_name="contentType")
    def content_type(self) -> typing.Optional[str]:
        return jsii.get(self, "contentType")

    @content_type.setter
    def content_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "contentType", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudAssetFolderFeedTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudAssetFolderFeedTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetFolderFeedConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'billing_project': 'billingProject', 'feed_id': 'feedId', 'feed_output_config': 'feedOutputConfig', 'folder': 'folder', 'asset_names': 'assetNames', 'asset_types': 'assetTypes', 'content_type': 'contentType', 'timeouts': 'timeouts'})
class CloudAssetFolderFeedConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, billing_project: str, feed_id: str, feed_output_config: typing.List["CloudAssetFolderFeedFeedOutputConfig"], folder: str, asset_names: typing.Optional[typing.List[str]]=None, asset_types: typing.Optional[typing.List[str]]=None, content_type: typing.Optional[str]=None, timeouts: typing.Optional["CloudAssetFolderFeedTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param billing_project: The project whose identity will be used when sending messages to the destination pubsub topic. It also specifies the project for API enablement check, quota, and billing.
        :param feed_id: This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
        :param feed_output_config: feed_output_config block.
        :param folder: The folder this feed should be created in.
        :param asset_names: A list of the full names of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1. See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
        :param asset_types: A list of types of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: "compute.googleapis.com/Disk" See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all supported asset types.
        :param content_type: Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudAssetFolderFeedTimeouts(**timeouts)
        self._values = {
            'billing_project': billing_project,
            'feed_id': feed_id,
            'feed_output_config': feed_output_config,
            'folder': folder,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if asset_names is not None: self._values["asset_names"] = asset_names
        if asset_types is not None: self._values["asset_types"] = asset_types
        if content_type is not None: self._values["content_type"] = content_type
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def billing_project(self) -> str:
        """The project whose identity will be used when sending messages to the destination pubsub topic.

        It also specifies the project for API
        enablement check, quota, and billing.
        """
        return self._values.get('billing_project')

    @builtins.property
    def feed_id(self) -> str:
        """This is the client-assigned asset feed identifier and it needs to be unique under a specific parent."""
        return self._values.get('feed_id')

    @builtins.property
    def feed_output_config(self) -> typing.List["CloudAssetFolderFeedFeedOutputConfig"]:
        """feed_output_config block."""
        return self._values.get('feed_output_config')

    @builtins.property
    def folder(self) -> str:
        """The folder this feed should be created in."""
        return self._values.get('folder')

    @builtins.property
    def asset_names(self) -> typing.Optional[typing.List[str]]:
        """A list of the full names of the assets to receive updates.

        You must specify either or both of
        assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
        exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
        See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
        """
        return self._values.get('asset_names')

    @builtins.property
    def asset_types(self) -> typing.Optional[typing.List[str]]:
        """A list of types of the assets to receive updates.

        You must specify either or both of assetNames
        and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
        the feed. For example: "compute.googleapis.com/Disk"
        See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
        supported asset types.
        """
        return self._values.get('asset_types')

    @builtins.property
    def content_type(self) -> typing.Optional[str]:
        """Asset content type.

        If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
        """
        return self._values.get('content_type')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudAssetFolderFeedTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetFolderFeedConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetFolderFeedFeedOutputConfig", jsii_struct_bases=[], name_mapping={'pubsub_destination': 'pubsubDestination'})
class CloudAssetFolderFeedFeedOutputConfig():
    def __init__(self, *, pubsub_destination: typing.List["CloudAssetFolderFeedFeedOutputConfigPubsubDestination"]) -> None:
        """
        :param pubsub_destination: pubsub_destination block.
        """
        self._values = {
            'pubsub_destination': pubsub_destination,
        }

    @builtins.property
    def pubsub_destination(self) -> typing.List["CloudAssetFolderFeedFeedOutputConfigPubsubDestination"]:
        """pubsub_destination block."""
        return self._values.get('pubsub_destination')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetFolderFeedFeedOutputConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetFolderFeedFeedOutputConfigPubsubDestination", jsii_struct_bases=[], name_mapping={'topic': 'topic'})
class CloudAssetFolderFeedFeedOutputConfigPubsubDestination():
    def __init__(self, *, topic: str) -> None:
        """
        :param topic: Destination on Cloud Pubsub topic.
        """
        self._values = {
            'topic': topic,
        }

    @builtins.property
    def topic(self) -> str:
        """Destination on Cloud Pubsub topic."""
        return self._values.get('topic')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetFolderFeedFeedOutputConfigPubsubDestination(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetFolderFeedTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class CloudAssetFolderFeedTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetFolderFeedTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudAssetOrganizationFeed(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudAssetOrganizationFeed"):
    def __init__(self, scope: constructs.Construct, id: str, *, billing_project: str, feed_id: str, feed_output_config: typing.List["CloudAssetOrganizationFeedFeedOutputConfig"], org_id: str, asset_names: typing.Optional[typing.List[str]]=None, asset_types: typing.Optional[typing.List[str]]=None, content_type: typing.Optional[str]=None, timeouts: typing.Optional["CloudAssetOrganizationFeedTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param billing_project: The project whose identity will be used when sending messages to the destination pubsub topic. It also specifies the project for API enablement check, quota, and billing.
        :param feed_id: This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
        :param feed_output_config: feed_output_config block.
        :param org_id: The organization this feed should be created in.
        :param asset_names: A list of the full names of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1. See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
        :param asset_types: A list of types of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: "compute.googleapis.com/Disk" See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all supported asset types.
        :param content_type: Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudAssetOrganizationFeedConfig(billing_project=billing_project, feed_id=feed_id, feed_output_config=feed_output_config, org_id=org_id, asset_names=asset_names, asset_types=asset_types, content_type=content_type, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudAssetOrganizationFeed, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="billingProject")
    def billing_project(self) -> str:
        return jsii.get(self, "billingProject")

    @billing_project.setter
    def billing_project(self, value: str) -> None:
        jsii.set(self, "billingProject", value)

    @builtins.property
    @jsii.member(jsii_name="feedId")
    def feed_id(self) -> str:
        return jsii.get(self, "feedId")

    @feed_id.setter
    def feed_id(self, value: str) -> None:
        jsii.set(self, "feedId", value)

    @builtins.property
    @jsii.member(jsii_name="feedOutputConfig")
    def feed_output_config(self) -> typing.List["CloudAssetOrganizationFeedFeedOutputConfig"]:
        return jsii.get(self, "feedOutputConfig")

    @feed_output_config.setter
    def feed_output_config(self, value: typing.List["CloudAssetOrganizationFeedFeedOutputConfig"]) -> None:
        jsii.set(self, "feedOutputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="orgId")
    def org_id(self) -> str:
        return jsii.get(self, "orgId")

    @org_id.setter
    def org_id(self, value: str) -> None:
        jsii.set(self, "orgId", value)

    @builtins.property
    @jsii.member(jsii_name="assetNames")
    def asset_names(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "assetNames")

    @asset_names.setter
    def asset_names(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "assetNames", value)

    @builtins.property
    @jsii.member(jsii_name="assetTypes")
    def asset_types(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "assetTypes")

    @asset_types.setter
    def asset_types(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "assetTypes", value)

    @builtins.property
    @jsii.member(jsii_name="contentType")
    def content_type(self) -> typing.Optional[str]:
        return jsii.get(self, "contentType")

    @content_type.setter
    def content_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "contentType", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudAssetOrganizationFeedTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudAssetOrganizationFeedTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetOrganizationFeedConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'billing_project': 'billingProject', 'feed_id': 'feedId', 'feed_output_config': 'feedOutputConfig', 'org_id': 'orgId', 'asset_names': 'assetNames', 'asset_types': 'assetTypes', 'content_type': 'contentType', 'timeouts': 'timeouts'})
class CloudAssetOrganizationFeedConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, billing_project: str, feed_id: str, feed_output_config: typing.List["CloudAssetOrganizationFeedFeedOutputConfig"], org_id: str, asset_names: typing.Optional[typing.List[str]]=None, asset_types: typing.Optional[typing.List[str]]=None, content_type: typing.Optional[str]=None, timeouts: typing.Optional["CloudAssetOrganizationFeedTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param billing_project: The project whose identity will be used when sending messages to the destination pubsub topic. It also specifies the project for API enablement check, quota, and billing.
        :param feed_id: This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
        :param feed_output_config: feed_output_config block.
        :param org_id: The organization this feed should be created in.
        :param asset_names: A list of the full names of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1. See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
        :param asset_types: A list of types of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: "compute.googleapis.com/Disk" See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all supported asset types.
        :param content_type: Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudAssetOrganizationFeedTimeouts(**timeouts)
        self._values = {
            'billing_project': billing_project,
            'feed_id': feed_id,
            'feed_output_config': feed_output_config,
            'org_id': org_id,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if asset_names is not None: self._values["asset_names"] = asset_names
        if asset_types is not None: self._values["asset_types"] = asset_types
        if content_type is not None: self._values["content_type"] = content_type
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def billing_project(self) -> str:
        """The project whose identity will be used when sending messages to the destination pubsub topic.

        It also specifies the project for API
        enablement check, quota, and billing.
        """
        return self._values.get('billing_project')

    @builtins.property
    def feed_id(self) -> str:
        """This is the client-assigned asset feed identifier and it needs to be unique under a specific parent."""
        return self._values.get('feed_id')

    @builtins.property
    def feed_output_config(self) -> typing.List["CloudAssetOrganizationFeedFeedOutputConfig"]:
        """feed_output_config block."""
        return self._values.get('feed_output_config')

    @builtins.property
    def org_id(self) -> str:
        """The organization this feed should be created in."""
        return self._values.get('org_id')

    @builtins.property
    def asset_names(self) -> typing.Optional[typing.List[str]]:
        """A list of the full names of the assets to receive updates.

        You must specify either or both of
        assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
        exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
        See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
        """
        return self._values.get('asset_names')

    @builtins.property
    def asset_types(self) -> typing.Optional[typing.List[str]]:
        """A list of types of the assets to receive updates.

        You must specify either or both of assetNames
        and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
        the feed. For example: "compute.googleapis.com/Disk"
        See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
        supported asset types.
        """
        return self._values.get('asset_types')

    @builtins.property
    def content_type(self) -> typing.Optional[str]:
        """Asset content type.

        If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
        """
        return self._values.get('content_type')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudAssetOrganizationFeedTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetOrganizationFeedConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetOrganizationFeedFeedOutputConfig", jsii_struct_bases=[], name_mapping={'pubsub_destination': 'pubsubDestination'})
class CloudAssetOrganizationFeedFeedOutputConfig():
    def __init__(self, *, pubsub_destination: typing.List["CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination"]) -> None:
        """
        :param pubsub_destination: pubsub_destination block.
        """
        self._values = {
            'pubsub_destination': pubsub_destination,
        }

    @builtins.property
    def pubsub_destination(self) -> typing.List["CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination"]:
        """pubsub_destination block."""
        return self._values.get('pubsub_destination')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetOrganizationFeedFeedOutputConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination", jsii_struct_bases=[], name_mapping={'topic': 'topic'})
class CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination():
    def __init__(self, *, topic: str) -> None:
        """
        :param topic: Destination on Cloud Pubsub topic.
        """
        self._values = {
            'topic': topic,
        }

    @builtins.property
    def topic(self) -> str:
        """Destination on Cloud Pubsub topic."""
        return self._values.get('topic')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetOrganizationFeedTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class CloudAssetOrganizationFeedTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetOrganizationFeedTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudAssetProjectFeed(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudAssetProjectFeed"):
    def __init__(self, scope: constructs.Construct, id: str, *, feed_id: str, feed_output_config: typing.List["CloudAssetProjectFeedFeedOutputConfig"], asset_names: typing.Optional[typing.List[str]]=None, asset_types: typing.Optional[typing.List[str]]=None, billing_project: typing.Optional[str]=None, content_type: typing.Optional[str]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["CloudAssetProjectFeedTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param feed_id: This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
        :param feed_output_config: feed_output_config block.
        :param asset_names: A list of the full names of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1. See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
        :param asset_types: A list of types of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: "compute.googleapis.com/Disk" See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all supported asset types.
        :param billing_project: The project whose identity will be used when sending messages to the destination pubsub topic. It also specifies the project for API enablement check, quota, and billing. If not specified, the resource's project will be used.
        :param content_type: Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
        :param project: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudAssetProjectFeedConfig(feed_id=feed_id, feed_output_config=feed_output_config, asset_names=asset_names, asset_types=asset_types, billing_project=billing_project, content_type=content_type, project=project, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudAssetProjectFeed, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="feedId")
    def feed_id(self) -> str:
        return jsii.get(self, "feedId")

    @feed_id.setter
    def feed_id(self, value: str) -> None:
        jsii.set(self, "feedId", value)

    @builtins.property
    @jsii.member(jsii_name="feedOutputConfig")
    def feed_output_config(self) -> typing.List["CloudAssetProjectFeedFeedOutputConfig"]:
        return jsii.get(self, "feedOutputConfig")

    @feed_output_config.setter
    def feed_output_config(self, value: typing.List["CloudAssetProjectFeedFeedOutputConfig"]) -> None:
        jsii.set(self, "feedOutputConfig", value)

    @builtins.property
    @jsii.member(jsii_name="assetNames")
    def asset_names(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "assetNames")

    @asset_names.setter
    def asset_names(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "assetNames", value)

    @builtins.property
    @jsii.member(jsii_name="assetTypes")
    def asset_types(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "assetTypes")

    @asset_types.setter
    def asset_types(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "assetTypes", value)

    @builtins.property
    @jsii.member(jsii_name="billingProject")
    def billing_project(self) -> typing.Optional[str]:
        return jsii.get(self, "billingProject")

    @billing_project.setter
    def billing_project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "billingProject", value)

    @builtins.property
    @jsii.member(jsii_name="contentType")
    def content_type(self) -> typing.Optional[str]:
        return jsii.get(self, "contentType")

    @content_type.setter
    def content_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "contentType", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudAssetProjectFeedTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudAssetProjectFeedTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetProjectFeedConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'feed_id': 'feedId', 'feed_output_config': 'feedOutputConfig', 'asset_names': 'assetNames', 'asset_types': 'assetTypes', 'billing_project': 'billingProject', 'content_type': 'contentType', 'project': 'project', 'timeouts': 'timeouts'})
class CloudAssetProjectFeedConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, feed_id: str, feed_output_config: typing.List["CloudAssetProjectFeedFeedOutputConfig"], asset_names: typing.Optional[typing.List[str]]=None, asset_types: typing.Optional[typing.List[str]]=None, billing_project: typing.Optional[str]=None, content_type: typing.Optional[str]=None, project: typing.Optional[str]=None, timeouts: typing.Optional["CloudAssetProjectFeedTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param feed_id: This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
        :param feed_output_config: feed_output_config block.
        :param asset_names: A list of the full names of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1. See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
        :param asset_types: A list of types of the assets to receive updates. You must specify either or both of assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to the feed. For example: "compute.googleapis.com/Disk" See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all supported asset types.
        :param billing_project: The project whose identity will be used when sending messages to the destination pubsub topic. It also specifies the project for API enablement check, quota, and billing. If not specified, the resource's project will be used.
        :param content_type: Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
        :param project: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudAssetProjectFeedTimeouts(**timeouts)
        self._values = {
            'feed_id': feed_id,
            'feed_output_config': feed_output_config,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if asset_names is not None: self._values["asset_names"] = asset_names
        if asset_types is not None: self._values["asset_types"] = asset_types
        if billing_project is not None: self._values["billing_project"] = billing_project
        if content_type is not None: self._values["content_type"] = content_type
        if project is not None: self._values["project"] = project
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def feed_id(self) -> str:
        """This is the client-assigned asset feed identifier and it needs to be unique under a specific parent."""
        return self._values.get('feed_id')

    @builtins.property
    def feed_output_config(self) -> typing.List["CloudAssetProjectFeedFeedOutputConfig"]:
        """feed_output_config block."""
        return self._values.get('feed_output_config')

    @builtins.property
    def asset_names(self) -> typing.Optional[typing.List[str]]:
        """A list of the full names of the assets to receive updates.

        You must specify either or both of
        assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
        exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
        See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
        """
        return self._values.get('asset_names')

    @builtins.property
    def asset_types(self) -> typing.Optional[typing.List[str]]:
        """A list of types of the assets to receive updates.

        You must specify either or both of assetNames
        and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
        the feed. For example: "compute.googleapis.com/Disk"
        See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
        supported asset types.
        """
        return self._values.get('asset_types')

    @builtins.property
    def billing_project(self) -> typing.Optional[str]:
        """The project whose identity will be used when sending messages to the destination pubsub topic.

        It also specifies the project for API
        enablement check, quota, and billing. If not specified, the resource's
        project will be used.
        """
        return self._values.get('billing_project')

    @builtins.property
    def content_type(self) -> typing.Optional[str]:
        """Asset content type.

        If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
        """
        return self._values.get('content_type')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudAssetProjectFeedTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetProjectFeedConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetProjectFeedFeedOutputConfig", jsii_struct_bases=[], name_mapping={'pubsub_destination': 'pubsubDestination'})
class CloudAssetProjectFeedFeedOutputConfig():
    def __init__(self, *, pubsub_destination: typing.List["CloudAssetProjectFeedFeedOutputConfigPubsubDestination"]) -> None:
        """
        :param pubsub_destination: pubsub_destination block.
        """
        self._values = {
            'pubsub_destination': pubsub_destination,
        }

    @builtins.property
    def pubsub_destination(self) -> typing.List["CloudAssetProjectFeedFeedOutputConfigPubsubDestination"]:
        """pubsub_destination block."""
        return self._values.get('pubsub_destination')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetProjectFeedFeedOutputConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetProjectFeedFeedOutputConfigPubsubDestination", jsii_struct_bases=[], name_mapping={'topic': 'topic'})
class CloudAssetProjectFeedFeedOutputConfigPubsubDestination():
    def __init__(self, *, topic: str) -> None:
        """
        :param topic: Destination on Cloud Pubsub topic.
        """
        self._values = {
            'topic': topic,
        }

    @builtins.property
    def topic(self) -> str:
        """Destination on Cloud Pubsub topic."""
        return self._values.get('topic')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetProjectFeedFeedOutputConfigPubsubDestination(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudAssetProjectFeedTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class CloudAssetProjectFeedTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudAssetProjectFeedTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudRunDomainMapping(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunDomainMapping"):
    def __init__(self, scope: constructs.Construct, id: str, *, location: str, metadata: typing.List["CloudRunDomainMappingMetadata"], name: str, spec: typing.List["CloudRunDomainMappingSpec"], project: typing.Optional[str]=None, timeouts: typing.Optional["CloudRunDomainMappingTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param location: The location of the cloud run instance. eg us-central1
        :param metadata: metadata block.
        :param name: Name should be a verified domain.
        :param spec: spec block.
        :param project: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudRunDomainMappingConfig(location=location, metadata=metadata, name=name, spec=spec, project=project, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudRunDomainMapping, self, [scope, id, config])

    @jsii.member(jsii_name="status")
    def status(self, index: str) -> "CloudRunDomainMappingStatus":
        """
        :param index: -
        """
        return jsii.invoke(self, "status", [index])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> str:
        return jsii.get(self, "location")

    @location.setter
    def location(self, value: str) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="metadata")
    def metadata(self) -> typing.List["CloudRunDomainMappingMetadata"]:
        return jsii.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: typing.List["CloudRunDomainMappingMetadata"]) -> None:
        jsii.set(self, "metadata", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="spec")
    def spec(self) -> typing.List["CloudRunDomainMappingSpec"]:
        return jsii.get(self, "spec")

    @spec.setter
    def spec(self, value: typing.List["CloudRunDomainMappingSpec"]) -> None:
        jsii.set(self, "spec", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudRunDomainMappingTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudRunDomainMappingTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunDomainMappingConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'location': 'location', 'metadata': 'metadata', 'name': 'name', 'spec': 'spec', 'project': 'project', 'timeouts': 'timeouts'})
class CloudRunDomainMappingConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, location: str, metadata: typing.List["CloudRunDomainMappingMetadata"], name: str, spec: typing.List["CloudRunDomainMappingSpec"], project: typing.Optional[str]=None, timeouts: typing.Optional["CloudRunDomainMappingTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: The location of the cloud run instance. eg us-central1
        :param metadata: metadata block.
        :param name: Name should be a verified domain.
        :param spec: spec block.
        :param project: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudRunDomainMappingTimeouts(**timeouts)
        self._values = {
            'location': location,
            'metadata': metadata,
            'name': name,
            'spec': spec,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if project is not None: self._values["project"] = project
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def location(self) -> str:
        """The location of the cloud run instance.

        eg us-central1
        """
        return self._values.get('location')

    @builtins.property
    def metadata(self) -> typing.List["CloudRunDomainMappingMetadata"]:
        """metadata block."""
        return self._values.get('metadata')

    @builtins.property
    def name(self) -> str:
        """Name should be a verified domain."""
        return self._values.get('name')

    @builtins.property
    def spec(self) -> typing.List["CloudRunDomainMappingSpec"]:
        """spec block."""
        return self._values.get('spec')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudRunDomainMappingTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunDomainMappingConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunDomainMappingMetadata", jsii_struct_bases=[], name_mapping={'namespace': 'namespace', 'annotations': 'annotations', 'labels': 'labels'})
class CloudRunDomainMappingMetadata():
    def __init__(self, *, namespace: str, annotations: typing.Optional[typing.Mapping[str, str]]=None, labels: typing.Optional[typing.Mapping[str, str]]=None) -> None:
        """
        :param namespace: In Cloud Run the namespace must be equal to either the project ID or project number.
        :param annotations: Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
        :param labels: Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: http://kubernetes.io/docs/user-guide/labels
        """
        self._values = {
            'namespace': namespace,
        }
        if annotations is not None: self._values["annotations"] = annotations
        if labels is not None: self._values["labels"] = labels

    @builtins.property
    def namespace(self) -> str:
        """In Cloud Run the namespace must be equal to either the project ID or project number."""
        return self._values.get('namespace')

    @builtins.property
    def annotations(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.

        More
        info: http://kubernetes.io/docs/user-guide/annotations
        """
        return self._values.get('annotations')

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Map of string keys and values that can be used to organize and categorize (scope and select) objects.

        May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
        """
        return self._values.get('labels')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunDomainMappingMetadata(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunDomainMappingSpec", jsii_struct_bases=[], name_mapping={'route_name': 'routeName', 'certificate_mode': 'certificateMode', 'force_override': 'forceOverride'})
class CloudRunDomainMappingSpec():
    def __init__(self, *, route_name: str, certificate_mode: typing.Optional[str]=None, force_override: typing.Optional[bool]=None) -> None:
        """
        :param route_name: The name of the Cloud Run Service that this DomainMapping applies to. The route must exist.
        :param certificate_mode: The mode of the certificate. Default value: "AUTOMATIC" Possible values: ["NONE", "AUTOMATIC"]
        :param force_override: If set, the mapping will override any mapping set before this spec was set. It is recommended that the user leaves this empty to receive an error warning about a potential conflict and only set it once the respective UI has given such a warning.
        """
        self._values = {
            'route_name': route_name,
        }
        if certificate_mode is not None: self._values["certificate_mode"] = certificate_mode
        if force_override is not None: self._values["force_override"] = force_override

    @builtins.property
    def route_name(self) -> str:
        """The name of the Cloud Run Service that this DomainMapping applies to.

        The route must exist.
        """
        return self._values.get('route_name')

    @builtins.property
    def certificate_mode(self) -> typing.Optional[str]:
        """The mode of the certificate.

        Default value: "AUTOMATIC" Possible values: ["NONE", "AUTOMATIC"]
        """
        return self._values.get('certificate_mode')

    @builtins.property
    def force_override(self) -> typing.Optional[bool]:
        """If set, the mapping will override any mapping set before this spec was set.

        It is recommended that the user leaves this empty to receive an error
        warning about a potential conflict and only set it once the respective UI
        has given such a warning.
        """
        return self._values.get('force_override')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunDomainMappingSpec(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudRunDomainMappingStatus(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunDomainMappingStatus"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(CloudRunDomainMappingStatus, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="conditions")
    def conditions(self) -> typing.Any:
        return jsii.get(self, "conditions")

    @builtins.property
    @jsii.member(jsii_name="mappedRouteName")
    def mapped_route_name(self) -> str:
        return jsii.get(self, "mappedRouteName")

    @builtins.property
    @jsii.member(jsii_name="observedGeneration")
    def observed_generation(self) -> jsii.Number:
        return jsii.get(self, "observedGeneration")

    @builtins.property
    @jsii.member(jsii_name="resourceRecords")
    def resource_records(self) -> typing.Any:
        return jsii.get(self, "resourceRecords")


class CloudRunDomainMappingStatusConditions(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunDomainMappingStatusConditions"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(CloudRunDomainMappingStatusConditions, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="message")
    def message(self) -> str:
        return jsii.get(self, "message")

    @builtins.property
    @jsii.member(jsii_name="reason")
    def reason(self) -> str:
        return jsii.get(self, "reason")

    @builtins.property
    @jsii.member(jsii_name="status")
    def status(self) -> str:
        return jsii.get(self, "status")

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> str:
        return jsii.get(self, "type")


class CloudRunDomainMappingStatusResourceRecords(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunDomainMappingStatusResourceRecords"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(CloudRunDomainMappingStatusResourceRecords, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="rrdata")
    def rrdata(self) -> str:
        return jsii.get(self, "rrdata")

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> str:
        return jsii.get(self, "type")


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunDomainMappingTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete'})
class CloudRunDomainMappingTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunDomainMappingTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudRunService(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunService"):
    def __init__(self, scope: constructs.Construct, id: str, *, location: str, name: str, autogenerate_revision_name: typing.Optional[bool]=None, metadata: typing.Optional[typing.List["CloudRunServiceMetadata"]]=None, project: typing.Optional[str]=None, template: typing.Optional[typing.List["CloudRunServiceTemplate"]]=None, timeouts: typing.Optional["CloudRunServiceTimeouts"]=None, traffic: typing.Optional[typing.List["CloudRunServiceTraffic"]]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param location: The location of the cloud run instance. eg us-central1
        :param name: Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param autogenerate_revision_name: 
        :param metadata: metadata block.
        :param project: 
        :param template: template block.
        :param timeouts: timeouts block.
        :param traffic: traffic block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudRunServiceConfig(location=location, name=name, autogenerate_revision_name=autogenerate_revision_name, metadata=metadata, project=project, template=template, timeouts=timeouts, traffic=traffic, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudRunService, self, [scope, id, config])

    @jsii.member(jsii_name="status")
    def status(self, index: str) -> "CloudRunServiceStatus":
        """
        :param index: -
        """
        return jsii.invoke(self, "status", [index])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> str:
        return jsii.get(self, "location")

    @location.setter
    def location(self, value: str) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="autogenerateRevisionName")
    def autogenerate_revision_name(self) -> typing.Optional[bool]:
        return jsii.get(self, "autogenerateRevisionName")

    @autogenerate_revision_name.setter
    def autogenerate_revision_name(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "autogenerateRevisionName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="metadata")
    def metadata(self) -> typing.Optional[typing.List["CloudRunServiceMetadata"]]:
        return jsii.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: typing.Optional[typing.List["CloudRunServiceMetadata"]]) -> None:
        jsii.set(self, "metadata", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="template")
    def template(self) -> typing.Optional[typing.List["CloudRunServiceTemplate"]]:
        return jsii.get(self, "template")

    @template.setter
    def template(self, value: typing.Optional[typing.List["CloudRunServiceTemplate"]]) -> None:
        jsii.set(self, "template", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudRunServiceTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudRunServiceTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="traffic")
    def traffic(self) -> typing.Optional[typing.List["CloudRunServiceTraffic"]]:
        return jsii.get(self, "traffic")

    @traffic.setter
    def traffic(self, value: typing.Optional[typing.List["CloudRunServiceTraffic"]]) -> None:
        jsii.set(self, "traffic", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'location': 'location', 'name': 'name', 'autogenerate_revision_name': 'autogenerateRevisionName', 'metadata': 'metadata', 'project': 'project', 'template': 'template', 'timeouts': 'timeouts', 'traffic': 'traffic'})
class CloudRunServiceConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, location: str, name: str, autogenerate_revision_name: typing.Optional[bool]=None, metadata: typing.Optional[typing.List["CloudRunServiceMetadata"]]=None, project: typing.Optional[str]=None, template: typing.Optional[typing.List["CloudRunServiceTemplate"]]=None, timeouts: typing.Optional["CloudRunServiceTimeouts"]=None, traffic: typing.Optional[typing.List["CloudRunServiceTraffic"]]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: The location of the cloud run instance. eg us-central1
        :param name: Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param autogenerate_revision_name: 
        :param metadata: metadata block.
        :param project: 
        :param template: template block.
        :param timeouts: timeouts block.
        :param traffic: traffic block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudRunServiceTimeouts(**timeouts)
        self._values = {
            'location': location,
            'name': name,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if autogenerate_revision_name is not None: self._values["autogenerate_revision_name"] = autogenerate_revision_name
        if metadata is not None: self._values["metadata"] = metadata
        if project is not None: self._values["project"] = project
        if template is not None: self._values["template"] = template
        if timeouts is not None: self._values["timeouts"] = timeouts
        if traffic is not None: self._values["traffic"] = traffic

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def location(self) -> str:
        """The location of the cloud run instance.

        eg us-central1
        """
        return self._values.get('location')

    @builtins.property
    def name(self) -> str:
        """Name must be unique within a namespace, within a Cloud Run region.

        Is required when creating resources. Name is primarily intended
        for creation idempotence and configuration definition. Cannot be updated.
        More info: http://kubernetes.io/docs/user-guide/identifiers#names
        """
        return self._values.get('name')

    @builtins.property
    def autogenerate_revision_name(self) -> typing.Optional[bool]:
        return self._values.get('autogenerate_revision_name')

    @builtins.property
    def metadata(self) -> typing.Optional[typing.List["CloudRunServiceMetadata"]]:
        """metadata block."""
        return self._values.get('metadata')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def template(self) -> typing.Optional[typing.List["CloudRunServiceTemplate"]]:
        """template block."""
        return self._values.get('template')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudRunServiceTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    @builtins.property
    def traffic(self) -> typing.Optional[typing.List["CloudRunServiceTraffic"]]:
        """traffic block."""
        return self._values.get('traffic')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudRunServiceIamBinding(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunServiceIamBinding"):
    def __init__(self, scope: constructs.Construct, id: str, *, members: typing.List[str], role: str, service: str, condition: typing.Optional[typing.List["CloudRunServiceIamBindingCondition"]]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param members: 
        :param role: 
        :param service: 
        :param condition: condition block.
        :param location: 
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudRunServiceIamBindingConfig(members=members, role=role, service=service, condition=condition, location=location, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudRunServiceIamBinding, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="members")
    def members(self) -> typing.List[str]:
        return jsii.get(self, "members")

    @members.setter
    def members(self, value: typing.List[str]) -> None:
        jsii.set(self, "members", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> str:
        return jsii.get(self, "service")

    @service.setter
    def service(self, value: str) -> None:
        jsii.set(self, "service", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["CloudRunServiceIamBindingCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["CloudRunServiceIamBindingCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> typing.Optional[str]:
        return jsii.get(self, "location")

    @location.setter
    def location(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceIamBindingCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class CloudRunServiceIamBindingCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceIamBindingCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceIamBindingConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'members': 'members', 'role': 'role', 'service': 'service', 'condition': 'condition', 'location': 'location', 'project': 'project'})
class CloudRunServiceIamBindingConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, members: typing.List[str], role: str, service: str, condition: typing.Optional[typing.List["CloudRunServiceIamBindingCondition"]]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param members: 
        :param role: 
        :param service: 
        :param condition: condition block.
        :param location: 
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'members': members,
            'role': role,
            'service': service,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if location is not None: self._values["location"] = location
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def members(self) -> typing.List[str]:
        return self._values.get('members')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def service(self) -> str:
        return self._values.get('service')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["CloudRunServiceIamBindingCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def location(self) -> typing.Optional[str]:
        return self._values.get('location')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceIamBindingConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudRunServiceIamMember(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunServiceIamMember"):
    def __init__(self, scope: constructs.Construct, id: str, *, member: str, role: str, service: str, condition: typing.Optional[typing.List["CloudRunServiceIamMemberCondition"]]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param member: 
        :param role: 
        :param service: 
        :param condition: condition block.
        :param location: 
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudRunServiceIamMemberConfig(member=member, role=role, service=service, condition=condition, location=location, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudRunServiceIamMember, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="member")
    def member(self) -> str:
        return jsii.get(self, "member")

    @member.setter
    def member(self, value: str) -> None:
        jsii.set(self, "member", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> str:
        return jsii.get(self, "service")

    @service.setter
    def service(self, value: str) -> None:
        jsii.set(self, "service", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["CloudRunServiceIamMemberCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["CloudRunServiceIamMemberCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> typing.Optional[str]:
        return jsii.get(self, "location")

    @location.setter
    def location(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceIamMemberCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class CloudRunServiceIamMemberCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceIamMemberCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceIamMemberConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'member': 'member', 'role': 'role', 'service': 'service', 'condition': 'condition', 'location': 'location', 'project': 'project'})
class CloudRunServiceIamMemberConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, member: str, role: str, service: str, condition: typing.Optional[typing.List["CloudRunServiceIamMemberCondition"]]=None, location: typing.Optional[str]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param member: 
        :param role: 
        :param service: 
        :param condition: condition block.
        :param location: 
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'member': member,
            'role': role,
            'service': service,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if location is not None: self._values["location"] = location
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def member(self) -> str:
        return self._values.get('member')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def service(self) -> str:
        return self._values.get('service')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["CloudRunServiceIamMemberCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def location(self) -> typing.Optional[str]:
        return self._values.get('location')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceIamMemberConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudRunServiceIamPolicy(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunServiceIamPolicy"):
    def __init__(self, scope: constructs.Construct, id: str, *, policy_data: str, service: str, location: typing.Optional[str]=None, project: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param policy_data: 
        :param service: 
        :param location: 
        :param project: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudRunServiceIamPolicyConfig(policy_data=policy_data, service=service, location=location, project=project, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudRunServiceIamPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="policyData")
    def policy_data(self) -> str:
        return jsii.get(self, "policyData")

    @policy_data.setter
    def policy_data(self, value: str) -> None:
        jsii.set(self, "policyData", value)

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> str:
        return jsii.get(self, "service")

    @service.setter
    def service(self, value: str) -> None:
        jsii.set(self, "service", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> typing.Optional[str]:
        return jsii.get(self, "location")

    @location.setter
    def location(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceIamPolicyConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'policy_data': 'policyData', 'service': 'service', 'location': 'location', 'project': 'project'})
class CloudRunServiceIamPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, policy_data: str, service: str, location: typing.Optional[str]=None, project: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param policy_data: 
        :param service: 
        :param location: 
        :param project: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'policy_data': policy_data,
            'service': service,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if location is not None: self._values["location"] = location
        if project is not None: self._values["project"] = project

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def policy_data(self) -> str:
        return self._values.get('policy_data')

    @builtins.property
    def service(self) -> str:
        return self._values.get('service')

    @builtins.property
    def location(self) -> typing.Optional[str]:
        return self._values.get('location')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceIamPolicyConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceMetadata", jsii_struct_bases=[], name_mapping={'annotations': 'annotations', 'labels': 'labels', 'namespace': 'namespace'})
class CloudRunServiceMetadata():
    def __init__(self, *, annotations: typing.Optional[typing.Mapping[str, str]]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, namespace: typing.Optional[str]=None) -> None:
        """
        :param annotations: Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
        :param labels: Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: http://kubernetes.io/docs/user-guide/labels
        :param namespace: In Cloud Run the namespace must be equal to either the project ID or project number.
        """
        self._values = {
        }
        if annotations is not None: self._values["annotations"] = annotations
        if labels is not None: self._values["labels"] = labels
        if namespace is not None: self._values["namespace"] = namespace

    @builtins.property
    def annotations(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.

        More
        info: http://kubernetes.io/docs/user-guide/annotations
        """
        return self._values.get('annotations')

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Map of string keys and values that can be used to organize and categorize (scope and select) objects.

        May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
        """
        return self._values.get('labels')

    @builtins.property
    def namespace(self) -> typing.Optional[str]:
        """In Cloud Run the namespace must be equal to either the project ID or project number."""
        return self._values.get('namespace')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceMetadata(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudRunServiceStatus(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunServiceStatus"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(CloudRunServiceStatus, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="conditions")
    def conditions(self) -> typing.Any:
        return jsii.get(self, "conditions")

    @builtins.property
    @jsii.member(jsii_name="latestCreatedRevisionName")
    def latest_created_revision_name(self) -> str:
        return jsii.get(self, "latestCreatedRevisionName")

    @builtins.property
    @jsii.member(jsii_name="latestReadyRevisionName")
    def latest_ready_revision_name(self) -> str:
        return jsii.get(self, "latestReadyRevisionName")

    @builtins.property
    @jsii.member(jsii_name="observedGeneration")
    def observed_generation(self) -> jsii.Number:
        return jsii.get(self, "observedGeneration")

    @builtins.property
    @jsii.member(jsii_name="url")
    def url(self) -> str:
        return jsii.get(self, "url")


class CloudRunServiceStatusConditions(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudRunServiceStatusConditions"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(CloudRunServiceStatusConditions, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="message")
    def message(self) -> str:
        return jsii.get(self, "message")

    @builtins.property
    @jsii.member(jsii_name="reason")
    def reason(self) -> str:
        return jsii.get(self, "reason")

    @builtins.property
    @jsii.member(jsii_name="status")
    def status(self) -> str:
        return jsii.get(self, "status")

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> str:
        return jsii.get(self, "type")


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplate", jsii_struct_bases=[], name_mapping={'metadata': 'metadata', 'spec': 'spec'})
class CloudRunServiceTemplate():
    def __init__(self, *, metadata: typing.Optional[typing.List["CloudRunServiceTemplateMetadata"]]=None, spec: typing.Optional[typing.List["CloudRunServiceTemplateSpec"]]=None) -> None:
        """
        :param metadata: metadata block.
        :param spec: spec block.
        """
        self._values = {
        }
        if metadata is not None: self._values["metadata"] = metadata
        if spec is not None: self._values["spec"] = spec

    @builtins.property
    def metadata(self) -> typing.Optional[typing.List["CloudRunServiceTemplateMetadata"]]:
        """metadata block."""
        return self._values.get('metadata')

    @builtins.property
    def spec(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpec"]]:
        """spec block."""
        return self._values.get('spec')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplate(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateMetadata", jsii_struct_bases=[], name_mapping={'annotations': 'annotations', 'labels': 'labels', 'name': 'name', 'namespace': 'namespace'})
class CloudRunServiceTemplateMetadata():
    def __init__(self, *, annotations: typing.Optional[typing.Mapping[str, str]]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, name: typing.Optional[str]=None, namespace: typing.Optional[str]=None) -> None:
        """
        :param annotations: Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
        :param labels: Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: http://kubernetes.io/docs/user-guide/labels
        :param name: Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param namespace: In Cloud Run the namespace must be equal to either the project ID or project number. It will default to the resource's project.
        """
        self._values = {
        }
        if annotations is not None: self._values["annotations"] = annotations
        if labels is not None: self._values["labels"] = labels
        if name is not None: self._values["name"] = name
        if namespace is not None: self._values["namespace"] = namespace

    @builtins.property
    def annotations(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Annotations is a key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata.

        More
        info: http://kubernetes.io/docs/user-guide/annotations
        """
        return self._values.get('annotations')

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Map of string keys and values that can be used to organize and categorize (scope and select) objects.

        May match selectors of replication controllers
        and routes.
        More info: http://kubernetes.io/docs/user-guide/labels
        """
        return self._values.get('labels')

    @builtins.property
    def name(self) -> typing.Optional[str]:
        """Name must be unique within a namespace, within a Cloud Run region.

        Is required when creating resources. Name is primarily intended
        for creation idempotence and configuration definition. Cannot be updated.
        More info: http://kubernetes.io/docs/user-guide/identifiers#names
        """
        return self._values.get('name')

    @builtins.property
    def namespace(self) -> typing.Optional[str]:
        """In Cloud Run the namespace must be equal to either the project ID or project number.

        It will default to the resource's project.
        """
        return self._values.get('namespace')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateMetadata(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpec", jsii_struct_bases=[], name_mapping={'container_concurrency': 'containerConcurrency', 'containers': 'containers', 'service_account_name': 'serviceAccountName', 'timeout_seconds': 'timeoutSeconds'})
class CloudRunServiceTemplateSpec():
    def __init__(self, *, container_concurrency: typing.Optional[jsii.Number]=None, containers: typing.Optional[typing.List["CloudRunServiceTemplateSpecContainers"]]=None, service_account_name: typing.Optional[str]=None, timeout_seconds: typing.Optional[jsii.Number]=None) -> None:
        """
        :param container_concurrency: ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container of the Revision. Values are: - '0' thread-safe, the system should manage the max concurrency. This is the default value. - '1' not-thread-safe. Single concurrency - '2-N' thread-safe, max concurrency of N
        :param containers: containers block.
        :param service_account_name: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param timeout_seconds: TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
        """
        self._values = {
        }
        if container_concurrency is not None: self._values["container_concurrency"] = container_concurrency
        if containers is not None: self._values["containers"] = containers
        if service_account_name is not None: self._values["service_account_name"] = service_account_name
        if timeout_seconds is not None: self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def container_concurrency(self) -> typing.Optional[jsii.Number]:
        """ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container of the Revision.

        Values are:

        - '0' thread-safe, the system should manage the max concurrency. This is
          the default value.
        - '1' not-thread-safe. Single concurrency
        - '2-N' thread-safe, max concurrency of N
        """
        return self._values.get('container_concurrency')

    @builtins.property
    def containers(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpecContainers"]]:
        """containers block."""
        return self._values.get('containers')

    @builtins.property
    def service_account_name(self) -> typing.Optional[str]:
        """Email address of the IAM service account associated with the revision of the service.

        The service account represents the identity of the running revision,
        and determines what permissions the revision has. If not provided, the revision
        will use the project's default service account.
        """
        return self._values.get('service_account_name')

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[jsii.Number]:
        """TimeoutSeconds holds the max duration the instance is allowed for responding to a request."""
        return self._values.get('timeout_seconds')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpec(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpecContainers", jsii_struct_bases=[], name_mapping={'image': 'image', 'args': 'args', 'command': 'command', 'env': 'env', 'env_from': 'envFrom', 'ports': 'ports', 'resources': 'resources', 'working_dir': 'workingDir'})
class CloudRunServiceTemplateSpecContainers():
    def __init__(self, *, image: str, args: typing.Optional[typing.List[str]]=None, command: typing.Optional[typing.List[str]]=None, env: typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnv"]]=None, env_from: typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFrom"]]=None, ports: typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersPorts"]]=None, resources: typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersResources"]]=None, working_dir: typing.Optional[str]=None) -> None:
        """
        :param image: Docker image name. This is most often a reference to a container located in the container registry, such as gcr.io/cloudrun/hello More info: https://kubernetes.io/docs/concepts/containers/images
        :param args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param env: env block.
        :param env_from: env_from block.
        :param ports: ports block.
        :param resources: resources block.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        self._values = {
            'image': image,
        }
        if args is not None: self._values["args"] = args
        if command is not None: self._values["command"] = command
        if env is not None: self._values["env"] = env
        if env_from is not None: self._values["env_from"] = env_from
        if ports is not None: self._values["ports"] = ports
        if resources is not None: self._values["resources"] = resources
        if working_dir is not None: self._values["working_dir"] = working_dir

    @builtins.property
    def image(self) -> str:
        """Docker image name.

        This is most often a reference to a container located
        in the container registry, such as gcr.io/cloudrun/hello
        More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return self._values.get('image')

    @builtins.property
    def args(self) -> typing.Optional[typing.List[str]]:
        """Arguments to the entrypoint.

        The docker image's CMD is used if this is not provided.
        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.
        More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return self._values.get('args')

    @builtins.property
    def command(self) -> typing.Optional[typing.List[str]]:
        """Entrypoint array.

        Not executed within a shell.
        The docker image's ENTRYPOINT is used if this is not provided.
        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.
        More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return self._values.get('command')

    @builtins.property
    def env(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnv"]]:
        """env block."""
        return self._values.get('env')

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFrom"]]:
        """env_from block."""
        return self._values.get('env_from')

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersPorts"]]:
        """ports block."""
        return self._values.get('ports')

    @builtins.property
    def resources(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersResources"]]:
        """resources block."""
        return self._values.get('resources')

    @builtins.property
    def working_dir(self) -> typing.Optional[str]:
        """Container's working directory.

        If not specified, the container runtime's default will be used, which
        might be configured in the container image.
        """
        return self._values.get('working_dir')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpecContainers(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpecContainersEnv", jsii_struct_bases=[], name_mapping={'name': 'name', 'value': 'value'})
class CloudRunServiceTemplateSpecContainersEnv():
    def __init__(self, *, name: typing.Optional[str]=None, value: typing.Optional[str]=None) -> None:
        """
        :param name: Name of the environment variable.
        :param value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        """
        self._values = {
        }
        if name is not None: self._values["name"] = name
        if value is not None: self._values["value"] = value

    @builtins.property
    def name(self) -> typing.Optional[str]:
        """Name of the environment variable."""
        return self._values.get('name')

    @builtins.property
    def value(self) -> typing.Optional[str]:
        """Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables.

        If a variable cannot be resolved,
        the reference in the input string will be unchanged. The $(VAR_NAME)
        syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
        references will never be expanded, regardless of whether the variable
        exists or not.
        Defaults to "".
        """
        return self._values.get('value')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpecContainersEnv(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpecContainersEnvFrom", jsii_struct_bases=[], name_mapping={'config_map_ref': 'configMapRef', 'prefix': 'prefix', 'secret_ref': 'secretRef'})
class CloudRunServiceTemplateSpecContainersEnvFrom():
    def __init__(self, *, config_map_ref: typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef"]]=None, prefix: typing.Optional[str]=None, secret_ref: typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFromSecretRef"]]=None) -> None:
        """
        :param config_map_ref: config_map_ref block.
        :param prefix: An optional identifier to prepend to each key in the ConfigMap.
        :param secret_ref: secret_ref block.
        """
        self._values = {
        }
        if config_map_ref is not None: self._values["config_map_ref"] = config_map_ref
        if prefix is not None: self._values["prefix"] = prefix
        if secret_ref is not None: self._values["secret_ref"] = secret_ref

    @builtins.property
    def config_map_ref(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef"]]:
        """config_map_ref block."""
        return self._values.get('config_map_ref')

    @builtins.property
    def prefix(self) -> typing.Optional[str]:
        """An optional identifier to prepend to each key in the ConfigMap."""
        return self._values.get('prefix')

    @builtins.property
    def secret_ref(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFromSecretRef"]]:
        """secret_ref block."""
        return self._values.get('secret_ref')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpecContainersEnvFrom(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef", jsii_struct_bases=[], name_mapping={'local_object_reference': 'localObjectReference', 'optional': 'optional'})
class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef():
    def __init__(self, *, local_object_reference: typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference"]]=None, optional: typing.Optional[bool]=None) -> None:
        """
        :param local_object_reference: local_object_reference block.
        :param optional: Specify whether the ConfigMap must be defined.
        """
        self._values = {
        }
        if local_object_reference is not None: self._values["local_object_reference"] = local_object_reference
        if optional is not None: self._values["optional"] = optional

    @builtins.property
    def local_object_reference(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference"]]:
        """local_object_reference block."""
        return self._values.get('local_object_reference')

    @builtins.property
    def optional(self) -> typing.Optional[bool]:
        """Specify whether the ConfigMap must be defined."""
        return self._values.get('optional')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference", jsii_struct_bases=[], name_mapping={'name': 'name'})
class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference():
    def __init__(self, *, name: str) -> None:
        """
        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        self._values = {
            'name': name,
        }

    @builtins.property
    def name(self) -> str:
        """Name of the referent.

        More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return self._values.get('name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpecContainersEnvFromSecretRef", jsii_struct_bases=[], name_mapping={'local_object_reference': 'localObjectReference', 'optional': 'optional'})
class CloudRunServiceTemplateSpecContainersEnvFromSecretRef():
    def __init__(self, *, local_object_reference: typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference"]]=None, optional: typing.Optional[bool]=None) -> None:
        """
        :param local_object_reference: local_object_reference block.
        :param optional: Specify whether the Secret must be defined.
        """
        self._values = {
        }
        if local_object_reference is not None: self._values["local_object_reference"] = local_object_reference
        if optional is not None: self._values["optional"] = optional

    @builtins.property
    def local_object_reference(self) -> typing.Optional[typing.List["CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference"]]:
        """local_object_reference block."""
        return self._values.get('local_object_reference')

    @builtins.property
    def optional(self) -> typing.Optional[bool]:
        """Specify whether the Secret must be defined."""
        return self._values.get('optional')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpecContainersEnvFromSecretRef(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference", jsii_struct_bases=[], name_mapping={'name': 'name'})
class CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference():
    def __init__(self, *, name: str) -> None:
        """
        :param name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        self._values = {
            'name': name,
        }

    @builtins.property
    def name(self) -> str:
        """Name of the referent.

        More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return self._values.get('name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpecContainersPorts", jsii_struct_bases=[], name_mapping={'container_port': 'containerPort', 'name': 'name', 'protocol': 'protocol'})
class CloudRunServiceTemplateSpecContainersPorts():
    def __init__(self, *, container_port: jsii.Number, name: typing.Optional[str]=None, protocol: typing.Optional[str]=None) -> None:
        """
        :param container_port: Port number.
        :param name: Name of the port.
        :param protocol: Protocol used on port. Defaults to TCP.
        """
        self._values = {
            'container_port': container_port,
        }
        if name is not None: self._values["name"] = name
        if protocol is not None: self._values["protocol"] = protocol

    @builtins.property
    def container_port(self) -> jsii.Number:
        """Port number."""
        return self._values.get('container_port')

    @builtins.property
    def name(self) -> typing.Optional[str]:
        """Name of the port."""
        return self._values.get('name')

    @builtins.property
    def protocol(self) -> typing.Optional[str]:
        """Protocol used on port.

        Defaults to TCP.
        """
        return self._values.get('protocol')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpecContainersPorts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTemplateSpecContainersResources", jsii_struct_bases=[], name_mapping={'limits': 'limits', 'requests': 'requests'})
class CloudRunServiceTemplateSpecContainersResources():
    def __init__(self, *, limits: typing.Optional[typing.Mapping[str, str]]=None, requests: typing.Optional[typing.Mapping[str, str]]=None) -> None:
        """
        :param limits: Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param requests: Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        self._values = {
        }
        if limits is not None: self._values["limits"] = limits
        if requests is not None: self._values["requests"] = requests

    @builtins.property
    def limits(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Limits describes the maximum amount of compute resources allowed.

        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return self._values.get('limits')

    @builtins.property
    def requests(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Requests describes the minimum amount of compute resources required.

        If Requests is omitted for a container, it defaults to Limits if that is
        explicitly specified, otherwise to an implementation-defined value.
        The values of the map is string form of the 'quantity' k8s type:
        https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return self._values.get('requests')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTemplateSpecContainersResources(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class CloudRunServiceTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudRunServiceTraffic", jsii_struct_bases=[], name_mapping={'percent': 'percent', 'latest_revision': 'latestRevision', 'revision_name': 'revisionName'})
class CloudRunServiceTraffic():
    def __init__(self, *, percent: jsii.Number, latest_revision: typing.Optional[bool]=None, revision_name: typing.Optional[str]=None) -> None:
        """
        :param percent: Percent specifies percent of the traffic to this Revision or Configuration.
        :param latest_revision: LatestRevision may be optionally provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target. When provided LatestRevision must be true if RevisionName is empty; it must be false when RevisionName is non-empty.
        :param revision_name: RevisionName of a specific revision to which to send this portion of traffic.
        """
        self._values = {
            'percent': percent,
        }
        if latest_revision is not None: self._values["latest_revision"] = latest_revision
        if revision_name is not None: self._values["revision_name"] = revision_name

    @builtins.property
    def percent(self) -> jsii.Number:
        """Percent specifies percent of the traffic to this Revision or Configuration."""
        return self._values.get('percent')

    @builtins.property
    def latest_revision(self) -> typing.Optional[bool]:
        """LatestRevision may be optionally provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target.

        When
        provided LatestRevision must be true if RevisionName is empty; it must be
        false when RevisionName is non-empty.
        """
        return self._values.get('latest_revision')

    @builtins.property
    def revision_name(self) -> typing.Optional[str]:
        """RevisionName of a specific revision to which to send this portion of traffic."""
        return self._values.get('revision_name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudRunServiceTraffic(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudSchedulerJob(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudSchedulerJob"):
    def __init__(self, scope: constructs.Construct, id: str, *, name: str, app_engine_http_target: typing.Optional[typing.List["CloudSchedulerJobAppEngineHttpTarget"]]=None, attempt_deadline: typing.Optional[str]=None, description: typing.Optional[str]=None, http_target: typing.Optional[typing.List["CloudSchedulerJobHttpTarget"]]=None, project: typing.Optional[str]=None, pubsub_target: typing.Optional[typing.List["CloudSchedulerJobPubsubTarget"]]=None, region: typing.Optional[str]=None, retry_config: typing.Optional[typing.List["CloudSchedulerJobRetryConfig"]]=None, schedule: typing.Optional[str]=None, timeouts: typing.Optional["CloudSchedulerJobTimeouts"]=None, time_zone: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param name: The name of the job.
        :param app_engine_http_target: app_engine_http_target block.
        :param attempt_deadline: The deadline for job attempts. If the request handler does not respond by this deadline then the request is cancelled and the attempt is marked as a DEADLINE_EXCEEDED failure. The failed attempt can be viewed in execution logs. Cloud Scheduler will retry the job according to the RetryConfig. The allowed duration for this deadline is: For HTTP targets, between 15 seconds and 30 minutes. For App Engine HTTP targets, between 15 seconds and 24 hours. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
        :param description: A human-readable description for the job. This string must not contain more than 500 characters.
        :param http_target: http_target block.
        :param project: 
        :param pubsub_target: pubsub_target block.
        :param region: Region where the scheduler job resides. If it is not provided, Terraform will use the provider default.
        :param retry_config: retry_config block.
        :param schedule: Describes the schedule on which the job will be executed.
        :param timeouts: timeouts block.
        :param time_zone: Specifies the time zone to be used in interpreting schedule. The value of this field must be a time zone name from the tz database.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudSchedulerJobConfig(name=name, app_engine_http_target=app_engine_http_target, attempt_deadline=attempt_deadline, description=description, http_target=http_target, project=project, pubsub_target=pubsub_target, region=region, retry_config=retry_config, schedule=schedule, timeouts=timeouts, time_zone=time_zone, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudSchedulerJob, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="appEngineHttpTarget")
    def app_engine_http_target(self) -> typing.Optional[typing.List["CloudSchedulerJobAppEngineHttpTarget"]]:
        return jsii.get(self, "appEngineHttpTarget")

    @app_engine_http_target.setter
    def app_engine_http_target(self, value: typing.Optional[typing.List["CloudSchedulerJobAppEngineHttpTarget"]]) -> None:
        jsii.set(self, "appEngineHttpTarget", value)

    @builtins.property
    @jsii.member(jsii_name="attemptDeadline")
    def attempt_deadline(self) -> typing.Optional[str]:
        return jsii.get(self, "attemptDeadline")

    @attempt_deadline.setter
    def attempt_deadline(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "attemptDeadline", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="httpTarget")
    def http_target(self) -> typing.Optional[typing.List["CloudSchedulerJobHttpTarget"]]:
        return jsii.get(self, "httpTarget")

    @http_target.setter
    def http_target(self, value: typing.Optional[typing.List["CloudSchedulerJobHttpTarget"]]) -> None:
        jsii.set(self, "httpTarget", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="pubsubTarget")
    def pubsub_target(self) -> typing.Optional[typing.List["CloudSchedulerJobPubsubTarget"]]:
        return jsii.get(self, "pubsubTarget")

    @pubsub_target.setter
    def pubsub_target(self, value: typing.Optional[typing.List["CloudSchedulerJobPubsubTarget"]]) -> None:
        jsii.set(self, "pubsubTarget", value)

    @builtins.property
    @jsii.member(jsii_name="region")
    def region(self) -> typing.Optional[str]:
        return jsii.get(self, "region")

    @region.setter
    def region(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "region", value)

    @builtins.property
    @jsii.member(jsii_name="retryConfig")
    def retry_config(self) -> typing.Optional[typing.List["CloudSchedulerJobRetryConfig"]]:
        return jsii.get(self, "retryConfig")

    @retry_config.setter
    def retry_config(self, value: typing.Optional[typing.List["CloudSchedulerJobRetryConfig"]]) -> None:
        jsii.set(self, "retryConfig", value)

    @builtins.property
    @jsii.member(jsii_name="schedule")
    def schedule(self) -> typing.Optional[str]:
        return jsii.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "schedule", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudSchedulerJobTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudSchedulerJobTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="timeZone")
    def time_zone(self) -> typing.Optional[str]:
        return jsii.get(self, "timeZone")

    @time_zone.setter
    def time_zone(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "timeZone", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudSchedulerJobAppEngineHttpTarget", jsii_struct_bases=[], name_mapping={'relative_uri': 'relativeUri', 'app_engine_routing': 'appEngineRouting', 'body': 'body', 'headers': 'headers', 'http_method': 'httpMethod'})
class CloudSchedulerJobAppEngineHttpTarget():
    def __init__(self, *, relative_uri: str, app_engine_routing: typing.Optional[typing.List["CloudSchedulerJobAppEngineHttpTargetAppEngineRouting"]]=None, body: typing.Optional[str]=None, headers: typing.Optional[typing.Mapping[str, str]]=None, http_method: typing.Optional[str]=None) -> None:
        """
        :param relative_uri: The relative URI. The relative URL must begin with "/" and must be a valid HTTP relative URL. It can contain a path, query string arguments, and # fragments. If the relative URL is empty, then the root path "/" will be used. No spaces are allowed, and the maximum length allowed is 2083 characters
        :param app_engine_routing: app_engine_routing block.
        :param body: HTTP request body. A request body is allowed only if the HTTP method is POST or PUT. It will result in invalid argument error to set a body on a job with an incompatible HttpMethod.
        :param headers: HTTP request headers. This map contains the header field names and values. Headers can be set when the job is created.
        :param http_method: Which HTTP method to use for the request.
        """
        self._values = {
            'relative_uri': relative_uri,
        }
        if app_engine_routing is not None: self._values["app_engine_routing"] = app_engine_routing
        if body is not None: self._values["body"] = body
        if headers is not None: self._values["headers"] = headers
        if http_method is not None: self._values["http_method"] = http_method

    @builtins.property
    def relative_uri(self) -> str:
        """The relative URI.

        The relative URL must begin with "/" and must be a valid HTTP relative URL.
        It can contain a path, query string arguments, and # fragments.
        If the relative URL is empty, then the root path "/" will be used.
        No spaces are allowed, and the maximum length allowed is 2083 characters
        """
        return self._values.get('relative_uri')

    @builtins.property
    def app_engine_routing(self) -> typing.Optional[typing.List["CloudSchedulerJobAppEngineHttpTargetAppEngineRouting"]]:
        """app_engine_routing block."""
        return self._values.get('app_engine_routing')

    @builtins.property
    def body(self) -> typing.Optional[str]:
        """HTTP request body.

        A request body is allowed only if the HTTP method is POST or PUT.
        It will result in invalid argument error to set a body on a job with an incompatible HttpMethod.
        """
        return self._values.get('body')

    @builtins.property
    def headers(self) -> typing.Optional[typing.Mapping[str, str]]:
        """HTTP request headers.

        This map contains the header field names and values.
        Headers can be set when the job is created.
        """
        return self._values.get('headers')

    @builtins.property
    def http_method(self) -> typing.Optional[str]:
        """Which HTTP method to use for the request."""
        return self._values.get('http_method')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudSchedulerJobAppEngineHttpTarget(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudSchedulerJobAppEngineHttpTargetAppEngineRouting", jsii_struct_bases=[], name_mapping={'instance': 'instance', 'service': 'service', 'version': 'version'})
class CloudSchedulerJobAppEngineHttpTargetAppEngineRouting():
    def __init__(self, *, instance: typing.Optional[str]=None, service: typing.Optional[str]=None, version: typing.Optional[str]=None) -> None:
        """
        :param instance: App instance. By default, the job is sent to an instance which is available when the job is attempted.
        :param service: App service. By default, the job is sent to the service which is the default service when the job is attempted.
        :param version: App version. By default, the job is sent to the version which is the default version when the job is attempted.
        """
        self._values = {
        }
        if instance is not None: self._values["instance"] = instance
        if service is not None: self._values["service"] = service
        if version is not None: self._values["version"] = version

    @builtins.property
    def instance(self) -> typing.Optional[str]:
        """App instance.

        By default, the job is sent to an instance which is available when the job is attempted.
        """
        return self._values.get('instance')

    @builtins.property
    def service(self) -> typing.Optional[str]:
        """App service.

        By default, the job is sent to the service which is the default service when the job is attempted.
        """
        return self._values.get('service')

    @builtins.property
    def version(self) -> typing.Optional[str]:
        """App version.

        By default, the job is sent to the version which is the default version when the job is attempted.
        """
        return self._values.get('version')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudSchedulerJobAppEngineHttpTargetAppEngineRouting(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudSchedulerJobConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'name': 'name', 'app_engine_http_target': 'appEngineHttpTarget', 'attempt_deadline': 'attemptDeadline', 'description': 'description', 'http_target': 'httpTarget', 'project': 'project', 'pubsub_target': 'pubsubTarget', 'region': 'region', 'retry_config': 'retryConfig', 'schedule': 'schedule', 'timeouts': 'timeouts', 'time_zone': 'timeZone'})
class CloudSchedulerJobConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, name: str, app_engine_http_target: typing.Optional[typing.List["CloudSchedulerJobAppEngineHttpTarget"]]=None, attempt_deadline: typing.Optional[str]=None, description: typing.Optional[str]=None, http_target: typing.Optional[typing.List["CloudSchedulerJobHttpTarget"]]=None, project: typing.Optional[str]=None, pubsub_target: typing.Optional[typing.List["CloudSchedulerJobPubsubTarget"]]=None, region: typing.Optional[str]=None, retry_config: typing.Optional[typing.List["CloudSchedulerJobRetryConfig"]]=None, schedule: typing.Optional[str]=None, timeouts: typing.Optional["CloudSchedulerJobTimeouts"]=None, time_zone: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: The name of the job.
        :param app_engine_http_target: app_engine_http_target block.
        :param attempt_deadline: The deadline for job attempts. If the request handler does not respond by this deadline then the request is cancelled and the attempt is marked as a DEADLINE_EXCEEDED failure. The failed attempt can be viewed in execution logs. Cloud Scheduler will retry the job according to the RetryConfig. The allowed duration for this deadline is: For HTTP targets, between 15 seconds and 30 minutes. For App Engine HTTP targets, between 15 seconds and 24 hours. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
        :param description: A human-readable description for the job. This string must not contain more than 500 characters.
        :param http_target: http_target block.
        :param project: 
        :param pubsub_target: pubsub_target block.
        :param region: Region where the scheduler job resides. If it is not provided, Terraform will use the provider default.
        :param retry_config: retry_config block.
        :param schedule: Describes the schedule on which the job will be executed.
        :param timeouts: timeouts block.
        :param time_zone: Specifies the time zone to be used in interpreting schedule. The value of this field must be a time zone name from the tz database.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudSchedulerJobTimeouts(**timeouts)
        self._values = {
            'name': name,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if app_engine_http_target is not None: self._values["app_engine_http_target"] = app_engine_http_target
        if attempt_deadline is not None: self._values["attempt_deadline"] = attempt_deadline
        if description is not None: self._values["description"] = description
        if http_target is not None: self._values["http_target"] = http_target
        if project is not None: self._values["project"] = project
        if pubsub_target is not None: self._values["pubsub_target"] = pubsub_target
        if region is not None: self._values["region"] = region
        if retry_config is not None: self._values["retry_config"] = retry_config
        if schedule is not None: self._values["schedule"] = schedule
        if timeouts is not None: self._values["timeouts"] = timeouts
        if time_zone is not None: self._values["time_zone"] = time_zone

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def name(self) -> str:
        """The name of the job."""
        return self._values.get('name')

    @builtins.property
    def app_engine_http_target(self) -> typing.Optional[typing.List["CloudSchedulerJobAppEngineHttpTarget"]]:
        """app_engine_http_target block."""
        return self._values.get('app_engine_http_target')

    @builtins.property
    def attempt_deadline(self) -> typing.Optional[str]:
        """The deadline for job attempts.

        If the request handler does not respond by this deadline then the request is
        cancelled and the attempt is marked as a DEADLINE_EXCEEDED failure. The failed attempt can be viewed in
        execution logs. Cloud Scheduler will retry the job according to the RetryConfig.
        The allowed duration for this deadline is:
        For HTTP targets, between 15 seconds and 30 minutes.
        For App Engine HTTP targets, between 15 seconds and 24 hours.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
        """
        return self._values.get('attempt_deadline')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """A human-readable description for the job.

        This string must not contain more than 500 characters.
        """
        return self._values.get('description')

    @builtins.property
    def http_target(self) -> typing.Optional[typing.List["CloudSchedulerJobHttpTarget"]]:
        """http_target block."""
        return self._values.get('http_target')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def pubsub_target(self) -> typing.Optional[typing.List["CloudSchedulerJobPubsubTarget"]]:
        """pubsub_target block."""
        return self._values.get('pubsub_target')

    @builtins.property
    def region(self) -> typing.Optional[str]:
        """Region where the scheduler job resides.

        If it is not provided, Terraform will use the provider default.
        """
        return self._values.get('region')

    @builtins.property
    def retry_config(self) -> typing.Optional[typing.List["CloudSchedulerJobRetryConfig"]]:
        """retry_config block."""
        return self._values.get('retry_config')

    @builtins.property
    def schedule(self) -> typing.Optional[str]:
        """Describes the schedule on which the job will be executed."""
        return self._values.get('schedule')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudSchedulerJobTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    @builtins.property
    def time_zone(self) -> typing.Optional[str]:
        """Specifies the time zone to be used in interpreting schedule.

        The value of this field must be a time zone name from the tz database.
        """
        return self._values.get('time_zone')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudSchedulerJobConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudSchedulerJobHttpTarget", jsii_struct_bases=[], name_mapping={'uri': 'uri', 'body': 'body', 'headers': 'headers', 'http_method': 'httpMethod', 'oauth_token': 'oauthToken', 'oidc_token': 'oidcToken'})
class CloudSchedulerJobHttpTarget():
    def __init__(self, *, uri: str, body: typing.Optional[str]=None, headers: typing.Optional[typing.Mapping[str, str]]=None, http_method: typing.Optional[str]=None, oauth_token: typing.Optional[typing.List["CloudSchedulerJobHttpTargetOauthToken"]]=None, oidc_token: typing.Optional[typing.List["CloudSchedulerJobHttpTargetOidcToken"]]=None) -> None:
        """
        :param uri: The full URI path that the request will be sent to.
        :param body: HTTP request body. A request body is allowed only if the HTTP method is POST, PUT, or PATCH. It is an error to set body on a job with an incompatible HttpMethod.
        :param headers: This map contains the header field names and values. Repeated headers are not supported, but a header value can contain commas.
        :param http_method: Which HTTP method to use for the request.
        :param oauth_token: oauth_token block.
        :param oidc_token: oidc_token block.
        """
        self._values = {
            'uri': uri,
        }
        if body is not None: self._values["body"] = body
        if headers is not None: self._values["headers"] = headers
        if http_method is not None: self._values["http_method"] = http_method
        if oauth_token is not None: self._values["oauth_token"] = oauth_token
        if oidc_token is not None: self._values["oidc_token"] = oidc_token

    @builtins.property
    def uri(self) -> str:
        """The full URI path that the request will be sent to."""
        return self._values.get('uri')

    @builtins.property
    def body(self) -> typing.Optional[str]:
        """HTTP request body.

        A request body is allowed only if the HTTP method is POST, PUT, or PATCH.
        It is an error to set body on a job with an incompatible HttpMethod.
        """
        return self._values.get('body')

    @builtins.property
    def headers(self) -> typing.Optional[typing.Mapping[str, str]]:
        """This map contains the header field names and values.

        Repeated headers are not supported, but a header value can contain commas.
        """
        return self._values.get('headers')

    @builtins.property
    def http_method(self) -> typing.Optional[str]:
        """Which HTTP method to use for the request."""
        return self._values.get('http_method')

    @builtins.property
    def oauth_token(self) -> typing.Optional[typing.List["CloudSchedulerJobHttpTargetOauthToken"]]:
        """oauth_token block."""
        return self._values.get('oauth_token')

    @builtins.property
    def oidc_token(self) -> typing.Optional[typing.List["CloudSchedulerJobHttpTargetOidcToken"]]:
        """oidc_token block."""
        return self._values.get('oidc_token')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudSchedulerJobHttpTarget(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudSchedulerJobHttpTargetOauthToken", jsii_struct_bases=[], name_mapping={'service_account_email': 'serviceAccountEmail', 'scope': 'scope'})
class CloudSchedulerJobHttpTargetOauthToken():
    def __init__(self, *, service_account_email: str, scope: typing.Optional[str]=None) -> None:
        """
        :param service_account_email: Service account email to be used for generating OAuth token. The service account must be within the same project as the job.
        :param scope: OAuth scope to be used for generating OAuth access token. If not specified, "https://www.googleapis.com/auth/cloud-platform" will be used.
        """
        self._values = {
            'service_account_email': service_account_email,
        }
        if scope is not None: self._values["scope"] = scope

    @builtins.property
    def service_account_email(self) -> str:
        """Service account email to be used for generating OAuth token.

        The service account must be within the same project as the job.
        """
        return self._values.get('service_account_email')

    @builtins.property
    def scope(self) -> typing.Optional[str]:
        """OAuth scope to be used for generating OAuth access token.

        If not specified,
        "https://www.googleapis.com/auth/cloud-platform" will be used.
        """
        return self._values.get('scope')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudSchedulerJobHttpTargetOauthToken(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudSchedulerJobHttpTargetOidcToken", jsii_struct_bases=[], name_mapping={'service_account_email': 'serviceAccountEmail', 'audience': 'audience'})
class CloudSchedulerJobHttpTargetOidcToken():
    def __init__(self, *, service_account_email: str, audience: typing.Optional[str]=None) -> None:
        """
        :param service_account_email: Service account email to be used for generating OAuth token. The service account must be within the same project as the job.
        :param audience: Audience to be used when generating OIDC token. If not specified, the URI specified in target will be used.
        """
        self._values = {
            'service_account_email': service_account_email,
        }
        if audience is not None: self._values["audience"] = audience

    @builtins.property
    def service_account_email(self) -> str:
        """Service account email to be used for generating OAuth token.

        The service account must be within the same project as the job.
        """
        return self._values.get('service_account_email')

    @builtins.property
    def audience(self) -> typing.Optional[str]:
        """Audience to be used when generating OIDC token.

        If not specified,
        the URI specified in target will be used.
        """
        return self._values.get('audience')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudSchedulerJobHttpTargetOidcToken(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudSchedulerJobPubsubTarget", jsii_struct_bases=[], name_mapping={'topic_name': 'topicName', 'attributes': 'attributes', 'data': 'data'})
class CloudSchedulerJobPubsubTarget():
    def __init__(self, *, topic_name: str, attributes: typing.Optional[typing.Mapping[str, str]]=None, data: typing.Optional[str]=None) -> None:
        """
        :param topic_name: The full resource name for the Cloud Pub/Sub topic to which messages will be published when a job is delivered. ~>**NOTE:** The topic name must be in the same format as required by PubSub's PublishRequest.name, e.g. 'projects/my-project/topics/my-topic'.
        :param attributes: Attributes for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
        :param data: The message payload for PubsubMessage. Pubsub message must contain either non-empty data, or at least one attribute.
        """
        self._values = {
            'topic_name': topic_name,
        }
        if attributes is not None: self._values["attributes"] = attributes
        if data is not None: self._values["data"] = data

    @builtins.property
    def topic_name(self) -> str:
        """The full resource name for the Cloud Pub/Sub topic to which messages will be published when a job is delivered.

        ~>**NOTE:**
        The topic name must be in the same format as required by PubSub's
        PublishRequest.name, e.g. 'projects/my-project/topics/my-topic'.
        """
        return self._values.get('topic_name')

    @builtins.property
    def attributes(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Attributes for PubsubMessage.

        Pubsub message must contain either non-empty data, or at least one attribute.
        """
        return self._values.get('attributes')

    @builtins.property
    def data(self) -> typing.Optional[str]:
        """The message payload for PubsubMessage.

        Pubsub message must contain either non-empty data, or at least one attribute.
        """
        return self._values.get('data')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudSchedulerJobPubsubTarget(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudSchedulerJobRetryConfig", jsii_struct_bases=[], name_mapping={'max_backoff_duration': 'maxBackoffDuration', 'max_doublings': 'maxDoublings', 'max_retry_duration': 'maxRetryDuration', 'min_backoff_duration': 'minBackoffDuration', 'retry_count': 'retryCount'})
class CloudSchedulerJobRetryConfig():
    def __init__(self, *, max_backoff_duration: typing.Optional[str]=None, max_doublings: typing.Optional[jsii.Number]=None, max_retry_duration: typing.Optional[str]=None, min_backoff_duration: typing.Optional[str]=None, retry_count: typing.Optional[jsii.Number]=None) -> None:
        """
        :param max_backoff_duration: The maximum amount of time to wait before retrying a job after it fails. A duration in seconds with up to nine fractional digits, terminated by 's'.
        :param max_doublings: The time between retries will double maxDoublings times. A job's retry interval starts at minBackoffDuration, then doubles maxDoublings times, then increases linearly, and finally retries retries at intervals of maxBackoffDuration up to retryCount times.
        :param max_retry_duration: The time limit for retrying a failed job, measured from time when an execution was first attempted. If specified with retryCount, the job will be retried until both limits are reached. A duration in seconds with up to nine fractional digits, terminated by 's'.
        :param min_backoff_duration: The minimum amount of time to wait before retrying a job after it fails. A duration in seconds with up to nine fractional digits, terminated by 's'.
        :param retry_count: The number of attempts that the system will make to run a job using the exponential backoff procedure described by maxDoublings. Values greater than 5 and negative values are not allowed.
        """
        self._values = {
        }
        if max_backoff_duration is not None: self._values["max_backoff_duration"] = max_backoff_duration
        if max_doublings is not None: self._values["max_doublings"] = max_doublings
        if max_retry_duration is not None: self._values["max_retry_duration"] = max_retry_duration
        if min_backoff_duration is not None: self._values["min_backoff_duration"] = min_backoff_duration
        if retry_count is not None: self._values["retry_count"] = retry_count

    @builtins.property
    def max_backoff_duration(self) -> typing.Optional[str]:
        """The maximum amount of time to wait before retrying a job after it fails.

        A duration in seconds with up to nine fractional digits, terminated by 's'.
        """
        return self._values.get('max_backoff_duration')

    @builtins.property
    def max_doublings(self) -> typing.Optional[jsii.Number]:
        """The time between retries will double maxDoublings times.

        A job's retry interval starts at minBackoffDuration,
        then doubles maxDoublings times, then increases linearly,
        and finally retries retries at intervals of maxBackoffDuration up to retryCount times.
        """
        return self._values.get('max_doublings')

    @builtins.property
    def max_retry_duration(self) -> typing.Optional[str]:
        """The time limit for retrying a failed job, measured from time when an execution was first attempted.

        If specified with retryCount, the job will be retried until both limits are reached.
        A duration in seconds with up to nine fractional digits, terminated by 's'.
        """
        return self._values.get('max_retry_duration')

    @builtins.property
    def min_backoff_duration(self) -> typing.Optional[str]:
        """The minimum amount of time to wait before retrying a job after it fails.

        A duration in seconds with up to nine fractional digits, terminated by 's'.
        """
        return self._values.get('min_backoff_duration')

    @builtins.property
    def retry_count(self) -> typing.Optional[jsii.Number]:
        """The number of attempts that the system will make to run a  job using the exponential backoff procedure described by maxDoublings.

        Values greater than 5 and negative values are not allowed.
        """
        return self._values.get('retry_count')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudSchedulerJobRetryConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudSchedulerJobTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete'})
class CloudSchedulerJobTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudSchedulerJobTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudTasksQueue(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudTasksQueue"):
    def __init__(self, scope: constructs.Construct, id: str, *, location: str, app_engine_routing_override: typing.Optional[typing.List["CloudTasksQueueAppEngineRoutingOverride"]]=None, name: typing.Optional[str]=None, project: typing.Optional[str]=None, rate_limits: typing.Optional[typing.List["CloudTasksQueueRateLimits"]]=None, retry_config: typing.Optional[typing.List["CloudTasksQueueRetryConfig"]]=None, timeouts: typing.Optional["CloudTasksQueueTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param location: The location of the queue.
        :param app_engine_routing_override: app_engine_routing_override block.
        :param name: The queue name.
        :param project: 
        :param rate_limits: rate_limits block.
        :param retry_config: retry_config block.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudTasksQueueConfig(location=location, app_engine_routing_override=app_engine_routing_override, name=name, project=project, rate_limits=rate_limits, retry_config=retry_config, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudTasksQueue, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> str:
        return jsii.get(self, "location")

    @location.setter
    def location(self, value: str) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="appEngineRoutingOverride")
    def app_engine_routing_override(self) -> typing.Optional[typing.List["CloudTasksQueueAppEngineRoutingOverride"]]:
        return jsii.get(self, "appEngineRoutingOverride")

    @app_engine_routing_override.setter
    def app_engine_routing_override(self, value: typing.Optional[typing.List["CloudTasksQueueAppEngineRoutingOverride"]]) -> None:
        jsii.set(self, "appEngineRoutingOverride", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[str]:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="rateLimits")
    def rate_limits(self) -> typing.Optional[typing.List["CloudTasksQueueRateLimits"]]:
        return jsii.get(self, "rateLimits")

    @rate_limits.setter
    def rate_limits(self, value: typing.Optional[typing.List["CloudTasksQueueRateLimits"]]) -> None:
        jsii.set(self, "rateLimits", value)

    @builtins.property
    @jsii.member(jsii_name="retryConfig")
    def retry_config(self) -> typing.Optional[typing.List["CloudTasksQueueRetryConfig"]]:
        return jsii.get(self, "retryConfig")

    @retry_config.setter
    def retry_config(self, value: typing.Optional[typing.List["CloudTasksQueueRetryConfig"]]) -> None:
        jsii.set(self, "retryConfig", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudTasksQueueTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudTasksQueueTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudTasksQueueAppEngineRoutingOverride", jsii_struct_bases=[], name_mapping={'instance': 'instance', 'service': 'service', 'version': 'version'})
class CloudTasksQueueAppEngineRoutingOverride():
    def __init__(self, *, instance: typing.Optional[str]=None, service: typing.Optional[str]=None, version: typing.Optional[str]=None) -> None:
        """
        :param instance: App instance. By default, the task is sent to an instance which is available when the task is attempted.
        :param service: App service. By default, the task is sent to the service which is the default service when the task is attempted.
        :param version: App version. By default, the task is sent to the version which is the default version when the task is attempted.
        """
        self._values = {
        }
        if instance is not None: self._values["instance"] = instance
        if service is not None: self._values["service"] = service
        if version is not None: self._values["version"] = version

    @builtins.property
    def instance(self) -> typing.Optional[str]:
        """App instance.

        By default, the task is sent to an instance which is available when the task is attempted.
        """
        return self._values.get('instance')

    @builtins.property
    def service(self) -> typing.Optional[str]:
        """App service.

        By default, the task is sent to the service which is the default service when the task is attempted.
        """
        return self._values.get('service')

    @builtins.property
    def version(self) -> typing.Optional[str]:
        """App version.

        By default, the task is sent to the version which is the default version when the task is attempted.
        """
        return self._values.get('version')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudTasksQueueAppEngineRoutingOverride(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudTasksQueueConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'location': 'location', 'app_engine_routing_override': 'appEngineRoutingOverride', 'name': 'name', 'project': 'project', 'rate_limits': 'rateLimits', 'retry_config': 'retryConfig', 'timeouts': 'timeouts'})
class CloudTasksQueueConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, location: str, app_engine_routing_override: typing.Optional[typing.List["CloudTasksQueueAppEngineRoutingOverride"]]=None, name: typing.Optional[str]=None, project: typing.Optional[str]=None, rate_limits: typing.Optional[typing.List["CloudTasksQueueRateLimits"]]=None, retry_config: typing.Optional[typing.List["CloudTasksQueueRetryConfig"]]=None, timeouts: typing.Optional["CloudTasksQueueTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: The location of the queue.
        :param app_engine_routing_override: app_engine_routing_override block.
        :param name: The queue name.
        :param project: 
        :param rate_limits: rate_limits block.
        :param retry_config: retry_config block.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudTasksQueueTimeouts(**timeouts)
        self._values = {
            'location': location,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if app_engine_routing_override is not None: self._values["app_engine_routing_override"] = app_engine_routing_override
        if name is not None: self._values["name"] = name
        if project is not None: self._values["project"] = project
        if rate_limits is not None: self._values["rate_limits"] = rate_limits
        if retry_config is not None: self._values["retry_config"] = retry_config
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def location(self) -> str:
        """The location of the queue."""
        return self._values.get('location')

    @builtins.property
    def app_engine_routing_override(self) -> typing.Optional[typing.List["CloudTasksQueueAppEngineRoutingOverride"]]:
        """app_engine_routing_override block."""
        return self._values.get('app_engine_routing_override')

    @builtins.property
    def name(self) -> typing.Optional[str]:
        """The queue name."""
        return self._values.get('name')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def rate_limits(self) -> typing.Optional[typing.List["CloudTasksQueueRateLimits"]]:
        """rate_limits block."""
        return self._values.get('rate_limits')

    @builtins.property
    def retry_config(self) -> typing.Optional[typing.List["CloudTasksQueueRetryConfig"]]:
        """retry_config block."""
        return self._values.get('retry_config')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudTasksQueueTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudTasksQueueConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudTasksQueueRateLimits", jsii_struct_bases=[], name_mapping={'max_concurrent_dispatches': 'maxConcurrentDispatches', 'max_dispatches_per_second': 'maxDispatchesPerSecond'})
class CloudTasksQueueRateLimits():
    def __init__(self, *, max_concurrent_dispatches: typing.Optional[jsii.Number]=None, max_dispatches_per_second: typing.Optional[jsii.Number]=None) -> None:
        """
        :param max_concurrent_dispatches: The maximum number of concurrent tasks that Cloud Tasks allows to be dispatched for this queue. After this threshold has been reached, Cloud Tasks stops dispatching tasks until the number of concurrent requests decreases.
        :param max_dispatches_per_second: The maximum rate at which tasks are dispatched from this queue. If unspecified when the queue is created, Cloud Tasks will pick the default.
        """
        self._values = {
        }
        if max_concurrent_dispatches is not None: self._values["max_concurrent_dispatches"] = max_concurrent_dispatches
        if max_dispatches_per_second is not None: self._values["max_dispatches_per_second"] = max_dispatches_per_second

    @builtins.property
    def max_concurrent_dispatches(self) -> typing.Optional[jsii.Number]:
        """The maximum number of concurrent tasks that Cloud Tasks allows to be dispatched for this queue.

        After this threshold has been
        reached, Cloud Tasks stops dispatching tasks until the number of
        concurrent requests decreases.
        """
        return self._values.get('max_concurrent_dispatches')

    @builtins.property
    def max_dispatches_per_second(self) -> typing.Optional[jsii.Number]:
        """The maximum rate at which tasks are dispatched from this queue.

        If unspecified when the queue is created, Cloud Tasks will pick the default.
        """
        return self._values.get('max_dispatches_per_second')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudTasksQueueRateLimits(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudTasksQueueRetryConfig", jsii_struct_bases=[], name_mapping={'max_attempts': 'maxAttempts', 'max_backoff': 'maxBackoff', 'max_doublings': 'maxDoublings', 'max_retry_duration': 'maxRetryDuration', 'min_backoff': 'minBackoff'})
class CloudTasksQueueRetryConfig():
    def __init__(self, *, max_attempts: typing.Optional[jsii.Number]=None, max_backoff: typing.Optional[str]=None, max_doublings: typing.Optional[jsii.Number]=None, max_retry_duration: typing.Optional[str]=None, min_backoff: typing.Optional[str]=None) -> None:
        """
        :param max_attempts: Number of attempts per task. Cloud Tasks will attempt the task maxAttempts times (that is, if the first attempt fails, then there will be maxAttempts - 1 retries). Must be >= -1. If unspecified when the queue is created, Cloud Tasks will pick the default. -1 indicates unlimited attempts.
        :param max_backoff: A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
        :param max_doublings: The time between retries will double maxDoublings times. A task's retry interval starts at minBackoff, then doubles maxDoublings times, then increases linearly, and finally retries retries at intervals of maxBackoff up to maxAttempts times.
        :param max_retry_duration: If positive, maxRetryDuration specifies the time limit for retrying a failed task, measured from when the task was first attempted. Once maxRetryDuration time has passed and the task has been attempted maxAttempts times, no further attempts will be made and the task will be deleted. If zero, then the task age is unlimited.
        :param min_backoff: A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried.
        """
        self._values = {
        }
        if max_attempts is not None: self._values["max_attempts"] = max_attempts
        if max_backoff is not None: self._values["max_backoff"] = max_backoff
        if max_doublings is not None: self._values["max_doublings"] = max_doublings
        if max_retry_duration is not None: self._values["max_retry_duration"] = max_retry_duration
        if min_backoff is not None: self._values["min_backoff"] = min_backoff

    @builtins.property
    def max_attempts(self) -> typing.Optional[jsii.Number]:
        """Number of attempts per task.

        Cloud Tasks will attempt the task maxAttempts times (that is, if
        the first attempt fails, then there will be maxAttempts - 1
        retries). Must be >= -1.

        If unspecified when the queue is created, Cloud Tasks will pick
        the default.

        -1 indicates unlimited attempts.
        """
        return self._values.get('max_attempts')

    @builtins.property
    def max_backoff(self) -> typing.Optional[str]:
        """A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried."""
        return self._values.get('max_backoff')

    @builtins.property
    def max_doublings(self) -> typing.Optional[jsii.Number]:
        """The time between retries will double maxDoublings times.

        A task's retry interval starts at minBackoff, then doubles maxDoublings times,
        then increases linearly, and finally retries retries at intervals of maxBackoff
        up to maxAttempts times.
        """
        return self._values.get('max_doublings')

    @builtins.property
    def max_retry_duration(self) -> typing.Optional[str]:
        """If positive, maxRetryDuration specifies the time limit for retrying a failed task, measured from when the task was first attempted.

        Once maxRetryDuration time has passed and the task has
        been attempted maxAttempts times, no further attempts will be
        made and the task will be deleted.

        If zero, then the task age is unlimited.
        """
        return self._values.get('max_retry_duration')

    @builtins.property
    def min_backoff(self) -> typing.Optional[str]:
        """A task will be scheduled for retry between minBackoff and maxBackoff duration after it fails, if the queue's RetryConfig specifies that the task should be retried."""
        return self._values.get('min_backoff')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudTasksQueueRetryConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudTasksQueueTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class CloudTasksQueueTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudTasksQueueTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudbuildTrigger(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudbuildTrigger"):
    def __init__(self, scope: constructs.Construct, id: str, *, build_attribute: typing.Optional[typing.List["CloudbuildTriggerBuild"]]=None, description: typing.Optional[str]=None, disabled: typing.Optional[bool]=None, filename: typing.Optional[str]=None, ignored_files: typing.Optional[typing.List[str]]=None, included_files: typing.Optional[typing.List[str]]=None, name: typing.Optional[str]=None, project: typing.Optional[str]=None, substitutions: typing.Optional[typing.Mapping[str, str]]=None, tags: typing.Optional[typing.List[str]]=None, timeouts: typing.Optional["CloudbuildTriggerTimeouts"]=None, trigger_template: typing.Optional[typing.List["CloudbuildTriggerTriggerTemplate"]]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param build_attribute: build block.
        :param description: Human-readable description of the trigger.
        :param disabled: Whether the trigger is disabled or not. If true, the trigger will never result in a build.
        :param filename: Path, from the source root, to a file whose contents is used for the template. Either a filename or build template must be provided.
        :param ignored_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'. If ignoredFiles and changed files are both empty, then they are not used to determine whether or not to trigger a build. If ignoredFiles is not empty, then we ignore any files that match any of the ignored_file globs. If the change has no files that are outside of the ignoredFiles globs, then we do not trigger a build.
        :param included_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'. If any of the files altered in the commit pass the ignoredFiles filter and includedFiles is empty, then as far as this filter is concerned, we should trigger the build. If any of the files altered in the commit pass the ignoredFiles filter and includedFiles is not empty, then we make sure that at least one of those files matches a includedFiles glob. If not, then we do not trigger a build.
        :param name: Name of the trigger. Must be unique within the project.
        :param project: 
        :param substitutions: Substitutions data for Build resource.
        :param tags: Tags for annotation of a BuildTrigger.
        :param timeouts: timeouts block.
        :param trigger_template: trigger_template block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudbuildTriggerConfig(build_attribute=build_attribute, description=description, disabled=disabled, filename=filename, ignored_files=ignored_files, included_files=included_files, name=name, project=project, substitutions=substitutions, tags=tags, timeouts=timeouts, trigger_template=trigger_template, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudbuildTrigger, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="createTime")
    def create_time(self) -> str:
        return jsii.get(self, "createTime")

    @builtins.property
    @jsii.member(jsii_name="triggerId")
    def trigger_id(self) -> str:
        return jsii.get(self, "triggerId")

    @builtins.property
    @jsii.member(jsii_name="buildAttribute")
    def build_attribute(self) -> typing.Optional[typing.List["CloudbuildTriggerBuild"]]:
        return jsii.get(self, "buildAttribute")

    @build_attribute.setter
    def build_attribute(self, value: typing.Optional[typing.List["CloudbuildTriggerBuild"]]) -> None:
        jsii.set(self, "buildAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="disabled")
    def disabled(self) -> typing.Optional[bool]:
        return jsii.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "disabled", value)

    @builtins.property
    @jsii.member(jsii_name="filename")
    def filename(self) -> typing.Optional[str]:
        return jsii.get(self, "filename")

    @filename.setter
    def filename(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "filename", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="ignoredFiles")
    def ignored_files(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "ignoredFiles")

    @ignored_files.setter
    def ignored_files(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "ignoredFiles", value)

    @builtins.property
    @jsii.member(jsii_name="includedFiles")
    def included_files(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "includedFiles")

    @included_files.setter
    def included_files(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "includedFiles", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[str]:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="substitutions")
    def substitutions(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "substitutions")

    @substitutions.setter
    def substitutions(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "substitutions", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudbuildTriggerTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudbuildTriggerTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="triggerTemplate")
    def trigger_template(self) -> typing.Optional[typing.List["CloudbuildTriggerTriggerTemplate"]]:
        return jsii.get(self, "triggerTemplate")

    @trigger_template.setter
    def trigger_template(self, value: typing.Optional[typing.List["CloudbuildTriggerTriggerTemplate"]]) -> None:
        jsii.set(self, "triggerTemplate", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerBuild", jsii_struct_bases=[], name_mapping={'step': 'step', 'images': 'images', 'logs_bucket': 'logsBucket', 'queue_ttl': 'queueTtl', 'secret': 'secret', 'source': 'source', 'substitutions': 'substitutions', 'tags': 'tags', 'timeout': 'timeout'})
class CloudbuildTriggerBuild():
    def __init__(self, *, step: typing.List["CloudbuildTriggerBuildStep"], images: typing.Optional[typing.List[str]]=None, logs_bucket: typing.Optional[str]=None, queue_ttl: typing.Optional[str]=None, secret: typing.Optional[typing.List["CloudbuildTriggerBuildSecret"]]=None, source: typing.Optional[typing.List["CloudbuildTriggerBuildSource"]]=None, substitutions: typing.Optional[typing.Mapping[str, str]]=None, tags: typing.Optional[typing.List[str]]=None, timeout: typing.Optional[str]=None) -> None:
        """
        :param step: step block.
        :param images: A list of images to be pushed upon the successful completion of all build steps. The images are pushed using the builder service account's credentials. The digests of the pushed images will be stored in the Build resource's results field. If any of the images fail to be pushed, the build status is marked FAILURE.
        :param logs_bucket: Google Cloud Storage bucket where logs should be written. Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        :param queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value, the build will expire and the build status will be EXPIRED. The TTL starts ticking from createTime. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param secret: secret block.
        :param source: source block.
        :param substitutions: Substitutions data for Build resource.
        :param tags: Tags for annotation of a Build. These are not docker tags.
        :param timeout: Amount of time that this build should be allowed to run, to second granularity. If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT. This timeout must be equal to or greater than the sum of the timeouts for build steps within the build. The expected format is the number of seconds followed by s. Default time is ten minutes (600s).
        """
        self._values = {
            'step': step,
        }
        if images is not None: self._values["images"] = images
        if logs_bucket is not None: self._values["logs_bucket"] = logs_bucket
        if queue_ttl is not None: self._values["queue_ttl"] = queue_ttl
        if secret is not None: self._values["secret"] = secret
        if source is not None: self._values["source"] = source
        if substitutions is not None: self._values["substitutions"] = substitutions
        if tags is not None: self._values["tags"] = tags
        if timeout is not None: self._values["timeout"] = timeout

    @builtins.property
    def step(self) -> typing.List["CloudbuildTriggerBuildStep"]:
        """step block."""
        return self._values.get('step')

    @builtins.property
    def images(self) -> typing.Optional[typing.List[str]]:
        """A list of images to be pushed upon the successful completion of all build steps.

        The images are pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build status is marked FAILURE.
        """
        return self._values.get('images')

    @builtins.property
    def logs_bucket(self) -> typing.Optional[str]:
        """Google Cloud Storage bucket where logs should be written.

        Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        """
        return self._values.get('logs_bucket')

    @builtins.property
    def queue_ttl(self) -> typing.Optional[str]:
        """TTL in queue for this build.

        If provided and the build is enqueued longer than this value,
        the build will expire and the build status will be EXPIRED.
        The TTL starts ticking from createTime.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return self._values.get('queue_ttl')

    @builtins.property
    def secret(self) -> typing.Optional[typing.List["CloudbuildTriggerBuildSecret"]]:
        """secret block."""
        return self._values.get('secret')

    @builtins.property
    def source(self) -> typing.Optional[typing.List["CloudbuildTriggerBuildSource"]]:
        """source block."""
        return self._values.get('source')

    @builtins.property
    def substitutions(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Substitutions data for Build resource."""
        return self._values.get('substitutions')

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[str]]:
        """Tags for annotation of a Build.

        These are not docker tags.
        """
        return self._values.get('tags')

    @builtins.property
    def timeout(self) -> typing.Optional[str]:
        """Amount of time that this build should be allowed to run, to second granularity.

        If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
        This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
        The expected format is the number of seconds followed by s.
        Default time is ten minutes (600s).
        """
        return self._values.get('timeout')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerBuild(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerBuildSecret", jsii_struct_bases=[], name_mapping={'kms_key_name': 'kmsKeyName', 'secret_env': 'secretEnv'})
class CloudbuildTriggerBuildSecret():
    def __init__(self, *, kms_key_name: str, secret_env: typing.Optional[typing.Mapping[str, str]]=None) -> None:
        """
        :param kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param secret_env: Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        self._values = {
            'kms_key_name': kms_key_name,
        }
        if secret_env is not None: self._values["secret_env"] = secret_env

    @builtins.property
    def kms_key_name(self) -> str:
        """Cloud KMS key name to use to decrypt these envs."""
        return self._values.get('kms_key_name')

    @builtins.property
    def secret_env(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Map of environment variable name to its encrypted value.

        Secret environment variables must be unique across all of a build's secrets,
        and must be used by at least one build step. Values can be at most 64 KB in size.
        There can be at most 100 secret values across all of a build's secrets.
        """
        return self._values.get('secret_env')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerBuildSecret(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerBuildSource", jsii_struct_bases=[], name_mapping={'repo_source': 'repoSource', 'storage_source': 'storageSource'})
class CloudbuildTriggerBuildSource():
    def __init__(self, *, repo_source: typing.Optional[typing.List["CloudbuildTriggerBuildSourceRepoSource"]]=None, storage_source: typing.Optional[typing.List["CloudbuildTriggerBuildSourceStorageSource"]]=None) -> None:
        """
        :param repo_source: repo_source block.
        :param storage_source: storage_source block.
        """
        self._values = {
        }
        if repo_source is not None: self._values["repo_source"] = repo_source
        if storage_source is not None: self._values["storage_source"] = storage_source

    @builtins.property
    def repo_source(self) -> typing.Optional[typing.List["CloudbuildTriggerBuildSourceRepoSource"]]:
        """repo_source block."""
        return self._values.get('repo_source')

    @builtins.property
    def storage_source(self) -> typing.Optional[typing.List["CloudbuildTriggerBuildSourceStorageSource"]]:
        """storage_source block."""
        return self._values.get('storage_source')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerBuildSource(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerBuildSourceRepoSource", jsii_struct_bases=[], name_mapping={'repo_name': 'repoName', 'branch_name': 'branchName', 'commit_sha': 'commitSha', 'dir': 'dir', 'invert_regex': 'invertRegex', 'project_id': 'projectId', 'substitutions': 'substitutions', 'tag_name': 'tagName'})
class CloudbuildTriggerBuildSourceRepoSource():
    def __init__(self, *, repo_name: str, branch_name: typing.Optional[str]=None, commit_sha: typing.Optional[str]=None, dir: typing.Optional[str]=None, invert_regex: typing.Optional[bool]=None, project_id: typing.Optional[str]=None, substitutions: typing.Optional[typing.Mapping[str, str]]=None, tag_name: typing.Optional[str]=None) -> None:
        """
        :param repo_name: Name of the Cloud Source Repository.
        :param branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param dir: Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's dir is specified and is an absolute path, this value is ignored for that step's execution.
        :param invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param project_id: ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        :param substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        self._values = {
            'repo_name': repo_name,
        }
        if branch_name is not None: self._values["branch_name"] = branch_name
        if commit_sha is not None: self._values["commit_sha"] = commit_sha
        if dir is not None: self._values["dir"] = dir
        if invert_regex is not None: self._values["invert_regex"] = invert_regex
        if project_id is not None: self._values["project_id"] = project_id
        if substitutions is not None: self._values["substitutions"] = substitutions
        if tag_name is not None: self._values["tag_name"] = tag_name

    @builtins.property
    def repo_name(self) -> str:
        """Name of the Cloud Source Repository."""
        return self._values.get('repo_name')

    @builtins.property
    def branch_name(self) -> typing.Optional[str]:
        """Regex matching branches to build.

        Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return self._values.get('branch_name')

    @builtins.property
    def commit_sha(self) -> typing.Optional[str]:
        """Explicit commit SHA to build.

        Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return self._values.get('commit_sha')

    @builtins.property
    def dir(self) -> typing.Optional[str]:
        """Directory, relative to the source root, in which to run the build.

        This must be a relative path. If a step's dir is specified and is an absolute path,
        this value is ignored for that step's execution.
        """
        return self._values.get('dir')

    @builtins.property
    def invert_regex(self) -> typing.Optional[bool]:
        """Only trigger a build if the revision regex does NOT match the revision regex."""
        return self._values.get('invert_regex')

    @builtins.property
    def project_id(self) -> typing.Optional[str]:
        """ID of the project that owns the Cloud Source Repository.

        If omitted, the project ID requesting the build is assumed.
        """
        return self._values.get('project_id')

    @builtins.property
    def substitutions(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Substitutions to use in a triggered build.

        Should only be used with triggers.run
        """
        return self._values.get('substitutions')

    @builtins.property
    def tag_name(self) -> typing.Optional[str]:
        """Regex matching tags to build.

        Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return self._values.get('tag_name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerBuildSourceRepoSource(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerBuildSourceStorageSource", jsii_struct_bases=[], name_mapping={'bucket': 'bucket', 'object': 'object', 'generation': 'generation'})
class CloudbuildTriggerBuildSourceStorageSource():
    def __init__(self, *, bucket: str, object: str, generation: typing.Optional[str]=None) -> None:
        """
        :param bucket: Google Cloud Storage bucket containing the source.
        :param object: Google Cloud Storage object containing the source. This object must be a gzipped archive file (.tar.gz) containing source to build.
        :param generation: Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used
        """
        self._values = {
            'bucket': bucket,
            'object': object,
        }
        if generation is not None: self._values["generation"] = generation

    @builtins.property
    def bucket(self) -> str:
        """Google Cloud Storage bucket containing the source."""
        return self._values.get('bucket')

    @builtins.property
    def object(self) -> str:
        """Google Cloud Storage object containing the source.

        This object must be a gzipped archive file (.tar.gz) containing source to build.
        """
        return self._values.get('object')

    @builtins.property
    def generation(self) -> typing.Optional[str]:
        """Google Cloud Storage generation for the object.

        If the generation is omitted, the latest generation will be used
        """
        return self._values.get('generation')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerBuildSourceStorageSource(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerBuildStep", jsii_struct_bases=[], name_mapping={'name': 'name', 'args': 'args', 'dir': 'dir', 'entrypoint': 'entrypoint', 'env': 'env', 'id': 'id', 'secret_env': 'secretEnv', 'timeout': 'timeout', 'timing': 'timing', 'volumes': 'volumes', 'wait_for': 'waitFor'})
class CloudbuildTriggerBuildStep():
    def __init__(self, *, name: str, args: typing.Optional[typing.List[str]]=None, dir: typing.Optional[str]=None, entrypoint: typing.Optional[str]=None, env: typing.Optional[typing.List[str]]=None, id: typing.Optional[str]=None, secret_env: typing.Optional[typing.List[str]]=None, timeout: typing.Optional[str]=None, timing: typing.Optional[str]=None, volumes: typing.Optional[typing.List["CloudbuildTriggerBuildStepVolumes"]]=None, wait_for: typing.Optional[typing.List[str]]=None) -> None:
        """
        :param name: The name of the container image that will run this particular build step. If the image is available in the host's Docker daemon's cache, it will be run directly. If not, the host will attempt to pull the image first, using the builder service account's credentials if necessary. The Docker daemon's cache will already have the latest versions of all of the officially supported build steps (https://github.com/GoogleCloudPlatform/cloud-builders). The Docker daemon will also have cached many of the layers for some popular images, like "ubuntu", "debian", but they will be refreshed at the time you attempt to use them. If you built an image in a previous build step, it will be stored in the host's Docker daemon's cache and is available to use as the name for a later build step.
        :param args: A list of arguments that will be presented to the step when it is started. If the image used to run the step's container has an entrypoint, the args are used as arguments to that entrypoint. If the image does not define an entrypoint, the first element in args is used as the entrypoint, and the remainder will be used as arguments.
        :param dir: Working directory to use when running this step's container. If this value is a relative path, it is relative to the build's working directory. If this value is absolute, it may be outside the build's working directory, in which case the contents of the path may not be persisted across build step executions, unless a 'volume' for that path is specified. If the build specifies a 'RepoSource' with 'dir' and a step with a 'dir', which specifies an absolute path, the 'RepoSource' 'dir' is ignored for the step's execution.
        :param entrypoint: Entrypoint to be used instead of the build step image's default entrypoint. If unset, the image's default entrypoint is used
        :param env: A list of environment variable definitions to be used when running a step. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param id: Unique identifier for this build step, used in 'wait_for' to reference this build step as a dependency.
        :param secret_env: A list of environment variables which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's 'Secret'.
        :param timeout: Time limit for executing this build step. If not defined, the step has no time limit and will be allowed to continue to run until either it completes or the build itself times out.
        :param timing: Output only. Stores timing information for executing this build step.
        :param volumes: volumes block.
        :param wait_for: The ID(s) of the step(s) that this build step depends on. This build step will not start until all the build steps in 'wait_for' have completed successfully. If 'wait_for' is empty, this build step will start when all previous build steps in the 'Build.Steps' list have completed successfully.
        """
        self._values = {
            'name': name,
        }
        if args is not None: self._values["args"] = args
        if dir is not None: self._values["dir"] = dir
        if entrypoint is not None: self._values["entrypoint"] = entrypoint
        if env is not None: self._values["env"] = env
        if id is not None: self._values["id"] = id
        if secret_env is not None: self._values["secret_env"] = secret_env
        if timeout is not None: self._values["timeout"] = timeout
        if timing is not None: self._values["timing"] = timing
        if volumes is not None: self._values["volumes"] = volumes
        if wait_for is not None: self._values["wait_for"] = wait_for

    @builtins.property
    def name(self) -> str:
        """The name of the container image that will run this particular build step.

        If the image is available in the host's Docker daemon's cache, it will be
        run directly. If not, the host will attempt to pull the image first, using
        the builder service account's credentials if necessary.

        The Docker daemon's cache will already have the latest versions of all of
        the officially supported build steps (https://github.com/GoogleCloudPlatform/cloud-builders).
        The Docker daemon will also have cached many of the layers for some popular
        images, like "ubuntu", "debian", but they will be refreshed at the time
        you attempt to use them.

        If you built an image in a previous build step, it will be stored in the
        host's Docker daemon's cache and is available to use as the name for a
        later build step.
        """
        return self._values.get('name')

    @builtins.property
    def args(self) -> typing.Optional[typing.List[str]]:
        """A list of arguments that will be presented to the step when it is started.

        If the image used to run the step's container has an entrypoint, the args
        are used as arguments to that entrypoint. If the image does not define an
        entrypoint, the first element in args is used as the entrypoint, and the
        remainder will be used as arguments.
        """
        return self._values.get('args')

    @builtins.property
    def dir(self) -> typing.Optional[str]:
        """Working directory to use when running this step's container.

        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a 'volume' for that path is specified.

        If the build specifies a 'RepoSource' with 'dir' and a step with a
        'dir',
        which specifies an absolute path, the 'RepoSource' 'dir' is ignored
        for the step's execution.
        """
        return self._values.get('dir')

    @builtins.property
    def entrypoint(self) -> typing.Optional[str]:
        """Entrypoint to be used instead of the build step image's default entrypoint.

        If unset, the image's default entrypoint is used
        """
        return self._values.get('entrypoint')

    @builtins.property
    def env(self) -> typing.Optional[typing.List[str]]:
        """A list of environment variable definitions to be used when running a step.

        The elements are of the form "KEY=VALUE" for the environment variable
        "KEY" being given the value "VALUE".
        """
        return self._values.get('env')

    @builtins.property
    def id(self) -> typing.Optional[str]:
        """Unique identifier for this build step, used in 'wait_for' to reference this build step as a dependency."""
        return self._values.get('id')

    @builtins.property
    def secret_env(self) -> typing.Optional[typing.List[str]]:
        """A list of environment variables which are encrypted using a Cloud Key Management Service crypto key.

        These values must be specified in
        the build's 'Secret'.
        """
        return self._values.get('secret_env')

    @builtins.property
    def timeout(self) -> typing.Optional[str]:
        """Time limit for executing this build step.

        If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return self._values.get('timeout')

    @builtins.property
    def timing(self) -> typing.Optional[str]:
        """Output only.

        Stores timing information for executing this
        build step.
        """
        return self._values.get('timing')

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List["CloudbuildTriggerBuildStepVolumes"]]:
        """volumes block."""
        return self._values.get('volumes')

    @builtins.property
    def wait_for(self) -> typing.Optional[typing.List[str]]:
        """The ID(s) of the step(s) that this build step depends on.

        This build step will not start until all the build steps in 'wait_for'
        have completed successfully. If 'wait_for' is empty, this build step
        will start when all previous build steps in the 'Build.Steps' list
        have completed successfully.
        """
        return self._values.get('wait_for')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerBuildStep(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerBuildStepVolumes", jsii_struct_bases=[], name_mapping={'name': 'name', 'path': 'path'})
class CloudbuildTriggerBuildStepVolumes():
    def __init__(self, *, name: str, path: str) -> None:
        """
        :param name: Name of the volume to mount. Volume names must be unique per build step and must be valid names for Docker volumes. Each named volume must be used by at least two build steps.
        :param path: Path at which to mount the volume. Paths must be absolute and cannot conflict with other volume paths on the same build step or with certain reserved volume paths.
        """
        self._values = {
            'name': name,
            'path': path,
        }

    @builtins.property
    def name(self) -> str:
        """Name of the volume to mount.

        Volume names must be unique per build step and must be valid names for
        Docker volumes. Each named volume must be used by at least two build steps.
        """
        return self._values.get('name')

    @builtins.property
    def path(self) -> str:
        """Path at which to mount the volume.

        Paths must be absolute and cannot conflict with other volume paths on
        the same build step or with certain reserved volume paths.
        """
        return self._values.get('path')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerBuildStepVolumes(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'build_attribute': 'buildAttribute', 'description': 'description', 'disabled': 'disabled', 'filename': 'filename', 'ignored_files': 'ignoredFiles', 'included_files': 'includedFiles', 'name': 'name', 'project': 'project', 'substitutions': 'substitutions', 'tags': 'tags', 'timeouts': 'timeouts', 'trigger_template': 'triggerTemplate'})
class CloudbuildTriggerConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, build_attribute: typing.Optional[typing.List["CloudbuildTriggerBuild"]]=None, description: typing.Optional[str]=None, disabled: typing.Optional[bool]=None, filename: typing.Optional[str]=None, ignored_files: typing.Optional[typing.List[str]]=None, included_files: typing.Optional[typing.List[str]]=None, name: typing.Optional[str]=None, project: typing.Optional[str]=None, substitutions: typing.Optional[typing.Mapping[str, str]]=None, tags: typing.Optional[typing.List[str]]=None, timeouts: typing.Optional["CloudbuildTriggerTimeouts"]=None, trigger_template: typing.Optional[typing.List["CloudbuildTriggerTriggerTemplate"]]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param build_attribute: build block.
        :param description: Human-readable description of the trigger.
        :param disabled: Whether the trigger is disabled or not. If true, the trigger will never result in a build.
        :param filename: Path, from the source root, to a file whose contents is used for the template. Either a filename or build template must be provided.
        :param ignored_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'. If ignoredFiles and changed files are both empty, then they are not used to determine whether or not to trigger a build. If ignoredFiles is not empty, then we ignore any files that match any of the ignored_file globs. If the change has no files that are outside of the ignoredFiles globs, then we do not trigger a build.
        :param included_files: ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'. If any of the files altered in the commit pass the ignoredFiles filter and includedFiles is empty, then as far as this filter is concerned, we should trigger the build. If any of the files altered in the commit pass the ignoredFiles filter and includedFiles is not empty, then we make sure that at least one of those files matches a includedFiles glob. If not, then we do not trigger a build.
        :param name: Name of the trigger. Must be unique within the project.
        :param project: 
        :param substitutions: Substitutions data for Build resource.
        :param tags: Tags for annotation of a BuildTrigger.
        :param timeouts: timeouts block.
        :param trigger_template: trigger_template block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudbuildTriggerTimeouts(**timeouts)
        self._values = {
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if build_attribute is not None: self._values["build_attribute"] = build_attribute
        if description is not None: self._values["description"] = description
        if disabled is not None: self._values["disabled"] = disabled
        if filename is not None: self._values["filename"] = filename
        if ignored_files is not None: self._values["ignored_files"] = ignored_files
        if included_files is not None: self._values["included_files"] = included_files
        if name is not None: self._values["name"] = name
        if project is not None: self._values["project"] = project
        if substitutions is not None: self._values["substitutions"] = substitutions
        if tags is not None: self._values["tags"] = tags
        if timeouts is not None: self._values["timeouts"] = timeouts
        if trigger_template is not None: self._values["trigger_template"] = trigger_template

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def build_attribute(self) -> typing.Optional[typing.List["CloudbuildTriggerBuild"]]:
        """build block."""
        return self._values.get('build_attribute')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """Human-readable description of the trigger."""
        return self._values.get('description')

    @builtins.property
    def disabled(self) -> typing.Optional[bool]:
        """Whether the trigger is disabled or not.

        If true, the trigger will never result in a build.
        """
        return self._values.get('disabled')

    @builtins.property
    def filename(self) -> typing.Optional[str]:
        """Path, from the source root, to a file whose contents is used for the template.

        Either a filename or build template must be provided.
        """
        return self._values.get('filename')

    @builtins.property
    def ignored_files(self) -> typing.Optional[typing.List[str]]:
        """ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'.

        If ignoredFiles and changed files are both empty, then they are not
        used to determine whether or not to trigger a build.

        If ignoredFiles is not empty, then we ignore any files that match any
        of the ignored_file globs. If the change has no files that are outside
        of the ignoredFiles globs, then we do not trigger a build.
        """
        return self._values.get('ignored_files')

    @builtins.property
    def included_files(self) -> typing.Optional[typing.List[str]]:
        """ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'.

        If any of the files altered in the commit pass the ignoredFiles filter
        and includedFiles is empty, then as far as this filter is concerned, we
        should trigger the build.

        If any of the files altered in the commit pass the ignoredFiles filter
        and includedFiles is not empty, then we make sure that at least one of
        those files matches a includedFiles glob. If not, then we do not trigger
        a build.
        """
        return self._values.get('included_files')

    @builtins.property
    def name(self) -> typing.Optional[str]:
        """Name of the trigger.

        Must be unique within the project.
        """
        return self._values.get('name')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def substitutions(self) -> typing.Optional[typing.Mapping[str, str]]:
        """Substitutions data for Build resource."""
        return self._values.get('substitutions')

    @builtins.property
    def tags(self) -> typing.Optional[typing.List[str]]:
        """Tags for annotation of a BuildTrigger."""
        return self._values.get('tags')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudbuildTriggerTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    @builtins.property
    def trigger_template(self) -> typing.Optional[typing.List["CloudbuildTriggerTriggerTemplate"]]:
        """trigger_template block."""
        return self._values.get('trigger_template')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class CloudbuildTriggerTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudbuildTriggerTriggerTemplate", jsii_struct_bases=[], name_mapping={'branch_name': 'branchName', 'commit_sha': 'commitSha', 'dir': 'dir', 'invert_regex': 'invertRegex', 'project_id': 'projectId', 'repo_name': 'repoName', 'tag_name': 'tagName'})
class CloudbuildTriggerTriggerTemplate():
    def __init__(self, *, branch_name: typing.Optional[str]=None, commit_sha: typing.Optional[str]=None, dir: typing.Optional[str]=None, invert_regex: typing.Optional[bool]=None, project_id: typing.Optional[str]=None, repo_name: typing.Optional[str]=None, tag_name: typing.Optional[str]=None) -> None:
        """
        :param branch_name: Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided. This field is a regular expression.
        :param commit_sha: Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        :param dir: Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's dir is specified and is an absolute path, this value is ignored for that step's execution.
        :param invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param project_id: ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        :param repo_name: Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
        :param tag_name: Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided. This field is a regular expression.
        """
        self._values = {
        }
        if branch_name is not None: self._values["branch_name"] = branch_name
        if commit_sha is not None: self._values["commit_sha"] = commit_sha
        if dir is not None: self._values["dir"] = dir
        if invert_regex is not None: self._values["invert_regex"] = invert_regex
        if project_id is not None: self._values["project_id"] = project_id
        if repo_name is not None: self._values["repo_name"] = repo_name
        if tag_name is not None: self._values["tag_name"] = tag_name

    @builtins.property
    def branch_name(self) -> typing.Optional[str]:
        """Name of the branch to build.

        Exactly one a of branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
        return self._values.get('branch_name')

    @builtins.property
    def commit_sha(self) -> typing.Optional[str]:
        """Explicit commit SHA to build.

        Exactly one of a branch name, tag, or commit SHA must be provided.
        """
        return self._values.get('commit_sha')

    @builtins.property
    def dir(self) -> typing.Optional[str]:
        """Directory, relative to the source root, in which to run the build.

        This must be a relative path. If a step's dir is specified and
        is an absolute path, this value is ignored for that step's
        execution.
        """
        return self._values.get('dir')

    @builtins.property
    def invert_regex(self) -> typing.Optional[bool]:
        """Only trigger a build if the revision regex does NOT match the revision regex."""
        return self._values.get('invert_regex')

    @builtins.property
    def project_id(self) -> typing.Optional[str]:
        """ID of the project that owns the Cloud Source Repository.

        If
        omitted, the project ID requesting the build is assumed.
        """
        return self._values.get('project_id')

    @builtins.property
    def repo_name(self) -> typing.Optional[str]:
        """Name of the Cloud Source Repository.

        If omitted, the name "default" is assumed.
        """
        return self._values.get('repo_name')

    @builtins.property
    def tag_name(self) -> typing.Optional[str]:
        """Name of the tag to build.

        Exactly one of a branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
        return self._values.get('tag_name')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudbuildTriggerTriggerTemplate(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudfunctionsFunction(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudfunctionsFunction"):
    def __init__(self, scope: constructs.Construct, id: str, *, name: str, runtime: str, available_memory_mb: typing.Optional[jsii.Number]=None, description: typing.Optional[str]=None, entry_point: typing.Optional[str]=None, environment_variables: typing.Optional[typing.Mapping[str, str]]=None, event_trigger: typing.Optional[typing.List["CloudfunctionsFunctionEventTrigger"]]=None, https_trigger_url: typing.Optional[str]=None, ingress_settings: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, max_instances: typing.Optional[jsii.Number]=None, project: typing.Optional[str]=None, region: typing.Optional[str]=None, service_account_email: typing.Optional[str]=None, source_archive_bucket: typing.Optional[str]=None, source_archive_object: typing.Optional[str]=None, source_repository: typing.Optional[typing.List["CloudfunctionsFunctionSourceRepository"]]=None, timeout: typing.Optional[jsii.Number]=None, timeouts: typing.Optional["CloudfunctionsFunctionTimeouts"]=None, trigger_http: typing.Optional[bool]=None, vpc_connector: typing.Optional[str]=None, vpc_connector_egress_settings: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param name: A user-defined name of the function. Function names must be unique globally.
        :param runtime: The runtime in which the function is going to run. Eg. "nodejs8", "nodejs10", "python37", "go111".
        :param available_memory_mb: Memory (in MB), available to the function. Default value is 256MB. Allowed values are: 128MB, 256MB, 512MB, 1024MB, and 2048MB.
        :param description: Description of the function.
        :param entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param event_trigger: event_trigger block.
        :param https_trigger_url: URL which triggers function execution. Returned only if trigger_http is used.
        :param ingress_settings: String value that controls what traffic can reach the function. Allowed values are ALLOW_ALL and ALLOW_INTERNAL_ONLY. Changes to this field will recreate the cloud function.
        :param labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        :param max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param project: Project of the function. If it is not provided, the provider project is used.
        :param region: Region of function. Currently can be only "us-central1". If it is not provided, the provider region is used.
        :param service_account_email: If provided, the self-provided service account to run the function with.
        :param source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param source_archive_object: The source archive object (file) in archive bucket.
        :param source_repository: source_repository block.
        :param timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param timeouts: timeouts block.
        :param trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as https_trigger_url. Cannot be used with trigger_bucket and trigger_topic.
        :param vpc_connector: The VPC Network Connector that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is projects/*/locations/*/connectors/*.
        :param vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are ALL_TRAFFIC and PRIVATE_RANGES_ONLY. Defaults to PRIVATE_RANGES_ONLY. If unset, this field preserves the previously set value.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudfunctionsFunctionConfig(name=name, runtime=runtime, available_memory_mb=available_memory_mb, description=description, entry_point=entry_point, environment_variables=environment_variables, event_trigger=event_trigger, https_trigger_url=https_trigger_url, ingress_settings=ingress_settings, labels=labels, max_instances=max_instances, project=project, region=region, service_account_email=service_account_email, source_archive_bucket=source_archive_bucket, source_archive_object=source_archive_object, source_repository=source_repository, timeout=timeout, timeouts=timeouts, trigger_http=trigger_http, vpc_connector=vpc_connector, vpc_connector_egress_settings=vpc_connector_egress_settings, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudfunctionsFunction, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="runtime")
    def runtime(self) -> str:
        return jsii.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: str) -> None:
        jsii.set(self, "runtime", value)

    @builtins.property
    @jsii.member(jsii_name="availableMemoryMb")
    def available_memory_mb(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "availableMemoryMb")

    @available_memory_mb.setter
    def available_memory_mb(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "availableMemoryMb", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="entryPoint")
    def entry_point(self) -> typing.Optional[str]:
        return jsii.get(self, "entryPoint")

    @entry_point.setter
    def entry_point(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "entryPoint", value)

    @builtins.property
    @jsii.member(jsii_name="environmentVariables")
    def environment_variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "environmentVariables")

    @environment_variables.setter
    def environment_variables(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "environmentVariables", value)

    @builtins.property
    @jsii.member(jsii_name="eventTrigger")
    def event_trigger(self) -> typing.Optional[typing.List["CloudfunctionsFunctionEventTrigger"]]:
        return jsii.get(self, "eventTrigger")

    @event_trigger.setter
    def event_trigger(self, value: typing.Optional[typing.List["CloudfunctionsFunctionEventTrigger"]]) -> None:
        jsii.set(self, "eventTrigger", value)

    @builtins.property
    @jsii.member(jsii_name="httpsTriggerUrl")
    def https_trigger_url(self) -> typing.Optional[str]:
        return jsii.get(self, "httpsTriggerUrl")

    @https_trigger_url.setter
    def https_trigger_url(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "httpsTriggerUrl", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="ingressSettings")
    def ingress_settings(self) -> typing.Optional[str]:
        return jsii.get(self, "ingressSettings")

    @ingress_settings.setter
    def ingress_settings(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "ingressSettings", value)

    @builtins.property
    @jsii.member(jsii_name="labels")
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "labels")

    @labels.setter
    def labels(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "labels", value)

    @builtins.property
    @jsii.member(jsii_name="maxInstances")
    def max_instances(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "maxInstances")

    @max_instances.setter
    def max_instances(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "maxInstances", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="region")
    def region(self) -> typing.Optional[str]:
        return jsii.get(self, "region")

    @region.setter
    def region(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "region", value)

    @builtins.property
    @jsii.member(jsii_name="serviceAccountEmail")
    def service_account_email(self) -> typing.Optional[str]:
        return jsii.get(self, "serviceAccountEmail")

    @service_account_email.setter
    def service_account_email(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "serviceAccountEmail", value)

    @builtins.property
    @jsii.member(jsii_name="sourceArchiveBucket")
    def source_archive_bucket(self) -> typing.Optional[str]:
        return jsii.get(self, "sourceArchiveBucket")

    @source_archive_bucket.setter
    def source_archive_bucket(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "sourceArchiveBucket", value)

    @builtins.property
    @jsii.member(jsii_name="sourceArchiveObject")
    def source_archive_object(self) -> typing.Optional[str]:
        return jsii.get(self, "sourceArchiveObject")

    @source_archive_object.setter
    def source_archive_object(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "sourceArchiveObject", value)

    @builtins.property
    @jsii.member(jsii_name="sourceRepository")
    def source_repository(self) -> typing.Optional[typing.List["CloudfunctionsFunctionSourceRepository"]]:
        return jsii.get(self, "sourceRepository")

    @source_repository.setter
    def source_repository(self, value: typing.Optional[typing.List["CloudfunctionsFunctionSourceRepository"]]) -> None:
        jsii.set(self, "sourceRepository", value)

    @builtins.property
    @jsii.member(jsii_name="timeout")
    def timeout(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "timeout", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudfunctionsFunctionTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudfunctionsFunctionTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="triggerHttp")
    def trigger_http(self) -> typing.Optional[bool]:
        return jsii.get(self, "triggerHttp")

    @trigger_http.setter
    def trigger_http(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "triggerHttp", value)

    @builtins.property
    @jsii.member(jsii_name="vpcConnector")
    def vpc_connector(self) -> typing.Optional[str]:
        return jsii.get(self, "vpcConnector")

    @vpc_connector.setter
    def vpc_connector(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "vpcConnector", value)

    @builtins.property
    @jsii.member(jsii_name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> typing.Optional[str]:
        return jsii.get(self, "vpcConnectorEgressSettings")

    @vpc_connector_egress_settings.setter
    def vpc_connector_egress_settings(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "vpcConnectorEgressSettings", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'name': 'name', 'runtime': 'runtime', 'available_memory_mb': 'availableMemoryMb', 'description': 'description', 'entry_point': 'entryPoint', 'environment_variables': 'environmentVariables', 'event_trigger': 'eventTrigger', 'https_trigger_url': 'httpsTriggerUrl', 'ingress_settings': 'ingressSettings', 'labels': 'labels', 'max_instances': 'maxInstances', 'project': 'project', 'region': 'region', 'service_account_email': 'serviceAccountEmail', 'source_archive_bucket': 'sourceArchiveBucket', 'source_archive_object': 'sourceArchiveObject', 'source_repository': 'sourceRepository', 'timeout': 'timeout', 'timeouts': 'timeouts', 'trigger_http': 'triggerHttp', 'vpc_connector': 'vpcConnector', 'vpc_connector_egress_settings': 'vpcConnectorEgressSettings'})
class CloudfunctionsFunctionConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, name: str, runtime: str, available_memory_mb: typing.Optional[jsii.Number]=None, description: typing.Optional[str]=None, entry_point: typing.Optional[str]=None, environment_variables: typing.Optional[typing.Mapping[str, str]]=None, event_trigger: typing.Optional[typing.List["CloudfunctionsFunctionEventTrigger"]]=None, https_trigger_url: typing.Optional[str]=None, ingress_settings: typing.Optional[str]=None, labels: typing.Optional[typing.Mapping[str, str]]=None, max_instances: typing.Optional[jsii.Number]=None, project: typing.Optional[str]=None, region: typing.Optional[str]=None, service_account_email: typing.Optional[str]=None, source_archive_bucket: typing.Optional[str]=None, source_archive_object: typing.Optional[str]=None, source_repository: typing.Optional[typing.List["CloudfunctionsFunctionSourceRepository"]]=None, timeout: typing.Optional[jsii.Number]=None, timeouts: typing.Optional["CloudfunctionsFunctionTimeouts"]=None, trigger_http: typing.Optional[bool]=None, vpc_connector: typing.Optional[str]=None, vpc_connector_egress_settings: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: A user-defined name of the function. Function names must be unique globally.
        :param runtime: The runtime in which the function is going to run. Eg. "nodejs8", "nodejs10", "python37", "go111".
        :param available_memory_mb: Memory (in MB), available to the function. Default value is 256MB. Allowed values are: 128MB, 256MB, 512MB, 1024MB, and 2048MB.
        :param description: Description of the function.
        :param entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param event_trigger: event_trigger block.
        :param https_trigger_url: URL which triggers function execution. Returned only if trigger_http is used.
        :param ingress_settings: String value that controls what traffic can reach the function. Allowed values are ALLOW_ALL and ALLOW_INTERNAL_ONLY. Changes to this field will recreate the cloud function.
        :param labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        :param max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param project: Project of the function. If it is not provided, the provider project is used.
        :param region: Region of function. Currently can be only "us-central1". If it is not provided, the provider region is used.
        :param service_account_email: If provided, the self-provided service account to run the function with.
        :param source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param source_archive_object: The source archive object (file) in archive bucket.
        :param source_repository: source_repository block.
        :param timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param timeouts: timeouts block.
        :param trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as https_trigger_url. Cannot be used with trigger_bucket and trigger_topic.
        :param vpc_connector: The VPC Network Connector that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is projects/*/locations/*/connectors/*.
        :param vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are ALL_TRAFFIC and PRIVATE_RANGES_ONLY. Defaults to PRIVATE_RANGES_ONLY. If unset, this field preserves the previously set value.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudfunctionsFunctionTimeouts(**timeouts)
        self._values = {
            'name': name,
            'runtime': runtime,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if available_memory_mb is not None: self._values["available_memory_mb"] = available_memory_mb
        if description is not None: self._values["description"] = description
        if entry_point is not None: self._values["entry_point"] = entry_point
        if environment_variables is not None: self._values["environment_variables"] = environment_variables
        if event_trigger is not None: self._values["event_trigger"] = event_trigger
        if https_trigger_url is not None: self._values["https_trigger_url"] = https_trigger_url
        if ingress_settings is not None: self._values["ingress_settings"] = ingress_settings
        if labels is not None: self._values["labels"] = labels
        if max_instances is not None: self._values["max_instances"] = max_instances
        if project is not None: self._values["project"] = project
        if region is not None: self._values["region"] = region
        if service_account_email is not None: self._values["service_account_email"] = service_account_email
        if source_archive_bucket is not None: self._values["source_archive_bucket"] = source_archive_bucket
        if source_archive_object is not None: self._values["source_archive_object"] = source_archive_object
        if source_repository is not None: self._values["source_repository"] = source_repository
        if timeout is not None: self._values["timeout"] = timeout
        if timeouts is not None: self._values["timeouts"] = timeouts
        if trigger_http is not None: self._values["trigger_http"] = trigger_http
        if vpc_connector is not None: self._values["vpc_connector"] = vpc_connector
        if vpc_connector_egress_settings is not None: self._values["vpc_connector_egress_settings"] = vpc_connector_egress_settings

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def name(self) -> str:
        """A user-defined name of the function.

        Function names must be unique globally.
        """
        return self._values.get('name')

    @builtins.property
    def runtime(self) -> str:
        """The runtime in which the function is going to run.

        Eg. "nodejs8", "nodejs10", "python37", "go111".
        """
        return self._values.get('runtime')

    @builtins.property
    def available_memory_mb(self) -> typing.Optional[jsii.Number]:
        """Memory (in MB), available to the function.

        Default value is 256MB. Allowed values are: 128MB, 256MB, 512MB, 1024MB, and 2048MB.
        """
        return self._values.get('available_memory_mb')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        """Description of the function."""
        return self._values.get('description')

    @builtins.property
    def entry_point(self) -> typing.Optional[str]:
        """Name of the function that will be executed when the Google Cloud Function is triggered."""
        return self._values.get('entry_point')

    @builtins.property
    def environment_variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        """A set of key/value environment variable pairs to assign to the function."""
        return self._values.get('environment_variables')

    @builtins.property
    def event_trigger(self) -> typing.Optional[typing.List["CloudfunctionsFunctionEventTrigger"]]:
        """event_trigger block."""
        return self._values.get('event_trigger')

    @builtins.property
    def https_trigger_url(self) -> typing.Optional[str]:
        """URL which triggers function execution.

        Returned only if trigger_http is used.
        """
        return self._values.get('https_trigger_url')

    @builtins.property
    def ingress_settings(self) -> typing.Optional[str]:
        """String value that controls what traffic can reach the function.

        Allowed values are ALLOW_ALL and ALLOW_INTERNAL_ONLY. Changes to this field will recreate the cloud function.
        """
        return self._values.get('ingress_settings')

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[str, str]]:
        """A set of key/value label pairs to assign to the function.

        Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        """
        return self._values.get('labels')

    @builtins.property
    def max_instances(self) -> typing.Optional[jsii.Number]:
        """The limit on the maximum number of function instances that may coexist at a given time."""
        return self._values.get('max_instances')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        """Project of the function.

        If it is not provided, the provider project is used.
        """
        return self._values.get('project')

    @builtins.property
    def region(self) -> typing.Optional[str]:
        """Region of function.

        Currently can be only "us-central1". If it is not provided, the provider region is used.
        """
        return self._values.get('region')

    @builtins.property
    def service_account_email(self) -> typing.Optional[str]:
        """If provided, the self-provided service account to run the function with."""
        return self._values.get('service_account_email')

    @builtins.property
    def source_archive_bucket(self) -> typing.Optional[str]:
        """The GCS bucket containing the zip archive which contains the function."""
        return self._values.get('source_archive_bucket')

    @builtins.property
    def source_archive_object(self) -> typing.Optional[str]:
        """The source archive object (file) in archive bucket."""
        return self._values.get('source_archive_object')

    @builtins.property
    def source_repository(self) -> typing.Optional[typing.List["CloudfunctionsFunctionSourceRepository"]]:
        """source_repository block."""
        return self._values.get('source_repository')

    @builtins.property
    def timeout(self) -> typing.Optional[jsii.Number]:
        """Timeout (in seconds) for the function.

        Default value is 60 seconds. Cannot be more than 540 seconds.
        """
        return self._values.get('timeout')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudfunctionsFunctionTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    @builtins.property
    def trigger_http(self) -> typing.Optional[bool]:
        """Boolean variable.

        Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as https_trigger_url. Cannot be used with trigger_bucket and trigger_topic.
        """
        return self._values.get('trigger_http')

    @builtins.property
    def vpc_connector(self) -> typing.Optional[str]:
        """The VPC Network Connector that this cloud function can connect to.

        It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is projects/*/locations/*/connectors/*.
        """
        return self._values.get('vpc_connector')

    @builtins.property
    def vpc_connector_egress_settings(self) -> typing.Optional[str]:
        """The egress settings for the connector, controlling what traffic is diverted through it.

        Allowed values are ALL_TRAFFIC and PRIVATE_RANGES_ONLY. Defaults to PRIVATE_RANGES_ONLY. If unset, this field preserves the previously set value.
        """
        return self._values.get('vpc_connector_egress_settings')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionEventTrigger", jsii_struct_bases=[], name_mapping={'event_type': 'eventType', 'resource': 'resource', 'failure_policy': 'failurePolicy'})
class CloudfunctionsFunctionEventTrigger():
    def __init__(self, *, event_type: str, resource: str, failure_policy: typing.Optional[typing.List["CloudfunctionsFunctionEventTriggerFailurePolicy"]]=None) -> None:
        """
        :param event_type: The type of event to observe. For example: "google.storage.object.finalize". See the documentation on calling Cloud Functions for a full reference of accepted triggers.
        :param resource: The name or partial URI of the resource from which to observe events. For example, "myBucket" or "projects/my-project/topics/my-topic"
        :param failure_policy: failure_policy block.
        """
        self._values = {
            'event_type': event_type,
            'resource': resource,
        }
        if failure_policy is not None: self._values["failure_policy"] = failure_policy

    @builtins.property
    def event_type(self) -> str:
        """The type of event to observe.

        For example: "google.storage.object.finalize". See the documentation on calling Cloud Functions for a full reference of accepted triggers.
        """
        return self._values.get('event_type')

    @builtins.property
    def resource(self) -> str:
        """The name or partial URI of the resource from which to observe events.

        For example, "myBucket" or "projects/my-project/topics/my-topic"
        """
        return self._values.get('resource')

    @builtins.property
    def failure_policy(self) -> typing.Optional[typing.List["CloudfunctionsFunctionEventTriggerFailurePolicy"]]:
        """failure_policy block."""
        return self._values.get('failure_policy')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionEventTrigger(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionEventTriggerFailurePolicy", jsii_struct_bases=[], name_mapping={'retry': 'retry'})
class CloudfunctionsFunctionEventTriggerFailurePolicy():
    def __init__(self, *, retry: bool) -> None:
        """
        :param retry: Whether the function should be retried on failure. Defaults to false.
        """
        self._values = {
            'retry': retry,
        }

    @builtins.property
    def retry(self) -> bool:
        """Whether the function should be retried on failure.

        Defaults to false.
        """
        return self._values.get('retry')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionEventTriggerFailurePolicy(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudfunctionsFunctionIamBinding(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudfunctionsFunctionIamBinding"):
    def __init__(self, scope: constructs.Construct, id: str, *, cloud_function: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["CloudfunctionsFunctionIamBindingCondition"]]=None, project: typing.Optional[str]=None, region: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param cloud_function: 
        :param members: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param region: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudfunctionsFunctionIamBindingConfig(cloud_function=cloud_function, members=members, role=role, condition=condition, project=project, region=region, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudfunctionsFunctionIamBinding, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="cloudFunction")
    def cloud_function(self) -> str:
        return jsii.get(self, "cloudFunction")

    @cloud_function.setter
    def cloud_function(self, value: str) -> None:
        jsii.set(self, "cloudFunction", value)

    @builtins.property
    @jsii.member(jsii_name="members")
    def members(self) -> typing.List[str]:
        return jsii.get(self, "members")

    @members.setter
    def members(self, value: typing.List[str]) -> None:
        jsii.set(self, "members", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["CloudfunctionsFunctionIamBindingCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["CloudfunctionsFunctionIamBindingCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="region")
    def region(self) -> typing.Optional[str]:
        return jsii.get(self, "region")

    @region.setter
    def region(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "region", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionIamBindingCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class CloudfunctionsFunctionIamBindingCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionIamBindingCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionIamBindingConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'cloud_function': 'cloudFunction', 'members': 'members', 'role': 'role', 'condition': 'condition', 'project': 'project', 'region': 'region'})
class CloudfunctionsFunctionIamBindingConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, cloud_function: str, members: typing.List[str], role: str, condition: typing.Optional[typing.List["CloudfunctionsFunctionIamBindingCondition"]]=None, project: typing.Optional[str]=None, region: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param cloud_function: 
        :param members: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param region: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'cloud_function': cloud_function,
            'members': members,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if project is not None: self._values["project"] = project
        if region is not None: self._values["region"] = region

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def cloud_function(self) -> str:
        return self._values.get('cloud_function')

    @builtins.property
    def members(self) -> typing.List[str]:
        return self._values.get('members')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["CloudfunctionsFunctionIamBindingCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def region(self) -> typing.Optional[str]:
        return self._values.get('region')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionIamBindingConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudfunctionsFunctionIamMember(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudfunctionsFunctionIamMember"):
    def __init__(self, scope: constructs.Construct, id: str, *, cloud_function: str, member: str, role: str, condition: typing.Optional[typing.List["CloudfunctionsFunctionIamMemberCondition"]]=None, project: typing.Optional[str]=None, region: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param cloud_function: 
        :param member: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param region: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudfunctionsFunctionIamMemberConfig(cloud_function=cloud_function, member=member, role=role, condition=condition, project=project, region=region, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudfunctionsFunctionIamMember, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="cloudFunction")
    def cloud_function(self) -> str:
        return jsii.get(self, "cloudFunction")

    @cloud_function.setter
    def cloud_function(self, value: str) -> None:
        jsii.set(self, "cloudFunction", value)

    @builtins.property
    @jsii.member(jsii_name="member")
    def member(self) -> str:
        return jsii.get(self, "member")

    @member.setter
    def member(self, value: str) -> None:
        jsii.set(self, "member", value)

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> str:
        return jsii.get(self, "role")

    @role.setter
    def role(self, value: str) -> None:
        jsii.set(self, "role", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.Optional[typing.List["CloudfunctionsFunctionIamMemberCondition"]]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.Optional[typing.List["CloudfunctionsFunctionIamMemberCondition"]]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="region")
    def region(self) -> typing.Optional[str]:
        return jsii.get(self, "region")

    @region.setter
    def region(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "region", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionIamMemberCondition", jsii_struct_bases=[], name_mapping={'expression': 'expression', 'title': 'title', 'description': 'description'})
class CloudfunctionsFunctionIamMemberCondition():
    def __init__(self, *, expression: str, title: str, description: typing.Optional[str]=None) -> None:
        """
        :param expression: 
        :param title: 
        :param description: 
        """
        self._values = {
            'expression': expression,
            'title': title,
        }
        if description is not None: self._values["description"] = description

    @builtins.property
    def expression(self) -> str:
        return self._values.get('expression')

    @builtins.property
    def title(self) -> str:
        return self._values.get('title')

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get('description')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionIamMemberCondition(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionIamMemberConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'cloud_function': 'cloudFunction', 'member': 'member', 'role': 'role', 'condition': 'condition', 'project': 'project', 'region': 'region'})
class CloudfunctionsFunctionIamMemberConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, cloud_function: str, member: str, role: str, condition: typing.Optional[typing.List["CloudfunctionsFunctionIamMemberCondition"]]=None, project: typing.Optional[str]=None, region: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param cloud_function: 
        :param member: 
        :param role: 
        :param condition: condition block.
        :param project: 
        :param region: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'cloud_function': cloud_function,
            'member': member,
            'role': role,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if condition is not None: self._values["condition"] = condition
        if project is not None: self._values["project"] = project
        if region is not None: self._values["region"] = region

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def cloud_function(self) -> str:
        return self._values.get('cloud_function')

    @builtins.property
    def member(self) -> str:
        return self._values.get('member')

    @builtins.property
    def role(self) -> str:
        return self._values.get('role')

    @builtins.property
    def condition(self) -> typing.Optional[typing.List["CloudfunctionsFunctionIamMemberCondition"]]:
        """condition block."""
        return self._values.get('condition')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def region(self) -> typing.Optional[str]:
        return self._values.get('region')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionIamMemberConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudfunctionsFunctionIamPolicy(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudfunctionsFunctionIamPolicy"):
    def __init__(self, scope: constructs.Construct, id: str, *, cloud_function: str, policy_data: str, project: typing.Optional[str]=None, region: typing.Optional[str]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param cloud_function: 
        :param policy_data: 
        :param project: 
        :param region: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudfunctionsFunctionIamPolicyConfig(cloud_function=cloud_function, policy_data=policy_data, project=project, region=region, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudfunctionsFunctionIamPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="etag")
    def etag(self) -> str:
        return jsii.get(self, "etag")

    @builtins.property
    @jsii.member(jsii_name="cloudFunction")
    def cloud_function(self) -> str:
        return jsii.get(self, "cloudFunction")

    @cloud_function.setter
    def cloud_function(self, value: str) -> None:
        jsii.set(self, "cloudFunction", value)

    @builtins.property
    @jsii.member(jsii_name="policyData")
    def policy_data(self) -> str:
        return jsii.get(self, "policyData")

    @policy_data.setter
    def policy_data(self, value: str) -> None:
        jsii.set(self, "policyData", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="region")
    def region(self) -> typing.Optional[str]:
        return jsii.get(self, "region")

    @region.setter
    def region(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "region", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionIamPolicyConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'cloud_function': 'cloudFunction', 'policy_data': 'policyData', 'project': 'project', 'region': 'region'})
class CloudfunctionsFunctionIamPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, cloud_function: str, policy_data: str, project: typing.Optional[str]=None, region: typing.Optional[str]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param cloud_function: 
        :param policy_data: 
        :param project: 
        :param region: 
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            'cloud_function': cloud_function,
            'policy_data': policy_data,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if project is not None: self._values["project"] = project
        if region is not None: self._values["region"] = region

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def cloud_function(self) -> str:
        return self._values.get('cloud_function')

    @builtins.property
    def policy_data(self) -> str:
        return self._values.get('policy_data')

    @builtins.property
    def project(self) -> typing.Optional[str]:
        return self._values.get('project')

    @builtins.property
    def region(self) -> typing.Optional[str]:
        return self._values.get('region')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionIamPolicyConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionSourceRepository", jsii_struct_bases=[], name_mapping={'url': 'url'})
class CloudfunctionsFunctionSourceRepository():
    def __init__(self, *, url: str) -> None:
        """
        :param url: The URL pointing to the hosted repository where the function is defined.
        """
        self._values = {
            'url': url,
        }

    @builtins.property
    def url(self) -> str:
        """The URL pointing to the hosted repository where the function is defined."""
        return self._values.get('url')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionSourceRepository(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudfunctionsFunctionTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'read': 'read', 'update': 'update'})
class CloudfunctionsFunctionTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, read: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param read: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if read is not None: self._values["read"] = read
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def read(self) -> typing.Optional[str]:
        return self._values.get('read')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudfunctionsFunctionTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudiotDevice(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudiotDevice"):
    def __init__(self, scope: constructs.Construct, id: str, *, name: str, registry: str, blocked: typing.Optional[bool]=None, credentials: typing.Optional[typing.List["CloudiotDeviceCredentials"]]=None, gateway_config: typing.Optional[typing.List["CloudiotDeviceGatewayConfig"]]=None, log_level: typing.Optional[str]=None, metadata: typing.Optional[typing.Mapping[str, str]]=None, timeouts: typing.Optional["CloudiotDeviceTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param name: A unique name for the resource.
        :param registry: The name of the device registry where this device should be created.
        :param blocked: If a device is blocked, connections or requests from this device will fail.
        :param credentials: credentials block.
        :param gateway_config: gateway_config block.
        :param log_level: The logging verbosity for device activity. Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
        :param metadata: The metadata key-value pairs assigned to the device.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudiotDeviceConfig(name=name, registry=registry, blocked=blocked, credentials=credentials, gateway_config=gateway_config, log_level=log_level, metadata=metadata, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudiotDevice, self, [scope, id, config])

    @jsii.member(jsii_name="config")
    def config(self, index: str) -> "CloudiotDeviceConfigA":
        """
        :param index: -
        """
        return jsii.invoke(self, "config", [index])

    @jsii.member(jsii_name="lastErrorStatus")
    def last_error_status(self, index: str) -> "CloudiotDeviceLastErrorStatus":
        """
        :param index: -
        """
        return jsii.invoke(self, "lastErrorStatus", [index])

    @jsii.member(jsii_name="state")
    def state(self, index: str) -> "CloudiotDeviceState":
        """
        :param index: -
        """
        return jsii.invoke(self, "state", [index])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="lastConfigAckTime")
    def last_config_ack_time(self) -> str:
        return jsii.get(self, "lastConfigAckTime")

    @builtins.property
    @jsii.member(jsii_name="lastConfigSendTime")
    def last_config_send_time(self) -> str:
        return jsii.get(self, "lastConfigSendTime")

    @builtins.property
    @jsii.member(jsii_name="lastErrorTime")
    def last_error_time(self) -> str:
        return jsii.get(self, "lastErrorTime")

    @builtins.property
    @jsii.member(jsii_name="lastEventTime")
    def last_event_time(self) -> str:
        return jsii.get(self, "lastEventTime")

    @builtins.property
    @jsii.member(jsii_name="lastHeartbeatTime")
    def last_heartbeat_time(self) -> str:
        return jsii.get(self, "lastHeartbeatTime")

    @builtins.property
    @jsii.member(jsii_name="lastStateTime")
    def last_state_time(self) -> str:
        return jsii.get(self, "lastStateTime")

    @builtins.property
    @jsii.member(jsii_name="numId")
    def num_id(self) -> str:
        return jsii.get(self, "numId")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="registry")
    def registry(self) -> str:
        return jsii.get(self, "registry")

    @registry.setter
    def registry(self, value: str) -> None:
        jsii.set(self, "registry", value)

    @builtins.property
    @jsii.member(jsii_name="blocked")
    def blocked(self) -> typing.Optional[bool]:
        return jsii.get(self, "blocked")

    @blocked.setter
    def blocked(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "blocked", value)

    @builtins.property
    @jsii.member(jsii_name="credentials")
    def credentials(self) -> typing.Optional[typing.List["CloudiotDeviceCredentials"]]:
        return jsii.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: typing.Optional[typing.List["CloudiotDeviceCredentials"]]) -> None:
        jsii.set(self, "credentials", value)

    @builtins.property
    @jsii.member(jsii_name="gatewayConfig")
    def gateway_config(self) -> typing.Optional[typing.List["CloudiotDeviceGatewayConfig"]]:
        return jsii.get(self, "gatewayConfig")

    @gateway_config.setter
    def gateway_config(self, value: typing.Optional[typing.List["CloudiotDeviceGatewayConfig"]]) -> None:
        jsii.set(self, "gatewayConfig", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="logLevel")
    def log_level(self) -> typing.Optional[str]:
        return jsii.get(self, "logLevel")

    @log_level.setter
    def log_level(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "logLevel", value)

    @builtins.property
    @jsii.member(jsii_name="metadata")
    def metadata(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "metadata", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudiotDeviceTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudiotDeviceTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudiotDeviceConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'name': 'name', 'registry': 'registry', 'blocked': 'blocked', 'credentials': 'credentials', 'gateway_config': 'gatewayConfig', 'log_level': 'logLevel', 'metadata': 'metadata', 'timeouts': 'timeouts'})
class CloudiotDeviceConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, name: str, registry: str, blocked: typing.Optional[bool]=None, credentials: typing.Optional[typing.List["CloudiotDeviceCredentials"]]=None, gateway_config: typing.Optional[typing.List["CloudiotDeviceGatewayConfig"]]=None, log_level: typing.Optional[str]=None, metadata: typing.Optional[typing.Mapping[str, str]]=None, timeouts: typing.Optional["CloudiotDeviceTimeouts"]=None) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: A unique name for the resource.
        :param registry: The name of the device registry where this device should be created.
        :param blocked: If a device is blocked, connections or requests from this device will fail.
        :param credentials: credentials block.
        :param gateway_config: gateway_config block.
        :param log_level: The logging verbosity for device activity. Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
        :param metadata: The metadata key-value pairs assigned to the device.
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict): lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict): timeouts = CloudiotDeviceTimeouts(**timeouts)
        self._values = {
            'name': name,
            'registry': registry,
        }
        if count is not None: self._values["count"] = count
        if depends_on is not None: self._values["depends_on"] = depends_on
        if lifecycle is not None: self._values["lifecycle"] = lifecycle
        if provider is not None: self._values["provider"] = provider
        if blocked is not None: self._values["blocked"] = blocked
        if credentials is not None: self._values["credentials"] = credentials
        if gateway_config is not None: self._values["gateway_config"] = gateway_config
        if log_level is not None: self._values["log_level"] = log_level
        if metadata is not None: self._values["metadata"] = metadata
        if timeouts is not None: self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('count')

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('depends_on')

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('lifecycle')

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get('provider')

    @builtins.property
    def name(self) -> str:
        """A unique name for the resource."""
        return self._values.get('name')

    @builtins.property
    def registry(self) -> str:
        """The name of the device registry where this device should be created."""
        return self._values.get('registry')

    @builtins.property
    def blocked(self) -> typing.Optional[bool]:
        """If a device is blocked, connections or requests from this device will fail."""
        return self._values.get('blocked')

    @builtins.property
    def credentials(self) -> typing.Optional[typing.List["CloudiotDeviceCredentials"]]:
        """credentials block."""
        return self._values.get('credentials')

    @builtins.property
    def gateway_config(self) -> typing.Optional[typing.List["CloudiotDeviceGatewayConfig"]]:
        """gateway_config block."""
        return self._values.get('gateway_config')

    @builtins.property
    def log_level(self) -> typing.Optional[str]:
        """The logging verbosity for device activity.

        Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
        """
        return self._values.get('log_level')

    @builtins.property
    def metadata(self) -> typing.Optional[typing.Mapping[str, str]]:
        """The metadata key-value pairs assigned to the device."""
        return self._values.get('metadata')

    @builtins.property
    def timeouts(self) -> typing.Optional["CloudiotDeviceTimeouts"]:
        """timeouts block."""
        return self._values.get('timeouts')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudiotDeviceConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudiotDeviceConfigA(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudiotDeviceConfigA"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(CloudiotDeviceConfigA, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="binaryData")
    def binary_data(self) -> str:
        return jsii.get(self, "binaryData")

    @builtins.property
    @jsii.member(jsii_name="cloudUpdateTime")
    def cloud_update_time(self) -> str:
        return jsii.get(self, "cloudUpdateTime")

    @builtins.property
    @jsii.member(jsii_name="deviceAckTime")
    def device_ack_time(self) -> str:
        return jsii.get(self, "deviceAckTime")

    @builtins.property
    @jsii.member(jsii_name="version")
    def version(self) -> str:
        return jsii.get(self, "version")


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudiotDeviceCredentials", jsii_struct_bases=[], name_mapping={'public_key': 'publicKey', 'expiration_time': 'expirationTime'})
class CloudiotDeviceCredentials():
    def __init__(self, *, public_key: typing.List["CloudiotDeviceCredentialsPublicKey"], expiration_time: typing.Optional[str]=None) -> None:
        """
        :param public_key: public_key block.
        :param expiration_time: The time at which this credential becomes invalid.
        """
        self._values = {
            'public_key': public_key,
        }
        if expiration_time is not None: self._values["expiration_time"] = expiration_time

    @builtins.property
    def public_key(self) -> typing.List["CloudiotDeviceCredentialsPublicKey"]:
        """public_key block."""
        return self._values.get('public_key')

    @builtins.property
    def expiration_time(self) -> typing.Optional[str]:
        """The time at which this credential becomes invalid."""
        return self._values.get('expiration_time')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudiotDeviceCredentials(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudiotDeviceCredentialsPublicKey", jsii_struct_bases=[], name_mapping={'format': 'format', 'key': 'key'})
class CloudiotDeviceCredentialsPublicKey():
    def __init__(self, *, format: str, key: str) -> None:
        """
        :param format: The format of the key. Possible values: ["RSA_PEM", "RSA_X509_PEM", "ES256_PEM", "ES256_X509_PEM"]
        :param key: The key data.
        """
        self._values = {
            'format': format,
            'key': key,
        }

    @builtins.property
    def format(self) -> str:
        """The format of the key.

        Possible values: ["RSA_PEM", "RSA_X509_PEM", "ES256_PEM", "ES256_X509_PEM"]
        """
        return self._values.get('format')

    @builtins.property
    def key(self) -> str:
        """The key data."""
        return self._values.get('key')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudiotDeviceCredentialsPublicKey(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudiotDeviceGatewayConfig", jsii_struct_bases=[], name_mapping={'gateway_auth_method': 'gatewayAuthMethod', 'gateway_type': 'gatewayType'})
class CloudiotDeviceGatewayConfig():
    def __init__(self, *, gateway_auth_method: typing.Optional[str]=None, gateway_type: typing.Optional[str]=None) -> None:
        """
        :param gateway_auth_method: Indicates whether the device is a gateway. Possible values: ["ASSOCIATION_ONLY", "DEVICE_AUTH_TOKEN_ONLY", "ASSOCIATION_AND_DEVICE_AUTH_TOKEN"]
        :param gateway_type: Indicates whether the device is a gateway. Default value: "NON_GATEWAY" Possible values: ["GATEWAY", "NON_GATEWAY"]
        """
        self._values = {
        }
        if gateway_auth_method is not None: self._values["gateway_auth_method"] = gateway_auth_method
        if gateway_type is not None: self._values["gateway_type"] = gateway_type

    @builtins.property
    def gateway_auth_method(self) -> typing.Optional[str]:
        """Indicates whether the device is a gateway.

        Possible values: ["ASSOCIATION_ONLY", "DEVICE_AUTH_TOKEN_ONLY", "ASSOCIATION_AND_DEVICE_AUTH_TOKEN"]
        """
        return self._values.get('gateway_auth_method')

    @builtins.property
    def gateway_type(self) -> typing.Optional[str]:
        """Indicates whether the device is a gateway.

        Default value: "NON_GATEWAY" Possible values: ["GATEWAY", "NON_GATEWAY"]
        """
        return self._values.get('gateway_type')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudiotDeviceGatewayConfig(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudiotDeviceLastErrorStatus(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudiotDeviceLastErrorStatus"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(CloudiotDeviceLastErrorStatus, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="details")
    def details(self) -> typing.Any:
        return jsii.get(self, "details")

    @builtins.property
    @jsii.member(jsii_name="message")
    def message(self) -> str:
        return jsii.get(self, "message")

    @builtins.property
    @jsii.member(jsii_name="number")
    def number(self) -> jsii.Number:
        return jsii.get(self, "number")


class CloudiotDeviceState(cdktf.ComplexComputedList, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudiotDeviceState"):
    def __init__(self, terraform_resource: cdktf.ITerraformResource, terraform_attribute: str, index: str) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(CloudiotDeviceState, self, [terraform_resource, terraform_attribute, index])

    @builtins.property
    @jsii.member(jsii_name="binaryData")
    def binary_data(self) -> str:
        return jsii.get(self, "binaryData")

    @builtins.property
    @jsii.member(jsii_name="updateTime")
    def update_time(self) -> str:
        return jsii.get(self, "updateTime")


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudiotDeviceTimeouts", jsii_struct_bases=[], name_mapping={'create': 'create', 'delete': 'delete', 'update': 'update'})
class CloudiotDeviceTimeouts():
    def __init__(self, *, create: typing.Optional[str]=None, delete: typing.Optional[str]=None, update: typing.Optional[str]=None) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {
        }
        if create is not None: self._values["create"] = create
        if delete is not None: self._values["delete"] = delete
        if update is not None: self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get('create')

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get('delete')

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get('update')

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return 'CloudiotDeviceTimeouts(%s)' % ', '.join(k + '=' + repr(v) for k, v in self._values.items())


class CloudiotRegistry(cdktf.TerraformResource, metaclass=jsii.JSIIMeta, jsii_type="@cdktf/provider-google.CloudiotRegistry"):
    def __init__(self, scope: constructs.Construct, id: str, *, name: str, credentials: typing.Optional[typing.List["CloudiotRegistryCredentials"]]=None, event_notification_configs: typing.Optional[typing.List["CloudiotRegistryEventNotificationConfigs"]]=None, http_config: typing.Optional[typing.Mapping[str, str]]=None, log_level: typing.Optional[str]=None, mqtt_config: typing.Optional[typing.Mapping[str, str]]=None, project: typing.Optional[str]=None, region: typing.Optional[str]=None, state_notification_config: typing.Optional[typing.Mapping[str, str]]=None, timeouts: typing.Optional["CloudiotRegistryTimeouts"]=None, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None) -> None:
        """
        :param scope: -
        :param id: -
        :param name: A unique name for the resource, required by device registry.
        :param credentials: credentials block.
        :param event_notification_configs: event_notification_configs block.
        :param http_config: Activate or deactivate HTTP.
        :param log_level: The default logging verbosity for activity from devices in this registry. Specifies which events should be written to logs. For example, if the LogLevel is ERROR, only events that terminate in errors will be logged. LogLevel is inclusive; enabling INFO logging will also enable ERROR logging. Default value: "NONE" Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
        :param mqtt_config: Activate or deactivate MQTT.
        :param project: 
        :param region: The region in which the created registry should reside. If it is not provided, the provider region is used.
        :param state_notification_config: A PubSub topic to publish device state updates.
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = CloudiotRegistryConfig(name=name, credentials=credentials, event_notification_configs=event_notification_configs, http_config=http_config, log_level=log_level, mqtt_config=mqtt_config, project=project, region=region, state_notification_config=state_notification_config, timeouts=timeouts, count=count, depends_on=depends_on, lifecycle=lifecycle, provider=provider)

        jsii.create(CloudiotRegistry, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="credentials")
    def credentials(self) -> typing.Optional[typing.List["CloudiotRegistryCredentials"]]:
        return jsii.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: typing.Optional[typing.List["CloudiotRegistryCredentials"]]) -> None:
        jsii.set(self, "credentials", value)

    @builtins.property
    @jsii.member(jsii_name="eventNotificationConfigs")
    def event_notification_configs(self) -> typing.Optional[typing.List["CloudiotRegistryEventNotificationConfigs"]]:
        return jsii.get(self, "eventNotificationConfigs")

    @event_notification_configs.setter
    def event_notification_configs(self, value: typing.Optional[typing.List["CloudiotRegistryEventNotificationConfigs"]]) -> None:
        jsii.set(self, "eventNotificationConfigs", value)

    @builtins.property
    @jsii.member(jsii_name="httpConfig")
    def http_config(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "httpConfig")

    @http_config.setter
    def http_config(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "httpConfig", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="logLevel")
    def log_level(self) -> typing.Optional[str]:
        return jsii.get(self, "logLevel")

    @log_level.setter
    def log_level(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "logLevel", value)

    @builtins.property
    @jsii.member(jsii_name="mqttConfig")
    def mqtt_config(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "mqttConfig")

    @mqtt_config.setter
    def mqtt_config(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "mqttConfig", value)

    @builtins.property
    @jsii.member(jsii_name="project")
    def project(self) -> typing.Optional[str]:
        return jsii.get(self, "project")

    @project.setter
    def project(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "project", value)

    @builtins.property
    @jsii.member(jsii_name="region")
    def region(self) -> typing.Optional[str]:
        return jsii.get(self, "region")

    @region.setter
    def region(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "region", value)

    @builtins.property
    @jsii.member(jsii_name="stateNotificationConfig")
    def state_notification_config(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "stateNotificationConfig")

    @state_notification_config.setter
    def state_notification_config(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "stateNotificationConfig", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["CloudiotRegistryTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["CloudiotRegistryTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(jsii_type="@cdktf/provider-google.CloudiotRegistryConfig", jsii_struct_bases=[cdktf.TerraformMetaArguments], name_mapping={'count': 'count', 'depends_on': 'dependsOn', 'lifecycle': 'lifecycle', 'provider': 'provider', 'name': 'name', 'credentials': 'credentials', 'event_notification_configs': 'eventNotificationConfigs', 'http_config': 'httpConfig', 'log_level': 'logLevel', 'mqtt_config': 'mqttConfig', 'project': 'project', 'region': 'region', 'state_notification_config': 'stateNotificationConfig', 'timeouts': 'timeouts'})
class CloudiotRegistryConfig(cdktf.TerraformMetaArguments):
    def __init__(self, *, count: typing.Optional[jsii.Number]=None, depends_on: typing.Optional[typing.List[cdktf.TerraformResource]]=None, lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle]=None, provider: typing.Optional[cdktf.TerraformProvider]=None, name: str, credentials: typing.Optional[typing.List["