import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the instance. One of name or self_link must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html#name DataGoogleComputeInstance#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html#project DataGoogleComputeInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The URI of the created resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html#self_link DataGoogleComputeInstance#self_link}
     *
     * @stability stable
     */
    readonly selfLink?: string;
    /**
     * The zone of the instance.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html#zone DataGoogleComputeInstance#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceAdvancedMachineFeatures extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enableNestedVirtualization(): any;
    /**
     * @stability stable
     */
    get threadsPerCore(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceAttachedDisk extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get deviceName(): string;
    /**
     * @stability stable
     */
    get diskEncryptionKeyRaw(): string;
    /**
     * @stability stable
     */
    get diskEncryptionKeySha256(): string;
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    get source(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceBootDiskInitializeParams extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    get labels(): any;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceBootDisk extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get autoDelete(): any;
    /**
     * @stability stable
     */
    get deviceName(): string;
    /**
     * @stability stable
     */
    get diskEncryptionKeyRaw(): string;
    /**
     * @stability stable
     */
    get diskEncryptionKeySha256(): string;
    /**
     * @stability stable
     */
    get initializeParams(): any;
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    get source(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceConfidentialInstanceConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enableConfidentialCompute(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceGuestAccelerator extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceNetworkInterfaceAccessConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get natIp(): string;
    /**
     * @stability stable
     */
    get networkTier(): string;
    /**
     * @stability stable
     */
    get publicPtrDomainName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceNetworkInterfaceAliasIpRange extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ipCidrRange(): string;
    /**
     * @stability stable
     */
    get subnetworkRangeName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get externalIpv6(): string;
    /**
     * @stability stable
     */
    get externalIpv6PrefixLength(): string;
    /**
     * @stability stable
     */
    get networkTier(): string;
    /**
     * @stability stable
     */
    get publicPtrDomainName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceNetworkInterface extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get accessConfig(): any;
    /**
     * @stability stable
     */
    get aliasIpRange(): any;
    /**
     * @stability stable
     */
    get ipv6AccessConfig(): any;
    /**
     * @stability stable
     */
    get ipv6AccessType(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    get networkIp(): string;
    /**
     * @stability stable
     */
    get nicType(): string;
    /**
     * @stability stable
     */
    get stackType(): string;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    get subnetworkProject(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceReservationAffinitySpecificReservation extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceReservationAffinity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get specificReservation(): any;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceSchedulingNodeAffinities extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceScheduling extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get automaticRestart(): any;
    /**
     * @stability stable
     */
    get minNodeCpus(): number;
    /**
     * @stability stable
     */
    get nodeAffinities(): any;
    /**
     * @stability stable
     */
    get onHostMaintenance(): string;
    /**
     * @stability stable
     */
    get preemptible(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceScratchDisk extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get interface(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceServiceAccount extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    get scopes(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleComputeInstanceShieldedInstanceConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): any;
    /**
     * @stability stable
     */
    get enableSecureBoot(): any;
    /**
     * @stability stable
     */
    get enableVtpm(): any;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html google_compute_instance}.
 *
 * @stability stable
 */
export declare class DataGoogleComputeInstance extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_instance.html google_compute_instance} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeInstanceConfig);
    /**
     * @stability stable
     */
    advancedMachineFeatures(index: string): DataGoogleComputeInstanceAdvancedMachineFeatures;
    /**
     * @stability stable
     */
    get allowStoppingForUpdate(): any;
    /**
     * @stability stable
     */
    attachedDisk(index: string): DataGoogleComputeInstanceAttachedDisk;
    /**
     * @stability stable
     */
    bootDisk(index: string): DataGoogleComputeInstanceBootDisk;
    /**
     * @stability stable
     */
    get canIpForward(): any;
    /**
     * @stability stable
     */
    confidentialInstanceConfig(index: string): DataGoogleComputeInstanceConfidentialInstanceConfig;
    /**
     * @stability stable
     */
    get cpuPlatform(): string;
    /**
     * @stability stable
     */
    get currentStatus(): string;
    /**
     * @stability stable
     */
    get deletionProtection(): any;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get desiredStatus(): string;
    /**
     * @stability stable
     */
    get enableDisplay(): any;
    /**
     * @stability stable
     */
    guestAccelerator(index: string): DataGoogleComputeInstanceGuestAccelerator;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceId(): string;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    /**
     * @stability stable
     */
    get metadataFingerprint(): string;
    /**
     * @stability stable
     */
    get metadataStartupScript(): string;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    networkInterface(index: string): DataGoogleComputeInstanceNetworkInterface;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    reservationAffinity(index: string): DataGoogleComputeInstanceReservationAffinity;
    /**
     * @stability stable
     */
    get resourcePolicies(): string[];
    /**
     * @stability stable
     */
    scheduling(index: string): DataGoogleComputeInstanceScheduling;
    /**
     * @stability stable
     */
    scratchDisk(index: string): DataGoogleComputeInstanceScratchDisk;
    private _selfLink?;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    set selfLink(value: string);
    /**
     * @stability stable
     */
    resetSelfLink(): void;
    /**
     * @stability stable
     */
    get selfLinkInput(): string | undefined;
    /**
     * @stability stable
     */
    serviceAccount(index: string): DataGoogleComputeInstanceServiceAccount;
    /**
     * @stability stable
     */
    shieldedInstanceConfig(index: string): DataGoogleComputeInstanceShieldedInstanceConfig;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get tagsFingerprint(): string;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
