import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations..html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class MigrationhubStrategy extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations..html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to get details of each anti pattern that collector should look at in a customer's environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAntiPattern.html
     */
    toGetAntiPattern(): this;
    /**
     * Grants permission to get details of an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentDetails.html
     */
    toGetApplicationComponentDetails(): this;
    /**
     * Grants permission to get a list of all recommended strategies and tools for an application running in a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentStrategies.html
     */
    toGetApplicationComponentStrategies(): this;
    /**
     * Grants permission to retrieve status of an on-going assessment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAssessment.html
     */
    toGetAssessment(): this;
    /**
     * Grants permission to get details of a specific import task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetImportFileTask.html
     */
    toGetImportFileTask(): this;
    /**
     * Grants permission to the collector to receive information from the service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetMessage.html
     */
    toGetMessage(): this;
    /**
     * Grants permission to retrieve customer migration/Modernization preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioPreferences.html
     */
    toGetPortfolioPreferences(): this;
    /**
     * Grants permission to retrieve overall summary (number-of servers to rehost etc as well as overall number of anti patterns)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioSummary.html
     */
    toGetPortfolioSummary(): this;
    /**
     * Grants permission to retrieve detailed information about a recommendation report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetRecommendationReportDetails.html
     */
    toGetRecommendationReportDetails(): this;
    /**
     * Grants permission to get info about a specific server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerDetails.html
     */
    toGetServerDetails(): this;
    /**
     * Grants permission to get recommended strategies and tools for a specific server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerStrategies.html
     */
    toGetServerStrategies(): this;
    /**
     * Grants permission to get a list of all anti patterns that collector should look for in a customer's environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListAntiPatterns.html
     */
    toListAntiPatterns(): this;
    /**
     * Grants permission to get a list of all applications running on servers on customer's servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListApplicationComponents.html
     */
    toListApplicationComponents(): this;
    /**
     * Grants permission to get a list of all collectors installed by the customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListCollectors.html
     */
    toListCollectors(): this;
    /**
     * Grants permission to get list of all imports performed by the customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListImportFileTask.html
     */
    toListImportFileTask(): this;
    /**
     * Grants permission to get a list of binaries that collector should assess
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListJarArtifacts.html
     */
    toListJarArtifacts(): this;
    /**
     * Grants permission to get a list of all servers in a customer's environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListServers.html
     */
    toListServers(): this;
    /**
     * Grants permission to save customer's Migration/Modernization preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_PutPortfolioPreferences.html
     */
    toPutPortfolioPreferences(): this;
    /**
     * Grants permission to register the collector to receive an ID and to start receiving messages from the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_RegisterCollector.html
     */
    toRegisterCollector(): this;
    /**
     * Grants permission to the collector to send information to the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_SendMessage.html
     */
    toSendMessage(): this;
    /**
     * Grants permission to start assessment in a customer's environment (collect data from all servers and provide recommendations)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartAssessment.html
     */
    toStartAssessment(): this;
    /**
     * Grants permission to start importing data from a file provided by customer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartImportFileTask.html
     */
    toStartImportFileTask(): this;
    /**
     * Grants permission to start generating a recommendation report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartRecommendationReportGeneration.html
     */
    toStartRecommendationReportGeneration(): this;
    /**
     * Grants permission to stop an on-going assessment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StopAssessment.html
     */
    toStopAssessment(): this;
    /**
     * Grants permission to update details for an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateApplicationComponentConfig.html
     */
    toUpdateApplicationComponentConfig(): this;
    /**
     * Grants permission to update info on a server along with the recommended strategy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateServerConfig.html
     */
    toUpdateServerConfig(): this;
    protected accessLevelList: AccessLevelList;
}
