"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrationhubStrategy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations..html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class MigrationhubStrategy extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [migrationhub-strategy](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhubstrategyrecommendations..html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'migrationhub-strategy';
        this.accessLevelList = {
            Read: [
                'GetAntiPattern',
                'GetApplicationComponentDetails',
                'GetApplicationComponentStrategies',
                'GetAssessment',
                'GetImportFileTask',
                'GetMessage',
                'GetPortfolioPreferences',
                'GetPortfolioSummary',
                'GetRecommendationReportDetails',
                'GetServerDetails',
                'GetServerStrategies'
            ],
            List: [
                'ListAntiPatterns',
                'ListApplicationComponents',
                'ListCollectors',
                'ListImportFileTask',
                'ListJarArtifacts',
                'ListServers'
            ],
            Write: [
                'PutPortfolioPreferences',
                'RegisterCollector',
                'SendMessage',
                'StartAssessment',
                'StartImportFileTask',
                'StartRecommendationReportGeneration',
                'StopAssessment',
                'UpdateApplicationComponentConfig',
                'UpdateServerConfig'
            ]
        };
    }
    /**
     * Grants permission to get details of each anti pattern that collector should look at in a customer's environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAntiPattern.html
     */
    toGetAntiPattern() {
        return this.to('GetAntiPattern');
    }
    /**
     * Grants permission to get details of an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentDetails.html
     */
    toGetApplicationComponentDetails() {
        return this.to('GetApplicationComponentDetails');
    }
    /**
     * Grants permission to get a list of all recommended strategies and tools for an application running in a server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetApplicationComponentStrategies.html
     */
    toGetApplicationComponentStrategies() {
        return this.to('GetApplicationComponentStrategies');
    }
    /**
     * Grants permission to retrieve status of an on-going assessment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetAssessment.html
     */
    toGetAssessment() {
        return this.to('GetAssessment');
    }
    /**
     * Grants permission to get details of a specific import task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetImportFileTask.html
     */
    toGetImportFileTask() {
        return this.to('GetImportFileTask');
    }
    /**
     * Grants permission to the collector to receive information from the service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetMessage.html
     */
    toGetMessage() {
        return this.to('GetMessage');
    }
    /**
     * Grants permission to retrieve customer migration/Modernization preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioPreferences.html
     */
    toGetPortfolioPreferences() {
        return this.to('GetPortfolioPreferences');
    }
    /**
     * Grants permission to retrieve overall summary (number-of servers to rehost etc as well as overall number of anti patterns)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetPortfolioSummary.html
     */
    toGetPortfolioSummary() {
        return this.to('GetPortfolioSummary');
    }
    /**
     * Grants permission to retrieve detailed information about a recommendation report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetRecommendationReportDetails.html
     */
    toGetRecommendationReportDetails() {
        return this.to('GetRecommendationReportDetails');
    }
    /**
     * Grants permission to get info about a specific server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerDetails.html
     */
    toGetServerDetails() {
        return this.to('GetServerDetails');
    }
    /**
     * Grants permission to get recommended strategies and tools for a specific server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_GetServerStrategies.html
     */
    toGetServerStrategies() {
        return this.to('GetServerStrategies');
    }
    /**
     * Grants permission to get a list of all anti patterns that collector should look for in a customer's environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListAntiPatterns.html
     */
    toListAntiPatterns() {
        return this.to('ListAntiPatterns');
    }
    /**
     * Grants permission to get a list of all applications running on servers on customer's servers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListApplicationComponents.html
     */
    toListApplicationComponents() {
        return this.to('ListApplicationComponents');
    }
    /**
     * Grants permission to get a list of all collectors installed by the customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListCollectors.html
     */
    toListCollectors() {
        return this.to('ListCollectors');
    }
    /**
     * Grants permission to get list of all imports performed by the customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListImportFileTask.html
     */
    toListImportFileTask() {
        return this.to('ListImportFileTask');
    }
    /**
     * Grants permission to get a list of binaries that collector should assess
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListJarArtifacts.html
     */
    toListJarArtifacts() {
        return this.to('ListJarArtifacts');
    }
    /**
     * Grants permission to get a list of all servers in a customer's environment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_ListServers.html
     */
    toListServers() {
        return this.to('ListServers');
    }
    /**
     * Grants permission to save customer's Migration/Modernization preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_PutPortfolioPreferences.html
     */
    toPutPortfolioPreferences() {
        return this.to('PutPortfolioPreferences');
    }
    /**
     * Grants permission to register the collector to receive an ID and to start receiving messages from the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_RegisterCollector.html
     */
    toRegisterCollector() {
        return this.to('RegisterCollector');
    }
    /**
     * Grants permission to the collector to send information to the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_SendMessage.html
     */
    toSendMessage() {
        return this.to('SendMessage');
    }
    /**
     * Grants permission to start assessment in a customer's environment (collect data from all servers and provide recommendations)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartAssessment.html
     */
    toStartAssessment() {
        return this.to('StartAssessment');
    }
    /**
     * Grants permission to start importing data from a file provided by customer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartImportFileTask.html
     */
    toStartImportFileTask() {
        return this.to('StartImportFileTask');
    }
    /**
     * Grants permission to start generating a recommendation report
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StartRecommendationReportGeneration.html
     */
    toStartRecommendationReportGeneration() {
        return this.to('StartRecommendationReportGeneration');
    }
    /**
     * Grants permission to stop an on-going assessment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_StopAssessment.html
     */
    toStopAssessment() {
        return this.to('StopAssessment');
    }
    /**
     * Grants permission to update details for an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateApplicationComponentConfig.html
     */
    toUpdateApplicationComponentConfig() {
        return this.to('UpdateApplicationComponentConfig');
    }
    /**
     * Grants permission to update info on a server along with the recommended strategy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-strategy/latest/APIReference/API_UpdateServerConfig.html
     */
    toUpdateServerConfig() {
        return this.to('UpdateServerConfig');
    }
}
exports.MigrationhubStrategy = MigrationhubStrategy;
_a = JSII_RTTI_SYMBOL_1;
MigrationhubStrategy[_a] = { fqn: "iam-floyd.MigrationhubStrategy", version: "0.338.0" };
//# sourceMappingURL=data:application/json;base64,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