"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderAttribute = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An attribute available from a third party identity provider.
 */
class ProviderAttribute {
    constructor(attributeName) {
        this.attributeName = attributeName;
    }
    /**
     * Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     * @param attributeName the attribute value string as recognized by the provider
     */
    static other(attributeName) {
        return new ProviderAttribute(attributeName);
    }
}
exports.ProviderAttribute = ProviderAttribute;
_a = JSII_RTTI_SYMBOL_1;
ProviderAttribute[_a] = { fqn: "@aws-cdk/aws-cognito.ProviderAttribute", version: "1.171.0" };
/** The email attribute provided by Apple */
ProviderAttribute.APPLE_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Apple */
ProviderAttribute.APPLE_NAME = new ProviderAttribute('name');
/** The first name attribute provided by Apple */
ProviderAttribute.APPLE_FIRST_NAME = new ProviderAttribute('firstName');
/** The last name attribute provided by Apple */
ProviderAttribute.APPLE_LAST_NAME = new ProviderAttribute('lastName');
/** The user id attribute provided by Amazon */
ProviderAttribute.AMAZON_USER_ID = new ProviderAttribute('user_id');
/** The email attribute provided by Amazon */
ProviderAttribute.AMAZON_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Amazon */
ProviderAttribute.AMAZON_NAME = new ProviderAttribute('name');
/** The postal code attribute provided by Amazon */
ProviderAttribute.AMAZON_POSTAL_CODE = new ProviderAttribute('postal_code');
/** The user id attribute provided by Facebook */
ProviderAttribute.FACEBOOK_ID = new ProviderAttribute('id');
/** The birthday attribute provided by Facebook */
ProviderAttribute.FACEBOOK_BIRTHDAY = new ProviderAttribute('birthday');
/** The email attribute provided by Facebook */
ProviderAttribute.FACEBOOK_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_NAME = new ProviderAttribute('name');
/** The first name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_FIRST_NAME = new ProviderAttribute('first_name');
/** The last name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_LAST_NAME = new ProviderAttribute('last_name');
/** The middle name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_MIDDLE_NAME = new ProviderAttribute('middle_name');
/** The gender attribute provided by Facebook */
ProviderAttribute.FACEBOOK_GENDER = new ProviderAttribute('gender');
/** The locale attribute provided by Facebook */
ProviderAttribute.FACEBOOK_LOCALE = new ProviderAttribute('locale');
/** The name attribute provided by Google */
ProviderAttribute.GOOGLE_NAMES = new ProviderAttribute('names');
/** The gender attribute provided by Google */
ProviderAttribute.GOOGLE_GENDER = new ProviderAttribute('gender');
/** The birthday attribute provided by Google */
ProviderAttribute.GOOGLE_BIRTHDAYS = new ProviderAttribute('birthdays');
/** The phone number attribute provided by Google */
ProviderAttribute.GOOGLE_PHONE_NUMBERS = new ProviderAttribute('phoneNumbers');
/** The email attribute provided by Google */
ProviderAttribute.GOOGLE_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Google */
ProviderAttribute.GOOGLE_NAME = new ProviderAttribute('name');
/** The picture attribute provided by Google */
ProviderAttribute.GOOGLE_PICTURE = new ProviderAttribute('picture');
/** The given name attribute provided by Google */
ProviderAttribute.GOOGLE_GIVEN_NAME = new ProviderAttribute('given_name');
/** The family name attribute provided by Google */
ProviderAttribute.GOOGLE_FAMILY_NAME = new ProviderAttribute('family_name');
//# sourceMappingURL=data:application/json;base64,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