# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeSummaryMetrics(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'num_rows': 'str',
        'num_failing_rows': 'str',
        'robustness_score': 'float',
        'model_performance': 'str',
        'all_tests': 'RimeTestResults',
        'duration': 'float',
        'severity_counts': 'RimeSeverityCounts',
        'average_prediction': 'float',
        'feature_summary_metrics': 'dict(str, RimeFeatureSummaryMetrics)',
        'prediction_drift_stat': 'float',
        'prediction_percentiles': 'dict(str, float)',
        'sensitivity_score': 'float',
        'issues': 'list[RimeIssue]',
        'custom_metrics': 'dict(str, RimeModelPerf)'
    }

    attribute_map = {
        'num_rows': 'numRows',
        'num_failing_rows': 'numFailingRows',
        'robustness_score': 'robustnessScore',
        'model_performance': 'modelPerformance',
        'all_tests': 'allTests',
        'duration': 'duration',
        'severity_counts': 'severityCounts',
        'average_prediction': 'averagePrediction',
        'feature_summary_metrics': 'featureSummaryMetrics',
        'prediction_drift_stat': 'predictionDriftStat',
        'prediction_percentiles': 'predictionPercentiles',
        'sensitivity_score': 'sensitivityScore',
        'issues': 'issues',
        'custom_metrics': 'customMetrics'
    }

    def __init__(self, num_rows=None, num_failing_rows=None, robustness_score=None, model_performance=None, all_tests=None, duration=None, severity_counts=None, average_prediction=None, feature_summary_metrics=None, prediction_drift_stat=None, prediction_percentiles=None, sensitivity_score=None, issues=None, custom_metrics=None):  # noqa: E501
        """RimeSummaryMetrics - a model defined in Swagger"""  # noqa: E501
        self._num_rows = None
        self._num_failing_rows = None
        self._robustness_score = None
        self._model_performance = None
        self._all_tests = None
        self._duration = None
        self._severity_counts = None
        self._average_prediction = None
        self._feature_summary_metrics = None
        self._prediction_drift_stat = None
        self._prediction_percentiles = None
        self._sensitivity_score = None
        self._issues = None
        self._custom_metrics = None
        self.discriminator = None
        if num_rows is not None:
            self.num_rows = num_rows
        if num_failing_rows is not None:
            self.num_failing_rows = num_failing_rows
        if robustness_score is not None:
            self.robustness_score = robustness_score
        if model_performance is not None:
            self.model_performance = model_performance
        if all_tests is not None:
            self.all_tests = all_tests
        if duration is not None:
            self.duration = duration
        if severity_counts is not None:
            self.severity_counts = severity_counts
        if average_prediction is not None:
            self.average_prediction = average_prediction
        if feature_summary_metrics is not None:
            self.feature_summary_metrics = feature_summary_metrics
        if prediction_drift_stat is not None:
            self.prediction_drift_stat = prediction_drift_stat
        if prediction_percentiles is not None:
            self.prediction_percentiles = prediction_percentiles
        if sensitivity_score is not None:
            self.sensitivity_score = sensitivity_score
        if issues is not None:
            self.issues = issues
        if custom_metrics is not None:
            self.custom_metrics = custom_metrics

    @property
    def num_rows(self):
        """Gets the num_rows of this RimeSummaryMetrics.  # noqa: E501


        :return: The num_rows of this RimeSummaryMetrics.  # noqa: E501
        :rtype: str
        """
        return self._num_rows

    @num_rows.setter
    def num_rows(self, num_rows):
        """Sets the num_rows of this RimeSummaryMetrics.


        :param num_rows: The num_rows of this RimeSummaryMetrics.  # noqa: E501
        :type: str
        """

        self._num_rows = num_rows

    @property
    def num_failing_rows(self):
        """Gets the num_failing_rows of this RimeSummaryMetrics.  # noqa: E501


        :return: The num_failing_rows of this RimeSummaryMetrics.  # noqa: E501
        :rtype: str
        """
        return self._num_failing_rows

    @num_failing_rows.setter
    def num_failing_rows(self, num_failing_rows):
        """Sets the num_failing_rows of this RimeSummaryMetrics.


        :param num_failing_rows: The num_failing_rows of this RimeSummaryMetrics.  # noqa: E501
        :type: str
        """

        self._num_failing_rows = num_failing_rows

    @property
    def robustness_score(self):
        """Gets the robustness_score of this RimeSummaryMetrics.  # noqa: E501


        :return: The robustness_score of this RimeSummaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._robustness_score

    @robustness_score.setter
    def robustness_score(self, robustness_score):
        """Sets the robustness_score of this RimeSummaryMetrics.


        :param robustness_score: The robustness_score of this RimeSummaryMetrics.  # noqa: E501
        :type: float
        """

        self._robustness_score = robustness_score

    @property
    def model_performance(self):
        """Gets the model_performance of this RimeSummaryMetrics.  # noqa: E501


        :return: The model_performance of this RimeSummaryMetrics.  # noqa: E501
        :rtype: str
        """
        return self._model_performance

    @model_performance.setter
    def model_performance(self, model_performance):
        """Sets the model_performance of this RimeSummaryMetrics.


        :param model_performance: The model_performance of this RimeSummaryMetrics.  # noqa: E501
        :type: str
        """

        self._model_performance = model_performance

    @property
    def all_tests(self):
        """Gets the all_tests of this RimeSummaryMetrics.  # noqa: E501


        :return: The all_tests of this RimeSummaryMetrics.  # noqa: E501
        :rtype: RimeTestResults
        """
        return self._all_tests

    @all_tests.setter
    def all_tests(self, all_tests):
        """Sets the all_tests of this RimeSummaryMetrics.


        :param all_tests: The all_tests of this RimeSummaryMetrics.  # noqa: E501
        :type: RimeTestResults
        """

        self._all_tests = all_tests

    @property
    def duration(self):
        """Gets the duration of this RimeSummaryMetrics.  # noqa: E501


        :return: The duration of this RimeSummaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this RimeSummaryMetrics.


        :param duration: The duration of this RimeSummaryMetrics.  # noqa: E501
        :type: float
        """

        self._duration = duration

    @property
    def severity_counts(self):
        """Gets the severity_counts of this RimeSummaryMetrics.  # noqa: E501


        :return: The severity_counts of this RimeSummaryMetrics.  # noqa: E501
        :rtype: RimeSeverityCounts
        """
        return self._severity_counts

    @severity_counts.setter
    def severity_counts(self, severity_counts):
        """Sets the severity_counts of this RimeSummaryMetrics.


        :param severity_counts: The severity_counts of this RimeSummaryMetrics.  # noqa: E501
        :type: RimeSeverityCounts
        """

        self._severity_counts = severity_counts

    @property
    def average_prediction(self):
        """Gets the average_prediction of this RimeSummaryMetrics.  # noqa: E501

        Average prediction is only defined for a subset of model tasks such as binary classification.  # noqa: E501

        :return: The average_prediction of this RimeSummaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._average_prediction

    @average_prediction.setter
    def average_prediction(self, average_prediction):
        """Sets the average_prediction of this RimeSummaryMetrics.

        Average prediction is only defined for a subset of model tasks such as binary classification.  # noqa: E501

        :param average_prediction: The average_prediction of this RimeSummaryMetrics.  # noqa: E501
        :type: float
        """

        self._average_prediction = average_prediction

    @property
    def feature_summary_metrics(self):
        """Gets the feature_summary_metrics of this RimeSummaryMetrics.  # noqa: E501


        :return: The feature_summary_metrics of this RimeSummaryMetrics.  # noqa: E501
        :rtype: dict(str, RimeFeatureSummaryMetrics)
        """
        return self._feature_summary_metrics

    @feature_summary_metrics.setter
    def feature_summary_metrics(self, feature_summary_metrics):
        """Sets the feature_summary_metrics of this RimeSummaryMetrics.


        :param feature_summary_metrics: The feature_summary_metrics of this RimeSummaryMetrics.  # noqa: E501
        :type: dict(str, RimeFeatureSummaryMetrics)
        """

        self._feature_summary_metrics = feature_summary_metrics

    @property
    def prediction_drift_stat(self):
        """Gets the prediction_drift_stat of this RimeSummaryMetrics.  # noqa: E501


        :return: The prediction_drift_stat of this RimeSummaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._prediction_drift_stat

    @prediction_drift_stat.setter
    def prediction_drift_stat(self, prediction_drift_stat):
        """Sets the prediction_drift_stat of this RimeSummaryMetrics.


        :param prediction_drift_stat: The prediction_drift_stat of this RimeSummaryMetrics.  # noqa: E501
        :type: float
        """

        self._prediction_drift_stat = prediction_drift_stat

    @property
    def prediction_percentiles(self):
        """Gets the prediction_percentiles of this RimeSummaryMetrics.  # noqa: E501


        :return: The prediction_percentiles of this RimeSummaryMetrics.  # noqa: E501
        :rtype: dict(str, float)
        """
        return self._prediction_percentiles

    @prediction_percentiles.setter
    def prediction_percentiles(self, prediction_percentiles):
        """Sets the prediction_percentiles of this RimeSummaryMetrics.


        :param prediction_percentiles: The prediction_percentiles of this RimeSummaryMetrics.  # noqa: E501
        :type: dict(str, float)
        """

        self._prediction_percentiles = prediction_percentiles

    @property
    def sensitivity_score(self):
        """Gets the sensitivity_score of this RimeSummaryMetrics.  # noqa: E501


        :return: The sensitivity_score of this RimeSummaryMetrics.  # noqa: E501
        :rtype: float
        """
        return self._sensitivity_score

    @sensitivity_score.setter
    def sensitivity_score(self, sensitivity_score):
        """Sets the sensitivity_score of this RimeSummaryMetrics.


        :param sensitivity_score: The sensitivity_score of this RimeSummaryMetrics.  # noqa: E501
        :type: float
        """

        self._sensitivity_score = sensitivity_score

    @property
    def issues(self):
        """Gets the issues of this RimeSummaryMetrics.  # noqa: E501


        :return: The issues of this RimeSummaryMetrics.  # noqa: E501
        :rtype: list[RimeIssue]
        """
        return self._issues

    @issues.setter
    def issues(self, issues):
        """Sets the issues of this RimeSummaryMetrics.


        :param issues: The issues of this RimeSummaryMetrics.  # noqa: E501
        :type: list[RimeIssue]
        """

        self._issues = issues

    @property
    def custom_metrics(self):
        """Gets the custom_metrics of this RimeSummaryMetrics.  # noqa: E501


        :return: The custom_metrics of this RimeSummaryMetrics.  # noqa: E501
        :rtype: dict(str, RimeModelPerf)
        """
        return self._custom_metrics

    @custom_metrics.setter
    def custom_metrics(self, custom_metrics):
        """Sets the custom_metrics of this RimeSummaryMetrics.


        :param custom_metrics: The custom_metrics of this RimeSummaryMetrics.  # noqa: E501
        :type: dict(str, RimeModelPerf)
        """

        self._custom_metrics = custom_metrics

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeSummaryMetrics, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeSummaryMetrics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
