import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "aws-cdk.app-delivery",
    "version": "1.201.0",
    "description": "Continuous Integration / Continuous Delivery for CDK Applications",
    "license": "Apache-2.0",
    "url": "https://github.com/aws/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/aws/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_cdk.app_delivery",
        "aws_cdk.app_delivery._jsii"
    ],
    "package_data": {
        "aws_cdk.app_delivery._jsii": [
            "app-delivery@1.201.0.jsii.tgz"
        ],
        "aws_cdk.app_delivery": [
            "py.typed"
        ]
    },
    "python_requires": "~=3.7",
    "install_requires": [
        "aws-cdk.aws-cloudformation==1.201.0",
        "aws-cdk.aws-codebuild==1.201.0",
        "aws-cdk.aws-codepipeline-actions==1.201.0",
        "aws-cdk.aws-codepipeline==1.201.0",
        "aws-cdk.aws-events==1.201.0",
        "aws-cdk.aws-iam==1.201.0",
        "aws-cdk.cloud-assembly-schema==1.201.0",
        "aws-cdk.core==1.201.0",
        "aws-cdk.cx-api==1.201.0",
        "constructs>=3.3.69, <4.0.0",
        "jsii>=1.74.0, <2.0.0",
        "publication>=0.0.3",
        "typeguard~=2.13.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Typing :: Typed",
        "Development Status :: 7 - Inactive",
        "License :: OSI Approved",
        "Framework :: AWS CDK",
        "Framework :: AWS CDK :: 1"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
