try:
	from zcrmsdk.src.com.zoho.crm.api.exception import SDKException
	from zcrmsdk.src.com.zoho.crm.api.util import Constants
except Exception:
	from ..exception import SDKException
	from ..util import Constants


class Notification(object):
	def __init__(self):
		"""Creates an instance of Notification"""

		self.__channel_expiry = None
		self.__resource_uri = None
		self.__resource_id = None
		self.__notify_url = None
		self.__resource_name = None
		self.__channel_id = None
		self.__events = None
		self.__token = None
		self.__notify_on_related_action = None
		self.__fields = None
		self.__deleteevents = None
		self.__key_modified = dict()

	def get_channel_expiry(self):
		"""
		The method to get the channel_expiry

		Returns:
			datetime: An instance of datetime
		"""

		return self.__channel_expiry

	def set_channel_expiry(self, channel_expiry):
		"""
		The method to set the value to channel_expiry

		Parameters:
			channel_expiry (datetime) : An instance of datetime
		"""

		from datetime import datetime

		if channel_expiry is not None and not isinstance(channel_expiry, datetime):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: channel_expiry EXPECTED TYPE: datetime', None, None)
		
		self.__channel_expiry = channel_expiry
		self.__key_modified['channel_expiry'] = 1

	def get_resource_uri(self):
		"""
		The method to get the resource_uri

		Returns:
			string: A string value
		"""

		return self.__resource_uri

	def set_resource_uri(self, resource_uri):
		"""
		The method to set the value to resource_uri

		Parameters:
			resource_uri (string) : A string representing the resource_uri
		"""

		if resource_uri is not None and not isinstance(resource_uri, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: resource_uri EXPECTED TYPE: str', None, None)
		
		self.__resource_uri = resource_uri
		self.__key_modified['resource_uri'] = 1

	def get_resource_id(self):
		"""
		The method to get the resource_id

		Returns:
			string: A string value
		"""

		return self.__resource_id

	def set_resource_id(self, resource_id):
		"""
		The method to set the value to resource_id

		Parameters:
			resource_id (string) : A string representing the resource_id
		"""

		if resource_id is not None and not isinstance(resource_id, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: resource_id EXPECTED TYPE: str', None, None)
		
		self.__resource_id = resource_id
		self.__key_modified['resource_id'] = 1

	def get_notify_url(self):
		"""
		The method to get the notify_url

		Returns:
			string: A string value
		"""

		return self.__notify_url

	def set_notify_url(self, notify_url):
		"""
		The method to set the value to notify_url

		Parameters:
			notify_url (string) : A string representing the notify_url
		"""

		if notify_url is not None and not isinstance(notify_url, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: notify_url EXPECTED TYPE: str', None, None)
		
		self.__notify_url = notify_url
		self.__key_modified['notify_url'] = 1

	def get_resource_name(self):
		"""
		The method to get the resource_name

		Returns:
			string: A string value
		"""

		return self.__resource_name

	def set_resource_name(self, resource_name):
		"""
		The method to set the value to resource_name

		Parameters:
			resource_name (string) : A string representing the resource_name
		"""

		if resource_name is not None and not isinstance(resource_name, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: resource_name EXPECTED TYPE: str', None, None)
		
		self.__resource_name = resource_name
		self.__key_modified['resource_name'] = 1

	def get_channel_id(self):
		"""
		The method to get the channel_id

		Returns:
			int: A int value
		"""

		return self.__channel_id

	def set_channel_id(self, channel_id):
		"""
		The method to set the value to channel_id

		Parameters:
			channel_id (int) : An int representing the channel_id
		"""

		if channel_id is not None and not isinstance(channel_id, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: channel_id EXPECTED TYPE: int', None, None)
		
		self.__channel_id = channel_id
		self.__key_modified['channel_id'] = 1

	def get_events(self):
		"""
		The method to get the events

		Returns:
			list: An instance of list
		"""

		return self.__events

	def set_events(self, events):
		"""
		The method to set the value to events

		Parameters:
			events (list) : An instance of list
		"""

		if events is not None and not isinstance(events, list):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: events EXPECTED TYPE: list', None, None)
		
		self.__events = events
		self.__key_modified['events'] = 1

	def get_token(self):
		"""
		The method to get the token

		Returns:
			string: A string value
		"""

		return self.__token

	def set_token(self, token):
		"""
		The method to set the value to token

		Parameters:
			token (string) : A string representing the token
		"""

		if token is not None and not isinstance(token, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: token EXPECTED TYPE: str', None, None)
		
		self.__token = token
		self.__key_modified['token'] = 1

	def get_notify_on_related_action(self):
		"""
		The method to get the notify_on_related_action

		Returns:
			bool: A bool value
		"""

		return self.__notify_on_related_action

	def set_notify_on_related_action(self, notify_on_related_action):
		"""
		The method to set the value to notify_on_related_action

		Parameters:
			notify_on_related_action (bool) : A bool representing the notify_on_related_action
		"""

		if notify_on_related_action is not None and not isinstance(notify_on_related_action, bool):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: notify_on_related_action EXPECTED TYPE: bool', None, None)
		
		self.__notify_on_related_action = notify_on_related_action
		self.__key_modified['notify_on_related_action'] = 1

	def get_fields(self):
		"""
		The method to get the fields

		Returns:
			dict: An instance of dict
		"""

		return self.__fields

	def set_fields(self, fields):
		"""
		The method to set the value to fields

		Parameters:
			fields (dict) : An instance of dict
		"""

		if fields is not None and not isinstance(fields, dict):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: fields EXPECTED TYPE: dict', None, None)
		
		self.__fields = fields
		self.__key_modified['fields'] = 1

	def get_deleteevents(self):
		"""
		The method to get the deleteevents

		Returns:
			bool: A bool value
		"""

		return self.__deleteevents

	def set_deleteevents(self, deleteevents):
		"""
		The method to set the value to deleteevents

		Parameters:
			deleteevents (bool) : A bool representing the deleteevents
		"""

		if deleteevents is not None and not isinstance(deleteevents, bool):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: deleteevents EXPECTED TYPE: bool', None, None)
		
		self.__deleteevents = deleteevents
		self.__key_modified['_delete_events'] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string representing the key

		Returns:
			int: A int value
		"""

		if key is not None and not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if key in self.__key_modified:
			return self.__key_modified.get(key)
		
		return None

	def set_key_modified(self, key, modification):
		"""
		The method to mark the given key as modified

		Parameters:
			key (string) : A string representing the key
			modification (int) : An int representing the modification
		"""

		if key is not None and not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if modification is not None and not isinstance(modification, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: modification EXPECTED TYPE: int', None, None)
		
		self.__key_modified[key] = modification
