// This file is automatically generated and updated by Zygoat and should not
// be edited manually. To extend or overwrite these settings, edit
// next.config.js

const withSvgr = require('next-svgr');
const withImages = require('next-images');

const prod = process.env.NODE_ENV === 'production';

const config = {
  webpack: (webpackConfig) => {
    webpackConfig.resolve.alias['@@'] = __dirname;
    webpackConfig.resolve.alias['@wui'] = '@bequestinc/wui';
    return webpackConfig;
  },
  env: {
    PROD: prod,
  },
  headers: async () => [
    {
      source: '/:path*',
      headers: [
        { key: 'X-FRAME-Options', value: 'DENY' },
        { key: 'Content-Security-Policy', value: "frame-ancestors 'none'" },
        { key: 'Strict-Transport-Security', value: 'max-age:31536000; includeSubDomains' },
        { key: 'Cache-Control', value: 'no-cache, no-store' },
        { key: 'X-Content-Type-Options', value: 'nosniff' },
        { key: 'X-XSS-Protection', value: '1; mode=block' },
      ],
    },
  ],
};

const withImagesConfig = {
  exclude: /\.svg$/,
};

const plugins = [withSvgr, [withImages, withImagesConfig]];

module.exports = { plugins, config };
