# -*- coding: utf-8 -*-
# Generated by Django 1.11.7 on 2017-12-02 08:45
from __future__ import unicode_literals

import django.db.models.deletion
import django_intenum
from django.db import migrations, models

import django_hearthstone.scenarios.models


class Migration(migrations.Migration):

	initial = True

	dependencies = []

	operations = [
		migrations.CreateModel(
			name="Adventure",
			fields=[
				(
					"id", models.AutoField(
						auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
					)
				),
				("note_desc", models.CharField(max_length=64)),
				("name", models.CharField(max_length=64)),
				("sort_order", models.PositiveIntegerField(default=0)),
				("leaving_soon", models.BooleanField(default=False)),
				("created", models.DateTimeField(auto_now_add=True)),
				("updated", models.DateTimeField(auto_now=True)),
				("build", models.PositiveIntegerField()),
			],
		),
		migrations.CreateModel(
			name="Scenario",
			fields=[
				(
					"id", models.AutoField(
						auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
					)
				),
				("note_desc", models.CharField(max_length=64)),
				("players", models.PositiveSmallIntegerField()),
				("player1_hero_card_id", models.IntegerField(null=True)),
				("player2_hero_card_id", models.IntegerField(null=True)),
				("is_tutorial", models.BooleanField(default=False)),
				("is_expert", models.BooleanField(default=False)),
				("is_coop", models.BooleanField(default=False)),
				("sort_order", models.PositiveIntegerField(default=0)),
				(
					"mode", django_intenum.IntEnumField(
						default=0, enum=django_hearthstone.scenarios.models.AdventureMode
					)
				),
				("client_player2_hero_card_id", models.IntegerField(null=True)),
				("name", models.CharField(max_length=64)),
				("description", models.TextField()),
				("opponent_name", models.CharField(max_length=64)),
				("completed_description", models.TextField()),
				("player1_deck_id", models.IntegerField(null=True)),
				("created", models.DateTimeField(auto_now_add=True)),
				("updated", models.DateTimeField(auto_now=True)),
				("build", models.PositiveIntegerField()),
				(
					"adventure", models.ForeignKey(
						blank=True,
						null=True,
						on_delete=django.db.models.deletion.SET_NULL,
						to="scenarios.Adventure"
					)
				),
			],
		),
		migrations.CreateModel(
			name="Wing",
			fields=[
				(
					"id", models.AutoField(
						auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
					)
				),
				("note_desc", models.CharField(max_length=64)),
				("sort_order", models.PositiveIntegerField()),
				("release", models.CharField(max_length=16)),
				("required_event", models.CharField(max_length=16)),
				("name", models.CharField(max_length=64)),
				("coming_soon_label", models.CharField(max_length=64)),
				("requires_label", models.CharField(max_length=64)),
				("created", models.DateTimeField(auto_now_add=True)),
				("updated", models.DateTimeField(auto_now=True)),
				("build", models.PositiveIntegerField()),
				(
					"adventure", models.ForeignKey(
						on_delete=django.db.models.deletion.PROTECT, to="scenarios.Adventure"
					)
				),
				(
					"ownership_prereq_wing", models.ForeignKey(
						blank=True,
						null=True,
						on_delete=django.db.models.deletion.SET_NULL,
						to="scenarios.Wing"
					)
				),
			],
		),
		migrations.AddField(
			model_name="scenario",
			name="wing",
			field=models.ForeignKey(
				blank=True,
				null=True,
				on_delete=django.db.models.deletion.SET_NULL,
				to="scenarios.Wing"
			),
		),
	]
