# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'InstanceBackupsScheduleArgs',
    'KubernetesNodePoolsArgs',
    'KubernetesNodePoolsNodeArgs',
    'LoadBalancerFirewallRuleArgs',
    'LoadBalancerForwardingRuleArgs',
    'LoadBalancerHealthCheckArgs',
    'LoadBalancerSslArgs',
    'GetApplicationFilterArgs',
    'GetBackupFilterArgs',
    'GetBareMetalPlanFilterArgs',
    'GetBareMetalServerFilterArgs',
    'GetBlockStorageFilterArgs',
    'GetFirewallGroupFilterArgs',
    'GetInstanceFilterArgs',
    'GetInstanceIpv4FilterArgs',
    'GetIsoPrivateFilterArgs',
    'GetIsoPublicFilterArgs',
    'GetKubernetesFilterArgs',
    'GetLoadBalancerFilterArgs',
    'GetObjectStorageClusterFilterArgs',
    'GetObjectStorageFilterArgs',
    'GetOsFilterArgs',
    'GetPlanFilterArgs',
    'GetPrivateNetworkFilterArgs',
    'GetRegionFilterArgs',
    'GetReservedIpFilterArgs',
    'GetReverseIpv4FilterArgs',
    'GetReverseIpv6FilterArgs',
    'GetSnapshotFilterArgs',
    'GetSshKeyFilterArgs',
    'GetStartupScriptFilterArgs',
    'GetUserFilterArgs',
    'GetVpcFilterArgs',
]

@pulumi.input_type
class InstanceBackupsScheduleArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 dom: Optional[pulumi.Input[int]] = None,
                 dow: Optional[pulumi.Input[int]] = None,
                 hour: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: Type of backup schedule Possible values are `daily`, `weekly`, `monthly`, `daily_alt_even`, or `daily_alt_odd`.
        :param pulumi.Input[int] dom: Day of month to run. Use values between 1 and 28.
        :param pulumi.Input[int] dow: Day of week to run. `1 = Sunday`, `2 = Monday`, `3 = Tuesday`, `4 = Wednesday`, `5 = Thursday`, `6 = Friday`, `7 = Saturday`
        :param pulumi.Input[int] hour: Hour of day to run in UTC.
        """
        pulumi.set(__self__, "type", type)
        if dom is not None:
            pulumi.set(__self__, "dom", dom)
        if dow is not None:
            pulumi.set(__self__, "dow", dow)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of backup schedule Possible values are `daily`, `weekly`, `monthly`, `daily_alt_even`, or `daily_alt_odd`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def dom(self) -> Optional[pulumi.Input[int]]:
        """
        Day of month to run. Use values between 1 and 28.
        """
        return pulumi.get(self, "dom")

    @dom.setter
    def dom(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dom", value)

    @property
    @pulumi.getter
    def dow(self) -> Optional[pulumi.Input[int]]:
        """
        Day of week to run. `1 = Sunday`, `2 = Monday`, `3 = Tuesday`, `4 = Wednesday`, `5 = Thursday`, `6 = Friday`, `7 = Saturday`
        """
        return pulumi.get(self, "dow")

    @dow.setter
    def dow(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dow", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        Hour of day to run in UTC.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)


@pulumi.input_type
class KubernetesNodePoolsArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 node_quantity: pulumi.Input[int],
                 plan: pulumi.Input[str],
                 auto_scaler: Optional[pulumi.Input[bool]] = None,
                 date_created: Optional[pulumi.Input[str]] = None,
                 date_updated: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 max_nodes: Optional[pulumi.Input[int]] = None,
                 min_nodes: Optional[pulumi.Input[int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] label: The label to be used as a prefix for nodes in this node pool.
        :param pulumi.Input[int] node_quantity: The number of nodes in this node pool.
        :param pulumi.Input[str] plan: The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        :param pulumi.Input[bool] auto_scaler: Enable the auto scaler for the default node pool.
        :param pulumi.Input[str] date_created: Date node was created.
        :param pulumi.Input[str] date_updated: Date of node pool updates.
        :param pulumi.Input[str] id: ID of node.
        :param pulumi.Input[int] max_nodes: The maximum number of nodes to use with the auto scaler.
        :param pulumi.Input[int] min_nodes: The minimum number of nodes to use with the auto scaler.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]] nodes: Array that contains information about nodes within this node pool.
        :param pulumi.Input[str] status: Status of node.
        :param pulumi.Input[str] tag: Tag for node pool.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "node_quantity", node_quantity)
        pulumi.set(__self__, "plan", plan)
        if auto_scaler is not None:
            pulumi.set(__self__, "auto_scaler", auto_scaler)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_updated is not None:
            pulumi.set(__self__, "date_updated", date_updated)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="nodeQuantity")
    def node_quantity(self) -> pulumi.Input[int]:
        """
        The number of nodes in this node pool.
        """
        return pulumi.get(self, "node_quantity")

    @node_quantity.setter
    def node_quantity(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_quantity", value)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[str]:
        """
        The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable the auto scaler for the default node pool.
        """
        return pulumi.get(self, "auto_scaler")

    @auto_scaler.setter
    def auto_scaler(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_scaler", value)

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_created", value)

    @property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Date of node pool updates.
        """
        return pulumi.get(self, "date_updated")

    @date_updated.setter
    def date_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_updated", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_nodes", value)

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "min_nodes")

    @min_nodes.setter
    def min_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_nodes", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]]]:
        """
        Array that contains information about nodes within this node pool.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodePoolsNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        Tag for node pool.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class KubernetesNodePoolsNodeArgs:
    def __init__(__self__, *,
                 date_created: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] date_created: Date node was created.
        :param pulumi.Input[str] id: ID of node.
        :param pulumi.Input[str] label: The label to be used as a prefix for nodes in this node pool.
        :param pulumi.Input[str] status: Status of node.
        """
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_created", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class LoadBalancerFirewallRuleArgs:
    def __init__(__self__, *,
                 ip_type: pulumi.Input[str],
                 port: pulumi.Input[int],
                 source: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_type: The type of ip this rule is - may be either v4 or v6.
        :param pulumi.Input[int] port: The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        :param pulumi.Input[str] source: IP address with subnet that is allowed through the firewall. You may also pass in `cloudflare` which will allow only CloudFlares IP range.
        :param pulumi.Input[str] id: The load balancer ID.
        """
        pulumi.set(__self__, "ip_type", ip_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "source", source)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> pulumi.Input[str]:
        """
        The type of ip this rule is - may be either v4 or v6.
        """
        return pulumi.get(self, "ip_type")

    @ip_type.setter
    def ip_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_type", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        IP address with subnet that is allowed through the firewall. You may also pass in `cloudflare` which will allow only CloudFlares IP range.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class LoadBalancerForwardingRuleArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[int],
                 backend_protocol: pulumi.Input[str],
                 frontend_port: pulumi.Input[int],
                 frontend_protocol: pulumi.Input[str],
                 rule_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] backend_port: Port on instance side.
        :param pulumi.Input[str] backend_protocol: Protocol on instance side. Possible values: "http", "https", "tcp".
        :param pulumi.Input[int] frontend_port: Port on load balancer side.
        :param pulumi.Input[str] frontend_protocol: Protocol on load balancer side. Possible values: "http", "https", "tcp".
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "backend_protocol", backend_protocol)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "frontend_protocol", frontend_protocol)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[int]:
        """
        Port on instance side.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="backendProtocol")
    def backend_protocol(self) -> pulumi.Input[str]:
        """
        Protocol on instance side. Possible values: "http", "https", "tcp".
        """
        return pulumi.get(self, "backend_protocol")

    @backend_protocol.setter
    def backend_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend_protocol", value)

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Input[int]:
        """
        Port on load balancer side.
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "frontend_port", value)

    @property
    @pulumi.getter(name="frontendProtocol")
    def frontend_protocol(self) -> pulumi.Input[str]:
        """
        Protocol on load balancer side. Possible values: "http", "https", "tcp".
        """
        return pulumi.get(self, "frontend_protocol")

    @frontend_protocol.setter
    def frontend_protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "frontend_protocol", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)


@pulumi.input_type
class LoadBalancerHealthCheckArgs:
    def __init__(__self__, *,
                 check_interval: pulumi.Input[int],
                 healthy_threshold: pulumi.Input[int],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 response_timeout: pulumi.Input[int],
                 unhealthy_threshold: pulumi.Input[int],
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] check_interval: Time in seconds to perform health check. Default value is 15.
        :param pulumi.Input[int] healthy_threshold: Number of failed attempts encountered before failover. Default value is 5.
        :param pulumi.Input[int] port: The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        :param pulumi.Input[str] protocol: The protocol used to traffic requests to the load balancer. Possible values are `http`, or `tcp`. Default value is `http`.
        :param pulumi.Input[int] response_timeout: Time in seconds to wait for a health check response. Default value is 5.
        :param pulumi.Input[int] unhealthy_threshold: Number of failed attempts encountered before failover. Default value is 5.
        :param pulumi.Input[str] path: The path on the attached instances that the load balancer should check against. Default value is `/`
        """
        pulumi.set(__self__, "check_interval", check_interval)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "response_timeout", response_timeout)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> pulumi.Input[int]:
        """
        Time in seconds to perform health check. Default value is 15.
        """
        return pulumi.get(self, "check_interval")

    @check_interval.setter
    def check_interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "check_interval", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> pulumi.Input[int]:
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used to traffic requests to the load balancer. Possible values are `http`, or `tcp`. Default value is `http`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> pulumi.Input[int]:
        """
        Time in seconds to wait for a health check response. Default value is 5.
        """
        return pulumi.get(self, "response_timeout")

    @response_timeout.setter
    def response_timeout(self, value: pulumi.Input[int]):
        pulumi.set(self, "response_timeout", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> pulumi.Input[int]:
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "unhealthy_threshold", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path on the attached instances that the load balancer should check against. Default value is `/`
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class LoadBalancerSslArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[str],
                 private_key: pulumi.Input[str],
                 chain: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] certificate: The SSL Certificate.
        :param pulumi.Input[str] private_key: The SSL certificates private key.
        :param pulumi.Input[str] chain: The SSL certificate chain.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[str]:
        """
        The SSL Certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[str]:
        """
        The SSL certificates private key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def chain(self) -> Optional[pulumi.Input[str]]:
        """
        The SSL certificate chain.
        """
        return pulumi.get(self, "chain")

    @chain.setter
    def chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chain", value)


@pulumi.input_type
class GetApplicationFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetBackupFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetBareMetalPlanFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetBareMetalServerFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetBlockStorageFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetFirewallGroupFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetInstanceFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetInstanceIpv4FilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetIsoPrivateFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetIsoPublicFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetKubernetesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetLoadBalancerFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetObjectStorageClusterFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetObjectStorageFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetOsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetPlanFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetPrivateNetworkFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetRegionFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetReservedIpFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetReverseIpv4FilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetReverseIpv6FilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetSnapshotFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetSshKeyFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetStartupScriptFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetUserFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class GetVpcFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)


