# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
]

@pulumi.output_type
class GetAccountResult:
    """
    A collection of values returned by getAccount.
    """
    def __init__(__self__, acls=None, balance=None, email=None, id=None, last_payment_amount=None, last_payment_date=None, name=None, pending_charges=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if balance and not isinstance(balance, float):
            raise TypeError("Expected argument 'balance' to be a float")
        pulumi.set(__self__, "balance", balance)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_payment_amount and not isinstance(last_payment_amount, float):
            raise TypeError("Expected argument 'last_payment_amount' to be a float")
        pulumi.set(__self__, "last_payment_amount", last_payment_amount)
        if last_payment_date and not isinstance(last_payment_date, str):
            raise TypeError("Expected argument 'last_payment_date' to be a str")
        pulumi.set(__self__, "last_payment_date", last_payment_date)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pending_charges and not isinstance(pending_charges, float):
            raise TypeError("Expected argument 'pending_charges' to be a float")
        pulumi.set(__self__, "pending_charges", pending_charges)

    @property
    @pulumi.getter
    def acls(self) -> Sequence[str]:
        """
        The access control list on your Vultr account.
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter
    def balance(self) -> float:
        """
        The current balance on your Vultr account.
        """
        return pulumi.get(self, "balance")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email address on your Vultr account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastPaymentAmount")
    def last_payment_amount(self) -> float:
        """
        The amount of the last payment made on your Vultr account.
        """
        return pulumi.get(self, "last_payment_amount")

    @property
    @pulumi.getter(name="lastPaymentDate")
    def last_payment_date(self) -> str:
        """
        The date of the last payment made on your Vultr account.
        """
        return pulumi.get(self, "last_payment_date")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name on your Vultr account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pendingCharges")
    def pending_charges(self) -> float:
        """
        The pending charges on your Vultr account.
        """
        return pulumi.get(self, "pending_charges")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            acls=self.acls,
            balance=self.balance,
            email=self.email,
            id=self.id,
            last_payment_amount=self.last_payment_amount,
            last_payment_date=self.last_payment_date,
            name=self.name,
            pending_charges=self.pending_charges)


def get_account(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    Get information about your Vultr account. This data source provides the balance, pending charges, last payment date, and last payment amount for your Vultr account.

    ## Example Usage

    Get the information for an account:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_account = vultr.get_account()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        acls=__ret__.acls,
        balance=__ret__.balance,
        email=__ret__.email,
        id=__ret__.id,
        last_payment_amount=__ret__.last_payment_amount,
        last_payment_date=__ret__.last_payment_date,
        name=__ret__.name,
        pending_charges=__ret__.pending_charges)
