# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    """
    A collection of values returned by getApplication.
    """
    def __init__(__self__, deploy_name=None, filters=None, id=None, image_id=None, name=None, short_name=None, type=None, vendor=None):
        if deploy_name and not isinstance(deploy_name, str):
            raise TypeError("Expected argument 'deploy_name' to be a str")
        pulumi.set(__self__, "deploy_name", deploy_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if short_name and not isinstance(short_name, str):
            raise TypeError("Expected argument 'short_name' to be a str")
        pulumi.set(__self__, "short_name", short_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vendor and not isinstance(vendor, str):
            raise TypeError("Expected argument 'vendor' to be a str")
        pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="deployName")
    def deploy_name(self) -> str:
        """
        The deploy name of the application.
        """
        return pulumi.get(self, "deploy_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetApplicationFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The Marketplace ID for this application.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> str:
        """
        The short name of the application.
        """
        return pulumi.get(self, "short_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        This defines if an application is `one-click` or `marketplace` .
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vendor(self) -> str:
        """
        The vendor who authored the application.
        """
        return pulumi.get(self, "vendor")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            deploy_name=self.deploy_name,
            filters=self.filters,
            id=self.id,
            image_id=self.image_id,
            name=self.name,
            short_name=self.short_name,
            type=self.type,
            vendor=self.vendor)


def get_application(filters: Optional[Sequence[pulumi.InputType['GetApplicationFilterArgs']]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Get information about applications that can be launched when creating a Vultr VPS.

    ## Example Usage

    Get the information for an application by `deploy_name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    docker = vultr.get_application(filters=[vultr.GetApplicationFilterArgs(
        name="deploy_name",
        values=["Docker on CentOS 7 x64"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetApplicationFilterArgs']] filters: Query parameters for finding applications.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        deploy_name=__ret__.deploy_name,
        filters=__ret__.filters,
        id=__ret__.id,
        image_id=__ret__.image_id,
        name=__ret__.name,
        short_name=__ret__.short_name,
        type=__ret__.type,
        vendor=__ret__.vendor)


@_utilities.lift_output_func(get_application)
def get_application_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetApplicationFilterArgs']]]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Get information about applications that can be launched when creating a Vultr VPS.

    ## Example Usage

    Get the information for an application by `deploy_name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    docker = vultr.get_application(filters=[vultr.GetApplicationFilterArgs(
        name="deploy_name",
        values=["Docker on CentOS 7 x64"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetApplicationFilterArgs']] filters: Query parameters for finding applications.
    """
    ...
