# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBackupResult',
    'AwaitableGetBackupResult',
    'get_backup',
    'get_backup_output',
]

@pulumi.output_type
class GetBackupResult:
    """
    A collection of values returned by getBackup.
    """
    def __init__(__self__, backups=None, filters=None, id=None):
        if backups and not isinstance(backups, list):
            raise TypeError("Expected argument 'backups' to be a list")
        pulumi.set(__self__, "backups", backups)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def backups(self) -> Sequence[Mapping[str, Any]]:
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBackupFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetBackupResult(GetBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupResult(
            backups=self.backups,
            filters=self.filters,
            id=self.id)


def get_backup(filters: Optional[Sequence[pulumi.InputType['GetBackupFilterArgs']]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupResult:
    """
    Get information about a Vultr backup. This data source provides a list of backups which contain the description, size, status, and the creation date for your Vultr backup.

    ## Example Usage

    Get the information for a backup by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_backup = vultr.get_backup(filters=[vultr.GetBackupFilterArgs(
        name="description",
        values=["my-backup-description"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetBackupFilterArgs']] filters: Query parameters for finding backups.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getBackup:getBackup', __args__, opts=opts, typ=GetBackupResult).value

    return AwaitableGetBackupResult(
        backups=__ret__.backups,
        filters=__ret__.filters,
        id=__ret__.id)


@_utilities.lift_output_func(get_backup)
def get_backup_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetBackupFilterArgs']]]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackupResult]:
    """
    Get information about a Vultr backup. This data source provides a list of backups which contain the description, size, status, and the creation date for your Vultr backup.

    ## Example Usage

    Get the information for a backup by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_backup = vultr.get_backup(filters=[vultr.GetBackupFilterArgs(
        name="description",
        values=["my-backup-description"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetBackupFilterArgs']] filters: Query parameters for finding backups.
    """
    ...
