# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetDnsDomainResult',
    'AwaitableGetDnsDomainResult',
    'get_dns_domain',
    'get_dns_domain_output',
]

@pulumi.output_type
class GetDnsDomainResult:
    """
    A collection of values returned by getDnsDomain.
    """
    def __init__(__self__, date_created=None, dns_sec=None, domain=None, id=None):
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if dns_sec and not isinstance(dns_sec, str):
            raise TypeError("Expected argument 'dns_sec' to be a str")
        pulumi.set(__self__, "dns_sec", dns_sec)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> str:
        """
        The date the DNS domain was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter(name="dnsSec")
    def dns_sec(self) -> str:
        """
        The Domain's DNSSEC status
        """
        return pulumi.get(self, "dns_sec")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Name of domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDnsDomainResult(GetDnsDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsDomainResult(
            date_created=self.date_created,
            dns_sec=self.dns_sec,
            domain=self.domain,
            id=self.id)


def get_dns_domain(domain: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsDomainResult:
    """
    Get information about a DNS domain associated with your Vultr account.

    ## Example Usage

    Get the information for a DNS domain:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_domain = vultr.get_dns_domain(domain="example.com")
    ```


    :param str domain: The name you're searching for.
    """
    __args__ = dict()
    __args__['domain'] = domain
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getDnsDomain:getDnsDomain', __args__, opts=opts, typ=GetDnsDomainResult).value

    return AwaitableGetDnsDomainResult(
        date_created=__ret__.date_created,
        dns_sec=__ret__.dns_sec,
        domain=__ret__.domain,
        id=__ret__.id)


@_utilities.lift_output_func(get_dns_domain)
def get_dns_domain_output(domain: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDnsDomainResult]:
    """
    Get information about a DNS domain associated with your Vultr account.

    ## Example Usage

    Get the information for a DNS domain:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_domain = vultr.get_dns_domain(domain="example.com")
    ```


    :param str domain: The name you're searching for.
    """
    ...
