# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIsoPublicResult',
    'AwaitableGetIsoPublicResult',
    'get_iso_public',
    'get_iso_public_output',
]

@pulumi.output_type
class GetIsoPublicResult:
    """
    A collection of values returned by getIsoPublic.
    """
    def __init__(__self__, description=None, filters=None, id=None, md5sum=None, name=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if md5sum and not isinstance(md5sum, str):
            raise TypeError("Expected argument 'md5sum' to be a str")
        pulumi.set(__self__, "md5sum", md5sum)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the ISO file.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIsoPublicFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def md5sum(self) -> str:
        """
        The MD5Sum of the ISO file.
        """
        return pulumi.get(self, "md5sum")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The ISO file's name.
        """
        return pulumi.get(self, "name")


class AwaitableGetIsoPublicResult(GetIsoPublicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIsoPublicResult(
            description=self.description,
            filters=self.filters,
            id=self.id,
            md5sum=self.md5sum,
            name=self.name)


def get_iso_public(filters: Optional[Sequence[pulumi.InputType['GetIsoPublicFilterArgs']]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIsoPublicResult:
    """
    Get information about an ISO file offered in the Vultr ISO library.

    ## Example Usage

    Get the information for a ISO file by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_iso = vultr.get_iso_public(filters=[vultr.GetIsoPublicFilterArgs(
        name="description",
        values=["iso-description"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetIsoPublicFilterArgs']] filters: Query parameters for finding ISO files.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getIsoPublic:getIsoPublic', __args__, opts=opts, typ=GetIsoPublicResult).value

    return AwaitableGetIsoPublicResult(
        description=__ret__.description,
        filters=__ret__.filters,
        id=__ret__.id,
        md5sum=__ret__.md5sum,
        name=__ret__.name)


@_utilities.lift_output_func(get_iso_public)
def get_iso_public_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetIsoPublicFilterArgs']]]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIsoPublicResult]:
    """
    Get information about an ISO file offered in the Vultr ISO library.

    ## Example Usage

    Get the information for a ISO file by `description`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_iso = vultr.get_iso_public(filters=[vultr.GetIsoPublicFilterArgs(
        name="description",
        values=["iso-description"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetIsoPublicFilterArgs']] filters: Query parameters for finding ISO files.
    """
    ...
