# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetObjectStorageClusterResult',
    'AwaitableGetObjectStorageClusterResult',
    'get_object_storage_cluster',
    'get_object_storage_cluster_output',
]

@pulumi.output_type
class GetObjectStorageClusterResult:
    """
    A collection of values returned by getObjectStorageCluster.
    """
    def __init__(__self__, deploy=None, filters=None, hostname=None, id=None, region=None):
        if deploy and not isinstance(deploy, str):
            raise TypeError("Expected argument 'deploy' to be a str")
        pulumi.set(__self__, "deploy", deploy)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def deploy(self) -> str:
        """
        The Cluster is eligible for Object Storage deployment. (yes or no)
        """
        return pulumi.get(self, "deploy")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetObjectStorageClusterFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The cluster hostname.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The identifying cluster ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region ID of the object storage cluster.
        """
        return pulumi.get(self, "region")


class AwaitableGetObjectStorageClusterResult(GetObjectStorageClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectStorageClusterResult(
            deploy=self.deploy,
            filters=self.filters,
            hostname=self.hostname,
            id=self.id,
            region=self.region)


def get_object_storage_cluster(filters: Optional[Sequence[pulumi.InputType['GetObjectStorageClusterFilterArgs']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectStorageClusterResult:
    """
    Get information about Object Storage Clusters on Vultr.

    ## Example Usage

    Get the information for an object storage cluster by `region`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    s3 = vultr.get_object_storage_cluster(filters=[vultr.GetObjectStorageClusterFilterArgs(
        name="region",
        values=["ewr"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetObjectStorageClusterFilterArgs']] filters: Query parameters for finding operating systems.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getObjectStorageCluster:getObjectStorageCluster', __args__, opts=opts, typ=GetObjectStorageClusterResult).value

    return AwaitableGetObjectStorageClusterResult(
        deploy=__ret__.deploy,
        filters=__ret__.filters,
        hostname=__ret__.hostname,
        id=__ret__.id,
        region=__ret__.region)


@_utilities.lift_output_func(get_object_storage_cluster)
def get_object_storage_cluster_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetObjectStorageClusterFilterArgs']]]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetObjectStorageClusterResult]:
    """
    Get information about Object Storage Clusters on Vultr.

    ## Example Usage

    Get the information for an object storage cluster by `region`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    s3 = vultr.get_object_storage_cluster(filters=[vultr.GetObjectStorageClusterFilterArgs(
        name="region",
        values=["ewr"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetObjectStorageClusterFilterArgs']] filters: Query parameters for finding operating systems.
    """
    ...
