# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOsResult',
    'AwaitableGetOsResult',
    'get_os',
    'get_os_output',
]

@pulumi.output_type
class GetOsResult:
    """
    A collection of values returned by getOs.
    """
    def __init__(__self__, arch=None, family=None, filters=None, id=None, name=None):
        if arch and not isinstance(arch, str):
            raise TypeError("Expected argument 'arch' to be a str")
        pulumi.set(__self__, "arch", arch)
        if family and not isinstance(family, str):
            raise TypeError("Expected argument 'family' to be a str")
        pulumi.set(__self__, "family", family)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arch(self) -> str:
        """
        The architecture of the operating system.
        """
        return pulumi.get(self, "arch")

    @property
    @pulumi.getter
    def family(self) -> str:
        """
        The family of the operating system.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the operating system.
        """
        return pulumi.get(self, "name")


class AwaitableGetOsResult(GetOsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOsResult(
            arch=self.arch,
            family=self.family,
            filters=self.filters,
            id=self.id,
            name=self.name)


def get_os(filters: Optional[Sequence[pulumi.InputType['GetOsFilterArgs']]] = None,
           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOsResult:
    """
    Get information about operating systems that can be launched when creating a Vultr VPS.

    ## Example Usage

    Get the information for an operating system by `name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    centos = vultr.get_os(filters=[vultr.GetOsFilterArgs(
        name="name",
        values=["CentOS 7 x64"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetOsFilterArgs']] filters: Query parameters for finding operating systems.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getOs:getOs', __args__, opts=opts, typ=GetOsResult).value

    return AwaitableGetOsResult(
        arch=__ret__.arch,
        family=__ret__.family,
        filters=__ret__.filters,
        id=__ret__.id,
        name=__ret__.name)


@_utilities.lift_output_func(get_os)
def get_os_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetOsFilterArgs']]]]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOsResult]:
    """
    Get information about operating systems that can be launched when creating a Vultr VPS.

    ## Example Usage

    Get the information for an operating system by `name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    centos = vultr.get_os(filters=[vultr.GetOsFilterArgs(
        name="name",
        values=["CentOS 7 x64"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetOsFilterArgs']] filters: Query parameters for finding operating systems.
    """
    ...
