# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRegionResult',
    'AwaitableGetRegionResult',
    'get_region',
    'get_region_output',
]

@pulumi.output_type
class GetRegionResult:
    """
    A collection of values returned by getRegion.
    """
    def __init__(__self__, city=None, continent=None, country=None, filters=None, id=None, options=None):
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if continent and not isinstance(continent, str):
            raise TypeError("Expected argument 'continent' to be a str")
        pulumi.set(__self__, "continent", continent)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if options and not isinstance(options, list):
            raise TypeError("Expected argument 'options' to be a list")
        pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        The city the region is in.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def continent(self) -> str:
        """
        The continent the region is in.
        """
        return pulumi.get(self, "continent")

    @property
    @pulumi.getter
    def country(self) -> str:
        """
        The country the region is in.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRegionFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def options(self) -> Sequence[str]:
        """
        Shows whether options like ddos protection or block storage are available in the region.
        """
        return pulumi.get(self, "options")


class AwaitableGetRegionResult(GetRegionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionResult(
            city=self.city,
            continent=self.continent,
            country=self.country,
            filters=self.filters,
            id=self.id,
            options=self.options)


def get_region(filters: Optional[Sequence[pulumi.InputType['GetRegionFilterArgs']]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionResult:
    """
    Get information about a Vultr region.

    ## Example Usage

    Get the information for a region by `id`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_region = vultr.get_region(filters=[vultr.GetRegionFilterArgs(
        name="id",
        values=["sea"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetRegionFilterArgs']] filters: Query parameters for finding regions.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getRegion:getRegion', __args__, opts=opts, typ=GetRegionResult).value

    return AwaitableGetRegionResult(
        city=__ret__.city,
        continent=__ret__.continent,
        country=__ret__.country,
        filters=__ret__.filters,
        id=__ret__.id,
        options=__ret__.options)


@_utilities.lift_output_func(get_region)
def get_region_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetRegionFilterArgs']]]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegionResult]:
    """
    Get information about a Vultr region.

    ## Example Usage

    Get the information for a region by `id`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_region = vultr.get_region(filters=[vultr.GetRegionFilterArgs(
        name="id",
        values=["sea"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetRegionFilterArgs']] filters: Query parameters for finding regions.
    """
    ...
