# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReservedIpResult',
    'AwaitableGetReservedIpResult',
    'get_reserved_ip',
    'get_reserved_ip_output',
]

@pulumi.output_type
class GetReservedIpResult:
    """
    A collection of values returned by getReservedIp.
    """
    def __init__(__self__, filters=None, id=None, instance_id=None, ip_type=None, label=None, region=None, subnet=None, subnet_size=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if ip_type and not isinstance(ip_type, str):
            raise TypeError("Expected argument 'ip_type' to be a str")
        pulumi.set(__self__, "ip_type", ip_type)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if subnet and not isinstance(subnet, str):
            raise TypeError("Expected argument 'subnet' to be a str")
        pulumi.set(__self__, "subnet", subnet)
        if subnet_size and not isinstance(subnet_size, int):
            raise TypeError("Expected argument 'subnet_size' to be a int")
        pulumi.set(__self__, "subnet_size", subnet_size)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetReservedIpFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the VPS the reserved IP is attached to.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> str:
        """
        The IP type of the reserved IP.
        """
        return pulumi.get(self, "ip_type")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        The label of the reserved IP.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The ID of the region that the reserved IP is in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        The subnet of the reserved IP.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="subnetSize")
    def subnet_size(self) -> int:
        """
        The subnet size of the reserved IP.
        """
        return pulumi.get(self, "subnet_size")


class AwaitableGetReservedIpResult(GetReservedIpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReservedIpResult(
            filters=self.filters,
            id=self.id,
            instance_id=self.instance_id,
            ip_type=self.ip_type,
            label=self.label,
            region=self.region,
            subnet=self.subnet,
            subnet_size=self.subnet_size)


def get_reserved_ip(filters: Optional[Sequence[pulumi.InputType['GetReservedIpFilterArgs']]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReservedIpResult:
    """
    Get information about a Vultr reserved IP address.

    ## Example Usage

    Get the information for a reserved IP by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_reserved_ip = vultr.get_reserved_ip(filters=[vultr.GetReservedIpFilterArgs(
        name="label",
        values=["my-reserved-ip-label"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetReservedIpFilterArgs']] filters: Query parameters for finding reserved IP addresses.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getReservedIp:getReservedIp', __args__, opts=opts, typ=GetReservedIpResult).value

    return AwaitableGetReservedIpResult(
        filters=__ret__.filters,
        id=__ret__.id,
        instance_id=__ret__.instance_id,
        ip_type=__ret__.ip_type,
        label=__ret__.label,
        region=__ret__.region,
        subnet=__ret__.subnet,
        subnet_size=__ret__.subnet_size)


@_utilities.lift_output_func(get_reserved_ip)
def get_reserved_ip_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetReservedIpFilterArgs']]]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReservedIpResult]:
    """
    Get information about a Vultr reserved IP address.

    ## Example Usage

    Get the information for a reserved IP by `label`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_reserved_ip = vultr.get_reserved_ip(filters=[vultr.GetReservedIpFilterArgs(
        name="label",
        values=["my-reserved-ip-label"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetReservedIpFilterArgs']] filters: Query parameters for finding reserved IP addresses.
    """
    ...
