# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetReverseIpv6Result',
    'AwaitableGetReverseIpv6Result',
    'get_reverse_ipv6',
    'get_reverse_ipv6_output',
]

@pulumi.output_type
class GetReverseIpv6Result:
    """
    A collection of values returned by getReverseIpv6.
    """
    def __init__(__self__, filters=None, id=None, instance_id=None, ip=None, reverse=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if reverse and not isinstance(reverse, str):
            raise TypeError("Expected argument 'reverse' to be a str")
        pulumi.set(__self__, "reverse", reverse)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetReverseIpv6FilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance the IPv6 reverse DNS record was set for.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The IPv6 address in canonical format used in the reverse DNS record.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def reverse(self) -> str:
        """
        The hostname used in the IPv6 reverse DNS record.
        """
        return pulumi.get(self, "reverse")


class AwaitableGetReverseIpv6Result(GetReverseIpv6Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReverseIpv6Result(
            filters=self.filters,
            id=self.id,
            instance_id=self.instance_id,
            ip=self.ip,
            reverse=self.reverse)


def get_reverse_ipv6(filters: Optional[Sequence[pulumi.InputType['GetReverseIpv6FilterArgs']]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReverseIpv6Result:
    """
    Get information about a Vultr Reverse IPv6.

    ## Example Usage

    Get the information for an IPv6 reverse DNS record by `reverse`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_reverse_ipv6 = vultr.get_reverse_ipv6(filters=[vultr.GetReverseIpv6FilterArgs(
        name="reverse",
        values=["host.example.com"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetReverseIpv6FilterArgs']] filters: Query parameters for finding IPv6 reverse DNS records.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getReverseIpv6:getReverseIpv6', __args__, opts=opts, typ=GetReverseIpv6Result).value

    return AwaitableGetReverseIpv6Result(
        filters=__ret__.filters,
        id=__ret__.id,
        instance_id=__ret__.instance_id,
        ip=__ret__.ip,
        reverse=__ret__.reverse)


@_utilities.lift_output_func(get_reverse_ipv6)
def get_reverse_ipv6_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetReverseIpv6FilterArgs']]]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReverseIpv6Result]:
    """
    Get information about a Vultr Reverse IPv6.

    ## Example Usage

    Get the information for an IPv6 reverse DNS record by `reverse`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_reverse_ipv6 = vultr.get_reverse_ipv6(filters=[vultr.GetReverseIpv6FilterArgs(
        name="reverse",
        values=["host.example.com"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetReverseIpv6FilterArgs']] filters: Query parameters for finding IPv6 reverse DNS records.
    """
    ...
