# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, acls=None, api_enabled=None, email=None, filters=None, id=None, name=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if api_enabled and not isinstance(api_enabled, bool):
            raise TypeError("Expected argument 'api_enabled' to be a bool")
        pulumi.set(__self__, "api_enabled", api_enabled)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def acls(self) -> Sequence[str]:
        """
        The access control list for the user.
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter(name="apiEnabled")
    def api_enabled(self) -> bool:
        """
        Whether API is enabled for the user.
        """
        return pulumi.get(self, "api_enabled")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUserFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            acls=self.acls,
            api_enabled=self.api_enabled,
            email=self.email,
            filters=self.filters,
            id=self.id,
            name=self.name)


def get_user(filters: Optional[Sequence[pulumi.InputType['GetUserFilterArgs']]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Get information about a Vultr user associated with your account. This data source provides the name, email, access control list, and API status for a Vultr user associated with your account.

    ## Example Usage

    Get the information for a user by `email`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_user = vultr.get_user(filters=[vultr.GetUserFilterArgs(
        name="email",
        values=["jdoe@example.com"],
    )])
    ```

    Get the information for a user by `name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_user = vultr.get_user(filters=[vultr.GetUserFilterArgs(
        name="name",
        values=["John Doe"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetUserFilterArgs']] filters: Query parameters for finding users.
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vultr:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        acls=__ret__.acls,
        api_enabled=__ret__.api_enabled,
        email=__ret__.email,
        filters=__ret__.filters,
        id=__ret__.id,
        name=__ret__.name)


@_utilities.lift_output_func(get_user)
def get_user_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetUserFilterArgs']]]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    Get information about a Vultr user associated with your account. This data source provides the name, email, access control list, and API status for a Vultr user associated with your account.

    ## Example Usage

    Get the information for a user by `email`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_user = vultr.get_user(filters=[vultr.GetUserFilterArgs(
        name="email",
        values=["jdoe@example.com"],
    )])
    ```

    Get the information for a user by `name`:

    ```python
    import pulumi
    import pulumi_vultr as vultr

    my_user = vultr.get_user(filters=[vultr.GetUserFilterArgs(
        name="name",
        values=["John Doe"],
    )])
    ```


    :param Sequence[pulumi.InputType['GetUserFilterArgs']] filters: Query parameters for finding users.
    """
    ...
