# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 plan: pulumi.Input[str],
                 region: pulumi.Input[str],
                 activation_email: Optional[pulumi.Input[bool]] = None,
                 app_id: Optional[pulumi.Input[int]] = None,
                 backups: Optional[pulumi.Input[str]] = None,
                 backups_schedule: Optional[pulumi.Input['InstanceBackupsScheduleArgs']] = None,
                 ddos_protection: Optional[pulumi.Input[bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 firewall_group_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 iso_id: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 os_id: Optional[pulumi.Input[int]] = None,
                 private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reserved_ip_id: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] plan: The ID of the plan that you want the instance to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        :param pulumi.Input[str] region: The ID of the region that the instance is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[bool] activation_email: Whether an activation email will be sent when the server is ready.
        :param pulumi.Input[int] app_id: The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        :param pulumi.Input[str] backups: Whether automatic backups will be enabled for this server (these have an extra charge associated with them). Values can be enabled or disabled.
        :param pulumi.Input['InstanceBackupsScheduleArgs'] backups_schedule: A block that defines the way backups should be scheduled. While this is an optional field if `backups` are `enabled` this field is mandatory. The configuration of a `backups_schedule` is listed below.
        :param pulumi.Input[bool] ddos_protection: Whether DDOS protection will be enabled on the server (there is an additional charge for this).
        :param pulumi.Input[bool] enable_ipv6: Whether the server has IPv6 networking activated.
        :param pulumi.Input[str] firewall_group_id: The ID of the firewall group to assign to the server.
        :param pulumi.Input[str] hostname: The hostname to assign to the server.
        :param pulumi.Input[str] image_id: The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        :param pulumi.Input[str] iso_id: The ID of the ISO file to be installed on the server. [See List ISO](https://www.vultr.com/api/#operation/list-isos)
        :param pulumi.Input[str] label: A label for the server.
        :param pulumi.Input[int] os_id: The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_network_ids: (Deprecated: use `vpc_ids` instead) A list of private network IDs to be attached to the server.
        :param pulumi.Input[str] reserved_ip_id: ID of the floating IP to use as the main IP of this server.
        :param pulumi.Input[str] script_id: The ID of the startup script you want added to the server.
        :param pulumi.Input[str] snapshot_id: The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to apply to the instance.
        :param pulumi.Input[str] user_data: Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_ids: A list of VPC IDs to be attached to the server.
        """
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "region", region)
        if activation_email is not None:
            pulumi.set(__self__, "activation_email", activation_email)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if backups_schedule is not None:
            pulumi.set(__self__, "backups_schedule", backups_schedule)
        if ddos_protection is not None:
            pulumi.set(__self__, "ddos_protection", ddos_protection)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if firewall_group_id is not None:
            pulumi.set(__self__, "firewall_group_id", firewall_group_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if iso_id is not None:
            pulumi.set(__self__, "iso_id", iso_id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if os_id is not None:
            pulumi.set(__self__, "os_id", os_id)
        if private_network_ids is not None:
            warnings.warn("""private_network_ids has been deprecated and should no longer be used. Instead, use vpc_ids""", DeprecationWarning)
            pulumi.log.warn("""private_network_ids is deprecated: private_network_ids has been deprecated and should no longer be used. Instead, use vpc_ids""")
        if private_network_ids is not None:
            pulumi.set(__self__, "private_network_ids", private_network_ids)
        if reserved_ip_id is not None:
            pulumi.set(__self__, "reserved_ip_id", reserved_ip_id)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vpc_ids is not None:
            pulumi.set(__self__, "vpc_ids", vpc_ids)

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Input[str]:
        """
        The ID of the plan that you want the instance to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: pulumi.Input[str]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The ID of the region that the instance is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="activationEmail")
    def activation_email(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an activation email will be sent when the server is ready.
        """
        return pulumi.get(self, "activation_email")

    @activation_email.setter
    def activation_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activation_email", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[str]]:
        """
        Whether automatic backups will be enabled for this server (these have an extra charge associated with them). Values can be enabled or disabled.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backups", value)

    @property
    @pulumi.getter(name="backupsSchedule")
    def backups_schedule(self) -> Optional[pulumi.Input['InstanceBackupsScheduleArgs']]:
        """
        A block that defines the way backups should be scheduled. While this is an optional field if `backups` are `enabled` this field is mandatory. The configuration of a `backups_schedule` is listed below.
        """
        return pulumi.get(self, "backups_schedule")

    @backups_schedule.setter
    def backups_schedule(self, value: Optional[pulumi.Input['InstanceBackupsScheduleArgs']]):
        pulumi.set(self, "backups_schedule", value)

    @property
    @pulumi.getter(name="ddosProtection")
    def ddos_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether DDOS protection will be enabled on the server (there is an additional charge for this).
        """
        return pulumi.get(self, "ddos_protection")

    @ddos_protection.setter
    def ddos_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ddos_protection", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the server has IPv6 networking activated.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter(name="firewallGroupId")
    def firewall_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the firewall group to assign to the server.
        """
        return pulumi.get(self, "firewall_group_id")

    @firewall_group_id.setter
    def firewall_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_group_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname to assign to the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="isoId")
    def iso_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ISO file to be installed on the server. [See List ISO](https://www.vultr.com/api/#operation/list-isos)
        """
        return pulumi.get(self, "iso_id")

    @iso_id.setter
    def iso_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iso_id", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label for the server.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="osId")
    def os_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        """
        return pulumi.get(self, "os_id")

    @os_id.setter
    def os_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "os_id", value)

    @property
    @pulumi.getter(name="privateNetworkIds")
    def private_network_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Deprecated: use `vpc_ids` instead) A list of private network IDs to be attached to the server.
        """
        return pulumi.get(self, "private_network_ids")

    @private_network_ids.setter
    def private_network_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_network_ids", value)

    @property
    @pulumi.getter(name="reservedIpId")
    def reserved_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the floating IP to use as the main IP of this server.
        """
        return pulumi.get(self, "reserved_ip_id")

    @reserved_ip_id.setter
    def reserved_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_ip_id", value)

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the startup script you want added to the server.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_id", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to apply to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of VPC IDs to be attached to the server.
        """
        return pulumi.get(self, "vpc_ids")

    @vpc_ids.setter
    def vpc_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_ids", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 activation_email: Optional[pulumi.Input[bool]] = None,
                 allowed_bandwidth: Optional[pulumi.Input[int]] = None,
                 app_id: Optional[pulumi.Input[int]] = None,
                 backups: Optional[pulumi.Input[str]] = None,
                 backups_schedule: Optional[pulumi.Input['InstanceBackupsScheduleArgs']] = None,
                 date_created: Optional[pulumi.Input[str]] = None,
                 ddos_protection: Optional[pulumi.Input[bool]] = None,
                 default_password: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[int]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 firewall_group_id: Optional[pulumi.Input[str]] = None,
                 gateway_v4: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 internal_ip: Optional[pulumi.Input[str]] = None,
                 iso_id: Optional[pulumi.Input[str]] = None,
                 kvm: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 main_ip: Optional[pulumi.Input[str]] = None,
                 netmask_v4: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 os_id: Optional[pulumi.Input[int]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 power_status: Optional[pulumi.Input[str]] = None,
                 private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ram: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_ip_id: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 server_status: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 v6_main_ip: Optional[pulumi.Input[str]] = None,
                 v6_network: Optional[pulumi.Input[str]] = None,
                 v6_network_size: Optional[pulumi.Input[int]] = None,
                 vcpu_count: Optional[pulumi.Input[int]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[bool] activation_email: Whether an activation email will be sent when the server is ready.
        :param pulumi.Input[int] allowed_bandwidth: The server's allowed bandwidth usage in GB.
        :param pulumi.Input[int] app_id: The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        :param pulumi.Input[str] backups: Whether automatic backups will be enabled for this server (these have an extra charge associated with them). Values can be enabled or disabled.
        :param pulumi.Input['InstanceBackupsScheduleArgs'] backups_schedule: A block that defines the way backups should be scheduled. While this is an optional field if `backups` are `enabled` this field is mandatory. The configuration of a `backups_schedule` is listed below.
        :param pulumi.Input[str] date_created: The date the server was added to your Vultr account.
        :param pulumi.Input[bool] ddos_protection: Whether DDOS protection will be enabled on the server (there is an additional charge for this).
        :param pulumi.Input[str] default_password: The server's default password.
        :param pulumi.Input[int] disk: The description of the disk(s) on the server.
        :param pulumi.Input[bool] enable_ipv6: Whether the server has IPv6 networking activated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features: Array of which features are enabled.
        :param pulumi.Input[str] firewall_group_id: The ID of the firewall group to assign to the server.
        :param pulumi.Input[str] gateway_v4: The server's IPv4 gateway.
        :param pulumi.Input[str] hostname: The hostname to assign to the server.
        :param pulumi.Input[str] image_id: The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        :param pulumi.Input[str] internal_ip: The server's internal IP address.
        :param pulumi.Input[str] iso_id: The ID of the ISO file to be installed on the server. [See List ISO](https://www.vultr.com/api/#operation/list-isos)
        :param pulumi.Input[str] kvm: The server's current KVM URL. This URL will change periodically. It is not advised to cache this value.
        :param pulumi.Input[str] label: A label for the server.
        :param pulumi.Input[str] main_ip: The server's main IP address.
        :param pulumi.Input[str] netmask_v4: The server's IPv4 netmask.
        :param pulumi.Input[str] os: The string description of the operating system installed on the server.
        :param pulumi.Input[int] os_id: The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        :param pulumi.Input[str] plan: The ID of the plan that you want the instance to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        :param pulumi.Input[str] power_status: Whether the server is powered on or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_network_ids: (Deprecated: use `vpc_ids` instead) A list of private network IDs to be attached to the server.
        :param pulumi.Input[int] ram: The amount of memory available on the server in MB.
        :param pulumi.Input[str] region: The ID of the region that the instance is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[str] reserved_ip_id: ID of the floating IP to use as the main IP of this server.
        :param pulumi.Input[str] script_id: The ID of the startup script you want added to the server.
        :param pulumi.Input[str] server_status: A more detailed server status (none, locked, installingbooting, isomounting, ok).
        :param pulumi.Input[str] snapshot_id: The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        :param pulumi.Input[str] status: The status of the server's subscription.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to apply to the instance.
        :param pulumi.Input[str] user_data: Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        :param pulumi.Input[str] v6_main_ip: The main IPv6 network address.
        :param pulumi.Input[str] v6_network: The IPv6 subnet.
        :param pulumi.Input[int] v6_network_size: The IPv6 network size in bits.
        :param pulumi.Input[int] vcpu_count: The number of virtual CPUs available on the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_ids: A list of VPC IDs to be attached to the server.
        """
        if activation_email is not None:
            pulumi.set(__self__, "activation_email", activation_email)
        if allowed_bandwidth is not None:
            pulumi.set(__self__, "allowed_bandwidth", allowed_bandwidth)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if backups_schedule is not None:
            pulumi.set(__self__, "backups_schedule", backups_schedule)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if ddos_protection is not None:
            pulumi.set(__self__, "ddos_protection", ddos_protection)
        if default_password is not None:
            pulumi.set(__self__, "default_password", default_password)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if firewall_group_id is not None:
            pulumi.set(__self__, "firewall_group_id", firewall_group_id)
        if gateway_v4 is not None:
            pulumi.set(__self__, "gateway_v4", gateway_v4)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if internal_ip is not None:
            pulumi.set(__self__, "internal_ip", internal_ip)
        if iso_id is not None:
            pulumi.set(__self__, "iso_id", iso_id)
        if kvm is not None:
            pulumi.set(__self__, "kvm", kvm)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if main_ip is not None:
            pulumi.set(__self__, "main_ip", main_ip)
        if netmask_v4 is not None:
            pulumi.set(__self__, "netmask_v4", netmask_v4)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if os_id is not None:
            pulumi.set(__self__, "os_id", os_id)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if power_status is not None:
            pulumi.set(__self__, "power_status", power_status)
        if private_network_ids is not None:
            warnings.warn("""private_network_ids has been deprecated and should no longer be used. Instead, use vpc_ids""", DeprecationWarning)
            pulumi.log.warn("""private_network_ids is deprecated: private_network_ids has been deprecated and should no longer be used. Instead, use vpc_ids""")
        if private_network_ids is not None:
            pulumi.set(__self__, "private_network_ids", private_network_ids)
        if ram is not None:
            pulumi.set(__self__, "ram", ram)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_ip_id is not None:
            pulumi.set(__self__, "reserved_ip_id", reserved_ip_id)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if server_status is not None:
            pulumi.set(__self__, "server_status", server_status)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if v6_main_ip is not None:
            pulumi.set(__self__, "v6_main_ip", v6_main_ip)
        if v6_network is not None:
            pulumi.set(__self__, "v6_network", v6_network)
        if v6_network_size is not None:
            pulumi.set(__self__, "v6_network_size", v6_network_size)
        if vcpu_count is not None:
            pulumi.set(__self__, "vcpu_count", vcpu_count)
        if vpc_ids is not None:
            pulumi.set(__self__, "vpc_ids", vpc_ids)

    @property
    @pulumi.getter(name="activationEmail")
    def activation_email(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an activation email will be sent when the server is ready.
        """
        return pulumi.get(self, "activation_email")

    @activation_email.setter
    def activation_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activation_email", value)

    @property
    @pulumi.getter(name="allowedBandwidth")
    def allowed_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The server's allowed bandwidth usage in GB.
        """
        return pulumi.get(self, "allowed_bandwidth")

    @allowed_bandwidth.setter
    def allowed_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allowed_bandwidth", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[str]]:
        """
        Whether automatic backups will be enabled for this server (these have an extra charge associated with them). Values can be enabled or disabled.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backups", value)

    @property
    @pulumi.getter(name="backupsSchedule")
    def backups_schedule(self) -> Optional[pulumi.Input['InstanceBackupsScheduleArgs']]:
        """
        A block that defines the way backups should be scheduled. While this is an optional field if `backups` are `enabled` this field is mandatory. The configuration of a `backups_schedule` is listed below.
        """
        return pulumi.get(self, "backups_schedule")

    @backups_schedule.setter
    def backups_schedule(self, value: Optional[pulumi.Input['InstanceBackupsScheduleArgs']]):
        pulumi.set(self, "backups_schedule", value)

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date the server was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_created", value)

    @property
    @pulumi.getter(name="ddosProtection")
    def ddos_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether DDOS protection will be enabled on the server (there is an additional charge for this).
        """
        return pulumi.get(self, "ddos_protection")

    @ddos_protection.setter
    def ddos_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ddos_protection", value)

    @property
    @pulumi.getter(name="defaultPassword")
    def default_password(self) -> Optional[pulumi.Input[str]]:
        """
        The server's default password.
        """
        return pulumi.get(self, "default_password")

    @default_password.setter
    def default_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_password", value)

    @property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[int]]:
        """
        The description of the disk(s) on the server.
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the server has IPv6 networking activated.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of which features are enabled.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="firewallGroupId")
    def firewall_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the firewall group to assign to the server.
        """
        return pulumi.get(self, "firewall_group_id")

    @firewall_group_id.setter
    def firewall_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_group_id", value)

    @property
    @pulumi.getter(name="gatewayV4")
    def gateway_v4(self) -> Optional[pulumi.Input[str]]:
        """
        The server's IPv4 gateway.
        """
        return pulumi.get(self, "gateway_v4")

    @gateway_v4.setter
    def gateway_v4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_v4", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname to assign to the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The server's internal IP address.
        """
        return pulumi.get(self, "internal_ip")

    @internal_ip.setter
    def internal_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_ip", value)

    @property
    @pulumi.getter(name="isoId")
    def iso_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ISO file to be installed on the server. [See List ISO](https://www.vultr.com/api/#operation/list-isos)
        """
        return pulumi.get(self, "iso_id")

    @iso_id.setter
    def iso_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iso_id", value)

    @property
    @pulumi.getter
    def kvm(self) -> Optional[pulumi.Input[str]]:
        """
        The server's current KVM URL. This URL will change periodically. It is not advised to cache this value.
        """
        return pulumi.get(self, "kvm")

    @kvm.setter
    def kvm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kvm", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        A label for the server.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="mainIp")
    def main_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The server's main IP address.
        """
        return pulumi.get(self, "main_ip")

    @main_ip.setter
    def main_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_ip", value)

    @property
    @pulumi.getter(name="netmaskV4")
    def netmask_v4(self) -> Optional[pulumi.Input[str]]:
        """
        The server's IPv4 netmask.
        """
        return pulumi.get(self, "netmask_v4")

    @netmask_v4.setter
    def netmask_v4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmask_v4", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        The string description of the operating system installed on the server.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="osId")
    def os_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        """
        return pulumi.get(self, "os_id")

    @os_id.setter
    def os_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "os_id", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the plan that you want the instance to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="powerStatus")
    def power_status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the server is powered on or not.
        """
        return pulumi.get(self, "power_status")

    @power_status.setter
    def power_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "power_status", value)

    @property
    @pulumi.getter(name="privateNetworkIds")
    def private_network_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Deprecated: use `vpc_ids` instead) A list of private network IDs to be attached to the server.
        """
        return pulumi.get(self, "private_network_ids")

    @private_network_ids.setter
    def private_network_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_network_ids", value)

    @property
    @pulumi.getter
    def ram(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory available on the server in MB.
        """
        return pulumi.get(self, "ram")

    @ram.setter
    def ram(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ram", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the region that the instance is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reservedIpId")
    def reserved_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the floating IP to use as the main IP of this server.
        """
        return pulumi.get(self, "reserved_ip_id")

    @reserved_ip_id.setter
    def reserved_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_ip_id", value)

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the startup script you want added to the server.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_id", value)

    @property
    @pulumi.getter(name="serverStatus")
    def server_status(self) -> Optional[pulumi.Input[str]]:
        """
        A more detailed server status (none, locked, installingbooting, isomounting, ok).
        """
        return pulumi.get(self, "server_status")

    @server_status.setter
    def server_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_status", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the server's subscription.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags to apply to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="v6MainIp")
    def v6_main_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The main IPv6 network address.
        """
        return pulumi.get(self, "v6_main_ip")

    @v6_main_ip.setter
    def v6_main_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v6_main_ip", value)

    @property
    @pulumi.getter(name="v6Network")
    def v6_network(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 subnet.
        """
        return pulumi.get(self, "v6_network")

    @v6_network.setter
    def v6_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v6_network", value)

    @property
    @pulumi.getter(name="v6NetworkSize")
    def v6_network_size(self) -> Optional[pulumi.Input[int]]:
        """
        The IPv6 network size in bits.
        """
        return pulumi.get(self, "v6_network_size")

    @v6_network_size.setter
    def v6_network_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "v6_network_size", value)

    @property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of virtual CPUs available on the server.
        """
        return pulumi.get(self, "vcpu_count")

    @vcpu_count.setter
    def vcpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vcpu_count", value)

    @property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of VPC IDs to be attached to the server.
        """
        return pulumi.get(self, "vpc_ids")

    @vpc_ids.setter
    def vpc_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_ids", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_email: Optional[pulumi.Input[bool]] = None,
                 app_id: Optional[pulumi.Input[int]] = None,
                 backups: Optional[pulumi.Input[str]] = None,
                 backups_schedule: Optional[pulumi.Input[pulumi.InputType['InstanceBackupsScheduleArgs']]] = None,
                 ddos_protection: Optional[pulumi.Input[bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 firewall_group_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 iso_id: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 os_id: Optional[pulumi.Input[int]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_ip_id: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Vultr instance resource. This can be used to create, read, modify, and delete instances on your Vultr account.

        ## Example Usage

        Create a new instance:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_instance = vultr.Instance("myInstance",
            os_id=167,
            plan="vc2-1c-1gb",
            region="sea")
        ```

        Create a new instance with options:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_instance = vultr.Instance("myInstance",
            activation_email=False,
            backups="enabled",
            backups_schedule=vultr.InstanceBackupsScheduleArgs(
                type="daily",
            ),
            ddos_protection=True,
            enable_ipv6=True,
            hostname="my-instance-hostname",
            label="my-instance-label",
            os_id=167,
            plan="vc2-1c-1gb",
            region="sea",
            tags=["my-instance-tag"])
        ```

        ## Import

        Instances can be imported using the instance `ID`, e.g.

        ```sh
         $ pulumi import vultr:index/instance:Instance my_instance b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activation_email: Whether an activation email will be sent when the server is ready.
        :param pulumi.Input[int] app_id: The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        :param pulumi.Input[str] backups: Whether automatic backups will be enabled for this server (these have an extra charge associated with them). Values can be enabled or disabled.
        :param pulumi.Input[pulumi.InputType['InstanceBackupsScheduleArgs']] backups_schedule: A block that defines the way backups should be scheduled. While this is an optional field if `backups` are `enabled` this field is mandatory. The configuration of a `backups_schedule` is listed below.
        :param pulumi.Input[bool] ddos_protection: Whether DDOS protection will be enabled on the server (there is an additional charge for this).
        :param pulumi.Input[bool] enable_ipv6: Whether the server has IPv6 networking activated.
        :param pulumi.Input[str] firewall_group_id: The ID of the firewall group to assign to the server.
        :param pulumi.Input[str] hostname: The hostname to assign to the server.
        :param pulumi.Input[str] image_id: The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        :param pulumi.Input[str] iso_id: The ID of the ISO file to be installed on the server. [See List ISO](https://www.vultr.com/api/#operation/list-isos)
        :param pulumi.Input[str] label: A label for the server.
        :param pulumi.Input[int] os_id: The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        :param pulumi.Input[str] plan: The ID of the plan that you want the instance to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_network_ids: (Deprecated: use `vpc_ids` instead) A list of private network IDs to be attached to the server.
        :param pulumi.Input[str] region: The ID of the region that the instance is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[str] reserved_ip_id: ID of the floating IP to use as the main IP of this server.
        :param pulumi.Input[str] script_id: The ID of the startup script you want added to the server.
        :param pulumi.Input[str] snapshot_id: The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to apply to the instance.
        :param pulumi.Input[str] user_data: Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_ids: A list of VPC IDs to be attached to the server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr instance resource. This can be used to create, read, modify, and delete instances on your Vultr account.

        ## Example Usage

        Create a new instance:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_instance = vultr.Instance("myInstance",
            os_id=167,
            plan="vc2-1c-1gb",
            region="sea")
        ```

        Create a new instance with options:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_instance = vultr.Instance("myInstance",
            activation_email=False,
            backups="enabled",
            backups_schedule=vultr.InstanceBackupsScheduleArgs(
                type="daily",
            ),
            ddos_protection=True,
            enable_ipv6=True,
            hostname="my-instance-hostname",
            label="my-instance-label",
            os_id=167,
            plan="vc2-1c-1gb",
            region="sea",
            tags=["my-instance-tag"])
        ```

        ## Import

        Instances can be imported using the instance `ID`, e.g.

        ```sh
         $ pulumi import vultr:index/instance:Instance my_instance b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_email: Optional[pulumi.Input[bool]] = None,
                 app_id: Optional[pulumi.Input[int]] = None,
                 backups: Optional[pulumi.Input[str]] = None,
                 backups_schedule: Optional[pulumi.Input[pulumi.InputType['InstanceBackupsScheduleArgs']]] = None,
                 ddos_protection: Optional[pulumi.Input[bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 firewall_group_id: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 iso_id: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 os_id: Optional[pulumi.Input[int]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 reserved_ip_id: Optional[pulumi.Input[str]] = None,
                 script_id: Optional[pulumi.Input[str]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["activation_email"] = activation_email
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["backups"] = backups
            __props__.__dict__["backups_schedule"] = backups_schedule
            __props__.__dict__["ddos_protection"] = ddos_protection
            __props__.__dict__["enable_ipv6"] = enable_ipv6
            __props__.__dict__["firewall_group_id"] = firewall_group_id
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["iso_id"] = iso_id
            __props__.__dict__["label"] = label
            __props__.__dict__["os_id"] = os_id
            if plan is None and not opts.urn:
                raise TypeError("Missing required property 'plan'")
            __props__.__dict__["plan"] = plan
            if private_network_ids is not None and not opts.urn:
                warnings.warn("""private_network_ids has been deprecated and should no longer be used. Instead, use vpc_ids""", DeprecationWarning)
                pulumi.log.warn("""private_network_ids is deprecated: private_network_ids has been deprecated and should no longer be used. Instead, use vpc_ids""")
            __props__.__dict__["private_network_ids"] = private_network_ids
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["reserved_ip_id"] = reserved_ip_id
            __props__.__dict__["script_id"] = script_id
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["ssh_key_ids"] = ssh_key_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["vpc_ids"] = vpc_ids
            __props__.__dict__["allowed_bandwidth"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["default_password"] = None
            __props__.__dict__["disk"] = None
            __props__.__dict__["features"] = None
            __props__.__dict__["gateway_v4"] = None
            __props__.__dict__["internal_ip"] = None
            __props__.__dict__["kvm"] = None
            __props__.__dict__["main_ip"] = None
            __props__.__dict__["netmask_v4"] = None
            __props__.__dict__["os"] = None
            __props__.__dict__["power_status"] = None
            __props__.__dict__["ram"] = None
            __props__.__dict__["server_status"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["v6_main_ip"] = None
            __props__.__dict__["v6_network"] = None
            __props__.__dict__["v6_network_size"] = None
            __props__.__dict__["vcpu_count"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["defaultPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'vultr:index/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_email: Optional[pulumi.Input[bool]] = None,
            allowed_bandwidth: Optional[pulumi.Input[int]] = None,
            app_id: Optional[pulumi.Input[int]] = None,
            backups: Optional[pulumi.Input[str]] = None,
            backups_schedule: Optional[pulumi.Input[pulumi.InputType['InstanceBackupsScheduleArgs']]] = None,
            date_created: Optional[pulumi.Input[str]] = None,
            ddos_protection: Optional[pulumi.Input[bool]] = None,
            default_password: Optional[pulumi.Input[str]] = None,
            disk: Optional[pulumi.Input[int]] = None,
            enable_ipv6: Optional[pulumi.Input[bool]] = None,
            features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            firewall_group_id: Optional[pulumi.Input[str]] = None,
            gateway_v4: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            internal_ip: Optional[pulumi.Input[str]] = None,
            iso_id: Optional[pulumi.Input[str]] = None,
            kvm: Optional[pulumi.Input[str]] = None,
            label: Optional[pulumi.Input[str]] = None,
            main_ip: Optional[pulumi.Input[str]] = None,
            netmask_v4: Optional[pulumi.Input[str]] = None,
            os: Optional[pulumi.Input[str]] = None,
            os_id: Optional[pulumi.Input[int]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            power_status: Optional[pulumi.Input[str]] = None,
            private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ram: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            reserved_ip_id: Optional[pulumi.Input[str]] = None,
            script_id: Optional[pulumi.Input[str]] = None,
            server_status: Optional[pulumi.Input[str]] = None,
            snapshot_id: Optional[pulumi.Input[str]] = None,
            ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            v6_main_ip: Optional[pulumi.Input[str]] = None,
            v6_network: Optional[pulumi.Input[str]] = None,
            v6_network_size: Optional[pulumi.Input[int]] = None,
            vcpu_count: Optional[pulumi.Input[int]] = None,
            vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activation_email: Whether an activation email will be sent when the server is ready.
        :param pulumi.Input[int] allowed_bandwidth: The server's allowed bandwidth usage in GB.
        :param pulumi.Input[int] app_id: The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        :param pulumi.Input[str] backups: Whether automatic backups will be enabled for this server (these have an extra charge associated with them). Values can be enabled or disabled.
        :param pulumi.Input[pulumi.InputType['InstanceBackupsScheduleArgs']] backups_schedule: A block that defines the way backups should be scheduled. While this is an optional field if `backups` are `enabled` this field is mandatory. The configuration of a `backups_schedule` is listed below.
        :param pulumi.Input[str] date_created: The date the server was added to your Vultr account.
        :param pulumi.Input[bool] ddos_protection: Whether DDOS protection will be enabled on the server (there is an additional charge for this).
        :param pulumi.Input[str] default_password: The server's default password.
        :param pulumi.Input[int] disk: The description of the disk(s) on the server.
        :param pulumi.Input[bool] enable_ipv6: Whether the server has IPv6 networking activated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] features: Array of which features are enabled.
        :param pulumi.Input[str] firewall_group_id: The ID of the firewall group to assign to the server.
        :param pulumi.Input[str] gateway_v4: The server's IPv4 gateway.
        :param pulumi.Input[str] hostname: The hostname to assign to the server.
        :param pulumi.Input[str] image_id: The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        :param pulumi.Input[str] internal_ip: The server's internal IP address.
        :param pulumi.Input[str] iso_id: The ID of the ISO file to be installed on the server. [See List ISO](https://www.vultr.com/api/#operation/list-isos)
        :param pulumi.Input[str] kvm: The server's current KVM URL. This URL will change periodically. It is not advised to cache this value.
        :param pulumi.Input[str] label: A label for the server.
        :param pulumi.Input[str] main_ip: The server's main IP address.
        :param pulumi.Input[str] netmask_v4: The server's IPv4 netmask.
        :param pulumi.Input[str] os: The string description of the operating system installed on the server.
        :param pulumi.Input[int] os_id: The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        :param pulumi.Input[str] plan: The ID of the plan that you want the instance to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        :param pulumi.Input[str] power_status: Whether the server is powered on or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_network_ids: (Deprecated: use `vpc_ids` instead) A list of private network IDs to be attached to the server.
        :param pulumi.Input[int] ram: The amount of memory available on the server in MB.
        :param pulumi.Input[str] region: The ID of the region that the instance is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        :param pulumi.Input[str] reserved_ip_id: ID of the floating IP to use as the main IP of this server.
        :param pulumi.Input[str] script_id: The ID of the startup script you want added to the server.
        :param pulumi.Input[str] server_status: A more detailed server status (none, locked, installingbooting, isomounting, ok).
        :param pulumi.Input[str] snapshot_id: The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        :param pulumi.Input[str] status: The status of the server's subscription.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags to apply to the instance.
        :param pulumi.Input[str] user_data: Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        :param pulumi.Input[str] v6_main_ip: The main IPv6 network address.
        :param pulumi.Input[str] v6_network: The IPv6 subnet.
        :param pulumi.Input[int] v6_network_size: The IPv6 network size in bits.
        :param pulumi.Input[int] vcpu_count: The number of virtual CPUs available on the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_ids: A list of VPC IDs to be attached to the server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["activation_email"] = activation_email
        __props__.__dict__["allowed_bandwidth"] = allowed_bandwidth
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["backups"] = backups
        __props__.__dict__["backups_schedule"] = backups_schedule
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["ddos_protection"] = ddos_protection
        __props__.__dict__["default_password"] = default_password
        __props__.__dict__["disk"] = disk
        __props__.__dict__["enable_ipv6"] = enable_ipv6
        __props__.__dict__["features"] = features
        __props__.__dict__["firewall_group_id"] = firewall_group_id
        __props__.__dict__["gateway_v4"] = gateway_v4
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["internal_ip"] = internal_ip
        __props__.__dict__["iso_id"] = iso_id
        __props__.__dict__["kvm"] = kvm
        __props__.__dict__["label"] = label
        __props__.__dict__["main_ip"] = main_ip
        __props__.__dict__["netmask_v4"] = netmask_v4
        __props__.__dict__["os"] = os
        __props__.__dict__["os_id"] = os_id
        __props__.__dict__["plan"] = plan
        __props__.__dict__["power_status"] = power_status
        __props__.__dict__["private_network_ids"] = private_network_ids
        __props__.__dict__["ram"] = ram
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_ip_id"] = reserved_ip_id
        __props__.__dict__["script_id"] = script_id
        __props__.__dict__["server_status"] = server_status
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["ssh_key_ids"] = ssh_key_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["v6_main_ip"] = v6_main_ip
        __props__.__dict__["v6_network"] = v6_network
        __props__.__dict__["v6_network_size"] = v6_network_size
        __props__.__dict__["vcpu_count"] = vcpu_count
        __props__.__dict__["vpc_ids"] = vpc_ids
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activationEmail")
    def activation_email(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether an activation email will be sent when the server is ready.
        """
        return pulumi.get(self, "activation_email")

    @property
    @pulumi.getter(name="allowedBandwidth")
    def allowed_bandwidth(self) -> pulumi.Output[int]:
        """
        The server's allowed bandwidth usage in GB.
        """
        return pulumi.get(self, "allowed_bandwidth")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[int]:
        """
        The ID of the Vultr application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications)
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def backups(self) -> pulumi.Output[Optional[str]]:
        """
        Whether automatic backups will be enabled for this server (these have an extra charge associated with them). Values can be enabled or disabled.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter(name="backupsSchedule")
    def backups_schedule(self) -> pulumi.Output[Optional['outputs.InstanceBackupsSchedule']]:
        """
        A block that defines the way backups should be scheduled. While this is an optional field if `backups` are `enabled` this field is mandatory. The configuration of a `backups_schedule` is listed below.
        """
        return pulumi.get(self, "backups_schedule")

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[str]:
        """
        The date the server was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter(name="ddosProtection")
    def ddos_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether DDOS protection will be enabled on the server (there is an additional charge for this).
        """
        return pulumi.get(self, "ddos_protection")

    @property
    @pulumi.getter(name="defaultPassword")
    def default_password(self) -> pulumi.Output[str]:
        """
        The server's default password.
        """
        return pulumi.get(self, "default_password")

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Output[int]:
        """
        The description of the disk(s) on the server.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the server has IPv6 networking activated.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter
    def features(self) -> pulumi.Output[Sequence[str]]:
        """
        Array of which features are enabled.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="firewallGroupId")
    def firewall_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the firewall group to assign to the server.
        """
        return pulumi.get(self, "firewall_group_id")

    @property
    @pulumi.getter(name="gatewayV4")
    def gateway_v4(self) -> pulumi.Output[str]:
        """
        The server's IPv4 gateway.
        """
        return pulumi.get(self, "gateway_v4")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The hostname to assign to the server.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The ID of the Vultr marketplace application to be installed on the server. [See List Applications](https://www.vultr.com/api/#operation/list-applications) Note marketplace applications are denoted by type: `marketplace` and you must use the `image_id` not the id.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> pulumi.Output[str]:
        """
        The server's internal IP address.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter(name="isoId")
    def iso_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the ISO file to be installed on the server. [See List ISO](https://www.vultr.com/api/#operation/list-isos)
        """
        return pulumi.get(self, "iso_id")

    @property
    @pulumi.getter
    def kvm(self) -> pulumi.Output[str]:
        """
        The server's current KVM URL. This URL will change periodically. It is not advised to cache this value.
        """
        return pulumi.get(self, "kvm")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        A label for the server.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="mainIp")
    def main_ip(self) -> pulumi.Output[str]:
        """
        The server's main IP address.
        """
        return pulumi.get(self, "main_ip")

    @property
    @pulumi.getter(name="netmaskV4")
    def netmask_v4(self) -> pulumi.Output[str]:
        """
        The server's IPv4 netmask.
        """
        return pulumi.get(self, "netmask_v4")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[str]:
        """
        The string description of the operating system installed on the server.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="osId")
    def os_id(self) -> pulumi.Output[int]:
        """
        The ID of the operating system to be installed on the server. [See List OS](https://www.vultr.com/api/#operation/list-os)
        """
        return pulumi.get(self, "os_id")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[str]:
        """
        The ID of the plan that you want the instance to subscribe to. [See List Plans](https://www.vultr.com/api/#tag/plans)
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="powerStatus")
    def power_status(self) -> pulumi.Output[str]:
        """
        Whether the server is powered on or not.
        """
        return pulumi.get(self, "power_status")

    @property
    @pulumi.getter(name="privateNetworkIds")
    def private_network_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Deprecated: use `vpc_ids` instead) A list of private network IDs to be attached to the server.
        """
        return pulumi.get(self, "private_network_ids")

    @property
    @pulumi.getter
    def ram(self) -> pulumi.Output[int]:
        """
        The amount of memory available on the server in MB.
        """
        return pulumi.get(self, "ram")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The ID of the region that the instance is to be created in. [See List Regions](https://www.vultr.com/api/#operation/list-regions)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="reservedIpId")
    def reserved_ip_id(self) -> pulumi.Output[str]:
        """
        ID of the floating IP to use as the main IP of this server.
        """
        return pulumi.get(self, "reserved_ip_id")

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> pulumi.Output[str]:
        """
        The ID of the startup script you want added to the server.
        """
        return pulumi.get(self, "script_id")

    @property
    @pulumi.getter(name="serverStatus")
    def server_status(self) -> pulumi.Output[str]:
        """
        A more detailed server status (none, locked, installingbooting, isomounting, ok).
        """
        return pulumi.get(self, "server_status")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[str]:
        """
        The ID of the Vultr snapshot that the server will restore for the initial installation. [See List Snapshots](https://www.vultr.com/api/#operation/list-snapshots)
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of SSH key IDs to apply to the server on install (only valid for Linux/FreeBSD).
        """
        return pulumi.get(self, "ssh_key_ids")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the server's subscription.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags to apply to the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[str]:
        """
        Generic data store, which some provisioning tools and cloud operating systems use as a configuration file. It is generally consumed only once after an instance has been launched, but individual needs may vary.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="v6MainIp")
    def v6_main_ip(self) -> pulumi.Output[str]:
        """
        The main IPv6 network address.
        """
        return pulumi.get(self, "v6_main_ip")

    @property
    @pulumi.getter(name="v6Network")
    def v6_network(self) -> pulumi.Output[str]:
        """
        The IPv6 subnet.
        """
        return pulumi.get(self, "v6_network")

    @property
    @pulumi.getter(name="v6NetworkSize")
    def v6_network_size(self) -> pulumi.Output[int]:
        """
        The IPv6 network size in bits.
        """
        return pulumi.get(self, "v6_network_size")

    @property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> pulumi.Output[int]:
        """
        The number of virtual CPUs available on the server.
        """
        return pulumi.get(self, "vcpu_count")

    @property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of VPC IDs to be attached to the server.
        """
        return pulumi.get(self, "vpc_ids")

