# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 forwarding_rules: pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]],
                 region: pulumi.Input[str],
                 attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 balancing_algorithm: Optional[pulumi.Input[str]] = None,
                 cookie_name: Optional[pulumi.Input[str]] = None,
                 firewall_rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerFirewallRuleArgs']]]] = None,
                 health_check: Optional[pulumi.Input['LoadBalancerHealthCheckArgs']] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 ssl: Optional[pulumi.Input['LoadBalancerSslArgs']] = None,
                 ssl_redirect: Optional[pulumi.Input[bool]] = None,
                 vpc: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]] forwarding_rules: List of forwarding rules for a load balancer. The configuration of a `forwarding_rules` is listened below.
        :param pulumi.Input[str] region: The region your load balancer is deployed in.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attached_instances: Array of instances that are currently attached to the load balancer.
        :param pulumi.Input[str] balancing_algorithm: The balancing algorithm for your load balancer. Options are `roundrobin` or `leastconn`. Default value is `roundrobin`
        :param pulumi.Input[str] cookie_name: Name for your given sticky session.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerFirewallRuleArgs']]] firewall_rules: Defines the firewall rules for a load balancer.
        :param pulumi.Input['LoadBalancerHealthCheckArgs'] health_check: A block that defines the way load balancers should check for health. The configuration of a `health_check` is listed below.
        :param pulumi.Input[str] label: The load balancer's label.
        :param pulumi.Input[str] private_network: A private network ID that the load balancer should be attached to.
        :param pulumi.Input[bool] proxy_protocol: Boolean value that indicates if Proxy Protocol is enabled.
        :param pulumi.Input['LoadBalancerSslArgs'] ssl: A block that supplies your ssl configuration to be used with HTTPS. The configuration of a `ssl` is listed below.
        :param pulumi.Input[bool] ssl_redirect: Boolean value that indicates if HTTP calls will be redirected to HTTPS.
        :param pulumi.Input[str] vpc: A VPC ID that the load balancer should be attached to.
        """
        pulumi.set(__self__, "forwarding_rules", forwarding_rules)
        pulumi.set(__self__, "region", region)
        if attached_instances is not None:
            pulumi.set(__self__, "attached_instances", attached_instances)
        if balancing_algorithm is not None:
            pulumi.set(__self__, "balancing_algorithm", balancing_algorithm)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if firewall_rules is not None:
            pulumi.set(__self__, "firewall_rules", firewall_rules)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if private_network is not None:
            warnings.warn("""private_network is deprecated and should no longer be used. Instead, use vpc""", DeprecationWarning)
            pulumi.log.warn("""private_network is deprecated: private_network is deprecated and should no longer be used. Instead, use vpc""")
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if ssl_redirect is not None:
            pulumi.set(__self__, "ssl_redirect", ssl_redirect)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="forwardingRules")
    def forwarding_rules(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]:
        """
        List of forwarding rules for a load balancer. The configuration of a `forwarding_rules` is listened below.
        """
        return pulumi.get(self, "forwarding_rules")

    @forwarding_rules.setter
    def forwarding_rules(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]):
        pulumi.set(self, "forwarding_rules", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The region your load balancer is deployed in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="attachedInstances")
    def attached_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of instances that are currently attached to the load balancer.
        """
        return pulumi.get(self, "attached_instances")

    @attached_instances.setter
    def attached_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attached_instances", value)

    @property
    @pulumi.getter(name="balancingAlgorithm")
    def balancing_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The balancing algorithm for your load balancer. Options are `roundrobin` or `leastconn`. Default value is `roundrobin`
        """
        return pulumi.get(self, "balancing_algorithm")

    @balancing_algorithm.setter
    def balancing_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "balancing_algorithm", value)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for your given sticky session.
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie_name", value)

    @property
    @pulumi.getter(name="firewallRules")
    def firewall_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerFirewallRuleArgs']]]]:
        """
        Defines the firewall rules for a load balancer.
        """
        return pulumi.get(self, "firewall_rules")

    @firewall_rules.setter
    def firewall_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerFirewallRuleArgs']]]]):
        pulumi.set(self, "firewall_rules", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['LoadBalancerHealthCheckArgs']]:
        """
        A block that defines the way load balancers should check for health. The configuration of a `health_check` is listed below.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['LoadBalancerHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer's label.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[str]]:
        """
        A private network ID that the load balancer should be attached to.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that indicates if Proxy Protocol is enabled.
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy_protocol", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['LoadBalancerSslArgs']]:
        """
        A block that supplies your ssl configuration to be used with HTTPS. The configuration of a `ssl` is listed below.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['LoadBalancerSslArgs']]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter(name="sslRedirect")
    def ssl_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that indicates if HTTP calls will be redirected to HTTPS.
        """
        return pulumi.get(self, "ssl_redirect")

    @ssl_redirect.setter
    def ssl_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_redirect", value)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[str]]:
        """
        A VPC ID that the load balancer should be attached to.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 balancing_algorithm: Optional[pulumi.Input[str]] = None,
                 cookie_name: Optional[pulumi.Input[str]] = None,
                 firewall_rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerFirewallRuleArgs']]]] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]] = None,
                 has_ssl: Optional[pulumi.Input[bool]] = None,
                 health_check: Optional[pulumi.Input['LoadBalancerHealthCheckArgs']] = None,
                 ipv4: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input['LoadBalancerSslArgs']] = None,
                 ssl_redirect: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vpc: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attached_instances: Array of instances that are currently attached to the load balancer.
        :param pulumi.Input[str] balancing_algorithm: The balancing algorithm for your load balancer. Options are `roundrobin` or `leastconn`. Default value is `roundrobin`
        :param pulumi.Input[str] cookie_name: Name for your given sticky session.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerFirewallRuleArgs']]] firewall_rules: Defines the firewall rules for a load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]] forwarding_rules: List of forwarding rules for a load balancer. The configuration of a `forwarding_rules` is listened below.
        :param pulumi.Input[bool] has_ssl: Boolean value that indicates if SSL is enabled.
        :param pulumi.Input['LoadBalancerHealthCheckArgs'] health_check: A block that defines the way load balancers should check for health. The configuration of a `health_check` is listed below.
        :param pulumi.Input[str] ipv4: IPv4 address for your load balancer.
        :param pulumi.Input[str] ipv6: IPv6 address for your load balancer.
        :param pulumi.Input[str] label: The load balancer's label.
        :param pulumi.Input[str] private_network: A private network ID that the load balancer should be attached to.
        :param pulumi.Input[bool] proxy_protocol: Boolean value that indicates if Proxy Protocol is enabled.
        :param pulumi.Input[str] region: The region your load balancer is deployed in.
        :param pulumi.Input['LoadBalancerSslArgs'] ssl: A block that supplies your ssl configuration to be used with HTTPS. The configuration of a `ssl` is listed below.
        :param pulumi.Input[bool] ssl_redirect: Boolean value that indicates if HTTP calls will be redirected to HTTPS.
        :param pulumi.Input[str] status: Current status for the load balancer
        :param pulumi.Input[str] vpc: A VPC ID that the load balancer should be attached to.
        """
        if attached_instances is not None:
            pulumi.set(__self__, "attached_instances", attached_instances)
        if balancing_algorithm is not None:
            pulumi.set(__self__, "balancing_algorithm", balancing_algorithm)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if firewall_rules is not None:
            pulumi.set(__self__, "firewall_rules", firewall_rules)
        if forwarding_rules is not None:
            pulumi.set(__self__, "forwarding_rules", forwarding_rules)
        if has_ssl is not None:
            pulumi.set(__self__, "has_ssl", has_ssl)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if ipv4 is not None:
            pulumi.set(__self__, "ipv4", ipv4)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if private_network is not None:
            warnings.warn("""private_network is deprecated and should no longer be used. Instead, use vpc""", DeprecationWarning)
            pulumi.log.warn("""private_network is deprecated: private_network is deprecated and should no longer be used. Instead, use vpc""")
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if ssl_redirect is not None:
            pulumi.set(__self__, "ssl_redirect", ssl_redirect)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="attachedInstances")
    def attached_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of instances that are currently attached to the load balancer.
        """
        return pulumi.get(self, "attached_instances")

    @attached_instances.setter
    def attached_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attached_instances", value)

    @property
    @pulumi.getter(name="balancingAlgorithm")
    def balancing_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The balancing algorithm for your load balancer. Options are `roundrobin` or `leastconn`. Default value is `roundrobin`
        """
        return pulumi.get(self, "balancing_algorithm")

    @balancing_algorithm.setter
    def balancing_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "balancing_algorithm", value)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for your given sticky session.
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie_name", value)

    @property
    @pulumi.getter(name="firewallRules")
    def firewall_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerFirewallRuleArgs']]]]:
        """
        Defines the firewall rules for a load balancer.
        """
        return pulumi.get(self, "firewall_rules")

    @firewall_rules.setter
    def firewall_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerFirewallRuleArgs']]]]):
        pulumi.set(self, "firewall_rules", value)

    @property
    @pulumi.getter(name="forwardingRules")
    def forwarding_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]]:
        """
        List of forwarding rules for a load balancer. The configuration of a `forwarding_rules` is listened below.
        """
        return pulumi.get(self, "forwarding_rules")

    @forwarding_rules.setter
    def forwarding_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerForwardingRuleArgs']]]]):
        pulumi.set(self, "forwarding_rules", value)

    @property
    @pulumi.getter(name="hasSsl")
    def has_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that indicates if SSL is enabled.
        """
        return pulumi.get(self, "has_ssl")

    @has_ssl.setter
    def has_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_ssl", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['LoadBalancerHealthCheckArgs']]:
        """
        A block that defines the way load balancers should check for health. The configuration of a `health_check` is listed below.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['LoadBalancerHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter
    def ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address for your load balancer.
        """
        return pulumi.get(self, "ipv4")

    @ipv4.setter
    def ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4", value)

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 address for your load balancer.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancer's label.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[str]]:
        """
        A private network ID that the load balancer should be attached to.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that indicates if Proxy Protocol is enabled.
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy_protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region your load balancer is deployed in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['LoadBalancerSslArgs']]:
        """
        A block that supplies your ssl configuration to be used with HTTPS. The configuration of a `ssl` is listed below.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['LoadBalancerSslArgs']]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter(name="sslRedirect")
    def ssl_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value that indicates if HTTP calls will be redirected to HTTPS.
        """
        return pulumi.get(self, "ssl_redirect")

    @ssl_redirect.setter
    def ssl_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_redirect", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status for the load balancer
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[str]]:
        """
        A VPC ID that the load balancer should be attached to.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc", value)


class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 balancing_algorithm: Optional[pulumi.Input[str]] = None,
                 cookie_name: Optional[pulumi.Input[str]] = None,
                 firewall_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerFirewallRuleArgs']]]]] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerForwardingRuleArgs']]]]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[pulumi.InputType['LoadBalancerSslArgs']]] = None,
                 ssl_redirect: Optional[pulumi.Input[bool]] = None,
                 vpc: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Get information about a Vultr load balancer.

        ## Example Usage

        Create a new load balancer:

        ```python
        import pulumi
        import ediri_vultr as vultr

        lb = vultr.LoadBalancer("lb",
            balancing_algorithm="roundrobin",
            forwarding_rules=[vultr.LoadBalancerForwardingRuleArgs(
                backend_port=81,
                backend_protocol="http",
                frontend_port=82,
                frontend_protocol="http",
            )],
            health_check=vultr.LoadBalancerHealthCheckArgs(
                check_interval=3,
                healthy_threshold=4,
                path="/test",
                port=8080,
                protocol="http",
                response_timeout=1,
                unhealthy_threshold=2,
            ),
            label="terraform lb example",
            region="ewr")
        ```

        ## Import

        Load Balancers can be imported using the load balancer `ID`, e.g.

        ```sh
         $ pulumi import vultr:index/loadBalancer:LoadBalancer lb b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attached_instances: Array of instances that are currently attached to the load balancer.
        :param pulumi.Input[str] balancing_algorithm: The balancing algorithm for your load balancer. Options are `roundrobin` or `leastconn`. Default value is `roundrobin`
        :param pulumi.Input[str] cookie_name: Name for your given sticky session.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerFirewallRuleArgs']]]] firewall_rules: Defines the firewall rules for a load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerForwardingRuleArgs']]]] forwarding_rules: List of forwarding rules for a load balancer. The configuration of a `forwarding_rules` is listened below.
        :param pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']] health_check: A block that defines the way load balancers should check for health. The configuration of a `health_check` is listed below.
        :param pulumi.Input[str] label: The load balancer's label.
        :param pulumi.Input[str] private_network: A private network ID that the load balancer should be attached to.
        :param pulumi.Input[bool] proxy_protocol: Boolean value that indicates if Proxy Protocol is enabled.
        :param pulumi.Input[str] region: The region your load balancer is deployed in.
        :param pulumi.Input[pulumi.InputType['LoadBalancerSslArgs']] ssl: A block that supplies your ssl configuration to be used with HTTPS. The configuration of a `ssl` is listed below.
        :param pulumi.Input[bool] ssl_redirect: Boolean value that indicates if HTTP calls will be redirected to HTTPS.
        :param pulumi.Input[str] vpc: A VPC ID that the load balancer should be attached to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Get information about a Vultr load balancer.

        ## Example Usage

        Create a new load balancer:

        ```python
        import pulumi
        import ediri_vultr as vultr

        lb = vultr.LoadBalancer("lb",
            balancing_algorithm="roundrobin",
            forwarding_rules=[vultr.LoadBalancerForwardingRuleArgs(
                backend_port=81,
                backend_protocol="http",
                frontend_port=82,
                frontend_protocol="http",
            )],
            health_check=vultr.LoadBalancerHealthCheckArgs(
                check_interval=3,
                healthy_threshold=4,
                path="/test",
                port=8080,
                protocol="http",
                response_timeout=1,
                unhealthy_threshold=2,
            ),
            label="terraform lb example",
            region="ewr")
        ```

        ## Import

        Load Balancers can be imported using the load balancer `ID`, e.g.

        ```sh
         $ pulumi import vultr:index/loadBalancer:LoadBalancer lb b6a859c5-b299-49dd-8888-b1abbc517d08
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 balancing_algorithm: Optional[pulumi.Input[str]] = None,
                 cookie_name: Optional[pulumi.Input[str]] = None,
                 firewall_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerFirewallRuleArgs']]]]] = None,
                 forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerForwardingRuleArgs']]]]] = None,
                 health_check: Optional[pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[pulumi.InputType['LoadBalancerSslArgs']]] = None,
                 ssl_redirect: Optional[pulumi.Input[bool]] = None,
                 vpc: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["attached_instances"] = attached_instances
            __props__.__dict__["balancing_algorithm"] = balancing_algorithm
            __props__.__dict__["cookie_name"] = cookie_name
            __props__.__dict__["firewall_rules"] = firewall_rules
            if forwarding_rules is None and not opts.urn:
                raise TypeError("Missing required property 'forwarding_rules'")
            __props__.__dict__["forwarding_rules"] = forwarding_rules
            __props__.__dict__["health_check"] = health_check
            __props__.__dict__["label"] = label
            if private_network is not None and not opts.urn:
                warnings.warn("""private_network is deprecated and should no longer be used. Instead, use vpc""", DeprecationWarning)
                pulumi.log.warn("""private_network is deprecated: private_network is deprecated and should no longer be used. Instead, use vpc""")
            __props__.__dict__["private_network"] = private_network
            __props__.__dict__["proxy_protocol"] = proxy_protocol
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["ssl"] = ssl
            __props__.__dict__["ssl_redirect"] = ssl_redirect
            __props__.__dict__["vpc"] = vpc
            __props__.__dict__["has_ssl"] = None
            __props__.__dict__["ipv4"] = None
            __props__.__dict__["ipv6"] = None
            __props__.__dict__["status"] = None
        super(LoadBalancer, __self__).__init__(
            'vultr:index/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            balancing_algorithm: Optional[pulumi.Input[str]] = None,
            cookie_name: Optional[pulumi.Input[str]] = None,
            firewall_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerFirewallRuleArgs']]]]] = None,
            forwarding_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerForwardingRuleArgs']]]]] = None,
            has_ssl: Optional[pulumi.Input[bool]] = None,
            health_check: Optional[pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']]] = None,
            ipv4: Optional[pulumi.Input[str]] = None,
            ipv6: Optional[pulumi.Input[str]] = None,
            label: Optional[pulumi.Input[str]] = None,
            private_network: Optional[pulumi.Input[str]] = None,
            proxy_protocol: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            ssl: Optional[pulumi.Input[pulumi.InputType['LoadBalancerSslArgs']]] = None,
            ssl_redirect: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vpc: Optional[pulumi.Input[str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attached_instances: Array of instances that are currently attached to the load balancer.
        :param pulumi.Input[str] balancing_algorithm: The balancing algorithm for your load balancer. Options are `roundrobin` or `leastconn`. Default value is `roundrobin`
        :param pulumi.Input[str] cookie_name: Name for your given sticky session.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerFirewallRuleArgs']]]] firewall_rules: Defines the firewall rules for a load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerForwardingRuleArgs']]]] forwarding_rules: List of forwarding rules for a load balancer. The configuration of a `forwarding_rules` is listened below.
        :param pulumi.Input[bool] has_ssl: Boolean value that indicates if SSL is enabled.
        :param pulumi.Input[pulumi.InputType['LoadBalancerHealthCheckArgs']] health_check: A block that defines the way load balancers should check for health. The configuration of a `health_check` is listed below.
        :param pulumi.Input[str] ipv4: IPv4 address for your load balancer.
        :param pulumi.Input[str] ipv6: IPv6 address for your load balancer.
        :param pulumi.Input[str] label: The load balancer's label.
        :param pulumi.Input[str] private_network: A private network ID that the load balancer should be attached to.
        :param pulumi.Input[bool] proxy_protocol: Boolean value that indicates if Proxy Protocol is enabled.
        :param pulumi.Input[str] region: The region your load balancer is deployed in.
        :param pulumi.Input[pulumi.InputType['LoadBalancerSslArgs']] ssl: A block that supplies your ssl configuration to be used with HTTPS. The configuration of a `ssl` is listed below.
        :param pulumi.Input[bool] ssl_redirect: Boolean value that indicates if HTTP calls will be redirected to HTTPS.
        :param pulumi.Input[str] status: Current status for the load balancer
        :param pulumi.Input[str] vpc: A VPC ID that the load balancer should be attached to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["attached_instances"] = attached_instances
        __props__.__dict__["balancing_algorithm"] = balancing_algorithm
        __props__.__dict__["cookie_name"] = cookie_name
        __props__.__dict__["firewall_rules"] = firewall_rules
        __props__.__dict__["forwarding_rules"] = forwarding_rules
        __props__.__dict__["has_ssl"] = has_ssl
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["ipv4"] = ipv4
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["label"] = label
        __props__.__dict__["private_network"] = private_network
        __props__.__dict__["proxy_protocol"] = proxy_protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["ssl"] = ssl
        __props__.__dict__["ssl_redirect"] = ssl_redirect
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc"] = vpc
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attachedInstances")
    def attached_instances(self) -> pulumi.Output[Sequence[str]]:
        """
        Array of instances that are currently attached to the load balancer.
        """
        return pulumi.get(self, "attached_instances")

    @property
    @pulumi.getter(name="balancingAlgorithm")
    def balancing_algorithm(self) -> pulumi.Output[str]:
        """
        The balancing algorithm for your load balancer. Options are `roundrobin` or `leastconn`. Default value is `roundrobin`
        """
        return pulumi.get(self, "balancing_algorithm")

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name for your given sticky session.
        """
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter(name="firewallRules")
    def firewall_rules(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerFirewallRule']]]:
        """
        Defines the firewall rules for a load balancer.
        """
        return pulumi.get(self, "firewall_rules")

    @property
    @pulumi.getter(name="forwardingRules")
    def forwarding_rules(self) -> pulumi.Output[Sequence['outputs.LoadBalancerForwardingRule']]:
        """
        List of forwarding rules for a load balancer. The configuration of a `forwarding_rules` is listened below.
        """
        return pulumi.get(self, "forwarding_rules")

    @property
    @pulumi.getter(name="hasSsl")
    def has_ssl(self) -> pulumi.Output[bool]:
        """
        Boolean value that indicates if SSL is enabled.
        """
        return pulumi.get(self, "has_ssl")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.LoadBalancerHealthCheck']:
        """
        A block that defines the way load balancers should check for health. The configuration of a `health_check` is listed below.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter
    def ipv4(self) -> pulumi.Output[str]:
        """
        IPv4 address for your load balancer.
        """
        return pulumi.get(self, "ipv4")

    @property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output[str]:
        """
        IPv6 address for your load balancer.
        """
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[Optional[str]]:
        """
        The load balancer's label.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> pulumi.Output[Optional[str]]:
        """
        A private network ID that the load balancer should be attached to.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that indicates if Proxy Protocol is enabled.
        """
        return pulumi.get(self, "proxy_protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region your load balancer is deployed in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def ssl(self) -> pulumi.Output[Optional['outputs.LoadBalancerSsl']]:
        """
        A block that supplies your ssl configuration to be used with HTTPS. The configuration of a `ssl` is listed below.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter(name="sslRedirect")
    def ssl_redirect(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean value that indicates if HTTP calls will be redirected to HTTPS.
        """
        return pulumi.get(self, "ssl_redirect")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Current status for the load balancer
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def vpc(self) -> pulumi.Output[Optional[str]]:
        """
        A VPC ID that the load balancer should be attached to.
        """
        return pulumi.get(self, "vpc")

