# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'InstanceBackupsSchedule',
    'KubernetesNodePools',
    'KubernetesNodePoolsNode',
    'LoadBalancerFirewallRule',
    'LoadBalancerForwardingRule',
    'LoadBalancerHealthCheck',
    'LoadBalancerSsl',
    'GetApplicationFilterResult',
    'GetBackupFilterResult',
    'GetBareMetalPlanFilterResult',
    'GetBareMetalServerFilterResult',
    'GetBlockStorageFilterResult',
    'GetFirewallGroupFilterResult',
    'GetInstanceFilterResult',
    'GetInstanceIpv4FilterResult',
    'GetIsoPrivateFilterResult',
    'GetIsoPublicFilterResult',
    'GetKubernetesFilterResult',
    'GetKubernetesNodePoolResult',
    'GetKubernetesNodePoolNodeResult',
    'GetLoadBalancerFilterResult',
    'GetObjectStorageClusterFilterResult',
    'GetObjectStorageFilterResult',
    'GetOsFilterResult',
    'GetPlanFilterResult',
    'GetPrivateNetworkFilterResult',
    'GetRegionFilterResult',
    'GetReservedIpFilterResult',
    'GetReverseIpv4FilterResult',
    'GetReverseIpv6FilterResult',
    'GetSnapshotFilterResult',
    'GetSshKeyFilterResult',
    'GetStartupScriptFilterResult',
    'GetUserFilterResult',
    'GetVpcFilterResult',
]

@pulumi.output_type
class InstanceBackupsSchedule(dict):
    def __init__(__self__, *,
                 type: str,
                 dom: Optional[int] = None,
                 dow: Optional[int] = None,
                 hour: Optional[int] = None):
        """
        :param str type: Type of backup schedule Possible values are `daily`, `weekly`, `monthly`, `daily_alt_even`, or `daily_alt_odd`.
        :param int dom: Day of month to run. Use values between 1 and 28.
        :param int dow: Day of week to run. `1 = Sunday`, `2 = Monday`, `3 = Tuesday`, `4 = Wednesday`, `5 = Thursday`, `6 = Friday`, `7 = Saturday`
        :param int hour: Hour of day to run in UTC.
        """
        pulumi.set(__self__, "type", type)
        if dom is not None:
            pulumi.set(__self__, "dom", dom)
        if dow is not None:
            pulumi.set(__self__, "dow", dow)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of backup schedule Possible values are `daily`, `weekly`, `monthly`, `daily_alt_even`, or `daily_alt_odd`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def dom(self) -> Optional[int]:
        """
        Day of month to run. Use values between 1 and 28.
        """
        return pulumi.get(self, "dom")

    @property
    @pulumi.getter
    def dow(self) -> Optional[int]:
        """
        Day of week to run. `1 = Sunday`, `2 = Monday`, `3 = Tuesday`, `4 = Wednesday`, `5 = Thursday`, `6 = Friday`, `7 = Saturday`
        """
        return pulumi.get(self, "dow")

    @property
    @pulumi.getter
    def hour(self) -> Optional[int]:
        """
        Hour of day to run in UTC.
        """
        return pulumi.get(self, "hour")


@pulumi.output_type
class KubernetesNodePools(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeQuantity":
            suggest = "node_quantity"
        elif key == "autoScaler":
            suggest = "auto_scaler"
        elif key == "dateCreated":
            suggest = "date_created"
        elif key == "dateUpdated":
            suggest = "date_updated"
        elif key == "maxNodes":
            suggest = "max_nodes"
        elif key == "minNodes":
            suggest = "min_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePools. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePools.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePools.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: str,
                 node_quantity: int,
                 plan: str,
                 auto_scaler: Optional[bool] = None,
                 date_created: Optional[str] = None,
                 date_updated: Optional[str] = None,
                 id: Optional[str] = None,
                 max_nodes: Optional[int] = None,
                 min_nodes: Optional[int] = None,
                 nodes: Optional[Sequence['outputs.KubernetesNodePoolsNode']] = None,
                 status: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str label: The label to be used as a prefix for nodes in this node pool.
        :param int node_quantity: The number of nodes in this node pool.
        :param str plan: The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        :param bool auto_scaler: Enable the auto scaler for the default node pool.
        :param str date_created: Date node was created.
        :param str date_updated: Date of node pool updates.
        :param str id: ID of node.
        :param int max_nodes: The maximum number of nodes to use with the auto scaler.
        :param int min_nodes: The minimum number of nodes to use with the auto scaler.
        :param Sequence['KubernetesNodePoolsNodeArgs'] nodes: Array that contains information about nodes within this node pool.
        :param str status: Status of node.
        :param str tag: Tag for node pool.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "node_quantity", node_quantity)
        pulumi.set(__self__, "plan", plan)
        if auto_scaler is not None:
            pulumi.set(__self__, "auto_scaler", auto_scaler)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if date_updated is not None:
            pulumi.set(__self__, "date_updated", date_updated)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="nodeQuantity")
    def node_quantity(self) -> int:
        """
        The number of nodes in this node pool.
        """
        return pulumi.get(self, "node_quantity")

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        The plan to be used in this node pool. [See Plans List](https://www.vultr.com/api/#operation/list-plans) Note the minimum plan requirements must have at least 1 core and 2 gbs of memory.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> Optional[bool]:
        """
        Enable the auto scaler for the default node pool.
        """
        return pulumi.get(self, "auto_scaler")

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[str]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> Optional[str]:
        """
        Date of node pool updates.
        """
        return pulumi.get(self, "date_updated")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[int]:
        """
        The maximum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[int]:
        """
        The minimum number of nodes to use with the auto scaler.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.KubernetesNodePoolsNode']]:
        """
        Array that contains information about nodes within this node pool.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Tag for node pool.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class KubernetesNodePoolsNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateCreated":
            suggest = "date_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePoolsNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePoolsNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePoolsNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_created: Optional[str] = None,
                 id: Optional[str] = None,
                 label: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str date_created: Date node was created.
        :param str id: ID of node.
        :param str label: The label to be used as a prefix for nodes in this node pool.
        :param str status: Status of node.
        """
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[str]:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        The label to be used as a prefix for nodes in this node pool.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class LoadBalancerFirewallRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipType":
            suggest = "ip_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerFirewallRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerFirewallRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerFirewallRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_type: str,
                 port: int,
                 source: str,
                 id: Optional[str] = None):
        """
        :param str ip_type: The type of ip this rule is - may be either v4 or v6.
        :param int port: The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        :param str source: IP address with subnet that is allowed through the firewall. You may also pass in `cloudflare` which will allow only CloudFlares IP range.
        :param str id: The load balancer ID.
        """
        pulumi.set(__self__, "ip_type", ip_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "source", source)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> str:
        """
        The type of ip this rule is - may be either v4 or v6.
        """
        return pulumi.get(self, "ip_type")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        IP address with subnet that is allowed through the firewall. You may also pass in `cloudflare` which will allow only CloudFlares IP range.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The load balancer ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancerForwardingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPort":
            suggest = "backend_port"
        elif key == "backendProtocol":
            suggest = "backend_protocol"
        elif key == "frontendPort":
            suggest = "frontend_port"
        elif key == "frontendProtocol":
            suggest = "frontend_protocol"
        elif key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerForwardingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerForwardingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerForwardingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_port: int,
                 backend_protocol: str,
                 frontend_port: int,
                 frontend_protocol: str,
                 rule_id: Optional[str] = None):
        """
        :param int backend_port: Port on instance side.
        :param str backend_protocol: Protocol on instance side. Possible values: "http", "https", "tcp".
        :param int frontend_port: Port on load balancer side.
        :param str frontend_protocol: Protocol on load balancer side. Possible values: "http", "https", "tcp".
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "backend_protocol", backend_protocol)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "frontend_protocol", frontend_protocol)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> int:
        """
        Port on instance side.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter(name="backendProtocol")
    def backend_protocol(self) -> str:
        """
        Protocol on instance side. Possible values: "http", "https", "tcp".
        """
        return pulumi.get(self, "backend_protocol")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> int:
        """
        Port on load balancer side.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="frontendProtocol")
    def frontend_protocol(self) -> str:
        """
        Protocol on load balancer side. Possible values: "http", "https", "tcp".
        """
        return pulumi.get(self, "frontend_protocol")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[str]:
        return pulumi.get(self, "rule_id")


@pulumi.output_type
class LoadBalancerHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "responseTimeout":
            suggest = "response_timeout"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_interval: int,
                 healthy_threshold: int,
                 port: int,
                 protocol: str,
                 response_timeout: int,
                 unhealthy_threshold: int,
                 path: Optional[str] = None):
        """
        :param int check_interval: Time in seconds to perform health check. Default value is 15.
        :param int healthy_threshold: Number of failed attempts encountered before failover. Default value is 5.
        :param int port: The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        :param str protocol: The protocol used to traffic requests to the load balancer. Possible values are `http`, or `tcp`. Default value is `http`.
        :param int response_timeout: Time in seconds to wait for a health check response. Default value is 5.
        :param int unhealthy_threshold: Number of failed attempts encountered before failover. Default value is 5.
        :param str path: The path on the attached instances that the load balancer should check against. Default value is `/`
        """
        pulumi.set(__self__, "check_interval", check_interval)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "response_timeout", response_timeout)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> int:
        """
        Time in seconds to perform health check. Default value is 15.
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> int:
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The assigned port (integer) on the attached instances that the load balancer should check against. Default value is `80`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used to traffic requests to the load balancer. Possible values are `http`, or `tcp`. Default value is `http`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> int:
        """
        Time in seconds to wait for a health check response. Default value is 5.
        """
        return pulumi.get(self, "response_timeout")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> int:
        """
        Number of failed attempts encountered before failover. Default value is 5.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path on the attached instances that the load balancer should check against. Default value is `/`
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class LoadBalancerSsl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerSsl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerSsl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerSsl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: str,
                 private_key: str,
                 chain: Optional[str] = None):
        """
        :param str certificate: The SSL Certificate.
        :param str private_key: The SSL certificates private key.
        :param str chain: The SSL certificate chain.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        The SSL Certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        The SSL certificates private key.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def chain(self) -> Optional[str]:
        """
        The SSL certificate chain.
        """
        return pulumi.get(self, "chain")


@pulumi.output_type
class GetApplicationFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBackupFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBareMetalPlanFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBareMetalServerFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBlockStorageFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetFirewallGroupFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInstanceFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInstanceIpv4FilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetIsoPrivateFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetIsoPublicFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetKubernetesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetKubernetesNodePoolResult(dict):
    def __init__(__self__, *,
                 date_created: str,
                 date_updated: str,
                 id: str,
                 label: str,
                 node_quantity: int,
                 nodes: Sequence['outputs.GetKubernetesNodePoolNodeResult'],
                 plan: str,
                 status: str,
                 tag: str,
                 auto_scaler: Optional[bool] = None,
                 max_nodes: Optional[int] = None,
                 min_nodes: Optional[int] = None):
        """
        :param str date_created: Date node was created.
        :param str date_updated: Date of node pool updates.
        :param str id: ID of node.
        :param str label: Label of node.
        :param int node_quantity: Number of nodes within node pool.
        :param Sequence['GetKubernetesNodePoolNodeArgs'] nodes: Array that contains information about nodes within this node pool.
        :param str plan: Node plan that nodes are using within this node pool.
        :param str status: Status of node.
        :param str tag: Tag for node pool.
        :param bool auto_scaler: Boolean indicating if the auto scaler for the default node pool is active.
        :param int max_nodes: The maximum number of nodes used by the auto scaler.
        :param int min_nodes: The minimum number of nodes used by the auto scaler.
        """
        pulumi.set(__self__, "date_created", date_created)
        pulumi.set(__self__, "date_updated", date_updated)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "node_quantity", node_quantity)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "plan", plan)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tag", tag)
        if auto_scaler is not None:
            pulumi.set(__self__, "auto_scaler", auto_scaler)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> str:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter(name="dateUpdated")
    def date_updated(self) -> str:
        """
        Date of node pool updates.
        """
        return pulumi.get(self, "date_updated")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Label of node.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="nodeQuantity")
    def node_quantity(self) -> int:
        """
        Number of nodes within node pool.
        """
        return pulumi.get(self, "node_quantity")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetKubernetesNodePoolNodeResult']:
        """
        Array that contains information about nodes within this node pool.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        Node plan that nodes are using within this node pool.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Tag for node pool.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="autoScaler")
    def auto_scaler(self) -> Optional[bool]:
        """
        Boolean indicating if the auto scaler for the default node pool is active.
        """
        return pulumi.get(self, "auto_scaler")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[int]:
        """
        The maximum number of nodes used by the auto scaler.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[int]:
        """
        The minimum number of nodes used by the auto scaler.
        """
        return pulumi.get(self, "min_nodes")


@pulumi.output_type
class GetKubernetesNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 date_created: str,
                 id: str,
                 label: str,
                 status: str):
        """
        :param str date_created: Date node was created.
        :param str id: ID of node.
        :param str label: Label of node.
        :param str status: Status of node.
        """
        pulumi.set(__self__, "date_created", date_created)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> str:
        """
        Date node was created.
        """
        return pulumi.get(self, "date_created")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Label of node.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of node.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetLoadBalancerFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetObjectStorageClusterFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetObjectStorageFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetOsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPlanFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetPrivateNetworkFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetRegionFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetReservedIpFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetReverseIpv4FilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetReverseIpv6FilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values to filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values to filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetSnapshotFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetSshKeyFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetStartupScriptFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetUserFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetVpcFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str]):
        """
        :param str name: Attribute name to filter with.
        :param Sequence[str] values: One or more values filter with.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Attribute name to filter with.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        One or more values filter with.
        """
        return pulumi.get(self, "values")


