# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 password: pulumi.Input[str],
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 api_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] email: Email for this user.
        :param pulumi.Input[str] password: Password for this user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acls: The access control list for the user.
        :param pulumi.Input[bool] api_enabled: Whether API is enabled for the user. Default behavior is set to enabled.
        :param pulumi.Input[str] name: Name for this user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "password", password)
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if api_enabled is not None:
            pulumi.set(__self__, "api_enabled", api_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        Email for this user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password for this user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The access control list for the user.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "acls", value)

    @property
    @pulumi.getter(name="apiEnabled")
    def api_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether API is enabled for the user. Default behavior is set to enabled.
        """
        return pulumi.get(self, "api_enabled")

    @api_enabled.setter
    def api_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "api_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for this user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 api_enabled: Optional[pulumi.Input[bool]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acls: The access control list for the user.
        :param pulumi.Input[bool] api_enabled: Whether API is enabled for the user. Default behavior is set to enabled.
        :param pulumi.Input[str] email: Email for this user.
        :param pulumi.Input[str] name: Name for this user.
        :param pulumi.Input[str] password: Password for this user.
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if api_enabled is not None:
            pulumi.set(__self__, "api_enabled", api_enabled)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The access control list for the user.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "acls", value)

    @property
    @pulumi.getter(name="apiEnabled")
    def api_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether API is enabled for the user. Default behavior is set to enabled.
        """
        return pulumi.get(self, "api_enabled")

    @api_enabled.setter
    def api_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "api_enabled", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email for this user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for this user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for this user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 api_enabled: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Vultr User resource. This can be used to create, read, modify, and delete Users.

        ## Example Usage

        Create a new User without any ACLs

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_user = vultr.User("myUser",
            api_enabled=True,
            email="user@vultr.com",
            password="myP@ssw0rd")
        ```

        Create a new User with all ACLs

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_user = vultr.User("myUser",
            acls=[
                "manage_users",
                "subscriptions",
                "provisioning",
                "billing",
                "support",
                "abuse",
                "dns",
                "upgrade",
            ],
            api_enabled=True,
            email="user@vultr.com",
            password="myP@ssw0rd")
        ```

        ## Import

        Users can be imported using the User `ID`, e.g.

        ```sh
         $ pulumi import vultr:index/user:User myuser 1345fef0-8ed3-4a66-bd8c-822a7b7bd05a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acls: The access control list for the user.
        :param pulumi.Input[bool] api_enabled: Whether API is enabled for the user. Default behavior is set to enabled.
        :param pulumi.Input[str] email: Email for this user.
        :param pulumi.Input[str] name: Name for this user.
        :param pulumi.Input[str] password: Password for this user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr User resource. This can be used to create, read, modify, and delete Users.

        ## Example Usage

        Create a new User without any ACLs

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_user = vultr.User("myUser",
            api_enabled=True,
            email="user@vultr.com",
            password="myP@ssw0rd")
        ```

        Create a new User with all ACLs

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_user = vultr.User("myUser",
            acls=[
                "manage_users",
                "subscriptions",
                "provisioning",
                "billing",
                "support",
                "abuse",
                "dns",
                "upgrade",
            ],
            api_enabled=True,
            email="user@vultr.com",
            password="myP@ssw0rd")
        ```

        ## Import

        Users can be imported using the User `ID`, e.g.

        ```sh
         $ pulumi import vultr:index/user:User myuser 1345fef0-8ed3-4a66-bd8c-822a7b7bd05a
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 api_enabled: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["acls"] = acls
            __props__.__dict__["api_enabled"] = api_enabled
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["api_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'vultr:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            api_enabled: Optional[pulumi.Input[bool]] = None,
            api_key: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] acls: The access control list for the user.
        :param pulumi.Input[bool] api_enabled: Whether API is enabled for the user. Default behavior is set to enabled.
        :param pulumi.Input[str] email: Email for this user.
        :param pulumi.Input[str] name: Name for this user.
        :param pulumi.Input[str] password: Password for this user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["acls"] = acls
        __props__.__dict__["api_enabled"] = api_enabled
        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["email"] = email
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The access control list for the user.
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter(name="apiEnabled")
    def api_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether API is enabled for the user. Default behavior is set to enabled.
        """
        return pulumi.get(self, "api_enabled")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        Email for this user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name for this user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password for this user.
        """
        return pulumi.get(self, "password")

