# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE
# OVERWRITTEN WHEN PREPARING PACKAGES.
#
# IF YOU WANT TO MODIFY IT, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `provider_packages` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-huawei",
        "name": "Huawei",
        "description": "Huawei Cloud integration (including `Huawei Cloud <https://www.huaweicloud.com/intl/en-us/>`__).\n",
        "versions": ["1.0.3", "1.0.2", "1.0.1", "1.0.0"],
        "dependencies": [
            "apache-airflow>=2.5.0",
            "psycopg2>=2.9.4",
            "huaweicloudsdkcore>=3.1.21",
            "esdk-obs-python>=3.22.2",
            "huaweicloudsdkdws>=3.1.21",
            "huaweicloudsdksmn>=3.1.19",
            "huaweicloudsdkdli==3.1.19",
            "huaweicloudsdkcdm>=3.1.19",
            "huaweicloudsdkdlf>=3.1.19",
            "huaweicloudsdkiam>=3.1.19",
        ],
        "integrations": [
            {
                "integration-name": "Huawei Cloud CDM",
                "external-doc-url": "https://support.huaweicloud.com/intl/en-us/cdm/index.html",
                "logo": "/integration-logos/huawei/CDM.png",
                "how-to-guide": ["/docs/apache-airflow-providers-huawei/operators/cdm.rst"],
                "tags": ["huawei"],
            },
            {
                "integration-name": "Huawei Cloud DataArts",
                "external-doc-url": "https://support.huaweicloud.com/intl/en-us/dataartsstudio/index.html",
                "logo": "/integration-logos/huawei/DataArts.png",
                "how-to-guide": ["/docs/apache-airflow-providers-huawei/operators/dataarts.rst"],
                "tags": ["huawei"],
            },
            {
                "integration-name": "Huawei Cloud DLI",
                "external-doc-url": "https://support.huaweicloud.com/intl/en-us/dli/index.html",
                "logo": "/integration-logos/huawei/DLI.png",
                "how-to-guide": ["/docs/apache-airflow-providers-huawei/operators/dli.rst"],
                "tags": ["huawei"],
            },
            {
                "integration-name": "Huawei Cloud DWS",
                "external-doc-url": "https://support.huaweicloud.com/intl/en-us/dws/index.html",
                "logo": "/integration-logos/huawei/DWS.png",
                "how-to-guide": ["/docs/apache-airflow-providers-huawei/operators/dws.rst"],
                "tags": ["huawei"],
            },
            {
                "integration-name": "Huawei Cloud SMN",
                "external-doc-url": "https://support.huaweicloud.com/intl/en-us/smn/index.html",
                "logo": "/integration-logos/huawei/SMN.png",
                "how-to-guide": ["/docs/apache-airflow-providers-huawei/operators/smn.rst"],
                "tags": ["huawei"],
            },
            {
                "integration-name": "Huawei Cloud OBS",
                "external-doc-url": "https://support.huaweicloud.com/intl/en-us/obs/index.html",
                "logo": "/integration-logos/huawei/OBS.png",
                "how-to-guide": ["/docs/apache-airflow-providers-huawei/operators/obs.rst"],
                "tags": ["huawei"],
            },
        ],
        "operators": [
            {
                "integration-name": "Huawei Cloud OBS",
                "python-modules": ["airflow.providers.huawei.cloud.operators.huawei_obs"],
            },
            {
                "integration-name": "Huawei Cloud DWS",
                "python-modules": ["airflow.providers.huawei.cloud.operators.dws"],
            },
            {
                "integration-name": "Huawei Cloud SMN",
                "python-modules": ["airflow.providers.huawei.cloud.operators.smn"],
            },
            {
                "integration-name": "Huawei Cloud DLI",
                "python-modules": ["airflow.providers.huawei.cloud.operators.dli"],
            },
            {
                "integration-name": "Huawei Cloud CDM",
                "python-modules": ["airflow.providers.huawei.cloud.operators.cdm"],
            },
            {
                "integration-name": "Huawei Cloud DataArts",
                "python-modules": ["airflow.providers.huawei.cloud.operators.dataarts"],
            },
        ],
        "sensors": [
            {
                "integration-name": "Huawei Cloud OBS",
                "python-modules": ["airflow.providers.huawei.cloud.sensors.huawei_obs_key"],
            },
            {
                "integration-name": "Huawei Cloud DWS",
                "python-modules": ["airflow.providers.huawei.cloud.sensors.dws"],
            },
            {
                "integration-name": "Huawei Cloud DLI",
                "python-modules": ["airflow.providers.huawei.cloud.sensors.dli"],
            },
            {
                "integration-name": "Huawei Cloud CDM",
                "python-modules": ["airflow.providers.huawei.cloud.sensors.cdm"],
            },
            {
                "integration-name": "Huawei Cloud DataArts",
                "python-modules": ["airflow.providers.huawei.cloud.sensors.dataarts"],
            },
        ],
        "hooks": [
            {
                "integration-name": "Huawei Cloud",
                "python-modules": ["airflow.providers.huawei.cloud.hooks.base_huawei_cloud"],
            },
            {
                "integration-name": "Huawei Cloud OBS",
                "python-modules": ["airflow.providers.huawei.cloud.hooks.huawei_obs"],
            },
            {
                "integration-name": "Huawei Cloud DWS",
                "python-modules": ["airflow.providers.huawei.cloud.hooks.dws"],
            },
            {
                "integration-name": "Huawei Cloud DWS SQL",
                "python-modules": ["airflow.providers.huawei.cloud.hooks.dws_sql"],
            },
            {
                "integration-name": "Huawei Cloud SMN",
                "python-modules": ["airflow.providers.huawei.cloud.hooks.smn"],
            },
            {
                "integration-name": "Huawei Cloud DLI",
                "python-modules": ["airflow.providers.huawei.cloud.hooks.dli"],
            },
            {
                "integration-name": "Huawei Cloud CDM",
                "python-modules": ["airflow.providers.huawei.cloud.hooks.cdm"],
            },
            {
                "integration-name": "Huawei Cloud DataArts",
                "python-modules": ["airflow.providers.huawei.cloud.hooks.dataarts"],
            },
        ],
        "connection-types": [
            {
                "hook-class-name": "airflow.providers.huawei.cloud.hooks.base_huawei_cloud.HuaweiBaseHook",
                "connection-type": "huaweicloud",
            },
            {
                "hook-class-name": "airflow.providers.huawei.cloud.hooks.dws_sql.DWSSqlHook",
                "connection-type": "dws",
            },
        ],
    }
