"""initial generation.

Revision ID: 6d4e785df5cb
Revises: 
Create Date: 2022-09-27 19:19:39.281403

"""
import sqlalchemy as sa
from sqlalchemy.ext.mutable import MutableDict

import moe
from alembic import op

# revision identifiers, used by Alembic.
revision = "6d4e785df5cb"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "album",
        sa.Column("_id", sa.Integer(), nullable=False),
        sa.Column("artist", sa.String(), nullable=False),
        sa.Column("date", sa.Date(), nullable=False),
        sa.Column("disc_total", sa.Integer(), nullable=False, default=1),
        sa.Column("path", moe.library.lib_item.PathType(), nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column(
            "_custom_fields",
            MutableDict.as_mutable(sa.JSON(none_as_null=True)),
            nullable=False,
            default={},
        ),
        sa.PrimaryKeyConstraint("_id"),
        sa.UniqueConstraint("path"),
    )
    op.create_table(
        "extra",
        sa.Column("_id", sa.Integer(), nullable=False),
        sa.Column("path", moe.library.lib_item.PathType(), nullable=False),
        sa.Column(
            "_custom_fields",
            MutableDict.as_mutable(sa.JSON(none_as_null=True)),
            nullable=False,
            default={},
        ),
        sa.Column("_album_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["_album_id"],
            ["album._id"],
        ),
        sa.PrimaryKeyConstraint("_id"),
        sa.UniqueConstraint("path"),
    )
    op.create_table(
        "track",
        sa.Column("_id", sa.Integer(), nullable=False),
        sa.Column("artist", sa.String(), nullable=False),
        sa.Column("disc", sa.Integer(), nullable=False),
        sa.Column("path", moe.library.lib_item.PathType(), nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("track_num", sa.Integer(), nullable=False),
        sa.Column(
            "_custom_fields",
            MutableDict.as_mutable(sa.JSON(none_as_null=True)),
            nullable=False,
            default={},
        ),
        sa.Column("_album_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["_album_id"],
            ["album._id"],
        ),
        sa.PrimaryKeyConstraint("_id"),
        sa.UniqueConstraint("disc", "track_num", "_album_id"),
        sa.UniqueConstraint("path"),
    )
    op.create_table(
        "genre",
        sa.Column("_id", sa.Integer(), nullable=False),
        sa.Column("_track_id", sa.Integer(), nullable=True),
        sa.Column("name", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["_track_id"],
            ["track._id"],
        ),
        sa.PrimaryKeyConstraint("_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("genre")
    op.drop_table("track")
    op.drop_table("extra")
    op.drop_table("album")
    # ### end Alembic commands ###
