import { Construct } from 'constructs';
export declare enum VolumeType {
    STANDARD = "standard",
    IO1 = "io1",
    IO2 = "io2",
    GP2 = "gp2",
    SC1 = "sc1",
    ST1 = "st1",
    GP3 = "gp3"
}
export declare enum ResourceType {
    IMAGE = "image",
    SNAPSHOT = "snapshot"
}
export interface CreateAMIProps {
    readonly description?: string;
    readonly instanceId: string;
    readonly name?: string;
    readonly blockDeviceMappings?: Array<BlockDeviceMapping>;
    readonly tagSpecifications?: Array<TagSpecification>;
    readonly deleteInstance?: boolean;
    readonly deleteAmi?: boolean;
}
export interface BlockDeviceMapping {
    readonly deviceName?: string;
    readonly virtualName?: string;
    readonly ebs?: Ebs;
    readonly noDevice?: string;
}
export interface Ebs {
    readonly deleteOnTermination?: boolean;
    readonly iops?: number;
    readonly snapshotId?: string;
    readonly volumeSize?: number;
    readonly volumeType?: VolumeType;
    readonly kmsKeyId?: string;
    readonly throughput?: number;
    readonly outpostArn?: string;
    readonly encrypted?: boolean;
}
export interface Tags {
    readonly key: string;
    readonly value: string;
}
export interface TagSpecification {
    readonly resourceType?: ResourceType;
    readonly tags?: Array<Tags>;
}
export declare class CreateAMI extends Construct {
    readonly imageId: string;
    readonly imageName: string;
    constructor(scope: Construct, id: string, props: CreateAMIProps);
}
