# spswarehouse_airflow

This package is a clone of `spswarehouse`, adapted to be used in Airflow. Rather than using a credentials.py file, it pulls credentials from Airflow's Connections.


# Usage

## Snowflake Access

The main difference in this packages is that you do not import `Warehouse` directly from the package.  Instead, you will import the function `create_warehouse`, and then call that function to create the warehouse connection when you need it.  After completing the Warehouse work, you need to manually close the Warehouse connection.

At the top of your DAG file:
```
from spswarehouse_airflow.warehouse import create_warehouse
from spswarehouse_airflow.table_utils import *
```

In a function that is fed to a PythonOperator:
```
Warehouse = create_warehouse()
<Whatever it is you need to do in the warehouse>
Warehouse.close()
```

## Google Access

Similar to Snowflake, rather than importing GoogleSheets or GoogleDrive, import the relevant create function.

```
from spswarehouse_airflow.googlesheets import create_sheets
from spswarehouse_airflow.googledrive import create_drive
from spswarehouse_airflow.googleslides import create_slides
```

```
GoogleSheets = create_sheets()
GoogleDrive = create_drive()
GoogleSlides = create_slides()
````

Default service account e-mail to share your files with is `airflow@dops-special-projects.iam.gserviceaccount.com`

If you are not using `google_cloud_default` as the connection name for where you are storing the credentials, pass the conn_id to the create function.  E.g., `GoogleSheets = create_sheets(custom_conn_id)`
