# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# System
from typing import Union

# Pip
from jsoncodable import JSONCodable

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# -------------------------------------------------------- class: ListingAreaSize -------------------------------------------------------- #

class ListingAreaSize(JSONCodable):

    # ------------------------------------------------------------- Init ------------------------------------------------------------- #

    def __init__(
        self,
        lot_size: Union[int, float],
        lot_unit: str,
        lot_size_sqft: Union[int, float],
        living_size: Union[int, float],
        living_unit: str,
        living_unit_short: str
    ):
        self.lot = ListingLotSize(lot_size, lot_unit, lot_size_sqft)
        self.living = ListingLivingSize(living_size, living_unit, living_unit_short)


# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ------------------------------------------------------- class: ListingLivingSize ------------------------------------------------------- #

class ListingLivingSize(JSONCodable):

    # ------------------------------------------------------------- Init ------------------------------------------------------------- #

    def __init__(
        self,
        size: Union[int, float],
        unit: str,
        unit_short: str
    ):
        self.size = size
        self.unit = unit
        self.unit_short = unit_short


# ---------------------------------------------------------------------------------------------------------------------------------------- #



# --------------------------------------------------------- class: ListingLotSize -------------------------------------------------------- #

class ListingLotSize(JSONCodable):

    # ------------------------------------------------------------- Init ------------------------------------------------------------- #

    def __init__(
        self,
        size: Union[int, float],
        unit: str,
        size_sqft: int
    ):
        self.size = size
        self.unit = unit
        self.size_sqft = size_sqft


# ---------------------------------------------------------------------------------------------------------------------------------------- #