# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# Pip
from jsoncodable import JSONCodable

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ------------------------------------------------------------ class: Region ------------------------------------------------------------- #

class Region(JSONCodable):

    # ------------------------------------------------------------- Init ------------------------------------------------------------- #

    def __init__(
        self,
        d: dict
    ):
        self.display = d['display']
        m = d['metaData']

        self.id = int(m['regionId'])
        self.type = m['regionType']
        self.city = m['city']
        self.county = m['county']
        self.state = m['state']

        self.latitude = m['lat']
        self.longitude = m['lng']
        self.score = m['score']
        self.slug = self.display.replace(',', '').replace(' ', '-').lower()


# ---------------------------------------------------------------------------------------------------------------------------------------- #