"""This file is auto-generated by _attrs_generator.py. Changes will be overwritten.
"""

from . import Attr
import requests
from typing import Union


def _get_json_schema():
    "Get the current JSON schema from the web"
    url = "http://search.rcsb.org/rcsbsearch/v1/metadata/schema"

    response = requests.get(url)
    response.raise_for_status()
    return response.json()


class SchemaGroup:
    """A non-leaf node in the RCSB schema. Leaves are Attr values."""

    def __str__(self):
        return "\n".join((str(c) for c in self.__dict__.values()))


def _make_group(fullname: str, node) -> Union[SchemaGroup, Attr]:
    """Represent this node of the schema as a python object

    Params:
    - name: full dot-separated attribute name

    Returns:
    An Attr (Leaf nodes) or SchemaGroup (object nodes)
    """
    if node["type"] in ("string", "number", "integer", "date"):
        return Attr(fullname)
    elif node["type"] == "array":
        # skip to items
        return _make_group(fullname, node["items"])
    elif node["type"] == "object":
        group = SchemaGroup()  # parent, name)
        for childname, childnode in node["properties"].items():
            fullchildname = f"{fullname}.{childname}" if fullname else childname
            childgroup = _make_group(fullchildname, childnode)
            setattr(group, childname, childgroup)
        return group
    else:
        raise TypeError(f"Unrecognized node type {node['type']!r} of {fullname}")


def _make_schema():
    json = _get_json_schema()
    return _make_group("", json)


rcsb_attributes = _make_schema()
"""Object with known RCSB attributes.

This is provided to ease autocompletion as compared to creating Attr objects from
strings. For example, `rcsb_attributes.rcsb_nonpolymer_instance_feature_summary.chem_id`
is equivalent to `Attr(rcsb_nonpolymer_instance_feature_summary.chem_id)`
"""
