from typing import Any

from pony.converting import timedelta2str as timedelta2str
from pony.orm import core as core
from pony.orm import dbapiprovider as dbapiprovider
from pony.orm import dbschema as dbschema
from pony.orm import ormtypes as ormtypes
from pony.orm import sqltranslation as sqltranslation
from pony.orm.core import log_orm as log_orm
from pony.orm.dbapiprovider import DBAPIProvider as DBAPIProvider
from pony.orm.dbapiprovider import Pool as Pool
from pony.orm.dbapiprovider import wrap_dbapi_exceptions as wrap_dbapi_exceptions
from pony.orm.sqlbuilding import SQLBuilder as SQLBuilder
from pony.orm.sqlbuilding import Value as Value
from pony.orm.sqlbuilding import join as join
from pony.orm.sqltranslation import SQLTranslator as SQLTranslator
from pony.py23compat import buffer as buffer
from pony.py23compat import int_types as int_types
from pony.utils import is_ident as is_ident
from psycopg2 import extensions as extensions  # type: ignore

NoneType: Any

class PGColumn(dbschema.Column):
    auto_template: str

class PGSchema(dbschema.DBSchema):
    dialect: str
    column_class: Any

class PGTranslator(SQLTranslator):
    dialect: str

class PGValue(Value): ...

class PGSQLBuilder(SQLBuilder):
    dialect: str
    value_class: Any
    def INSERT(
        builder, table_name: Any, columns: Any, values: Any, returning: Any | None = ...
    ) -> Any: ...
    def TO_INT(builder, expr: Any) -> Any: ...
    def TO_STR(builder, expr: Any) -> Any: ...
    def TO_REAL(builder, expr: Any) -> Any: ...
    def DATE(builder, expr: Any) -> Any: ...
    def RANDOM(builder) -> Any: ...
    def DATE_ADD(builder, expr: Any, delta: Any) -> Any: ...
    def DATE_SUB(builder, expr: Any, delta: Any) -> Any: ...
    def DATE_DIFF(builder, expr1: Any, expr2: Any) -> Any: ...
    def DATETIME_ADD(builder, expr: Any, delta: Any) -> Any: ...
    def DATETIME_SUB(builder, expr: Any, delta: Any) -> Any: ...
    def DATETIME_DIFF(builder, expr1: Any, expr2: Any) -> Any: ...
    def eval_json_path(builder, values: Any) -> Any: ...  # type: ignore
    def JSON_QUERY(builder, expr: Any, path: Any) -> Any: ...
    json_value_type_mapping: Any
    def JSON_VALUE(builder, expr: Any, path: Any, type: Any) -> Any: ...
    def JSON_NONZERO(builder, expr: Any) -> Any: ...
    def JSON_CONCAT(builder, left: Any, right: Any) -> Any: ...
    def JSON_CONTAINS(builder, expr: Any, path: Any, key: Any) -> Any: ...
    def JSON_ARRAY_LENGTH(builder, value: Any) -> Any: ...
    def GROUP_CONCAT(
        builder, distinct: Any, expr: Any, sep: Any | None = ...
    ) -> Any: ...
    def ARRAY_INDEX(builder, col: Any, index: Any) -> Any: ...
    def ARRAY_CONTAINS(builder, key: Any, not_in: Any, col: Any) -> Any: ...
    def ARRAY_SUBSET(builder, array1: Any, not_in: Any, array2: Any) -> Any: ...
    def ARRAY_LENGTH(builder, array: Any) -> Any: ...
    def ARRAY_SLICE(builder, array: Any, start: Any, stop: Any) -> Any: ...
    def MAKE_ARRAY(builder, *items: Any) -> Any: ...

class PGIntConverter(dbapiprovider.IntConverter):
    signed_types: Any
    unsigned_types: Any

class PGRealConverter(dbapiprovider.RealConverter):
    def sql_type(converter) -> Any: ...

class PGBlobConverter(dbapiprovider.BlobConverter):
    def sql_type(converter) -> Any: ...

class PGTimedeltaConverter(dbapiprovider.TimedeltaConverter):
    sql_type_name: str

class PGDatetimeConverter(dbapiprovider.DatetimeConverter):
    sql_type_name: str

class PGUuidConverter(dbapiprovider.UuidConverter):
    def py2sql(converter, val: Any) -> Any: ...

class PGJsonConverter(dbapiprovider.JsonConverter):
    def sql_type(self) -> Any: ...

class PGArrayConverter(dbapiprovider.ArrayConverter):
    array_types: Any

class PGPool(Pool):
    def release(pool, con: Any) -> None: ...

ADMIN_SHUTDOWN: str

class PGProvider(DBAPIProvider):
    dialect: str
    paramstyle: str
    max_name_len: int
    max_params_count: int
    index_if_not_exists_syntax: bool
    dbapi_module: Any
    dbschema_cls: Any
    translator_cls: Any
    sqlbuilder_cls: Any
    array_converter_cls: Any
    default_schema_name: str
    fk_types: Any
    def normalize_name(provider, name: Any) -> Any: ...
    def inspect_connection(provider, connection: Any) -> None: ...
    def should_reconnect(provider, exc: Any) -> Any: ...
    def get_pool(provider, *args: Any, **kwargs: Any) -> Any: ...
    def set_transaction_mode(provider, connection: Any, cache: Any) -> None: ...
    def execute(
        provider,
        cursor: Any,
        sql: Any,
        arguments: Any | None = ...,
        returning_id: bool = ...,
    ) -> Any: ...
    def table_exists(
        provider, connection: Any, table_name: Any, case_sensitive: bool = ...
    ) -> Any: ...
    def index_exists(
        provider,
        connection: Any,
        table_name: Any,
        index_name: Any,
        case_sensitive: bool = ...,
    ) -> Any: ...
    def fk_exists(
        provider,
        connection: Any,
        table_name: Any,
        fk_name: Any,
        case_sensitive: bool = ...,
    ) -> Any: ...
    def drop_table(provider, connection: Any, table_name: Any) -> None: ...
    converter_classes: Any

provider_cls = PGProvider
