from typing import Any

from pony.py23compat import buffer as buffer
from pony.py23compat import int_types as int_types
from pony.utils import deref_proxy as deref_proxy
from pony.utils import parse_expr as parse_expr
from pony.utils import throw as throw

NoneType: Any

class LongStr(str):
    lazy: bool

LongUnicode = LongStr

class SetType:
    def __deepcopy__(self, memo: Any) -> Any: ...
    item_type: Any
    def __init__(self, item_type: Any) -> None: ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...
    def __hash__(self) -> Any: ...

class FuncType:
    def __deepcopy__(self, memo: Any) -> Any: ...
    func: Any
    def __init__(self, func: Any) -> None: ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...
    def __hash__(self) -> Any: ...

class MethodType:
    def __deepcopy__(self, memo: Any) -> Any: ...
    obj: Any
    func: Any
    def __init__(self, method: Any) -> None: ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...
    def __hash__(self) -> Any: ...

raw_sql_cache: Any

def parse_raw_sql(sql: Any) -> Any: ...
def raw_sql(sql: Any, result_type: Any | None = ...) -> Any: ...

class RawSQL:
    def __deepcopy__(self, memo: Any) -> None: ...
    sql: Any
    result_type: Any
    def __init__(
        self,
        sql: Any,
        globals: Any | None = ...,
        locals: Any | None = ...,
        result_type: Any | None = ...,
    ) -> None: ...

class RawSQLType:
    def __deepcopy__(self, memo: Any) -> Any: ...
    sql: Any
    items: Any
    types: Any
    result_type: Any
    def __init__(self, sql: Any, items: Any, types: Any, result_type: Any) -> None: ...
    def __hash__(self) -> Any: ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...

class QueryType:
    query_key: Any
    translator: Any
    limit: Any
    offset: Any
    def __init__(
        self, query: Any, limit: Any | None = ..., offset: Any | None = ...
    ) -> None: ...
    def __hash__(self) -> Any: ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...

def normalize(value: Any) -> Any: ...
def normalize_type(t: Any) -> Any: ...

coercions: Any

def coerce_types(t1: Any, t2: Any) -> Any: ...
def are_comparable_types(t1: Any, t2: Any, op: str = ...) -> Any: ...

class TrackedValue:
    obj_ref: Any
    attr: Any
    def __init__(self, obj: Any, attr: Any) -> None: ...
    @classmethod
    def make(cls, obj: Any, attr: Any, value: Any) -> Any: ...
    def get_untracked(self) -> None: ...

def tracked_method(func: Any) -> Any: ...

class TrackedDict(TrackedValue, dict[Any, Any]):
    def __init__(self, obj: Any, attr: Any, value: Any) -> None: ...
    def __reduce__(self) -> Any: ...
    __setitem__: Any
    __delitem__: Any
    def update(self, *args: Any, **kwargs: Any) -> Any: ...
    setdefault: Any
    pop: Any
    popitem: Any
    clear: Any
    def get_untracked(self) -> Any: ...

class TrackedList(TrackedValue, list[Any]):
    def __init__(self, obj: Any, attr: Any, value: Any) -> None: ...
    def __reduce__(self) -> Any: ...
    __setitem__: Any
    __delitem__: Any
    extend: Any
    append: Any
    pop: Any
    remove: Any
    insert: Any
    reverse: Any
    sort: Any
    clear: Any
    def get_untracked(self) -> Any: ...

def validate_item(item_type: Any, item: Any) -> Any: ...

class TrackedArray(TrackedList):
    item_type: Any
    def __init__(self, obj: Any, attr: Any, value: Any) -> None: ...
    def extend(self, items: Any) -> None: ...
    def append(self, item: Any) -> None: ...
    def insert(self, index: Any, item: Any) -> None: ...
    def __setitem__(self, index: Any, item: Any) -> None: ...
    def __contains__(self, item: Any) -> Any: ...

class Json:
    @classmethod
    def default_empty_value(cls) -> Any: ...
    wrapped: Any
    def __init__(self, wrapped: Any) -> None: ...

class Array:
    item_type: Any
    @classmethod
    def default_empty_value(cls: Any) -> Any: ...

class IntArray(Array):
    item_type: Any

class StrArray(Array):
    item_type: Any

class FloatArray(Array):
    item_type: Any

numeric_types: Any
comparable_types: Any
primitive_types: Any
function_types: Any
type_normalization_dict: Any
array_types: Any
