# Generated by Django 3.1.3 on 2020-12-09 21:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='NotificationTarget',
            fields=[
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=15, unique=True)),
                ('notification_module_name', models.CharField(max_length=50)),
            ],
            options={
                'verbose_name_plural': 'Notification Targets',
                'db_table': 'notification_system_target',
            },
        ),
        migrations.CreateModel(
            name='TargetUserRecord',
            fields=[
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('target_user_id', models.CharField(max_length=200)),
                ('description', models.CharField(max_length=200)),
                ('active', models.BooleanField(default=True)),
                ('target', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='django_notification_system.notificationtarget')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notification_target_user_records', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'User In Notification Targets',
                'db_table': 'notification_system_target_user_record',
            },
        ),
        migrations.CreateModel(
            name='NotificationOptOut',
            fields=[
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('active', models.BooleanField(default=False)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='notification_opt_out', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Notification Opt Outs',
                'db_table': 'notification_system_opt_out',
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(max_length=100)),
                ('body', models.TextField()),
                ('extra', models.JSONField(blank=True, default=dict, null=True)),
                ('status', models.CharField(choices=[('DELIVERED', 'Delivered'), ('DELIVERY FAILURE', 'Delivery Failure'), ('INACTIVE DEVICE', 'Inactive Device'), ('OPTED OUT', 'Opted Out'), ('RETRY', 'Retry'), ('SCHEDULED', 'Scheduled')], max_length=16)),
                ('scheduled_delivery', models.DateTimeField()),
                ('attempted_delivery', models.DateTimeField(blank=True, null=True)),
                ('retry_time_interval', models.PositiveIntegerField(default=0)),
                ('retry_attempts', models.PositiveIntegerField(default=0)),
                ('max_retries', models.PositiveIntegerField(default=3)),
                ('target_user_record', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to='django_notification_system.targetuserrecord')),
            ],
            options={
                'verbose_name_plural': 'Notifications',
                'db_table': 'notification_system_notification',
            },
        ),
        migrations.AddConstraint(
            model_name='targetuserrecord',
            constraint=models.UniqueConstraint(fields=('user', 'target', 'target_user_id'), name='user target ids cannot be repeated'),
        ),
        migrations.AlterUniqueTogether(
            name='notification',
            unique_together={('target_user_record', 'scheduled_delivery', 'title', 'extra')},
        ),
    ]
