# Generated by Django 4.2.8 on 2024-01-03 08:54

from contextlib import suppress

from django.apps import apps
from django.contrib.contenttypes.models import ContentType
from django.db import migrations


def migrate_content_type(apps, schema_editor):
    WikiArticleRelationship = apps.get_model("wbwiki", "WikiArticleRelationship")

    for model_name in [
        "Classification",
        "Instrument",
        "ClassificationGroup",
        "Deal",
        "Exchange",
        "InstrumentClassificationRelatedInstrument",
        "InstrumentClassificationThroughModel",
        "InstrumentFavoriteGroup",
        "InstrumentList",
        "InstrumentListThroughModel",
        "InstrumentRequest",
        "RelatedInstrumentThroughModel",
        "InstrumentPrice",
    ]:
        with suppress(ContentType.DoesNotExist):
            old_ct = ContentType.objects.get(app_label="wbportfolio", model=model_name.lower())
            new_ct = ContentType.objects.get(app_label="wbfdm", model=model_name.lower())
            WikiArticleRelationship.objects.filter(content_type_id=old_ct.id).update(content_type_id=new_ct.id)


class Migration(migrations.Migration):
    dependencies = (
        [
            ("wbwiki", "0005_wikiarticlerelationship_and_more"),
            ("wbfdm", "0012_instrumentprice_created_instrumentprice_modified"),
        ]
        if apps.is_installed("wbfdm")
        else [("wbwiki", "0005_wikiarticlerelationship_and_more")]
    )
    operations = [migrations.RunPython(migrate_content_type)]
