# Generated by Django 2.2.12 on 2020-04-29 16:44

import os
from django.db import migrations, models


def populate_from_env_vars(apps, schema_editor):
    Asset = apps.get_model("polaris", "Asset")
    for asset in Asset.objects.all():
        dist_seed = os.environ.get(f"{asset.code}_DISTRIBUTION_ACCOUNT_SEED")
        if dist_seed:
            asset.distribution_seed = dist_seed
            asset.save()


class Migration(migrations.Migration):

    dependencies = [
        ("polaris", "0010_auto_20200413_2021"),
    ]

    operations = [
        migrations.AddField(
            model_name="asset",
            name="distribution_seed",
            field=models.TextField(null=True),
        ),
        migrations.RunPython(populate_from_env_vars),
    ]
